/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util;

import com.qianjiang.util.MyLogger;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DateUtil {
    private static final MyLogger LOGGER = new MyLogger(DateUtil.class);
    private static final String DATE = "yyyy-MM-dd";
    private static final String LOGGERINFO1 = "\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!";
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    public static String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static String DEFAULT_DATE_PATTERN_HOUR = "yyyy-MM-dd HH:mm";
    public static String DEFAULT_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final Map<String, SimpleDateFormat> dateFormatMap = new HashMap<String, SimpleDateFormat>();

    private DateUtil() {
    }

    public static Date buildDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtil.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException(LOGGERINFO1);
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static int getStartToEndDayInterval(Date start, Date end) {
        if (start == null || end == null) {
            throw new InvalidParameterException("\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (start.after(end)) {
            throw new InvalidParameterException("\u7ed3\u675f\u65e5\u671f\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f!");
        }
        return (int)((end.getTime() - start.getTime()) / 86400000L);
    }

    public static String dateToString(Date date, String dateFormatStr) {
        if (date == null) {
            throw new InvalidParameterException(LOGGERINFO1);
        }
        SimpleDateFormat dateFormat = null;
        if (dateFormatStr == null || "".equals(dateFormatStr)) {
            dateFormat = dateFormatMap.get(DATE);
        } else {
            dateFormat = dateFormatMap.get(dateFormatStr);
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(dateFormatStr);
                dateFormatMap.put(dateFormatStr, dateFormat);
            }
        }
        return dateFormat.format(date);
    }

    public static Date stringToDate(String date, String dateFormatStr) {
        if (date == null || "".equals(date)) {
            throw new InvalidParameterException(LOGGERINFO1);
        }
        SimpleDateFormat dateFormat = null;
        if (dateFormatStr == null || "".equals(dateFormatStr)) {
            dateFormat = dateFormatMap.get(DATE);
        } else {
            dateFormat = dateFormatMap.get(dateFormatStr);
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(dateFormatStr);
                dateFormatMap.put(dateFormatStr, dateFormat);
            }
        }
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static List<String> getAllDateBetween2Date(String startTime, String endTime) {
        ArrayList<String> dateList = new ArrayList<String>();
        try {
            Calendar startCalendar = Calendar.getInstance();
            Calendar endCalendar = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat(DATE);
            Date startDate = df.parse(startTime);
            startCalendar.setTime(startDate);
            Date endDate = df.parse(endTime);
            endCalendar.setTime(endDate);
            dateList.add(startTime);
            while (true) {
                startCalendar.add(5, 1);
                if (startCalendar.getTimeInMillis() >= endCalendar.getTimeInMillis()) break;
                dateList.add(df.format(startCalendar.getTime()));
            }
            dateList.add(endTime);
        }
        catch (ParseException e) {
            LOGGER.error("\u65e5\u671f\u5904\u7406\u5931\u8d25:" + e.getLocalizedMessage());
        }
        return dateList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addSomeDays(String startDate, int days) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE);
        try {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                Date date = sdf.parse(startDate);
                Date nextDate = DateUtil.addSomeDays(date, days);
                return sdf.format(nextDate);
            }
        }
        catch (ParseException e) {
            LOGGER.error(LOGGERINFO1 + e.getLocalizedMessage());
            return null;
        }
    }

    public static Date addSomeDays(Date startDate, int days) {
        return new Date(startDate.getTime() + (long)days * 86400000L);
    }

    public static Date stringtoDate(String dateStr, String format) {
        Date d = null;
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            formater.setLenient(false);
            d = formater.parse(dateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return d;
    }

    public static String getSysCurrentDate() {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        String time = sdf.format(new Date());
        return time;
    }

    public static String getSysCurrentDate(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String time = sdf.format(new Date());
        return time;
    }

    public static String getPreDate(Date date, String format, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        Date preDate = calendar.getTime();
        return DateUtil.dateToString(preDate, format);
    }

    public static String dateSub(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, days);
        return DateUtil.dateToString(calendar.getTime(), DEFAULT_DATE_PATTERN);
    }

    public static void main(String[] args) {
        String preDate = DateUtil.getPreDate(new Date(), DEFAULT_TIME_PATTERN, -1);
        System.out.println("preDate:" + preDate);
        String currentTime = DateUtil.getSysCurrentDate(DEFAULT_TIME_PATTERN);
        System.out.println("currentTime:" + currentTime);
    }

    static {
        dateFormatMap.put(DATE, new SimpleDateFormat(DATE));
        dateFormatMap.put("yyyy-MM-dd hh:mm:ss", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss"));
        dateFormatMap.put("yyyy/MM/dd", new SimpleDateFormat("yyyy/MM/dd"));
        dateFormatMap.put("yyyy/MM/dd hh:mm:ss", new SimpleDateFormat("yyyy/MM/dd hh:mm:ss"));
        dateFormatMap.put("yyyyMMdd", new SimpleDateFormat("yyyyMMdd"));
        dateFormatMap.put("yyyyMMddhhmmss", new SimpleDateFormat("yyyyMMddhhmmss"));
    }
}

