/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.common.util.tenpay.util.TenpayUtil;
import com.qianjiang.customer.bean.ChargeWithdraw;
import com.qianjiang.customer.bean.DepositInfo;
import com.qianjiang.customer.bean.TradeInfo;
import com.qianjiang.customer.dao.ChargeWithdrawMapper;
import com.qianjiang.customer.dao.DepositInfoMapper;
import com.qianjiang.customer.dao.TradeInfoMapper;
import com.qianjiang.customer.service.ChargeWithdrawService;
import com.qianjiang.customer.vo.DepositInfoVo;
import com.qianjiang.deposit.bean.BankInfo;
import com.qianjiang.deposit.mapper.BankInfoMapper;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="chargeWithdrawServiceImpl")
public class ChargeWithdrawServiceImpl
implements ChargeWithdrawService {
    public static final MyLogger LOGGER = new MyLogger(ChargeWithdrawServiceImpl.class);
    @Autowired
    private ChargeWithdrawMapper chargeWithdrawMapper;
    @Resource(name="BankInfoMapper")
    private BankInfoMapper bankInfoMapper;
    @Resource(name="DepositInfoMapperM")
    private DepositInfoMapper depositInfoMapper;
    @Resource(name="TradeInfoMapperImpl")
    private TradeInfoMapper tradeInfoMapper;

    @Override
    public Long selectTotalChargeWithdraw(DepositInfoVo depositInfo) {
        Long result = null;
        LOGGER.info("\u67e5\u8be2\u4f1a\u5458\u63d0\u73b0\u8bb0\u5f55\u5217\u8868\u603b\u6570\u636e\u6761\u6570...");
        try {
            result = this.chargeWithdrawMapper.selectTotalChargeWithdraw(depositInfo);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return result;
    }

    @Override
    public PageBean selectChargeWithdrawList(DepositInfoVo depositInfo, PageBean pageBean) {
        Long rowNos = this.selectTotalChargeWithdraw(depositInfo);
        pageBean.setRows(rowNos.intValue());
        depositInfo.setStartRowNum(pageBean.getStartRowNum());
        depositInfo.setEndRowNum(pageBean.getEndRowNum());
        try {
            LOGGER.info("\u67e5\u8be2\u4f1a\u5458\u63d0\u73b0\u8bb0\u5f55\u5217\u8868...");
            List<Object> chargeWithdrawList = this.chargeWithdrawMapper.selectChargeWithdrawList(depositInfo);
            if (CollectionUtils.isNotEmpty(chargeWithdrawList)) {
                pageBean.setList(chargeWithdrawList);
            }
            pageBean.setObjectBean(depositInfo);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return pageBean;
    }

    @Override
    public ChargeWithdraw selectChargeWithdrawById(Long withdrawId) {
        LOGGER.error("\u6839\u636e\u63d0\u73b0\u8bb0\u5f55ID\u67e5\u8be2\u8be5\u6761\u63d0\u73b0\u4fe1\u606f...");
        ChargeWithdraw chargeWithdraw = null;
        DepositInfoVo depositInfoVo = new DepositInfoVo();
        try {
            if (withdrawId != null) {
                depositInfoVo.setWithdrawId(withdrawId);
                depositInfoVo.setEndRowNum(1);
                chargeWithdraw = this.chargeWithdrawMapper.selectChargeWithdrawById(depositInfoVo);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u63d0\u73b0\u8bb0\u5f55ID\u67e5\u8be2\u8be5\u6761\u63d0\u73b0\u4fe1\u606f\uff1a", e);
        }
        return chargeWithdraw;
    }

    @Override
    public List<BankInfo> selectBankInfoList() {
        return this.bankInfoMapper.selectBankInfo();
    }

    @Override
    @Transactional
    public int insertWithdraw(ChargeWithdraw record) {
        try {
            BankInfo bankInfo;
            DepositInfo depositInfo = this.updateWithdrawDeposit(record);
            TradeInfo tradeInfo = this.insertSelective(record.getCustomerId(), record.getAmount(), "2", "2", record.getRemark(), depositInfo);
            record.setTradeInfoId(tradeInfo.getId());
            record.setCreateTime(new Date());
            if (record.getReceivingBank() != -1L && (bankInfo = this.bankInfoMapper.selectById(record.getReceivingBank())) != null) {
                record.setBankName(bankInfo.getBankName());
            }
            this.chargeWithdrawMapper.insertSelective(record);
            return tradeInfo.getId().intValue();
        }
        catch (Exception e) {
            LOGGER.info("\u751f\u6210\u63d0\u73b0\u7533\u8bf7\u8bb0\u5f55\u548c\u4ea4\u6613\u8bb0\u5f55\u5f02\u5e38,\u7528\u6237id:" + record.getCustomerId());
            return 0;
        }
    }

    private DepositInfo updateWithdrawDeposit(ChargeWithdraw record) {
        DepositInfo depositInfo = this.depositInfoMapper.selectDepositByCustId(record.getCustomerId());
        DepositInfo updateDepositInfo = new DepositInfo();
        updateDepositInfo.setFreezePreDeposit(depositInfo.getFreezePreDeposit().add(record.getAmount()));
        updateDepositInfo.setPreDeposit(depositInfo.getPreDeposit().subtract(record.getAmount()));
        updateDepositInfo.setCustomerId(record.getCustomerId());
        this.depositInfoMapper.updateDepositInfo(updateDepositInfo);
        return updateDepositInfo;
    }

    private TradeInfo insertSelective(Long customerId, BigDecimal orderPrice, String orderType, String payType, String remark, DepositInfo depositInfo) {
        TradeInfo tradeInfo = new TradeInfo();
        tradeInfo.setCustomerId(customerId);
        tradeInfo.setOrderPrice(orderPrice);
        tradeInfo.setOrderType(orderType);
        tradeInfo.setOrderCode(this.genenrateTradeCode(payType));
        tradeInfo.setCreatePerson(customerId);
        tradeInfo.setCreateTime(new Date());
        tradeInfo.setDelFlag("0");
        tradeInfo.setCurrentPrice(depositInfo.getPreDeposit().add(depositInfo.getFreezePreDeposit()));
        if ("0".equals(orderType)) {
            tradeInfo.setOrderStatus("5");
        } else if ("2".equals(orderType)) {
            tradeInfo.setOrderStatus("0");
        }
        if (StringUtils.isNotEmpty((String)remark)) {
            tradeInfo.setTradeRemark(remark);
        }
        if (this.tradeInfoMapper.insertSelective(tradeInfo) > 0) {
            return tradeInfo;
        }
        return null;
    }

    private String genenrateTradeCode(String orderType) {
        String tradeCode = "";
        String nonceStr = TenpayUtil.buildRandom((int)4) + "";
        String currTime = TenpayUtil.getCurrTime();
        if ("0".equals(orderType)) {
            tradeCode = "R" + currTime + nonceStr;
        } else if ("2".equals(orderType)) {
            tradeCode = "W" + currTime + nonceStr;
        }
        return tradeCode;
    }
}

