/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.customer.bean.CustomerFollow;
import com.qianjiang.customer.dao.CustomerFollowMapper;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.service.CustomerFollowServiceMapper;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.mgoods.vo.GoodsProductVo;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="customerFollowServiceMapper")
public class CustomerFollowServiceMapperImpl
implements CustomerFollowServiceMapper {
    private CustomerFollowMapper customerFollowMapper;
    @Resource(name="customerMapper")
    private CustomerMapper customerMapper;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService defaultAddressService;

    public CustomerFollowMapper getCustomerFollowMapper() {
        return this.customerFollowMapper;
    }

    @Resource(name="customerFollowMapper")
    public void setCustomerFollowMapper(CustomerFollowMapper customerFollowMapper) {
        this.customerFollowMapper = customerFollowMapper;
    }

    @Override
    public List<CustomerFollow> selectByCustomerId(Long customerId) {
        return this.customerFollowMapper.selectCustFollowByCustId(customerId);
    }

    @Override
    public List<CustomerFollow> selectSendId(Long goodsInfoId) {
        return this.customerFollowMapper.selectSendId(goodsInfoId);
    }

    @Override
    public PageBean selectCustomerFollow(Map<String, Object> paramMap, PageBean pb) {
        Long count = this.customerFollowMapper.selectCustomerFollowCount(Long.valueOf(paramMap.get("customerId").toString()));
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        if (pb.getPageNo() > pb.getLastPageNo()) {
            pb.setPageNo(pb.getLastPageNo());
        }
        if (pb.getPageNo() == 0) {
            pb.setPageNo(1);
        }
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("endRowNum", pb.getEndRowNum());
        List<Object> customerFollows = this.customerFollowMapper.selectCustFollowByCustId(paramMap);
        if (null != customerFollows && !customerFollows.isEmpty()) {
            for (int i = 0; i < customerFollows.size(); ++i) {
                CustomerFollow childCustomerFollow = (CustomerFollow)customerFollows.get(i);
                childCustomerFollow.setUtilBean(this.customerFollowMapper.queryCommentCountAndScoreByProductId(childCustomerFollow.getGoodsId()));
                GoodsProductVo goodsProductVo = this.customerMapper.queryPrductByProductId(childCustomerFollow.getGoodsId());
                if (goodsProductVo == null) continue;
                if (goodsProductVo.getIsThird() != null && !"".equals(goodsProductVo.getIsThird()) && "1".equals(goodsProductVo.getIsThird())) {
                    if (childCustomerFollow.getGood() == null) continue;
                    childCustomerFollow.getGood().setGoodStock(goodsProductVo.getGoodsInfoStock());
                    continue;
                }
                Long distinctId = this.defaultAddressService.getDefaultIdService();
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("productId", childCustomerFollow.getGoodsId());
                map.put("distinctId", distinctId);
                ProductWare productWare = this.customerMapper.queryProductWareByProductIdAndDistinctId(map);
                if (childCustomerFollow.getGood() == null) continue;
                childCustomerFollow.getGood().setGoodStock(productWare.getWareStock());
            }
        }
        pb.setList(customerFollows);
        return pb;
    }

    @Override
    public List<String> selectCustomerFollowForList(Map<String, Object> paramMap) {
        return this.customerFollowMapper.selectCustFollowByCustIdForList(paramMap);
    }

    @Override
    public int deleteFollow(Long followId, Long customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("followId", followId);
        map.put("customerId", customerId);
        return this.customerFollowMapper.deleteByPrimaryKey1(map);
    }
}

