/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.manager.util;

import com.qianjiang.util.MyLogger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class SqlHelper {
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    public static final MyLogger LOGGER = new MyLogger(SqlHelper.class);

    private SqlHelper() {
    }

    public static MetaObject forObject(Object object) {
        return MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY);
    }

    public static String getMapperSql(Object mapper, String methodName, Object ... args) {
        MetaObject metaObject = SqlHelper.forObject(mapper);
        SqlSession session = (SqlSession)metaObject.getValue("h.sqlSession");
        Class mapperInterface = (Class)metaObject.getValue("h.mapperInterface");
        String fullMethodName = mapperInterface.getCanonicalName() + "." + methodName;
        if (args == null || args.length == 0) {
            return SqlHelper.getNamespaceSql(session, fullMethodName, null);
        }
        return SqlHelper.getMapperSql(session, mapperInterface, methodName, args);
    }

    public static String getMapperSql(SqlSession session, String fullMapperMethodName, Object ... args) {
        if (args == null || args.length == 0) {
            return SqlHelper.getNamespaceSql(session, fullMapperMethodName, null);
        }
        String methodName = fullMapperMethodName.substring(fullMapperMethodName.lastIndexOf(46) + 1);
        Class<?> mapperInterface = null;
        try {
            mapperInterface = Class.forName(fullMapperMethodName.substring(0, fullMapperMethodName.lastIndexOf(46)));
            return SqlHelper.getMapperSql(session, mapperInterface, methodName, args);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("", e);
            throw new IllegalArgumentException("\u53c2\u6570" + fullMapperMethodName + "\u65e0\u6548\uff01");
        }
    }

    public static String getMapperSql(SqlSession session, Class mapperInterface, String methodName, Object ... args) {
        Object wParams;
        String fullMapperMethodName = mapperInterface.getCanonicalName() + "." + methodName;
        if (args == null || args.length == 0) {
            return SqlHelper.getNamespaceSql(session, fullMapperMethodName, null);
        }
        Method method = SqlHelper.getDeclaredMethods(mapperInterface, methodName);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Class<?>[] argTypes = method.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (RowBounds.class.isAssignableFrom(argTypes[i]) || ResultHandler.class.isAssignableFrom(argTypes[i])) continue;
            String paramName = "param" + (params.size() + 1);
            paramName = SqlHelper.getParamNameFromAnnotation(method, i, paramName);
            params.put(paramName, i >= args.length ? null : args[i]);
        }
        if (args != null && args.length == 1 && (wParams = SqlHelper.wrapCollection(args[0])) instanceof Map) {
            params.putAll((Map)wParams);
        }
        return SqlHelper.getNamespaceSql(session, fullMapperMethodName, params);
    }

    public static String getNamespaceSql(SqlSession session, String namespace) {
        return SqlHelper.getNamespaceSql(session, namespace, null);
    }

    public static String getNamespaceSql(SqlSession session, String namespace, Object params) {
        Object paramsNew = params;
        paramsNew = SqlHelper.wrapCollection(paramsNew);
        Configuration configuration = session.getConfiguration();
        MappedStatement mappedStatement = configuration.getMappedStatement(namespace);
        BoundSql boundSql = mappedStatement.getBoundSql(paramsNew);
        String sql = boundSql.getSql();
        return SqlHelper.formatSql(sql);
    }

    private static Method getDeclaredMethods(Class clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new IllegalArgumentException("\u65b9\u6cd5" + methodName + "\u4e0d\u5b58\u5728\uff01");
    }

    private static String getParamNameFromAnnotation(Method method, int i, String paramName) {
        Annotation[] paramAnnos;
        String paramNameNew = paramName;
        for (Annotation paramAnno : paramAnnos = method.getParameterAnnotations()[i]) {
            if (!(paramAnno instanceof Param)) continue;
            paramNameNew = ((Param)paramAnno).value();
        }
        return paramNameNew;
    }

    private static Object wrapCollection(Object object) {
        if (object instanceof List) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("list", object);
            return map;
        }
        if (object != null && object.getClass().isArray()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("array", object);
            return map;
        }
        return object;
    }

    public static String formatSql(String sql) {
        return sql == null ? "" : sql.replaceAll("\r|\n+", " ");
    }
}

