/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.comment.service.impl;

import com.qianjiang.comment.bean.Comment;
import com.qianjiang.comment.dao.CommentMapper;
import com.qianjiang.comment.dao.ShareMapper;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.comment.service.impl.ShareServiceImpl;
import com.qianjiang.comment.vo.ShareVo;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.operlog.util.OperaLogBean;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.other.bean.GoodsBean;
import com.qianjiang.util.PageBean;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="commentServiceMapper")
public class CommentServiceMapperImpl
implements CommentServiceMapper {
    private static final Logger LOGGER = Logger.getLogger(CommentServiceMapperImpl.class);
    private static final String RESULT = "result";
    private static final String GOODSID = "goodsId";
    private static final String COMMENTTYPE = "commentType";
    private static final String PARAMSTRING = "paramString";
    private static final String CUSTOMERID = "customerId";
    private CommentMapper commentMapper;
    @Autowired
    private ShareServiceImpl shareService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="shareMapper")
    private ShareMapper shareMapper;

    @Override
    public PageBean selectAllComment(PageBean pageBean, Comment comment, Long thirdId) {
        HashMap<String, Object> paramMap = null;
        int no = 0;
        try {
            comment.setThirdId(thirdId);
            pageBean.setRows(Integer.parseInt((comment == null ? this.commentMapper.selectAllCommentCount(thirdId) : this.commentMapper.selectCommentCount(comment)) + ""));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            if (comment != null) {
                comment.setStartRowNum(pageBean.getStartRowNum());
                comment.setEndRowNum(pageBean.getEndRowNum());
            }
            paramMap = new HashMap<String, Object>();
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            paramMap.put("thirdId", thirdId);
            pageBean.setList(comment == null ? this.commentMapper.selectCommentByLimit(paramMap) : this.commentMapper.selectCommentByComment(comment));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("\u67e5\u8be2\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        return pageBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteComment(String[] commentIds) {
        int count = 0;
        try {
            for (String custId : commentIds) {
                count += this.commentMapper.deleteCommentById(Long.parseLong(custId));
            }
            int n = count;
            return n;
        }
        finally {
            count = 0;
        }
    }

    @Override
    public Comment selectByCommentId(Long commentId) {
        return this.commentMapper.selectByCommentId(commentId);
    }

    @Override
    public PageBean selectAllConsult(PageBean pageBean, Comment comment, Long thirdId) {
        HashMap<String, Object> paramMap = null;
        int no = 0;
        try {
            System.out.println("thirdId===" + thirdId);
            pageBean.setRows(Integer.parseInt((comment == null ? this.commentMapper.selectAllConsultCount(thirdId) : this.commentMapper.selectConsultCount(comment)) + ""));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            if (comment != null) {
                comment.setThirdId(thirdId);
                comment.setStartRowNum(pageBean.getStartRowNum());
                comment.setEndRowNum(pageBean.getEndRowNum());
            }
            paramMap = new HashMap<String, Object>();
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            paramMap.put("thirdId", thirdId);
            pageBean.setList(comment == null ? this.commentMapper.selectAllConsult(paramMap) : this.commentMapper.selectConsultByConsult(comment));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("\u67e5\u8be2\u54a8\u8be2\u5217\u8868\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        return pageBean;
    }

    @Override
    public PageBean selectCommByGoodsId(PageBean pageBean, Long goodsId, Character type, String paramString, String item) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(GOODSID, goodsId);
        paramMap.put(COMMENTTYPE, type);
        paramMap.put(PARAMSTRING, paramString);
        paramMap.put("item", item);
        pageBean.setRows(Integer.parseInt(this.commentMapper.selectGoodAllCommCount(paramMap).toString()));
        if (pageBean.getPageNo() > pageBean.getLastPageNo()) {
            pageBean.setPageNo(pageBean.getLastPageNo());
        }
        if (pageBean.getPageNo() == 0) {
            pageBean.setPageNo(1);
        }
        paramMap.put("startRowNum", pageBean.getStartRowNum());
        paramMap.put("endRowNum", pageBean.getEndRowNum());
        pageBean.setList(this.commentMapper.selectAllCommentByGoodsId(paramMap));
        return pageBean;
    }

    @Override
    public PageBean selectCommByGoodsId(PageBean pageBean, Long goodsId, Character type, String parmaString) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(GOODSID, goodsId);
        paramMap.put(COMMENTTYPE, type);
        paramMap.put(PARAMSTRING, parmaString);
        pageBean.setRows(Integer.parseInt(this.commentMapper.selectGoodAllCommCount(paramMap).toString()));
        if (pageBean.getPageNo() > pageBean.getLastPageNo()) {
            pageBean.setPageNo(pageBean.getLastPageNo());
        }
        if (pageBean.getPageNo() == 0) {
            pageBean.setPageNo(1);
        }
        paramMap.put("startRowNum", pageBean.getStartRowNum());
        paramMap.put("endRowNum", pageBean.getEndRowNum());
        pageBean.setList(this.commentMapper.selectAllCommentByGoodsId(paramMap));
        return pageBean;
    }

    @Override
    public PageBean selectCommByGoodsIdHyc(PageBean pageBean, Long goodsId, Character type, String parmaString) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(GOODSID, goodsId);
        paramMap.put(COMMENTTYPE, type);
        paramMap.put(PARAMSTRING, parmaString);
        pageBean.setRows(Integer.parseInt(this.commentMapper.selectGoodAllCommCount(paramMap).toString()));
        if (pageBean.getPageNo() > pageBean.getLastPageNo()) {
            pageBean.setPageNo(pageBean.getLastPageNo());
        }
        if (pageBean.getPageNo() == 0) {
            pageBean.setPageNo(1);
        }
        pageBean.setList(this.commentMapper.selectAllCommentByGoodsIdHyc(paramMap));
        return pageBean;
    }

    @Override
    public PageBean selectCommDetailByGoodsIdHyc(PageBean pageBean, Long goodsId, Character type, String parmaString) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(GOODSID, goodsId);
        paramMap.put(COMMENTTYPE, type);
        paramMap.put(PARAMSTRING, parmaString);
        pageBean.setRows(Integer.parseInt(this.commentMapper.selectGoodAllCommCount(paramMap).toString()));
        if (pageBean.getPageNo() > pageBean.getLastPageNo()) {
            pageBean.setPageNo(pageBean.getLastPageNo());
        }
        if (pageBean.getPageNo() == 0) {
            pageBean.setPageNo(1);
        }
        pageBean.setList(this.commentMapper.selectAllCommentDetailByGoodsId(paramMap));
        return pageBean;
    }

    @Override
    public int queryCommentCountByType(Long goodsId, Character commentType, String paramString) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(GOODSID, goodsId);
        paramMap.put(COMMENTTYPE, commentType);
        paramMap.put(PARAMSTRING, paramString);
        return Integer.parseInt(this.commentMapper.selectGoodAllCommCount(paramMap).toString());
    }

    @Override
    public int updateComment(Comment comment) {
        return this.commentMapper.updateComment(comment);
    }

    @Override
    public int addGoodsComment(Comment comment) {
        return this.commentMapper.addGoodsComment(comment);
    }

    @Override
    public PageBean queryCustConsult(Long customerId, String flag, PageBean pageBean) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Comment comment = new Comment();
        comment.setCustomerId(customerId);
        comment.seteFlag(flag == null ? null : flag);
        pageBean.setRows(Integer.parseInt(this.commentMapper.queryCustConsultCount(comment).toString()));
        if (pageBean.getPageNo() > pageBean.getLastPageNo()) {
            pageBean.setPageNo(pageBean.getLastPageNo());
        }
        if (pageBean.getPageNo() == 0) {
            pageBean.setPageNo(1);
        }
        paramMap.put("comment", comment);
        paramMap.put("startRowNum", pageBean.getStartRowNum());
        paramMap.put("endRowNum", pageBean.getEndRowNum());
        pageBean.setList(this.commentMapper.queryCustConsult(paramMap));
        return pageBean;
    }

    @Override
    public PageBean queryCustComment(Long customerId, PageBean pageBean) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Comment comment = new Comment();
        comment.setCustomerId(customerId);
        pageBean.setRows(Integer.parseInt(this.commentMapper.queryCustCommentCount(comment).toString()));
        if (pageBean.getPageNo() > pageBean.getLastPageNo()) {
            pageBean.setPageNo(pageBean.getLastPageNo());
        }
        if (pageBean.getPageNo() == 0) {
            pageBean.setPageNo(1);
        }
        paramMap.put("comment", comment);
        paramMap.put("startRowNum", pageBean.getStartRowNum());
        paramMap.put("endRowNum", pageBean.getEndRowNum());
        pageBean.setList(this.commentMapper.queryCustComment(paramMap));
        return pageBean;
    }

    @Override
    public PageBean queryCommentByCust(Long orderId, Long customerId, PageBean pageBean) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orderId", orderId);
        paramMap.put(CUSTOMERID, customerId);
        pageBean.setRows(Integer.parseInt(this.commentMapper.queryCommentCountByCust(paramMap).toString()));
        if (pageBean.getPageNo() > pageBean.getLastPageNo()) {
            pageBean.setPageNo(pageBean.getLastPageNo());
        }
        if (pageBean.getPageNo() == 0) {
            pageBean.setPageNo(1);
        }
        paramMap.put("startRowNum", pageBean.getStartRowNum());
        paramMap.put("endRowNum", pageBean.getEndRowNum());
        pageBean.setList(this.commentMapper.queryCommentByCust(paramMap));
        return pageBean;
    }

    @Override
    public List<Comment> exportComment() {
        return this.commentMapper.queryAllComment();
    }

    @Override
    public void exportCommentTemp() {
    }

    @Override
    public String importCommentByExcel(Customer cust, String name, String ip, long loginUserId, byte[] fs) {
        try {
            return this.execImportComment(this.importComment(cust, name, ip, loginUserId, fs), cust, name, ip, loginUserId);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u5bfc\u5165\u5546\u54c1\u8bc4\u8bba\u5931\u8d25:", (Throwable)e);
            return "400";
        }
    }

    public String execImportComment(Map<String, Object> map, Customer cust, String name, String ip, long loginUserId) {
        List list = (List)map.get("commentList");
        if (list == null) {
            return map.get(RESULT).toString();
        }
        try {
            if (null != list && !list.isEmpty()) {
                for (Comment comment : list) {
                    comment.setDelFlag("0");
                    this.commentMapper.addGoodsComment(comment);
                }
                return "200";
            }
            return "400";
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
            OperaLogBean operaLogBean = new OperaLogBean(e, cust.getCustomerUsername());
            operaLogBean.setName(name);
            operaLogBean.setIp(ip);
            operaLogBean.setLoginUserId(Long.valueOf(loginUserId));
            OperaLogUtil.addOperaException((OperaLogBean)operaLogBean);
            return "200";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> importComment(Customer cust, String name, String ip, long loginUserId, byte[] fs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Comment> commentList = new ArrayList<Comment>();
        Comment comment = null;
        HSSFWorkbook wb = null;
        HSSFSheet sheet = null;
        HSSFRow row = null;
        int rows = 0;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(fs);
            POIFSFileSystem pfs = new POIFSFileSystem((InputStream)input);
            wb = new HSSFWorkbook(pfs);
            sheet = wb.getSheetAt(0);
            rows = sheet.getPhysicalNumberOfRows();
            Pattern numberPattern = Pattern.compile("[0-9]*");
            Pattern decimalPattern = Pattern.compile("([1-9]+[0-9]*|0)(\\.[\\d]+)?");
            Matcher isDecimal = null;
            Matcher isNum = null;
            for (int i = 1; i < rows; ++i) {
                HashMap<String, Object> hashMap;
                comment = new Comment();
                row = sheet.getRow(i);
                row.getCell(0).setCellType(1);
                String goodsNo = row.getCell(0).getStringCellValue();
                if (goodsNo == null || "".equals(goodsNo)) {
                    map.put(RESULT, "501");
                    HashMap<String, Object> hashMap2 = map;
                    return hashMap2;
                }
                Long goodsInfoId = this.commentMapper.selectGoodsInfoIdByNo(goodsNo);
                if (goodsInfoId == null) continue;
                comment.setGoodsId(goodsInfoId);
                row.getCell(1).setCellType(1);
                String commentContent = row.getCell(1).getStringCellValue();
                comment.setCommentContent(commentContent);
                row.getCell(2).setCellType(1);
                String isDisplay = row.getCell(2).getStringCellValue();
                isNum = numberPattern.matcher(isDisplay);
                if (isDisplay != null && !"".equals(isDisplay) && !isNum.matches()) {
                    map.put(RESULT, "502");
                    HashMap<String, Object> hashMap3 = map;
                    return hashMap3;
                }
                if (isDisplay != null && !"".equals(isDisplay)) {
                    comment.setIsDisplay(isDisplay);
                }
                if (row.getCell(3) != null) {
                    row.getCell(3).setCellType(1);
                    String scoreStr = row.getCell(3).getStringCellValue();
                    isDecimal = decimalPattern.matcher(scoreStr);
                    if (!isDecimal.matches()) {
                        map.put(RESULT, "503");
                        hashMap = map;
                        return hashMap;
                    }
                    comment.setCommentScore(new BigDecimal(scoreStr));
                }
                if (row.getCell(4) != null) {
                    row.getCell(4).setCellType(1);
                    String isAno = row.getCell(4).getStringCellValue();
                    isNum = numberPattern.matcher(isAno);
                    if (isAno != null && !"".equals(isAno) && !isNum.matches()) {
                        map.put(RESULT, "504");
                        hashMap = map;
                        return hashMap;
                    }
                    comment.setIsAnonymous(isAno);
                }
                if (row.getCell(5) != null) {
                    row.getCell(5).setCellType(1);
                    String userName = row.getCell(5).getStringCellValue();
                    Customer customer = this.customerServiceMapper.selectCustomerByUserName(userName);
                    comment.setCustomerId(customer.getCustomerId());
                    comment.setCustomerImg(customer.getCustomerImg());
                    comment.setCustomerNickname(customer.getCustomerNickname());
                }
                commentList.add(comment);
            }
            map.put("commentList", commentList);
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
            OperaLogBean operaLogBean = new OperaLogBean(e, cust.getCustomerUsername());
            operaLogBean.setName(name);
            operaLogBean.setIp(ip);
            operaLogBean.setLoginUserId(Long.valueOf(loginUserId));
            OperaLogUtil.addOperaException((OperaLogBean)operaLogBean);
            map.put(RESULT, "400");
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        finally {
            commentList = null;
            comment = null;
            fs = null;
            wb = null;
            sheet = null;
            row = null;
        }
    }

    @Override
    public Comment selectSellerComment(Long thirdId) {
        return this.commentMapper.selectSellerAvg(thirdId);
    }

    @Override
    public Comment queryCommentByOrderGoodsId(Long orderGoodsId, Long customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderGoodsId", orderGoodsId);
        map.put(CUSTOMERID, customerId);
        return this.commentMapper.queryCommentByOrderGoodsId(map);
    }

    public CommentMapper getCommentMapper() {
        return this.commentMapper;
    }

    @Resource(name="commentMapper")
    public void setCommentMapper(CommentMapper commentMapper) {
        this.commentMapper = commentMapper;
    }

    @Override
    public int queryShareTotal(String thirdId, String beginCreateTime, String endCreateTime) throws Exception {
        if (!(StringUtils.isEmpty((String)thirdId) || StringUtils.isEmpty((String)beginCreateTime) || StringUtils.isEmpty((String)endCreateTime))) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ShareVo share = new ShareVo();
            share.setThirdId(Long.valueOf(thirdId));
            share.setCreateTime(format.parse(beginCreateTime));
            share.setCreateTimeTo(format.parse(endCreateTime));
            return this.shareService.selectAllShareCount(share).intValue();
        }
        return 0;
    }

    @Override
    public Long queryConsultCount(Comment comment) {
        return this.commentMapper.selectConsultCount(comment);
    }

    @Override
    public Long queryCommentCount(Comment comment) {
        return this.commentMapper.selectCommentCount(comment);
    }

    @Override
    public PageBean selectCommByType(PageBean pb, Long productId, String hpic) {
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put(GOODSID, productId);
            paramMap.put("hpic", hpic);
            pb.setRows(this.commentMapper.selectCountCommByType(paramMap));
            if (pb.getPageNo() > pb.getLastPageNo()) {
                pb.setPageNo(pb.getLastPageNo());
            }
            if (pb.getPageNo() == 0) {
                pb.setPageNo(1);
            }
            paramMap.put("startRowNum", pb.getStartRowNum());
            paramMap.put("endRowNum", pb.getEndRowNum());
            List<Object> list = this.commentMapper.selectByCommType(paramMap);
            for (int i = 0; i < list.size(); ++i) {
                Comment comment = (Comment)list.get(i);
                if ("1".equals(comment.getIsAnonymous()) && null != comment.getCustomerNickname() && comment.getCustomerNickname().length() > 1) {
                    comment.setCustomerNickname(new StringBuilder(comment.getCustomerNickname()).replace(1, comment.getCustomerNickname().length() - 1, "*").toString());
                    continue;
                }
                if (!"1".equals(comment.getIsAnonymous()) || null == comment.getCustomerNickname() || comment.getCustomerNickname().length() >= 2) continue;
                comment.setCustomerNickname(new StringBuilder(comment.getCustomerNickname()).replace(comment.getCustomerNickname().length() - 1, comment.getCustomerNickname().length(), "*").toString());
            }
            pb.setList(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("\u4e1a\u52a1\u5c42\u67e5\u8be2\u5546\u54c1\u8bc4\u4ef7\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsBean selectOrderGoods(Long goodsId, Long orderId, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(GOODSID, goodsId);
            paramMap.put(CUSTOMERID, customerId);
            paramMap.put("orderId", orderId);
            GoodsBean goodsBean = this.commentMapper.selectOrderGoods(paramMap);
            return goodsBean;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    @Transactional
    public int addGoodsComment1(String publishIp, Comment comment, Long orderId) {
        comment.setIsConsult("0");
        comment.setPublishTime(new Date());
        comment.setIsDisplay("1");
        comment.setDelFlag("0");
        comment.setPublishIp(publishIp);
        int score = Integer.parseInt(comment.getCommentScore().toString());
        if (score < 2) {
            comment.setCommentType("2");
        } else if (2 <= score && score <= 3) {
            comment.setCommentType("1");
        } else {
            comment.setCommentType("0");
        }
        this.commentMapper.addGoodsComment(comment);
        this.customerPointServiceMapper.addIntegralByType(comment.getCustomerId(), "4");
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setCommentId(comment.getCommentId());
        goodsBean.setEvaluateFlag("1");
        goodsBean.setOrderId(orderId);
        goodsBean.setGoodsId(comment.getGoodsId());
        this.commentMapper.updateOrderGoods(goodsBean);
        return 0;
    }

    @Override
    public Long addGoodsComment2(String publishIp, Comment comment) {
        comment.setIsConsult("0");
        comment.setPublishTime(new Date());
        comment.setIsDisplay("1");
        comment.setDelFlag("0");
        comment.setPublishIp(publishIp);
        comment.setThirdId(this.shareMapper.queryThirdIdByGoodsInfoId(comment.getGoodsId()));
        int score = Integer.parseInt(comment.getCommentScore().toString());
        if (score < 2) {
            comment.setCommentType("2");
        } else if (2 <= score && score <= 3) {
            comment.setCommentType("1");
        } else {
            comment.setCommentType("0");
        }
        this.commentMapper.addGoodsComment(comment);
        this.customerPointServiceMapper.addIntegralByType(comment.getCustomerId(), "4");
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setCommentId(comment.getCommentId());
        goodsBean.setEvaluateFlag("1");
        goodsBean.setOrderGoodsId(comment.getOrderGoodsId());
        goodsBean.setGoodsId(comment.getGoodsId());
        this.commentMapper.updateOrderGoods(goodsBean);
        return comment.getCommentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comment selectGoodsComment(Long goodsId, Long orderId, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        GoodsBean goodsBean = null;
        try {
            paramMap.put(GOODSID, goodsId);
            paramMap.put(CUSTOMERID, customerId);
            paramMap.put("orderId", orderId);
            goodsBean = this.commentMapper.selectOrderGoods(paramMap);
            Comment comment = this.commentMapper.selectByCommentId(goodsBean.getCommentId());
            return comment;
        }
        finally {
            paramMap = null;
            goodsBean = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsBean selectOrderGoodsToComment(Long goodsId, Long orderId, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(GOODSID, goodsId);
            paramMap.put(CUSTOMERID, customerId);
            paramMap.put("orderId", orderId);
            GoodsBean goodsBean = this.commentMapper.selectOrderGoodsToComment(paramMap);
            return goodsBean;
        }
        finally {
            paramMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long checkCommGoodFlag(Long orderId, Long goodsId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(GOODSID, goodsId);
            paramMap.put("orderId", orderId);
            Long l = this.commentMapper.checkCommGoodFlag(paramMap);
            return l;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public boolean checkCommGoodIsUser(Long orderGoodsId, Long customerId, String flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderGoodsId", orderGoodsId);
        map.put(CUSTOMERID, customerId);
        map.put("flag", flag);
        Long count = this.commentMapper.checkCommGoodIsUser(map);
        return count > 0L;
    }
}

