/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.findpwd.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.findpwd.service.FindPwdService;
import com.qianjiang.utils.SecurityUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="findPwdService")
public class FindPwdServiceImpl
implements FindPwdService {
    private static final String UTYPE = "uType";
    @Resource(name="customerMapper")
    private CustomerMapper customerMapper;

    @Override
    public Object newForGetPwd(Map param, String code, String mobile, String newPassword) {
        String sessonCode = param.get("UpdatePassCode").toString();
        String userMobile = param.get("UpdatePassMobile").toString();
        if (StringUtils.isEmpty((String)sessonCode) || StringUtils.isEmpty((String)userMobile)) {
            return 0;
        }
        if (!code.equals(sessonCode) || !mobile.equals(userMobile)) {
            return 0;
        }
        HashMap<String, Object> paramMap = null;
        String nameEmp = mobile.trim();
        paramMap = new HashMap<String, Object>();
        if (nameEmp.indexOf("@") != -1) {
            paramMap.put(UTYPE, "email");
        } else if (Pattern.compile("^0?(13|15|17|18|14)[0-9]{9}$").matcher(nameEmp).find()) {
            paramMap.put(UTYPE, "mobile");
        } else {
            paramMap.put(UTYPE, "username");
        }
        paramMap.put("username", mobile);
        Customer customerN = this.customerMapper.selectCustomerByCustNameAndType(paramMap);
        if (customerN == null) {
            return 2;
        }
        CustomerAllInfo allInfo = new CustomerAllInfo();
        allInfo.setInfoMobile((String)param.get("userMobilex"));
        String salt = SecurityUtil.getNewPsw();
        String newpwd = SecurityUtil.getStoreLogpwd(customerN.getUniqueCode(), newPassword, salt);
        allInfo.setCustomerPassword(newpwd);
        allInfo.setSaltVal(salt);
        allInfo.setCustomerId(customerN.getCustomerId());
        this.customerMapper.updatePwdInfo(allInfo);
        return "1";
    }

    @Override
    public int checkCustomerExists(String username) throws UnsupportedEncodingException {
        HashMap<String, Object> paramMap = null;
        String nameEmp = username.trim();
        paramMap = new HashMap<String, Object>();
        if (nameEmp.indexOf("@") != -1) {
            paramMap.put(UTYPE, "email");
        } else if (Pattern.compile("^0?(13|15|17|18|14)[0-9]{9}$").matcher(nameEmp).find()) {
            paramMap.put(UTYPE, "mobile");
        } else {
            paramMap.put(UTYPE, "username");
        }
        paramMap.put("username", username);
        Customer customerN = this.customerMapper.selectCustomerByNamePwdAndType(paramMap);
        if (customerN != null) {
            return 1;
        }
        return 2;
    }

    @Override
    public Object UpdatePwdByEmail(Map<String, Object> param, String code, String mobile, String newPassword) {
        String emailNo = param.get("emailNo").toString();
        String emailCode = param.get("emailCode").toString();
        if (StringUtils.isEmpty((String)emailNo) || StringUtils.isEmpty((String)emailCode)) {
            return 0;
        }
        if (!code.equals(emailCode) || !mobile.equals(emailNo)) {
            return 0;
        }
        CustomerAllInfo customerN = this.customerMapper.selectCustomerByEmailNo(mobile);
        if (customerN == null) {
            return 2;
        }
        CustomerAllInfo allInfo = new CustomerAllInfo();
        String userCode = customerN.getCustomerId().toString();
        String saltVal = SecurityUtil.getNewPsw();
        String pwd = SecurityUtil.getStoreLogpwd(userCode, newPassword, saltVal);
        allInfo.setCustomerPassword(pwd);
        allInfo.setSaltVal(saltVal);
        allInfo.setCustomerId(customerN.getCustomerId());
        int state = this.customerMapper.updatePwdInfo(allInfo);
        if (state > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public Object updatePwdByCode(Map<String, Object> param, String code, String mobile, String newPassword) {
        String sessonCode = param.get("sessonCode").toString();
        String userMobile = param.get("userMobile").toString();
        if (StringUtils.isEmpty((String)sessonCode) || StringUtils.isEmpty((String)userMobile)) {
            return 0;
        }
        if (!code.equals(sessonCode) || !mobile.equals(userMobile)) {
            return 0;
        }
        HashMap<String, Object> paramMap = null;
        String nameEmp = mobile.trim();
        paramMap = new HashMap<String, Object>();
        if (nameEmp.indexOf("@") != -1) {
            paramMap.put(UTYPE, "email");
        } else if (Pattern.compile("^0?(13|15|17|18|14)[0-9]{9}$").matcher(nameEmp).find()) {
            paramMap.put(UTYPE, "mobile");
        } else {
            paramMap.put(UTYPE, "username");
        }
        paramMap.put("username", mobile);
        Customer customerN = this.customerMapper.selectCustomerByCustNameAndType(paramMap);
        if (customerN == null) {
            return 2;
        }
        CustomerAllInfo allInfo = new CustomerAllInfo();
        allInfo.setInfoMobile((String)param.get("userMobilex"));
        String salt = SecurityUtil.getNewPsw();
        String newpwd = SecurityUtil.getStoreLogpwd(customerN.getUniqueCode(), newPassword, salt);
        allInfo.setCustomerPassword(newpwd);
        allInfo.setSaltVal(salt);
        allInfo.setCustomerId(customerN.getCustomerId());
        this.customerMapper.updatePwdInfo(allInfo);
        return "1";
    }
}

