/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.manager.base;

import com.qianjiang.manager.util.SqlHelper;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class BasicSqlSupport {
    @Resource(name="sqlSession")
    private SqlSession session;
    @Resource(name="sqlSessionFactory")
    private SqlSessionFactory sqlSessionFactory;

    protected String getRunTimeSqlContent(String mappedId, Object parameterObject) {
        MappedStatement ms = this.sqlSessionFactory.getConfiguration().getMappedStatement(mappedId);
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        return this.formatSql(boundSql.getSql());
    }

    protected String getRunTimeSqlContent(String mappedId) {
        return this.getRunTimeSqlContent(mappedId, null);
    }

    protected String getRunTimeSqlContent(SqlSession session, String mappedId, Object param) {
        return SqlHelper.getNamespaceSql(session, mappedId, param);
    }

    protected String getRunTimeSqlContent(SqlSession session, String mappedId) {
        return SqlHelper.getNamespaceSql(session, mappedId);
    }

    private String formatSql(String sql) {
        return sql == null ? "" : sql.replaceAll("\r|\n+", " ");
    }

    public <T> T selectOne(String statement) {
        return (T)this.getSession().selectOne(statement);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.getSession().selectOne(statement, parameter);
    }

    public <E> List<E> selectList(String statement) {
        return this.getSession().selectList(statement);
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.getSession().selectList(statement, parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.getSession().selectList(statement, parameter, rowBounds);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return this.getSession().selectMap(statement, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.getSession().selectMap(statement, parameter, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return this.getSession().selectMap(statement, parameter, mapKey, rowBounds);
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.getSession().select(statement, parameter, handler);
    }

    public void select(String statement, ResultHandler handler) {
        this.getSession().select(statement, handler);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.getSession().select(statement, parameter, rowBounds, handler);
    }

    public int insert(String statement) {
        return this.getSession().insert(statement);
    }

    public int insert(String statement, Object parameter) {
        return this.getSession().insert(statement, parameter);
    }

    public int update(String statement) {
        return this.getSession().update(statement);
    }

    public int update(String statement, Object parameter) {
        return this.getSession().update(statement, parameter);
    }

    public int delete(String statement) {
        return this.getSession().delete(statement);
    }

    public int delete(String statement, Object parameter) {
        return this.getSession().delete(statement, parameter);
    }

    private String getDefaultSqlTransectionName(String statement) {
        int index = statement.substring(0, statement.lastIndexOf(".")).lastIndexOf(".");
        return statement.substring(index + 1);
    }

    private SqlSession getSession() {
        return this.session;
    }

    public void setSession(SqlSession session) {
        this.session = session;
    }
}

