/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.goods.service.impl;

import com.qianjiang.coupon.bean.MarketingRushUtil;
import com.qianjiang.goods.bean.GoodsDetailBean;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.promotion.bean.PreDiscountMarketing;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.site.goods.service.GoodsProductService1;
import com.qianjiang.site.groupon.bean.GrouponUtil;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="GoodsProductService1")
public class GoodsProductServiceImpl
implements GoodsProductService1 {
    private static final MyLogger LOGGER = new MyLogger(GoodsProductServiceImpl.class);
    private static final String DISTINCTID = "distinctId";
    private static final String CHADDRESS = "chAddress";
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService addressService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;

    @Override
    public GoodsDetailBean queryGoodsByproductIdAndDistinctId(Long productId, Long distinctId, Long marketingId, Long goodsGroupId) {
        GoodsDetailBean detailBean = new GoodsDetailBean();
        try {
            PreDiscountMarketing premark;
            Promotion mark;
            GoodsProductVo productVo = this.goodsProductService.getGoodsProductVoWithGoods(productId, distinctId);
            BigDecimal goodsPrice = BigDecimal.ZERO;
            BigDecimal goodsrate = BigDecimal.ONE;
            DecimalFormat myformat = new DecimalFormat("0.00");
            goodsrate = this.marketingService.getGoodsRate(goodsGroupId);
            if (marketingId != null && 0 != marketingId.intValue() && (mark = this.marketingService.marketingDetail(marketingId, productId)) != null && "15".equals(mark.getCodexType()) && (premark = mark.getPreDiscountMarketing()) != null) {
                String discountFlag = "";
                discountFlag = premark.getDiscountFlag();
                goodsrate = premark.getDiscountInfo();
                myformat = "1".equals(discountFlag) ? new DecimalFormat("0.0") : ("2".equals(discountFlag) ? new DecimalFormat("0") : new DecimalFormat("0.00"));
            }
            myformat.setRoundingMode(RoundingMode.FLOOR);
            goodsPrice = productVo.getGoodsInfoPreferPrice().multiply(goodsrate);
            goodsPrice = BigDecimal.valueOf(Double.valueOf(myformat.format(goodsPrice)));
            productVo.setGoodsInfoPreferPrice(goodsPrice);
            detailBean.setProductVo(productVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e0d\u540c\u5730\u533a\u8d27\u54c1\u4ef7\u683c\u4ee5\u53ca\u5e93\u5b58\u4e0d\u540c \u7ed3\u7b97\u9875\u9762\u7528\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return detailBean;
    }

    @Override
    public PageBean selectGrouponList(PageBean pb, Long distinctId) {
        pb.setRows(this.goodsProductService.selectGrouponCount());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("start", pb.getStartRowNum());
        map.put("number", pb.getEndRowNum());
        List productVos = this.goodsProductService.selectGrouponList(map);
        ArrayList<GrouponUtil> grouponUtils = new ArrayList<GrouponUtil>();
        for (GoodsProductVo vo : productVos) {
            Promotion marketing = this.marketingService.selectGrouponMarket(vo.getMarketingId());
            GoodsDetailBean detailBean = this.goodsProductService.queryDetailBeanByProductIdForGroupon(vo.getGoodsInfoId(), distinctId);
            if (marketing == null) continue;
            GrouponUtil grouponUtil = new GrouponUtil();
            vo.setGoodsInfoPreferPrice(detailBean.getProductVo().getGoodsInfoPreferPrice());
            vo.setGoodsInfoStock(detailBean.getProductVo().getGoodsInfoStock());
            grouponUtil.setGoodsProductVo(vo);
            grouponUtil.setMarketing(marketing);
            grouponUtils.add(grouponUtil);
        }
        pb.setList(grouponUtils);
        return pb;
    }

    @Override
    public PageBean selectMarketingRushList(PageBean pb, Long distinctId) {
        pb.setRows(this.goodsProductService.selectMarketingRushCount());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("start", pb.getStartRowNum());
        map.put("number", pb.getEndRowNum());
        List productVos = this.goodsProductService.selectMarketingRushList(map);
        ArrayList<MarketingRushUtil> marketingRushUtils = new ArrayList<MarketingRushUtil>();
        for (GoodsProductVo vo : productVos) {
            Promotion marketing = this.marketingService.selectRushMarket(vo.getMarketingId());
            GoodsDetailBean detailBean = this.goodsProductService.queryDetailBeanByProductIdForGroupon(vo.getGoodsInfoId(), distinctId);
            if (marketing == null) continue;
            MarketingRushUtil mrUtils = new MarketingRushUtil();
            String rushs = this.compareTime(marketing.getMarketingBegin(), marketing.getMarketingEnd());
            mrUtils.setRushTime(rushs);
            vo.setGoodsInfoPreferPrice(detailBean.getProductVo().getGoodsInfoPreferPrice());
            vo.setGoodsInfoStock(detailBean.getProductVo().getGoodsInfoStock());
            mrUtils.setGoodsProductVo(vo);
            mrUtils.setMarketing(marketing);
            marketingRushUtils.add(mrUtils);
        }
        pb.setList(marketingRushUtils);
        return pb;
    }

    @Override
    public String compareTime(Date begin, Date end) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(new Date().getTime());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        try {
            Date sysdate = df.parse(dateFormat.format(c.getTime()));
            Date begindate = df.parse(dateFormat.format(begin.getTime()));
            Date enddate = df.parse(dateFormat.format(end.getTime()));
            if (sysdate.getTime() <= begindate.getTime()) {
                return "1";
            }
            if (sysdate.getTime() >= enddate.getTime()) {
                return "3";
            }
            if (sysdate.getTime() >= begindate.getTime() && sysdate.getTime() <= enddate.getTime()) {
                return "2";
            }
            return "0";
        }
        catch (ParseException e) {
            LOGGER.error("\u6bd4\u8f83\u65f6\u95f4\u5927\u5c0f\u51fa\u9519\uff1a" + e);
            return "0";
        }
    }
}

