/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.promotion.service.impl;

import com.qianjiang.promotion.bean.Codex;
import com.qianjiang.promotion.dao.CodexMapper;
import com.qianjiang.promotion.service.CodexService;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="CodexService")
public class CodexServiceImpl
implements CodexService {
    private static final Logger LOGGER = Logger.getLogger(CodexServiceImpl.class);
    @Resource(name="CodexMapper")
    private CodexMapper codexMapper;

    @Override
    public PageBean selectCodexList(Codex codex, PageBean pageBean) {
        Map paramMap = MapUtil.getParamsMap((Object)codex);
        try {
            codex.setFlag("0");
            pageBean.setRows(this.codexMapper.selectCodexListCount(paramMap));
            Integer no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            if (no == 0) {
                no = 1;
            }
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no.intValue());
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            pageBean.setObjectBean((Object)codex);
            paramMap.put("start", pageBean.getStartRowNum());
            paramMap.put("number", pageBean.getEndRowNum());
            pageBean.setList(this.codexMapper.selectCodexList(paramMap));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("\u67e5\u8be2\u89c4\u5219\u5217\u8868\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        return pageBean;
    }

    @Override
    public int addCodex(Codex codex) {
        codex.setCreateTime(new Date());
        codex.setModTime(new Date());
        codex.setFlag("0");
        return this.codexMapper.addCodex(codex);
    }

    @Override
    public List<Codex> selectCodexListUseBox() {
        return this.codexMapper.selectCodexListUseBox();
    }

    @Override
    public Codex queryCodexDetail(Long codexId) {
        return this.codexMapper.queryCodexDetail(codexId);
    }

    @Override
    public List<Codex> queryCodexListByParam(Long codexStatus) {
        return this.codexMapper.queryCodexListByParam(codexStatus);
    }

    @Override
    public List<Codex> queryCodexsForSelect() {
        ArrayList<Codex> list = new ArrayList<Codex>();
        list.add(new Codex(1L, "\u76f4\u964d\u4fc3\u9500", "1"));
        list.add(new Codex(5L, "\u6ee1\u51cf\u4fc3\u9500", "5"));
        list.add(new Codex(6L, "\u6ee1\u8d60\u4fc3\u9500", "6"));
        list.add(new Codex(8L, "\u6ee1\u6298\u4fc3\u9500", "8"));
        list.add(new Codex(15L, "\u6298\u6263\u4fc3\u9500", "15"));
        list.add(new Codex(12L, "\u5305\u90ae", "12"));
        list.add(new Codex(10L, "\u56e2\u8d2d\u4fc3\u9500", "10"));
        list.add(new Codex(11L, "\u62a2\u8d2d\u4fc3\u9500", "11"));
        return list;
    }
}

