/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.coupon.service.impl;

import com.qianjiang.common.util.DateUtil;
import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.bean.CouponFullReduction;
import com.qianjiang.coupon.bean.CouponLelvel;
import com.qianjiang.coupon.bean.CouponNo;
import com.qianjiang.coupon.bean.CouponRange;
import com.qianjiang.coupon.bean.CouponStraightDown;
import com.qianjiang.coupon.bean.ParamIds;
import com.qianjiang.coupon.dao.CouponFullReductionMapper;
import com.qianjiang.coupon.dao.CouponMapper;
import com.qianjiang.coupon.dao.CouponNoMapper;
import com.qianjiang.coupon.dao.CouponRangeMapper;
import com.qianjiang.coupon.dao.CouponStraightDownMapper;
import com.qianjiang.coupon.service.CouponLelevlService;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.goods.dao.GoodsBrandMapper;
import com.qianjiang.goods.dao.GoodsCateMapper;
import com.qianjiang.goods.dao.GoodsMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.system.bean.PointSet;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.RanddomMath;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="CouponService")
public class CouponServiceImpl
implements CouponService {
    private static final MyLogger LOGGER = new MyLogger(CouponServiceImpl.class);
    private static final String DOWNPRICE = "downPrice";
    private static final String FULLPRICE = "fullPrice";
    private static final String REDUCTIONPRICE = "reductionPrice";
    private static final String CODESTATUS = "codeStatus";
    private static final String CUSTOMERID = "customerId";
    @Resource(name="CouponMapper")
    private CouponMapper couponMapper;
    @Resource(name="CouponNoMapper")
    private CouponNoMapper couponNoMapper;
    @Resource(name="CouponRangeMapper")
    private CouponRangeMapper couponRangeMapper;
    @Resource(name="GoodsCateMapper")
    private GoodsCateMapper goodsCateMapper;
    @Resource(name="GoodsBrandMapper")
    private GoodsBrandMapper goodsBrandMapper;
    @Resource(name="GoodsMapper")
    private GoodsMapper goodsMapper;
    @Resource(name="CouponFullReductionMapper")
    private CouponFullReductionMapper couponFullReductionMapper;
    @Resource(name="CouponStraightDownMapper")
    private CouponStraightDownMapper couponStraightDownMapper;
    @Resource(name="CouponLelevlService")
    private CouponLelevlService couponLelevlService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;

    @Override
    public List<Object> queryCouponListToBoss() {
        return this.couponMapper.queryCouponListToBoss();
    }

    @Override
    public List<Coupon> selectCouponList_site() {
        List<Coupon> couponLists = this.couponMapper.selectCouponList_site();
        for (int i = 0; i < couponLists.size(); ++i) {
            Coupon coupons = couponLists.get(i);
            String couponRulesType = coupons.getCouponRulesType();
            if ("1".equals(couponRulesType)) {
                coupons.setCouponStraightDown(this.couponStraightDownMapper.selectCouponStraightDown(coupons.getCouponId()));
            }
            if (!"2".equals(couponRulesType)) continue;
            coupons.setCouponFullReduction(this.couponFullReductionMapper.selectCouponFullReduction(coupons.getCouponId()));
        }
        return couponLists;
    }

    @Override
    public List<Coupon> selectCouponListByStoreId(Long storeId) {
        return this.couponMapper.selectCouponListByStoreId(storeId);
    }

    @Override
    public int updateCustomerPoint(CustomerPoint point) {
        return this.couponMapper.updateCustomerPoint(point);
    }

    @Override
    public PointSet selectPointSet() {
        return this.couponMapper.selectPointSet();
    }

    @Override
    public CustomerPoint selectCustomerPointByCustomerId(Long customerId) {
        CustomerPoint customerPoint = this.couponMapper.selectCustomerPointByCustomerId(customerId);
        if (null != customerPoint) {
            customerPoint.setPointSum(Long.valueOf(this.customerPointServiceMapper.getCustomerAllPoint(customerId + "").intValue()));
        }
        return customerPoint;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int doAddCoupon(Coupon coupon, Map<String, Object> requestmap, Long[] lelvelId) {
        int result = 0;
        Date currentDate = new Date();
        String downPrice = (String)requestmap.get(DOWNPRICE);
        String fullPrice = (String)requestmap.get(FULLPRICE);
        String reductionPrice = (String)requestmap.get(REDUCTIONPRICE);
        try {
            String couponRulesType;
            coupon.setCreateTime(currentDate);
            coupon.setModifyTime(currentDate);
            coupon.setDelFlag("0");
            this.couponMapper.doAddCoupon(coupon);
            Long couponId = coupon.getCodeId();
            ArrayList<CouponLelvel> clist = new ArrayList<CouponLelvel>();
            for (int i = 0; i < lelvelId.length; ++i) {
                CouponLelvel level = new CouponLelvel();
                level.setCouponId(couponId);
                level.setLelvelId(lelvelId[i]);
                level.setLelvelDelFlag("0");
                clist.add(level);
            }
            if (clist != null && !clist.isEmpty()) {
                this.couponLelevlService.addCouponLelvel(clist);
            }
            if ("1".equals(couponRulesType = coupon.getCouponRulesType())) {
                CouponStraightDown straightDown = new CouponStraightDown();
                straightDown.setCouponId(couponId);
                if (downPrice != null && !downPrice.isEmpty()) {
                    straightDown.setDownPrice(BigDecimal.valueOf(Double.valueOf(downPrice)));
                } else {
                    straightDown.setDownPrice(BigDecimal.valueOf(Double.valueOf(reductionPrice)));
                }
                straightDown.setUpdateTime(currentDate);
                straightDown.setDelFlag("0");
                this.couponStraightDownMapper.insertStraightDown(straightDown);
            } else if ("2".equals(coupon.getCouponRulesType())) {
                CouponFullReduction fullReduction = new CouponFullReduction();
                fullReduction.setCouponId(couponId);
                fullReduction.setFullPrice(BigDecimal.valueOf(Double.valueOf(fullPrice)));
                fullReduction.setReductionPrice(BigDecimal.valueOf(Double.valueOf(reductionPrice)));
                fullReduction.setUpdateTime(currentDate);
                fullReduction.setDelFlag("0");
                this.couponFullReductionMapper.insertFullDuction(fullReduction);
            }
            ArrayList<CouponNo> list = new ArrayList<CouponNo>();
            if (coupon.getCouponCount() != null && coupon.getCouponCount() > 0) {
                for (int i = 0; i < coupon.getCouponCount(); ++i) {
                    CouponNo cn = new CouponNo();
                    cn.setCodeStatus("0");
                    cn.setCodeNo(RanddomMath.randomString(32));
                    cn.setCouponId(couponId);
                    list.add(cn);
                }
                this.couponNoMapper.createCouponNo(list);
            }
            List goodsIdl = (List)requestmap.get("goodsId");
            String[] goodsId = (String[])goodsIdl.toArray();
            ArrayList<CouponRange> mslist = new ArrayList<CouponRange>();
            if (goodsId != null && goodsId.length > 0) {
                for (int i = 0; i < goodsId.length; ++i) {
                    CouponRange cr = new CouponRange();
                    cr.setCouponId(couponId);
                    cr.setCouponRangeFkId(Long.valueOf(goodsId[i]));
                    cr.setCouponRangeType("2");
                    cr.setDelFlag("0");
                    mslist.add(cr);
                }
            }
            if (mslist != null && !mslist.isEmpty()) {
                this.couponRangeMapper.createCouponRange(mslist);
            }
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int doAddCoupon(Coupon coupon, Map<String, Object> requestmap, Long[] lelvelId, String status) {
        int result = 0;
        Date currentDate = new Date();
        String downPrice = (String)requestmap.get(DOWNPRICE);
        String fullPrice = (String)requestmap.get(FULLPRICE);
        String reductionPrice = (String)requestmap.get(REDUCTIONPRICE);
        try {
            List goodsIdl;
            String[] goodsId;
            String couponRulesType;
            coupon.setCreateTime(currentDate);
            coupon.setModifyTime(currentDate);
            coupon.setDelFlag("0");
            this.couponMapper.doAddCoupon(coupon);
            Long couponId = coupon.getCouponId();
            ArrayList<CouponLelvel> clist = new ArrayList<CouponLelvel>();
            if (null != lelvelId && lelvelId.length > 0) {
                for (int i = 0; i < lelvelId.length; ++i) {
                    CouponLelvel level = new CouponLelvel();
                    level.setCouponId(couponId);
                    level.setLelvelId(lelvelId[i]);
                    level.setLelvelDelFlag("0");
                    clist.add(level);
                }
            }
            if (clist != null && !clist.isEmpty()) {
                this.couponLelevlService.addCouponLelvel(clist);
            }
            if ("1".equals(couponRulesType = coupon.getCouponRulesType())) {
                CouponStraightDown straightDown = new CouponStraightDown();
                straightDown.setCouponId(couponId);
                if (downPrice != null && !downPrice.isEmpty()) {
                    straightDown.setDownPrice(BigDecimal.valueOf(Double.valueOf(downPrice)));
                } else {
                    straightDown.setDownPrice(BigDecimal.valueOf(Double.valueOf(reductionPrice)));
                }
                straightDown.setUpdateTime(currentDate);
                straightDown.setDelFlag("0");
                this.couponStraightDownMapper.insertStraightDown(straightDown);
            } else if ("2".equals(couponRulesType)) {
                CouponFullReduction fullReduction = new CouponFullReduction();
                fullReduction.setCouponId(couponId);
                fullReduction.setFullPrice(BigDecimal.valueOf(Double.valueOf(fullPrice)));
                fullReduction.setReductionPrice(BigDecimal.valueOf(Double.valueOf(reductionPrice)));
                fullReduction.setUpdateTime(currentDate);
                fullReduction.setDelFlag("0");
                this.couponFullReductionMapper.insertFullDuction(fullReduction);
            }
            ArrayList<CouponNo> list = new ArrayList<CouponNo>();
            if (coupon.getCouponCount() != null && coupon.getCouponCount() > 0) {
                for (int i = 0; i < coupon.getCouponCount(); ++i) {
                    CouponNo cn = new CouponNo();
                    cn.setCouponId(couponId);
                    cn.setCodeNo(RanddomMath.randomString(16));
                    cn.setCodeStatus("0");
                    list.add(cn);
                }
            }
            if (list != null && !list.isEmpty()) {
                this.couponNoMapper.createCouponNo(list);
            }
            ArrayList<CouponRange> mslist = new ArrayList<CouponRange>();
            if ("1".equals(status)) {
                List cateIdl = (List)requestmap.get("cateIdp");
                String[] cateId = (String[])cateIdl.toArray();
                if (cateId != null && cateId.length > 0) {
                    for (int i = 0; i < cateId.length; ++i) {
                        CouponRange cr = new CouponRange();
                        cr.setCouponId(couponId);
                        cr.setCouponRangeFkId(Long.valueOf(cateId[i]));
                        cr.setDelFlag("0");
                        cr.setCouponRangeType("0");
                        mslist.add(cr);
                    }
                }
            } else if ("2".equals(status)) {
                List brandIdl = (List)requestmap.get("brandIdP");
                String[] brandId = (String[])brandIdl.toArray();
                if (brandId != null && brandId.length > 0) {
                    for (int i = 0; i < brandId.length; ++i) {
                        CouponRange cr = new CouponRange();
                        cr.setCouponId(couponId);
                        cr.setCouponRangeFkId(Long.valueOf(brandId[i]));
                        cr.setDelFlag("0");
                        cr.setCouponRangeType("1");
                        mslist.add(cr);
                    }
                }
            } else if ("0".equals(status) && (goodsId = (String[])(goodsIdl = (List)requestmap.get("goodsIdP")).toArray()) != null && goodsId.length > 0) {
                for (int i = 0; i < goodsId.length; ++i) {
                    CouponRange cr = new CouponRange();
                    cr.setCouponId(couponId);
                    cr.setCouponRangeFkId(Long.valueOf(goodsId[i]));
                    cr.setCouponRangeType("2");
                    cr.setDelFlag("0");
                    mslist.add(cr);
                }
            }
            if (mslist != null && !mslist.isEmpty()) {
                this.couponRangeMapper.createCouponRange(mslist);
            }
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6309\u5206\u7c7b\u6dfb\u52a0\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public PageBean searchCouponList(Coupon coupon, PageBean pageBean, String startTime, String endTime) {
        Map paramMap = MapUtil.getParamsMap((Object)coupon);
        try {
            if (startTime != null && !"".equals(startTime)) {
                coupon.setCouponStartTime(DateUtil.stringToDate((String)startTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                paramMap.put("couponStartTime", startTime);
            }
            if (endTime != null && !"".equals(endTime)) {
                coupon.setCouponEndTime(DateUtil.stringToDate((String)endTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                paramMap.put("couponEndTime", endTime);
            }
            if (coupon.getBusinessId() == null) {
                coupon.setBusinessId(0L);
            }
            paramMap.put("businessId", coupon.getBusinessId());
            pageBean.setRows(this.couponMapper.selectCouponListCount(paramMap));
            Integer no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no.intValue());
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            pageBean.setObjectBean((Object)coupon);
            paramMap.put("start", pageBean.getStartRowNum());
            paramMap.put("number", pageBean.getEndRowNum());
            pageBean.setList(this.couponMapper.selectCouponList(paramMap));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u5206\u9875\u67e5\u8be2\u6240\u6709\u4f18\u60e0\u5238\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pageBean;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int delCoupon(Long couponId) {
        Coupon cn = this.couponMapper.searchCouponById(couponId);
        int s = this.couponMapper.delCoupon(couponId);
        if (s > 0) {
            this.couponNoMapper.delCouponNo(couponId);
            this.deleteCouponShip(couponId, cn.getCouponRulesType());
        }
        return s;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int delAllCoupon(Long[] couponId) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long s : couponId) {
            Coupon cn = this.couponMapper.searchCouponById(s);
            this.deleteCouponShip(s, cn.getCouponRulesType());
            list.add(s);
        }
        int dcount = this.couponMapper.delAllCoupon(list);
        if (dcount > 0) {
            this.couponNoMapper.delAllCouponNo(list);
        }
        return dcount;
    }

    @Override
    @Transactional(readOnly=true)
    public Coupon searchCouponById(Long couponId) {
        Coupon coupon = this.couponMapper.searchCouponById(couponId);
        if ("1".equals(coupon.getCouponRulesType())) {
            coupon.setCouponStraightDown(this.couponStraightDownMapper.selectCouponStraightDown(couponId));
        }
        if ("2".equals(coupon.getCouponRulesType())) {
            coupon.setCouponFullReduction(this.couponFullReductionMapper.selectCouponFullReduction(couponId));
        }
        return coupon;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int doUpdateCouponById(Coupon coupon, Map<String, Object> requestmap, Long[] lelvelId, String status) {
        int result = 0;
        Date currentDate = new Date();
        String downPrice = (String)requestmap.get(DOWNPRICE);
        String fullPrice = (String)requestmap.get(FULLPRICE);
        String reductionPrice = (String)requestmap.get(REDUCTIONPRICE);
        try {
            List goodsIdl;
            String[] goodsId;
            Long couponId = coupon.getCouponId();
            String couponRulesType = coupon.getCouponRulesType();
            this.deleteCouponShip(couponId, couponRulesType);
            this.couponRangeMapper.delAllCouponRange(couponId);
            this.couponLelevlService.deleteCouponLelvel(couponId);
            coupon.setModifyTime(currentDate);
            this.couponMapper.doUpdateCouponById(coupon);
            ArrayList<CouponLelvel> clist = new ArrayList<CouponLelvel>();
            for (int i = 0; i < lelvelId.length; ++i) {
                CouponLelvel level = new CouponLelvel();
                level.setCouponId(couponId);
                level.setLelvelId(lelvelId[i]);
                level.setLelvelDelFlag("0");
                clist.add(level);
            }
            if (clist != null && !clist.isEmpty()) {
                this.couponLelevlService.addCouponLelvel(clist);
            }
            if ("1".equals(couponRulesType)) {
                CouponStraightDown straightDown = new CouponStraightDown();
                straightDown.setCouponId(couponId);
                if (downPrice != null && !downPrice.isEmpty()) {
                    straightDown.setDownPrice(BigDecimal.valueOf(Double.valueOf(downPrice)));
                } else {
                    straightDown.setDownPrice(BigDecimal.valueOf(Double.valueOf(reductionPrice)));
                }
                straightDown.setUpdateTime(currentDate);
                straightDown.setDelFlag("0");
                this.couponStraightDownMapper.insertStraightDown(straightDown);
            } else if ("2".equals(couponRulesType)) {
                CouponFullReduction fullReduction = new CouponFullReduction();
                fullReduction.setCouponId(couponId);
                fullReduction.setFullPrice(BigDecimal.valueOf(Double.valueOf(fullPrice)));
                fullReduction.setReductionPrice(BigDecimal.valueOf(Double.valueOf(reductionPrice)));
                fullReduction.setUpdateTime(currentDate);
                fullReduction.setDelFlag("0");
                this.couponFullReductionMapper.insertFullDuction(fullReduction);
            }
            ArrayList<CouponRange> mslist = new ArrayList<CouponRange>();
            if ("1".equals(status)) {
                List cateIdl = "0".equals(coupon.getIsAll()) ? (List)requestmap.get("cateIdp") : (List)requestmap.get("thirdcate_ids");
                String[] cateId = (String[])cateIdl.toArray();
                if (cateId != null && cateId.length > 0) {
                    for (int i = 0; i < cateId.length; ++i) {
                        CouponRange cr = new CouponRange();
                        cr.setCouponId(couponId);
                        cr.setCouponRangeFkId(Long.valueOf(cateId[i]));
                        cr.setCouponRangeType("0");
                        cr.setDelFlag("0");
                        mslist.add(cr);
                    }
                }
            } else if ("2".equals(status)) {
                List brandIdl = "0".equals(coupon.getIsAll()) ? (List)requestmap.get("brandIdP") : (List)requestmap.get("brand_allids");
                String[] brandId = (String[])brandIdl.toArray();
                if (brandId != null && brandId.length > 0) {
                    for (int i = 0; i < brandId.length; ++i) {
                        CouponRange cr = new CouponRange();
                        cr.setCouponId(couponId);
                        cr.setCouponRangeFkId(Long.valueOf(brandId[i]));
                        cr.setCouponRangeType("1");
                        cr.setDelFlag("0");
                        mslist.add(cr);
                    }
                }
            } else if ("0".equals(status) && (goodsId = (String[])(goodsIdl = "0".equals(coupon.getIsAll()) ? (List)requestmap.get("goodsIdP") : (List)requestmap.get("product_allids")).toArray()) != null && goodsId.length > 0) {
                for (int i = 0; i < goodsId.length; ++i) {
                    CouponRange cr = new CouponRange();
                    cr.setCouponId(couponId);
                    cr.setCouponRangeFkId(Long.valueOf(goodsId[i]));
                    cr.setCouponRangeType("2");
                    cr.setDelFlag("0");
                    mslist.add(cr);
                }
            }
            if (mslist != null && !mslist.isEmpty()) {
                this.couponRangeMapper.createCouponRange(mslist);
            }
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u4fee\u6539\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public List<Object> selectCouponRange(Long couponId, String type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("couponId", couponId);
        paramMap.put("couponRangeType", type);
        List<CouponRange> scopelist = this.couponRangeMapper.selectCouponRange(paramMap);
        List list = null;
        ArrayList<Long> idList = new ArrayList<Long>();
        if (scopelist != null && !scopelist.isEmpty()) {
            for (int i = 0; i < scopelist.size(); ++i) {
                idList.add(scopelist.get(i).getCouponRangeFkId());
            }
        }
        if ("0".equals(type) && !idList.isEmpty()) {
            list = this.goodsCateMapper.selectProductCateList(idList);
        }
        if ("1".equals(type) && !idList.isEmpty()) {
            list = this.goodsBrandMapper.selectProductBrandList(idList);
        }
        if ("2".equals(type) && !idList.isEmpty()) {
            list = this.goodsMapper.selectProductSkuList(idList);
        }
        return list;
    }

    @Override
    public PageBean myCouponList(PageBean pageBean, Long customerId, String codeStatus) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            if ("1".equals(codeStatus)) {
                paramMap.put(CODESTATUS, "1");
            } else if ("2".equals(codeStatus)) {
                paramMap.put(CODESTATUS, "2");
            } else if ("3".equals(codeStatus)) {
                paramMap.put(CODESTATUS, "3");
            } else {
                paramMap.put(CODESTATUS, "");
            }
            paramMap.put(CUSTOMERID, customerId);
            int myCouponListCount = this.couponMapper.myCouponListCount(paramMap);
            pageBean.setRows(myCouponListCount);
            paramMap.put("start", pageBean.getStartRowNum());
            paramMap.put("number", pageBean.getEndRowNum());
            List<Object> couponlist = this.couponMapper.myCouponList(paramMap);
            if (couponlist != null && !couponlist.isEmpty()) {
                for (int i = 0; i < couponlist.size(); ++i) {
                    Object obj = couponlist.get(i);
                    Coupon coupon = (Coupon)obj;
                    String couponRulesType = coupon.getCouponRulesType();
                    if ("1".equals(couponRulesType)) {
                        CouponStraightDown selectCouponStraightDown = this.couponStraightDownMapper.selectCouponStraightDown(coupon.getCouponId());
                        coupon.setCouponStraightDown(selectCouponStraightDown);
                    }
                    if ("2".equals(couponRulesType)) {
                        CouponFullReduction selectCouponFullReduction = this.couponFullReductionMapper.selectCouponFullReduction(coupon.getCouponId());
                        coupon.setCouponFullReduction(selectCouponFullReduction);
                    }
                    Object gclist = this.selectCouponRange(coupon.getCouponId(), "0");
                    coupon.setGclist((List<Object>)gclist);
                    Object gblist = this.selectCouponRange(coupon.getCouponId(), "1");
                    coupon.setGblist((List<Object>)gblist);
                    Object gplist = this.selectCouponRange(coupon.getCouponId(), "2");
                    coupon.setGplist((List<Object>)gplist);
                }
            }
            pageBean.setList(couponlist);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u67e5\u8be2\u6211\u7684\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pageBean;
    }

    @Override
    public int myCouponNoCount(Long customerId) {
        return this.couponMapper.myCouponNoCount(customerId);
    }

    @Override
    public List<Coupon> selectCouponListByIds(List<ParamIds> list, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("list", list);
        paramMap.put(CUSTOMERID, customerId);
        List<Coupon> couponlist = this.couponMapper.selectCouponListByIds(paramMap);
        if (couponlist != null && !couponlist.isEmpty()) {
            for (int i = 0; i < couponlist.size(); ++i) {
                if ("1".equals(couponlist.get(i).getCouponRulesType())) {
                    couponlist.get(i).setCouponStraightDown(this.couponStraightDownMapper.selectCouponStraightDown(couponlist.get(i).getCouponId()));
                }
                if (!"2".equals(couponlist.get(i).getCouponRulesType())) continue;
                couponlist.get(i).setCouponFullReduction(this.couponFullReductionMapper.selectCouponFullReduction(couponlist.get(i).getCouponId()));
            }
        }
        return couponlist;
    }

    @Override
    public List<Coupon> selectThirdCouponListByIds(List<ParamIds> list, Long customerId, Long third) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("list", list);
        paramMap.put(CUSTOMERID, customerId);
        paramMap.put("third", third);
        List<Coupon> couponlist = this.couponMapper.selectCouponListByIds(paramMap);
        if (couponlist != null && !couponlist.isEmpty()) {
            for (int i = 0; i < couponlist.size(); ++i) {
                if ("1".equals(couponlist.get(i).getCouponRulesType())) {
                    couponlist.get(i).setCouponStraightDown(this.couponStraightDownMapper.selectCouponStraightDown(couponlist.get(i).getCouponId()));
                }
                if (!"2".equals(couponlist.get(i).getCouponRulesType())) continue;
                couponlist.get(i).setCouponFullReduction(this.couponFullReductionMapper.selectCouponFullReduction(couponlist.get(i).getCouponId()));
            }
        }
        return couponlist;
    }

    @Override
    public List<Coupon> selectCouponListByIdsNew(List<ParamIds> list, Long thirdId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("list", list);
        paramMap.put("thirdId", thirdId);
        List<Coupon> couponlist = this.couponMapper.selectCouponListByIdsNew(paramMap);
        if (couponlist != null && !couponlist.isEmpty()) {
            for (int i = 0; i < couponlist.size(); ++i) {
                if ("1".equals(couponlist.get(i).getCouponRulesType())) {
                    couponlist.get(i).setCouponStraightDown(this.couponStraightDownMapper.selectCouponStraightDown(couponlist.get(i).getCouponId()));
                }
                if ("2".equals(couponlist.get(i).getCouponRulesType())) {
                    couponlist.get(i).setCouponFullReduction(this.couponFullReductionMapper.selectCouponFullReduction(couponlist.get(i).getCouponId()));
                }
                couponlist.get(i).setGclist((List<Object>)this.selectCouponRange(couponlist.get(i).getCouponId(), "0"));
                couponlist.get(i).setGblist((List<Object>)this.selectCouponRange(couponlist.get(i).getCouponId(), "1"));
                Object gpList = this.selectCouponRange(couponlist.get(i).getCouponId(), "2");
                couponlist.get(i).setGplist((List<Object>)gpList);
            }
        }
        return couponlist;
    }

    @Override
    public Coupon selectCouponByCodeNo(String codeNo) {
        Coupon coupon = this.couponMapper.selectCouponByCodeNo(codeNo);
        if (coupon != null) {
            if ("1".equals(coupon.getCouponRulesType())) {
                coupon.setCouponStraightDown(this.couponStraightDownMapper.selectCouponStraightDown(coupon.getCouponId()));
            }
            if ("2".equals(coupon.getCouponRulesType())) {
                coupon.setCouponFullReduction(this.couponFullReductionMapper.selectCouponFullReduction(coupon.getCouponId()));
            }
        }
        return coupon;
    }

    @Override
    public Coupon selectOneCouponNoByCouponIdAndUpdateNoIsGet(Long couponId, Long customerId) {
        Coupon coupon = this.couponMapper.selectOneCouponNoByCouponId(couponId);
        if (coupon != null) {
            CouponNo cn = new CouponNo();
            cn.setCodeNo(coupon.getCodeNo());
            cn.setCodeStatus("1");
            this.couponNoMapper.modifyNoStatus(cn);
        }
        return coupon;
    }

    @Override
    public int giveCusCoupon(String couponNo, Long customerId) {
        CouponNo cn = new CouponNo();
        cn.setCodeNo(couponNo);
        cn.setCustomerId(customerId);
        return this.couponNoMapper.giveCusCoupon(cn);
    }

    @Override
    public int modifyNoStatus(String couponNo, String codeStatus) {
        CouponNo no = new CouponNo();
        no.setCodeNo(couponNo);
        no.setCodeStatus(codeStatus);
        return this.couponNoMapper.modifyNoStatus(no);
    }

    @Override
    public int modifyNoStatusNew(String couponNo, String codeStatus) {
        CouponNo no = new CouponNo();
        no.setCodeNo(couponNo);
        no.setCodeStatus(codeStatus);
        return this.couponNoMapper.modifyNoStatusNew(no);
    }

    @Override
    public void addCouponC(Long couponId) {
        ArrayList<CouponNo> list = new ArrayList<CouponNo>();
        for (int i = 0; i < 100; ++i) {
            CouponNo cn = new CouponNo();
            cn.setCodeStatus("0");
            cn.setCodeNo(RanddomMath.randomString(32));
            cn.setCouponId(couponId);
            list.add(cn);
        }
        this.couponNoMapper.createCouponNo(list);
    }

    @Override
    public Date selectCouponTimeByCodeId(Long codeId) {
        return this.couponMapper.selectCouponTimeByCodeId(codeId);
    }

    @Override
    public int selectCouponCount() {
        return this.couponMapper.selectCouponListCount(null);
    }

    @Override
    public int returnCouponNo(String couponNo) {
        return this.couponNoMapper.returnCouponNo(couponNo);
    }

    @Override
    public List<Object> queryCouponList() {
        return this.couponMapper.queryCouponList();
    }

    @Override
    public List<Coupon> selectCouponListByAble() {
        return this.couponMapper.selectCouponListByAble();
    }

    @Override
    @Transactional(readOnly=true)
    public int newdelCoupon(Long couponId, Long thirdId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("couponId", couponId);
        paramMap.put("business", thirdId);
        Coupon cn = this.couponMapper.searchCouponById(couponId);
        int s = this.couponMapper.newDelCoupon(paramMap);
        if (s > 0) {
            this.couponNoMapper.delCouponNo(couponId);
            this.deleteCouponShip(couponId, cn.getCouponRulesType());
        }
        return s;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int delAllCoupon(Long[] couponId, Long thirdId) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long s : couponId) {
            Coupon cn = this.couponMapper.searchCouponById(s);
            this.deleteCouponShip(s, cn.getCouponRulesType());
            list.add(s);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("list", list);
        paramMap.put("business", thirdId);
        int dcount = this.couponMapper.newDelAllCoupon(paramMap);
        if (dcount > 0) {
            this.couponNoMapper.delAllCouponNo(list);
        }
        return dcount;
    }

    @Override
    public Long countByCodeStatus(Long customerId, String status) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(CODESTATUS, status);
        paramMap.put(CUSTOMERID, customerId);
        return this.couponMapper.myCouponListCount(paramMap);
    }

    @Override
    public void addIntegralUseRecord(Long customerId, Integer point, String str) {
        CustomerPoint customerPoint = new CustomerPoint();
        customerPoint.setCreateTime(new Date());
        customerPoint.setCustomerId(customerId);
        customerPoint.setPoint(point);
        customerPoint.setPointDetail(str);
        customerPoint.setPointType("0");
        this.couponMapper.addIntegralUseRecord(customerPoint);
    }

    @Override
    public List<Coupon> selectCouponListByCustomerId(Long customerId) {
        List<Coupon> couponlist = this.couponMapper.selectCouponListByCustomerId(customerId);
        if (couponlist != null && !couponlist.isEmpty()) {
            for (int i = 0; i < couponlist.size(); ++i) {
                if ("1".equals(couponlist.get(i).getCouponRulesType())) {
                    couponlist.get(i).setCouponStraightDown(this.couponStraightDownMapper.selectCouponStraightDown(couponlist.get(i).getCouponId()));
                }
                if ("2".equals(couponlist.get(i).getCouponRulesType())) {
                    couponlist.get(i).setCouponFullReduction(this.couponFullReductionMapper.selectCouponFullReduction(couponlist.get(i).getCouponId()));
                }
                couponlist.get(i).setGclist((List<Object>)this.selectCouponRange(couponlist.get(i).getCouponId(), "0"));
                couponlist.get(i).setGblist((List<Object>)this.selectCouponRange(couponlist.get(i).getCouponId(), "1"));
                Object gpList = this.selectCouponRange(couponlist.get(i).getCouponId(), "2");
                couponlist.get(i).setGplist((List<Object>)gpList);
            }
        }
        return couponlist;
    }

    @Override
    public List<Object> myCouponListM(Long customerId, String codeStatus) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        List<Object> couponlist = new ArrayList<Object>();
        try {
            if ("1".equals(codeStatus)) {
                paramMap.put(CODESTATUS, "1");
            } else if ("2".equals(codeStatus)) {
                paramMap.put(CODESTATUS, "2");
            } else if ("3".equals(codeStatus)) {
                paramMap.put(CODESTATUS, "3");
            } else {
                paramMap.put(CODESTATUS, "");
            }
            paramMap.put(CUSTOMERID, customerId);
            couponlist = this.couponMapper.myCouponList(paramMap);
            if (couponlist != null && !couponlist.isEmpty()) {
                for (int i = 0; i < couponlist.size(); ++i) {
                    if ("1".equals(((Coupon)couponlist.get(i)).getCouponRulesType())) {
                        ((Coupon)couponlist.get(i)).setCouponStraightDown(this.couponStraightDownMapper.selectCouponStraightDown(((Coupon)couponlist.get(i)).getCouponId()));
                    }
                    if ("2".equals(((Coupon)couponlist.get(i)).getCouponRulesType())) {
                        ((Coupon)couponlist.get(i)).setCouponFullReduction(this.couponFullReductionMapper.selectCouponFullReduction(((Coupon)couponlist.get(i)).getCouponId()));
                    }
                    ((Coupon)couponlist.get(i)).setGclist((List<Object>)this.selectCouponRange(((Coupon)couponlist.get(i)).getCouponId(), "0"));
                    ((Coupon)couponlist.get(i)).setGblist((List<Object>)this.selectCouponRange(((Coupon)couponlist.get(i)).getCouponId(), "1"));
                    Object gpList = this.selectCouponRange(((Coupon)couponlist.get(i)).getCouponId(), "2");
                    ((Coupon)couponlist.get(i)).setGplist((List<Object>)gpList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u65b0\u624b\u673a\u7aef\u6211\u7684\u4f18\u60e0\u5238\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return couponlist;
    }

    @Override
    public List<Coupon> selectCouponListByIdsAndCusId(List<ParamIds> list, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("list", list);
        paramMap.put(CUSTOMERID, customerId);
        List<Coupon> couponlist = this.couponMapper.selectCouponListByIds(paramMap);
        if (couponlist != null && !couponlist.isEmpty()) {
            for (int i = 0; i < couponlist.size(); ++i) {
                if ("1".equals(couponlist.get(i).getCouponRulesType())) {
                    couponlist.get(i).setCouponStraightDown(this.couponStraightDownMapper.selectCouponStraightDown(couponlist.get(i).getCouponId()));
                }
                if (!"2".equals(couponlist.get(i).getCouponRulesType())) continue;
                couponlist.get(i).setCouponFullReduction(this.couponFullReductionMapper.selectCouponFullReduction(couponlist.get(i).getCouponId()));
            }
        }
        return couponlist;
    }

    private void deleteCouponShip(Long couponId, String couponRulesType) {
        if ("1".equals(couponRulesType)) {
            this.couponStraightDownMapper.deleteStraightDown(couponId);
        }
        if ("2".equals(couponRulesType)) {
            this.couponFullReductionMapper.deleteFullReduction(couponId);
        }
        this.couponRangeMapper.delAllCouponRange(couponId);
    }
}

