/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.promotion.service.impl;

import com.qianjiang.promotion.bean.PromotionLogo;
import com.qianjiang.promotion.dao.PromotionLogoMapper;
import com.qianjiang.promotion.service.PromotionLogoService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="PromotionLogoService")
public class PromotionLogoServiceImpl
implements PromotionLogoService {
    private static final MyLogger LOGGER = new MyLogger(PromotionLogoServiceImpl.class);
    @Resource(name="PromotionLogoMapper")
    private PromotionLogoMapper logoMapper;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int addPromotionLogo(PromotionLogo promotionLogo) {
        promotionLogo.setCreateTime(new Date());
        promotionLogo.setDelFlag("0");
        return this.logoMapper.insertSelective(promotionLogo);
    }

    @Override
    public PromotionLogo selectByPrimaryKey(Long promotionLogoId) {
        return this.logoMapper.selectByPrimaryKey(promotionLogoId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int updatePromotionLogo(PromotionLogo promotionLogo) {
        promotionLogo.setModifyTime(new Date());
        return this.logoMapper.updateByPrimaryKeySelective(promotionLogo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int delAllPromotionLogo(Long[] promotionLogoId) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long s : promotionLogoId) {
            list.add(s);
        }
        return this.logoMapper.delAllPromotionLogo(list);
    }

    @Override
    public PageBean queryAllPromotionLogo(PageBean pageBean, PromotionLogo logo) {
        int rows;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (logo.getPromotionLogoName() != null && !"".equals(logo.getPromotionLogoName())) {
            paramMap.put("promotionLogoName", logo.getPromotionLogoName());
        }
        if ((rows = this.logoMapper.queryPromotionLogoCount(paramMap)) > 0) {
            pageBean.setRows(rows);
        } else {
            pageBean.setRows(0);
        }
        pageBean.setObjectBean((Object)logo);
        paramMap.put("start", pageBean.getStartRowNum());
        paramMap.put("number", pageBean.getEndRowNum());
        pageBean.setList(this.logoMapper.queryPromotionLogoList(paramMap));
        return pageBean;
    }

    @Override
    public boolean checkLogoName(String promotionLogoName) {
        return this.logoMapper.checkLogoName(promotionLogoName) <= 0;
    }

    @Override
    public PromotionLogo selectByLogoId(Long promotionLogoId) {
        return this.logoMapper.selectByPrimaryKey(promotionLogoId);
    }

    @Override
    public List<PromotionLogo> queryAllLogoList() {
        return this.logoMapper.queryAllLogoList();
    }
}

