/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.gift.service.impl;

import com.qianjiang.gift.bean.Gift;
import com.qianjiang.gift.bean.GiftPic;
import com.qianjiang.gift.dao.GiftMapper;
import com.qianjiang.gift.dao.GiftPicMapper;
import com.qianjiang.gift.service.GiftService;
import com.qianjiang.goods.bean.InfoImageManage;
import com.qianjiang.goods.dao.ImageSetMapper;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GiftService")
public class GiftServiceImpl
implements GiftService {
    private GiftMapper giftMapper;
    private GiftPicMapper giftPicMapper;
    @Resource(name="GoodsImageSetMapper")
    private ImageSetMapper imageSetMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchGiftList(Gift gift, PageBean pageBean) {
        gift.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)gift);
        pageBean.setRows(this.giftMapper.searchGiftListCount(paramMap));
        Integer no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
        no = no == 0 ? 1 : no;
        if (pageBean.getPageNo() >= no) {
            pageBean.setPageNo(no.intValue());
            pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            pageBean.setObjectBean((Object)gift);
        }
        paramMap.put("start", pageBean.getStartRowNum());
        paramMap.put("number", pageBean.getEndRowNum());
        try {
            pageBean.setList(this.giftMapper.searchGiftList(paramMap));
        }
        finally {
            paramMap = null;
        }
        return pageBean;
    }

    @Override
    @Transactional
    public int doAddGift(Gift gift) {
        int flag = 0;
        gift.setCreateTime(new Date());
        gift.setModifyTime(new Date());
        gift.setDelFlag("0");
        flag = this.giftMapper.doAddGift(gift);
        if (flag > 0 && gift.getPicUrl() != null && !"".equals(gift.getPicUrl())) {
            GiftPic image = new GiftPic();
            image.setDelFlag("0");
            image.setPicUrl(gift.getPicUrl());
            image.setGiftId(gift.getGiftId());
            if (gift.getPicUrl().indexOf(".com") != -1) {
                image.setPicBig(gift.getPicUrl() + "!352");
                image.setPicMiddle(gift.getPicUrl() + "!160");
                image.setPicLittle(gift.getPicUrl() + "!56");
            } else {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("url", gift.getPicUrl());
                InfoImageManage infoImageManage = this.imageSetMapper.queryImageByUrl(paramMap);
                image.setPicBig(infoImageManage.getBigImgUrl());
                image.setPicMiddle(infoImageManage.getMiddleImgUrl());
                image.setPicLittle(infoImageManage.getSmallImgUrl());
            }
            this.giftPicMapper.savePic(image);
        }
        return flag;
    }

    @Override
    public Gift selectGiftDetailById(Long giftId) {
        Gift gift = this.giftMapper.selectGiftDetailById(giftId);
        gift.setGiftPicList(this.giftPicMapper.selectGiftPicByGiftId(giftId));
        return gift;
    }

    @Override
    @Transactional
    public int doUpdateGift(Gift gift) {
        gift.setModifyTime(new Date());
        return this.giftMapper.doUpdateGift(gift);
    }

    @Override
    @Transactional
    public int delGift(Long giftId) {
        int delFlag = this.giftMapper.delGift(giftId);
        if (delFlag == 1) {
            this.giftPicMapper.deleteGiftPicByGiftId(giftId);
        }
        return delFlag;
    }

    @Override
    @Transactional
    public int delAllGift(Long[] giftId) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long id : giftId) {
            list.add(id);
        }
        int delFlag = this.giftMapper.delAllGift(list);
        if (delFlag > 0) {
            this.giftPicMapper.deleteAllGiftPicByGiftId(list);
        }
        return delFlag;
    }

    public GiftMapper getGiftMapper() {
        return this.giftMapper;
    }

    @Resource(name="GiftMapper")
    public void setGiftMapper(GiftMapper giftMapper) {
        this.giftMapper = giftMapper;
    }

    public GiftPicMapper getGiftPicMapper() {
        return this.giftPicMapper;
    }

    @Resource(name="GiftPicMapper")
    public void setGiftPicMapper(GiftPicMapper giftPicMapper) {
        this.giftPicMapper = giftPicMapper;
    }
}

