/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.mt.store.service;

import com.github.pagehelper.util.StringUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfoChannelDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfoQua;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisStoreBaseService;
import com.yqbsoft.laser.service.ext.channel.mt.MtConstants;
import com.yqbsoft.laser.service.ext.channel.mt.domain.MtResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisStoreServiceImpl
extends DisStoreBaseService {
    private String SYS_CODE = "mt.StoreServiceImpl";

    public Map<String, Object> buildStoreUpdateParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        UmUserinfo umUserinfo = (UmUserinfo)param.get("umUserinfo");
        if (null == umUserinfo) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("address", umUserinfo.getCompanyAddress());
        properties.put("longitude", umUserinfo.getUserinfoMap());
        properties.put("latitude", umUserinfo.getUserinfoMap());
        List umUserinfoChannelDomains = umUserinfo.getUmUserinfoChannelDomainList();
        boolean flag = true;
        if (ListUtil.isNotEmpty((Collection)umUserinfoChannelDomains)) {
            for (UmUserinfoChannelDomain ucd : umUserinfoChannelDomains) {
                if (!disChannel.getChannelCode().equals(ucd.getChannelCode())) continue;
                if (StringUtil.isNotEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("transportFree")) {
                    properties.put("shipping_fee", ucd.getUserinfoChannelVaule());
                }
                if (StringUtil.isNotEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("checkBusiness")) {
                    String status = "3";
                    if (ucd.getUserinfoChannelVaule().equals("0")) {
                        status = "1";
                    }
                    properties.put("open_level", status);
                }
                String servingTime = "";
                if (StringUtil.isNotEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("channelOpenTime")) {
                    servingTime = servingTime + ucd.getUserinfoChannelVaule() + " - ";
                }
                if (StringUtil.isNotEmpty((String)ucd.getUserinfoChannelKey()) && ucd.getUserinfoChannelKey().equals("channelCloseTime")) {
                    servingTime = servingTime + ucd.getUserinfoChannelVaule();
                }
                if (!StringUtils.isNotBlank((String)servingTime)) continue;
                List<String> timeStr = Arrays.asList(servingTime);
                properties.put("shipping_time", timeStr);
                flag = false;
            }
        }
        if (flag) {
            List userinfoQuas = umUserinfo.getUmUserinfoQuaList();
            String time = "";
            if (ListUtil.isNotEmpty((Collection)userinfoQuas)) {
                for (UmUserinfoQua userinfoQua : userinfoQuas) {
                    if (!disChannel.getMemberCode().equals(userinfoQua.getUserinfoCode())) continue;
                    if (StringUtil.isNotEmpty((String)userinfoQua.getUserinfoQuaKey()) && userinfoQua.getUserinfoQuaKey().equals("storeOpenTime")) {
                        time = time + userinfoQua.getUserinfoQuaVaule() + " - ";
                    }
                    if (!StringUtil.isNotEmpty((String)userinfoQua.getUserinfoQuaKey()) || !userinfoQua.getUserinfoQuaKey().equals("storeCloseTime")) continue;
                    time = time + userinfoQua.getUserinfoQuaVaule();
                }
            }
            if (StringUtil.isNotEmpty((String)time)) {
                List<String> result = Arrays.asList(time);
                properties.put("shipping_time", result);
            }
        }
        properties.put("description", umUserinfo.getUserinfoRemark());
        properties.put("name", umUserinfo.getUserinfoCompname());
        properties.put("phone", umUserinfo.getUserinfoPhone());
        properties.put("app_brand_code", umUserinfo.getUserinfoCode());
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        this.logger.error(this.SYS_CODE + ".buildStoreUpdateParam \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002", (Object)sendParam.toString());
        params.put("shopId", Long.valueOf((String)sendParam.remove("shopId")));
        params.put("properties", properties);
        sendParam.put("params", params);
        return sendParam;
    }

    public Map<String, Object> buildStoreStartParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }

    public Map<String, Object> buildStoreEndParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }

    public Map<String, Object> buildGetStoreParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        sendParam.put("app_poi_codes", sendParam.remove("app_poi_code"));
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }

    public String sendStoreStartParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    public UmUserinfo sendGetStore(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return null;
        }
        String url = configMap.get(MtConstants.realPath);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        try {
            json = com.yqbsoft.laser.service.ext.channel.mt.sevice.WebUtils.doGet(url, null, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        MtResult mtResult = this.make(json);
        if (null != mtResult && MapUtil.isNotEmpty(mtResult.getError())) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.e ======  " + mtResult.getError().get("msg"), (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (null == mtResult && MapUtil.isEmpty((Map)map)) {
            return null;
        }
        List dataList = (List)map.get("data");
        if (ListUtil.isEmpty((Collection)dataList)) {
            return null;
        }
        Map dataMap = (Map)dataList.get(0);
        UmUserinfo umUserinfo = new UmUserinfo();
        umUserinfo.setCompanyAddress((String)dataMap.get("address"));
        umUserinfo.setUserinfoMap(String.valueOf(dataMap.get("longitude")) + " / " + String.valueOf(dataMap.get("latitude")));
        umUserinfo.setUserinfoRemark((String)dataMap.get("promotion_info"));
        umUserinfo.setUserinfoCompname((String)dataMap.get("name"));
        umUserinfo.setUserinfoPhone((String)dataMap.get("phone"));
        umUserinfo.setDataState(Integer.valueOf(-1));
        if ((Integer)dataMap.get("is_online") == 1) {
            umUserinfo.setDataState(Integer.valueOf(0));
        }
        return umUserinfo;
    }

    public String sendStoreEndParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    public String sendStoreUpdateParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    private Map<String, Object> buildStoreComParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        return sendParam;
    }

    private String sendStoreComParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(MtConstants.realPath);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = WebUtils.doPostJson((String)url, sendhttpParam, (int)30000, (int)30000, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        MtResult mtResult = this.make(json);
        if (null == mtResult) {
            return json;
        }
        if (null != mtResult.getError()) {
            return (String)mtResult.getError().get("msg");
        }
        return "SUCCESS";
    }

    protected String getChannelCode() {
        return MtConstants.channelCode;
    }

    private MtResult make(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".make.json");
            return null;
        }
        MtResult mtResult = (MtResult)JsonUtil.buildNormalBinder().getJsonToObject(json, MtResult.class);
        if (null == mtResult) {
            return null;
        }
        return mtResult;
    }
}

