/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.mt.goods.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ImageBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisGoodsBaseService;
import com.yqbsoft.laser.service.ext.channel.mt.MtConstants;
import com.yqbsoft.laser.service.ext.channel.mt.domain.MtResult;
import com.yqbsoft.laser.service.ext.channel.mt.domain.MtResultObject;
import com.yqbsoft.laser.service.ext.channel.mt.sevice.HttpUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;

public class DisGoodsServiceImpl
extends DisGoodsBaseService {
    private String SYS_CODE = "mt.DisGoodsServiceImpl";

    protected String getChannelCode() {
        return MtConstants.channelCode;
    }

    public Map<String, Object> buildComGoodsClassParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            sendParam.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        RsGoodsClassDomain rsGoodsClassDomain = (RsGoodsClassDomain)param.get("rsGoodsClassDomain");
        if (null != rsGoodsClassDomain) {
            String parentId = rsGoodsClassDomain.getGoodsClassParentcode();
            if ("cmc.disGoods.updateSendGoodsClass".equals(channelApiCode)) {
                sendParam.put("category_code_origin", sendParam.get("category_code"));
            } else if ("cmc.disGoods.updateSendClassCodeByName".equals(channelApiCode)) {
                sendParam.put("category_name_origin", sendParam.get("category_name"));
            } else if ("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode) && StringUtils.isNotBlank((String)parentId) && !parentId.equals("-1")) {
                HashMap<String, String> mapByCode = new HashMap<String, String>();
                HashMap<String, String> mapParam = new HashMap<String, String>();
                mapByCode.put("tenantCode", disChannel.getTenantCode());
                mapByCode.put("goodsClassCode", rsGoodsClassDomain.getGoodsClassParentcode());
                mapParam.put("map", JsonUtil.buildNormalBinder().toJson(mapByCode));
                RsGoodsClassDomain parentrsGoodsClassDomain = this.getGoodsClass(mapParam);
                if (null == parentrsGoodsClassDomain) {
                    this.logger.error(this.SYS_CODE + ".buildComGoodsClassParam.url", (Object)((Object)mapByCode).toString());
                    return null;
                }
                sendParam.put("category_name_origin", parentrsGoodsClassDomain.getGoodsClassName());
                sendParam.put("secondary_category_code", rsGoodsClassDomain.getGoodsClassCode());
                sendParam.put("secondary_category_name", rsGoodsClassDomain.getGoodsClassName());
                sendParam.put("category_name", parentrsGoodsClassDomain.getGoodsClassName());
                sendParam.put("category_code", rsGoodsClassDomain.getGoodsClassParentcode());
            }
        }
        return sendParam;
    }

    public String sendComSaveGoodsClass(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        RsGoodsClassDomain rsGoodsClassDomain;
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(MtConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = HttpUtil.requestOfPost(url, sendhttpParam);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        MtResult mtResult = this.make(json);
        if (null == mtResult) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.elmResult", (Object)json);
            return json;
        }
        if (null != mtResult.getError()) {
            if ("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode)) {
                String tenantCode = (String)param.get("tenantCode");
                String memberCode = (String)param.get("memberCode");
                String resu = this.updateSendClassCodeByName(param, memberCode, tenantCode);
                if (resu.equals("SUCCESS")) {
                    RsGoodsClassDomain rsGoodsClassDomain2 = (RsGoodsClassDomain)param.get("rsGoodsClassDomain");
                    this.saveClassDictionary(disChannel, memberCode, rsGoodsClassDomain2.getGoodsClassCode(), rsGoodsClassDomain2.getGoodsClassCode(), tenantCode);
                    return "SUCCESS";
                }
            }
            return (String)mtResult.getError().get("msg");
        }
        if ("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode) && null != (rsGoodsClassDomain = (RsGoodsClassDomain)param.get("rsGoodsClassDomain")) && StringUtils.isNotBlank((String)rsGoodsClassDomain.getGoodsClassCode())) {
            this.saveClassDictionary(disChannel, (String)param.get("memberCode"), rsGoodsClassDomain.getGoodsClassCode(), rsGoodsClassDomain.getGoodsClassCode(), (String)param.get("tenantCode"));
        }
        return "SUCCESS";
    }

    private MtResult make(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".make.json");
            return null;
        }
        MtResult mtResult = (MtResult)JsonUtil.buildNormalBinder().getJsonToObject(json, MtResult.class);
        if (null == mtResult) {
            return null;
        }
        return mtResult;
    }

    public Map<String, Object> buildComGoodsParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        String memberCode = (String)param.get("memberCode");
        DecimalFormat df = new DecimalFormat("#");
        DecimalFormat keepFloat = new DecimalFormat("#.##");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        if ("cmc.disGoods.uploadImage".equals(channelApiCode)) {
            ImageBean imageBean = (ImageBean)param.get("imageBean");
            if (null == imageBean || null == imageBean.getImage()) {
                this.logger.error(this.SYS_CODE + ".buildComGoodsParam.imageBean");
            }
            sendParam.put("img_data", imageBean.getImage());
            sendParam.put("img_name", imageBean.getFileCode() + "." + imageBean.getFileType());
            if (StringUtils.isBlank((String)((String)sendParam.get("app_poi_code")))) {
                HashedMap dicMap = new HashedMap();
                dicMap.put("channelCode", disChannel.getChannelCode());
                dicMap.put("tenantCode", disChannel.getTenantCode());
                dicMap.put("dictionaryType", "UmUserinfo");
                String shopCode = this.getDictionary((Map)dicMap);
                sendParam.put("app_poi_code", shopCode);
            }
        } else if ("cmc.disGoods.saveSendGoods".equals(channelApiCode) || "cmc.disGoods.updateSendGoods".equals(channelApiCode)) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
            if (null == rsResourceGoodsReDomain) {
                this.logger.error(this.SYS_CODE + ".buildComGoodsParam.save/update", (Object)("rsResourceGoodsReDomain.isNull" + param.toString()));
                return null;
            }
            sendParam.put("app_food_code", rsResourceGoodsReDomain.getGoodsCode());
            sendParam.put("name", rsResourceGoodsReDomain.getGoodsName());
            if (StringUtils.isNotBlank((String)rsResourceGoodsReDomain.getGoodsShowname())) {
                sendParam.put("name", rsResourceGoodsReDomain.getGoodsShowname());
            }
            List skuDomains = rsResourceGoodsReDomain.getRsSkuDomainList();
            ArrayList skuList = new ArrayList();
            for (RsSkuDomain sku : skuDomains) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sku_id", sku.getSkuNo());
                map.put("spec", sku.getSkuName());
                map.put("upc", sku.getSkuBarcode());
                map.put("price", keepFloat.format(sku.getPricesetNprice()));
                map.put("stock", sku.getGoodsSupplynum() == null || sku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : df.format(sku.getGoodsSupplynum().setScale(0, 1)));
                map.put("weight", sku.getGoodsOneweight() == null || sku.getGoodsOneweight().compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : Integer.valueOf(sku.getGoodsOneweight().intValue()));
                skuList.add(map);
            }
            int minorder = 1;
            if (null != rsResourceGoodsReDomain.getGoodsMinnum() && rsResourceGoodsReDomain.getGoodsMinnum().compareTo(BigDecimal.ZERO) > 0) {
                minorder = rsResourceGoodsReDomain.getGoodsMinnum().intValue();
            }
            sendParam.put("skus", JsonUtil.buildNormalBinder().toJson(skuList));
            sendParam.put("min_order_count", minorder);
            sendParam.put("unit", StringUtils.isBlank((String)rsResourceGoodsReDomain.getPartsnameNumunit()) ? "\u4e2a" : rsResourceGoodsReDomain.getPartsnameNumunit());
            sendParam.put("box_num", "0");
            sendParam.put("box_price", "0");
            sendParam.put("category_code", StringUtils.isBlank((String)rsResourceGoodsReDomain.getClasstreeShopcode()) ? rsResourceGoodsReDomain.getClasstreeCode() : rsResourceGoodsReDomain.getClasstreeShopcode());
            String imgs = this.createImageList(disChannel, rsResourceGoodsReDomain.getRsGoodsFileDomainList());
            if (StringUtils.isNotBlank((String)imgs)) {
                sendParam.put("picture", imgs);
            }
            int state = rsResourceGoodsReDomain.getDataOpbillstate() == 1 ? 0 : 1;
            sendParam.put("is_sold_out", state);
        } else if ("cmc.disGoods.saveSendSku".equals(channelApiCode) || "cmc.disGoods.updateSendSku".equals(channelApiCode)) {
            RsSkuDomain rsSkuDomain = (RsSkuDomain)param.get("rsSkuDomain");
            if (null == rsSkuDomain) {
                this.logger.error(this.SYS_CODE + ".buildComGoodsParam.save/updateSku", (Object)("rsSkuDomain.isNull" + param.toString()));
                return null;
            }
            sendParam.put("app_food_code", rsSkuDomain.getGoodsCode());
            sendParam.put("name", rsSkuDomain.getGoodsName());
            if (StringUtils.isNotBlank((String)rsSkuDomain.getGoodsShowname())) {
                sendParam.put("name", rsSkuDomain.getGoodsShowname());
            }
            ArrayList skuList = new ArrayList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sku_id", rsSkuDomain.getSkuNo());
            map.put("spec", rsSkuDomain.getSkuName());
            map.put("upc", rsSkuDomain.getSkuBarcode());
            map.put("price", keepFloat.format(rsSkuDomain.getPricesetNprice()));
            map.put("stock", rsSkuDomain.getGoodsSupplynum() == null || rsSkuDomain.getGoodsSupplynum().compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : df.format(rsSkuDomain.getGoodsSupplynum().setScale(0, 1)));
            map.put("weight", rsSkuDomain.getGoodsOneweight() == null || rsSkuDomain.getGoodsOneweight().compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : Integer.valueOf(rsSkuDomain.getGoodsOneweight().intValue()));
            skuList.add(map);
            int minorder = 1;
            if (null != rsSkuDomain.getGoodsMinnum() && rsSkuDomain.getGoodsMinnum().compareTo(BigDecimal.ZERO) > 0) {
                minorder = rsSkuDomain.getGoodsMinnum().intValue();
            }
            sendParam.put("skus", JsonUtil.buildNormalBinder().toJson(skuList));
            sendParam.put("min_order_count", minorder);
            sendParam.put("unit", StringUtils.isBlank((String)rsSkuDomain.getPartsnameNumunit()) ? "\u4e2a" : rsSkuDomain.getPartsnameNumunit());
            sendParam.put("box_num", "0");
            sendParam.put("box_price", "0");
            sendParam.put("category_code", StringUtils.isBlank((String)rsSkuDomain.getClasstreeShopcode()) ? rsSkuDomain.getClasstreeCode() : rsSkuDomain.getClasstreeShopcode());
            String imgs = this.createImageList(disChannel, rsSkuDomain.getRsGoodsFileDomainList());
            if (StringUtils.isNotBlank((String)imgs)) {
                sendParam.put("picture", imgs);
            }
            int state = rsSkuDomain.getDataOpbillstate() == 1 ? 0 : 1;
            sendParam.put("is_sold_out", state);
        } else if ("cmc.disGoods.saveSendBatchGoodsByUpc".equals(channelApiCode)) {
            List paramGoodsList = (List)param.get("rsResourceGoodsReDomainList");
            if (ListUtil.isEmpty((Collection)paramGoodsList)) {
                this.logger.error(this.SYS_CODE + ".saveSendBatchGoodsByUpc", (Object)("paramGoodsList.isNull" + param.toString()));
                return null;
            }
            RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)paramGoodsList.get(0);
            List rsSkuDomainList = rsResourceGoodsDomain.getRsSkuDomainList();
            ArrayList<HashedMap> foodData = new ArrayList<HashedMap>();
            HashedMap foodDataMap = new HashedMap();
            foodDataMap.put("app_food_code", rsResourceGoodsDomain.getGoodsCode());
            String upc_code = "";
            for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
                upc_code = rsSkuDomain.getSkuBarcode();
                ArrayList skuList = new ArrayList();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sku_id", rsSkuDomain.getSkuNo());
                map.put("price", keepFloat.format(rsSkuDomain.getPricesetNprice()));
                map.put("stock", rsSkuDomain.getGoodsSupplynum() == null || rsSkuDomain.getGoodsSupplynum().compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : df.format(rsSkuDomain.getGoodsSupplynum().setScale(0, 1)));
                skuList.add(map);
                int minorder = 1;
                if (null != rsSkuDomain.getGoodsMinnum() && rsSkuDomain.getGoodsMinnum().compareTo(BigDecimal.ZERO) > 0) {
                    minorder = rsSkuDomain.getGoodsMinnum().intValue();
                }
                foodDataMap.put("standard_sku", skuList);
                foodDataMap.put("min_order_count", minorder);
                foodDataMap.put("category_code", StringUtils.isBlank((String)rsSkuDomain.getClasstreeShopcode()) ? rsSkuDomain.getClasstreeCode() : rsSkuDomain.getClasstreeShopcode());
                int state = rsSkuDomain.getDataOpbillstate() == 1 ? 0 : 1;
                foodDataMap.put("is_sold_out", state);
            }
            foodDataMap.put("upc_code", upc_code);
            foodData.add(foodDataMap);
            sendParam.put("food_data", JsonUtil.buildNormalBinder().toJson(foodData));
            this.logger.info(this.SYS_CODE + "saveSendBatchGoodsByUpc : ", (Object)(sendParam + " : " + param.toString()));
        } else if ("cmc.disGoods.updateSendSkuNum".equals(channelApiCode)) {
            ArrayList listMap = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sku_id", (String)param.get("skuNo"));
            map.put("stock", "0");
            BigDecimal num = BigDecimal.valueOf(Double.valueOf(String.valueOf(param.get("goodsSupplynum"))));
            if (null == num || num.compareTo(BigDecimal.ZERO) <= 0) {
                num = BigDecimal.ZERO;
            }
            map.put("stock", df.format(num.setScale(0, 1)));
            listMap.add(map);
            ArrayList retList = new ArrayList();
            HashMap<String, Object> foodDataMap = new HashMap<String, Object>();
            foodDataMap.put("app_food_code", param.get("goodsCode"));
            foodDataMap.put("skus", listMap);
            retList.add(foodDataMap);
            sendParam.put("food_data", JsonUtil.buildNormalBinder().toJson(retList));
        } else if ("cmc.disGoods.updateSendSkuPrice".equals(channelApiCode)) {
            ArrayList listMap = new ArrayList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sku_id", param.get("skuNo"));
            map.put("price", param.get("pricesetNprice"));
            listMap.add(map);
            ArrayList retList = new ArrayList();
            HashMap<String, Object> foodDataMap = new HashMap<String, Object>();
            foodDataMap.put("app_food_code", param.get("goodsCode"));
            foodDataMap.put("skus", listMap);
            retList.add(foodDataMap);
            sendParam.put("food_data", JsonUtil.buildNormalBinder().toJson(retList));
        } else if ("cmc.disGoods.updateSendSkuUp".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsUp".equals(channelApiCode)) {
            this.buildParam(sendParam, param);
        } else if ("cmc.disGoods.updateSendSkuDow".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsDow".equals(channelApiCode)) {
            this.buildParam(sendParam, param);
        } else if ("cmc.disGoods.delSendSku".equals(channelApiCode)) {
            sendParam.put("app_food_code", param.get("goodsCode"));
            sendParam.put("sku_id", param.get("skuNo"));
        } else if ("cmc.disGoods.delSendGoods".equals(channelApiCode)) {
            sendParam.put("app_food_code", param.get("goodsCode"));
        }
        return sendParam;
    }

    private String createImageList(DisChannel disChannel, List<RsGoodsFileDomain> rsGoodsFileDomainList) {
        if (ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return null;
        }
        String code = "";
        String resultId = "";
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            code = this.getFileOcode(disChannel, rsGoodsFileDomain.getGoodsFileName(), this.getChannelCode(), rsGoodsFileDomain.getTenantCode());
            if (!StringUtils.isNotBlank((String)code)) continue;
            resultId = resultId + code + ",";
        }
        if (StringUtils.isNotBlank((String)resultId)) {
            resultId = resultId.substring(0, resultId.length() - 1);
        }
        return resultId;
    }

    private Map<String, Object> buildParam(Map<String, Object> sendParam, Map<String, Object> param) {
        sendParam.put("sell_status", sendParam.get("sell_status"));
        ArrayList listMap = new ArrayList();
        HashMap<String, Object> foodDataMap = new HashMap<String, Object>();
        foodDataMap.put("app_food_code", param.get("goodsCode"));
        List skuList = (List)param.get("skuNoList");
        if (ListUtil.isNotEmpty((Collection)skuList)) {
            for (String sku : skuList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("sku_id", sku);
                listMap.add(map);
            }
            foodDataMap.put("skus", listMap);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sku_id", param.get("skuNo"));
            listMap.add(map);
            foodDataMap.put("skus", listMap);
        }
        ArrayList<HashMap<String, Object>> retList = new ArrayList<HashMap<String, Object>>();
        retList.add(foodDataMap);
        sendParam.put("food_data", JsonUtil.buildNormalBinder().toJson(retList));
        return sendParam;
    }

    public String sendComSaveGoods(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        RsSkuDomain rsSkuDomain;
        MtResult mtResult;
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(MtConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoods.url", (Object)(channelApiCode + ":" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            if ("cmc.disGoods.uploadImage".equals(channelApiCode)) {
                byte[] file = (byte[])sendhttpParam.remove("img_data");
                String filename = (String)sendhttpParam.get("img_name");
                HashMap<String, String> hmap = new HashMap<String, String>();
                for (String key : sendhttpParam.keySet()) {
                    hmap.put(key, sendhttpParam.get(key).toString());
                }
                json = HttpUtil.requestOfPost(url, hmap, file, filename);
            } else if ("cmc.disGoods.saveSendGoods".equals(channelApiCode) || "cmc.disGoods.saveSendSku".equals(channelApiCode)) {
                RsResourceGoodsReDomain goodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
                ArrayList<RsResourceGoodsReDomain> resourceGoodsReDomains = new ArrayList<RsResourceGoodsReDomain>();
                resourceGoodsReDomains.add(goodsReDomain);
                this.saveSendBatchGoodsByUpc(resourceGoodsReDomains, (String)param.get("memberCode"), (String)param.get("tenantCode"));
                json = HttpUtil.requestOfPost(url, sendhttpParam);
                if (StringUtils.isBlank((String)json)) {
                    this.logger.error(this.SYS_CODE + ".saveSendBatchGoodsByUpc.json", (Object)(channelApiCode + ":" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                MtResult mtResult2 = this.make(json);
                if (null == mtResult2) {
                    return "ERROR";
                }
                if (!MapUtil.isNotEmpty(mtResult2.getError())) {
                    return "SUCCESS";
                }
            } else {
                json = HttpUtil.requestOfPost(url, sendhttpParam);
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoods.e", (Object)(channelApiCode + ":" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoods.json", (Object)(channelApiCode + ":" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disGoods.uploadImage".equals(channelApiCode)) {
            mtResult = this.make(json);
            if (null == mtResult) {
                return "ERROR";
            }
            if (null != mtResult.getError()) {
                return (String)mtResult.getError().get("msg");
            }
            String code = (String)mtResult.getData();
            return code;
        }
        mtResult = this.make(json);
        if (null == mtResult) {
            return "ERROR";
        }
        if (MapUtil.isNotEmpty(mtResult.getError())) {
            String result;
            HashMap<String, String> skuParam;
            if ("cmc.disGoods.saveSendGoods".equals(channelApiCode)) {
                RsResourceGoodsReDomain goodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
                skuParam = new HashMap<String, String>();
                skuParam.put("goodsCode", goodsReDomain.getGoodsCode());
                skuParam.put("name", StringUtils.isBlank((String)goodsReDomain.getGoodsShowname()) ? goodsReDomain.getGoodsName() : goodsReDomain.getGoodsShowname());
                skuParam.put("goodsClass", goodsReDomain.getClasstreeShopname() == null ? goodsReDomain.getClasstreeName() : goodsReDomain.getClasstreeShopname());
                skuParam.put("rsResourceGoodsReDomain", (String)goodsReDomain);
                result = this.updateAppFoodCodeByNameAndSpec(skuParam, StringUtils.isBlank((String)goodsReDomain.getMemberCcode()) ? goodsReDomain.getMemberCode() : goodsReDomain.getMemberCcode(), goodsReDomain.getTenantCode());
                if (null == result || !result.equals("SUCCESS")) {
                    this.logger.error(this.SYS_CODE + ".saveSendGoods.updateAppFoodCodeByNameAndSpec", (Object)("result: " + result + " : " + channelApiCode + ":" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return (String)mtResult.getError().get("msg");
                }
            } else if ("cmc.disGoods.saveSendSku".equals(channelApiCode)) {
                rsSkuDomain = (RsSkuDomain)param.get("rsSkuDomain");
                skuParam = new HashMap();
                skuParam.put("goodsCode", rsSkuDomain.getGoodsCode());
                skuParam.put("name", StringUtils.isBlank((String)rsSkuDomain.getGoodsShowname()) ? rsSkuDomain.getGoodsName() : rsSkuDomain.getGoodsShowname());
                skuParam.put("goodsClass", rsSkuDomain.getClasstreeShopname() == null ? rsSkuDomain.getClasstreeName() : rsSkuDomain.getClasstreeShopname());
                skuParam.put("rsSkuDomain", (String)rsSkuDomain);
                result = this.updateAppFoodCodeByNameAndSpec(skuParam, StringUtils.isBlank((String)rsSkuDomain.getMemberCcode()) ? rsSkuDomain.getMemberCode() : rsSkuDomain.getMemberCcode(), rsSkuDomain.getTenantCode());
                if (null == result || !result.equals("SUCCESS")) {
                    this.logger.error(this.SYS_CODE + ".saveSendSku.updateAppFoodCodeByNameAndSpec", (Object)("result: " + result + " : " + channelApiCode + ":" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return (String)mtResult.getError().get("msg");
                }
            } else {
                return (String)mtResult.getError().get("msg");
            }
        }
        if ("cmc.disGoods.saveSendGoods".equals(channelApiCode)) {
            String msg;
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
            if (null == rsResourceGoodsReDomain) {
                this.logger.error(this.SYS_CODE + ".sendComSaveGoods.rsResourceGoodsReDomain", (Object)(channelApiCode + ":" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            this.saveGoods(disChannel, disChannel.getChannelCode(), rsResourceGoodsReDomain.getGoodsNo(), rsResourceGoodsReDomain.getGoodsCode(), rsResourceGoodsReDomain.getGoodsCode(), rsResourceGoodsReDomain.getTenantCode(), rsResourceGoodsReDomain.getMemberCcode());
            List rsSkuDomains = rsResourceGoodsReDomain.getRsSkuDomainList();
            if (ListUtil.isNotEmpty((Collection)rsSkuDomains)) {
                for (RsSkuDomain rsSkuDomain2 : rsSkuDomains) {
                    this.saveSku(disChannel, disChannel.getChannelCode(), rsSkuDomain2.getSkuNo(), null, rsSkuDomain2.getSkuNo(), rsResourceGoodsReDomain.getTenantCode(), rsResourceGoodsReDomain.getMemberCcode());
                }
            }
            if (MapUtil.isNotEmpty(mtResult.getError()) && !"SUCCESS".equals(msg = this.updateSendGoods(rsResourceGoodsReDomain, (String)param.get("memberCode"), (String)param.get("tenantCode")))) {
                return msg;
            }
        }
        if ("cmc.disGoods.saveSendSku".equals(channelApiCode)) {
            String msg;
            rsSkuDomain = (RsSkuDomain)param.get("rsSkuDomain");
            if (null == rsSkuDomain) {
                this.logger.error(this.SYS_CODE + ".sendComSaveGoods.rsSkuDomain", (Object)(channelApiCode + ":" + url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            this.saveSku(disChannel, disChannel.getChannelCode(), rsSkuDomain.getSkuNo(), rsSkuDomain.getSkuCode(), rsSkuDomain.getSkuNo(), rsSkuDomain.getTenantCode(), rsSkuDomain.getMemberCcode());
            if (MapUtil.isNotEmpty(mtResult.getError()) && !"SUCCESS".equals(msg = this.updateSendSku(rsSkuDomain, (String)param.get("memberCode"), (String)param.get("tenantCode")))) {
                return msg;
            }
        }
        if ("cmc.disGoods.getSendGoods".equals(channelApiCode) || "cmc.disGoods.getSendSku".equals(channelApiCode)) {
            rsSkuDomain = (RsSkuDomain)param.get("rsSkuDomain");
            if (StringUtils.isBlank((String)rsSkuDomain.getGoodsEocode())) {
                this.saveGoods(disChannel, disChannel.getChannelCode(), rsSkuDomain.getGoodsNo(), rsSkuDomain.getGoodsCode(), rsSkuDomain.getGoodsCode(), rsSkuDomain.getTenantCode(), rsSkuDomain.getMemberCcode());
            }
            if (StringUtils.isBlank((String)rsSkuDomain.getSkuEocode())) {
                this.saveSku(disChannel, disChannel.getChannelCode(), rsSkuDomain.getSkuNo(), null, rsSkuDomain.getSkuNo(), rsSkuDomain.getTenantCode(), rsSkuDomain.getMemberCcode());
            }
        }
        return "SUCCESS";
    }

    private MtResultObject makeObject(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".makeObject.json");
            return null;
        }
        MtResultObject elmResult = (MtResultObject)JsonUtil.buildNormalBinder().getJsonToObject(json, MtResultObject.class);
        if (null == elmResult) {
            return null;
        }
        return elmResult;
    }
}

