/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.mt.order.service;

import com.github.pagehelper.util.StringUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractproDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOrderBaseService;
import com.yqbsoft.laser.service.ext.channel.discom.util.EmojiUtil;
import com.yqbsoft.laser.service.ext.channel.mt.MtConstants;
import com.yqbsoft.laser.service.ext.channel.mt.sevice.WebUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisOrderServiceImpl
extends DisOrderBaseService {
    private String SYS_CODE = "mt.DisOrderServiceImpl";

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        return sendParam;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(MtConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map<String, String> mapStr = this.convert(sendhttpParam);
        try {
            json = WebUtils.doGet(url, mapStr, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map mtOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)mtOrderMap)) {
            return null;
        }
        if (null != mtOrderMap.get("error")) {
            throw new ApiException(this.SYS_CODE + ".sendComOrder.mtResultListOrder", (String)mtOrderMap.get("error"));
        }
        if (null == mtOrderMap.get("data")) {
            return null;
        }
        if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            Map map = (Map)mtOrderMap.get("data");
            if (MapUtil.isEmpty((Map)map)) {
                return null;
            }
            return this.createOrder(map, disChannel);
        }
        return null;
    }

    public Map<String, String> convert(Map<String, Object> map) {
        HashMap<String, String> strMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            strMap.put(key, String.valueOf(map.get(key)));
        }
        return strMap;
    }

    private DisContractDomain createOrder(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        try {
            return this.makeOrder(param, disChannel);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".createOrder.e", (Throwable)e);
            return null;
        }
    }

    public static Object timeStamp2Date(String seconds, String format) {
        if (StringUtil.isEmpty((String)seconds) || seconds.equals("null") || seconds.length() < 10) {
            return null;
        }
        if (StringUtil.isEmpty((String)format)) {
            return new Date(Long.valueOf(seconds + "000"));
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(Long.valueOf(seconds + "000")));
    }

    public static void main(String[] args) {
        String a = "1558886665";
        System.out.println(DisOrderServiceImpl.timeStamp2Date(a, null));
        DisOrderServiceImpl c = new DisOrderServiceImpl();
        System.out.println(c.transferLongToDate(Long.valueOf(a + "000")));
    }

    private Date transferLongToDate(Long millSec) {
        try {
            Date date = new Date(millSec);
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    private double buildExtras(String extras) {
        if (StringUtils.isBlank((String)extras)) {
            return 0.0;
        }
        List listExtras = (List)JsonUtil.buildNormalBinder().getJsonToList(extras, Map.class);
        this.logger.info(this.SYS_CODE + " .buildExtras", (Object)("extras : " + extras + " ;listExtras: " + listExtras + ";SNAPSHOT"));
        if (ListUtil.isEmpty((Collection)listExtras)) {
            return 0.0;
        }
        double reduceFee = 0.0;
        for (Map map : listExtras) {
            Double fee = map.get("reduce_fee") == null ? 0.0 : (Double)map.get("reduce_fee");
            reduceFee += fee.doubleValue();
        }
        return reduceFee;
    }

    private DisContractDomain makeOrder(Map<String, Object> map, DisChannel disChannel) {
        if (null == map || null == disChannel) {
            return null;
        }
        DisContractDomain disContractDomain = new DisContractDomain();
        disContractDomain.setGoodsReceiptArrdess(this.decodeParam((String)map.get("recipient_address")));
        disContractDomain.setChannelCode(disChannel.getChannelCode());
        disContractDomain.setChannelName(disChannel.getChannelName());
        disContractDomain.setTenantCode(disChannel.getTenantCode());
        try {
            Object sendTimeStr = map.get("order_send_time");
            if (null == sendTimeStr) {
                sendTimeStr = map.get("ctime");
            }
            Date sendTime = null;
            if (null != sendTimeStr) {
                sendTime = this.transferLongToDate(Long.valueOf(String.valueOf(sendTimeStr) + "000"));
            }
            Object deliverTimeStr = map.get("delivery_time");
            Date deliverTime = null;
            if (null != deliverTimeStr && Long.valueOf(String.valueOf(deliverTimeStr)) != 0L) {
                deliverTime = this.transferLongToDate(Long.valueOf(String.valueOf(deliverTimeStr) + "000"));
            }
            Object confirmCookingTimeStr = map.get("utime");
            Date confirmCookingTime = null;
            if (null != confirmCookingTimeStr) {
                confirmCookingTime = this.transferLongToDate(Long.valueOf(String.valueOf(confirmCookingTimeStr) + "000"));
            }
            Object orderConfirmTimeStr = map.get("order_confirm_time");
            Date orderConfirmTime = null;
            if (null != orderConfirmTimeStr) {
                orderConfirmTime = this.transferLongToDate(Long.valueOf(String.valueOf(orderConfirmTimeStr) + "000"));
            }
            disContractDomain.setContractPaydate(confirmCookingTime);
            disContractDomain.setContractValidate(sendTime);
            disContractDomain.setContractEffectivedate(deliverTime);
            disContractDomain.setGmtVaild(orderConfirmTime);
        }
        catch (Exception e) {
            return null;
        }
        String remark = this.decodeParam((String)map.get("caution"));
        remark = EmojiUtil.removeEmoji((String)remark);
        if (StringUtils.isNotBlank((String)remark) && remark.length() > 250) {
            int i = remark.indexOf("\u3010");
            remark = remark.substring(0, i).length() > 250 ? remark.substring(0, 249) : remark.substring(0, i);
        }
        disContractDomain.setContractRemark(remark);
        String detail = this.decodeParam((String)map.get("detail"));
        List detailList = (List)JsonUtil.buildNormalBinder().getJsonToList(detail, Map.class);
        disContractDomain.setContractInvoice(this.decodeParam((String)map.get("invoice_title")));
        disContractDomain.setContractTypepro("00");
        disContractDomain.setContractType("20");
        disContractDomain.setContractPmode("1");
        Object obj = map.get("pay_type");
        if ("2".equals(obj)) {
            disContractDomain.setContractPmode("0");
        }
        disContractDomain.setContractNbillcode(String.valueOf(map.get("order_id")));
        disContractDomain.setGoodsReceiptPhone((String)map.get("recipient_phone"));
        String extras = (String)map.get("extras");
        double pMoney = this.buildExtras(this.decodeParam(extras));
        disContractDomain.setGoodsPmoney(BigDecimal.valueOf(pMoney));
        String memberCcode = this.getMemberCode(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf(map.get("wm_poi_id")));
        disContractDomain.setMemberCode(disChannel.getMemberCode());
        disContractDomain.setMemberName(disChannel.getMemberName());
        disContractDomain.setMemberCcode(memberCcode);
        disContractDomain.setMemberCname(this.decodeParam((String)map.get("wm_poi_name")));
        this.setContractPro(disContractDomain, "day_seq", String.valueOf(map.get("day_seq")), "\u6d41\u6c34\u53f7");
        String dataState = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), map.get("status").toString());
        if (StringUtils.isBlank((String)dataState)) {
            dataState = (String)map.get("status");
        }
        disContractDomain.setDataState(Integer.valueOf(Integer.parseInt(dataState)));
        disContractDomain.setDataStatestr((String)map.get("status"));
        disContractDomain.setMemberBcode((String)map.get("userIdStr"));
        String total = null == map.get("total") ? "0" : (String)map.get("total");
        String original_price = null == map.get("original_price") ? "0" : (String)map.get("original_price");
        disContractDomain.setDataBmoney(new BigDecimal(total));
        disContractDomain.setContractMoney(new BigDecimal(total));
        disContractDomain.setContractInmoney(new BigDecimal(original_price));
        this.setContractPro(disContractDomain, "longitude", String.valueOf(map.get("longitude")), "\u7ecf\u5ea6");
        this.setContractPro(disContractDomain, "latitude", String.valueOf(map.get("latitude")), "\u7eac\u5ea6");
        disContractDomain.setGoodsReceiptMem(this.decodeParam((String)map.get("recipient_name")));
        disContractDomain.setContractActives(this.decodeParam(JsonUtil.buildNormalBinder().toJson(map.get("sku_benefit_detail"))));
        if (StringUtils.isNotBlank((String)((String)map.get("package_bag_money_yuan")))) {
            String boxMoney = (String)map.get("package_bag_money_yuan");
            disContractDomain.setContractPaymoney(new BigDecimal(boxMoney == null ? "0" : boxMoney));
        } else {
            String packageBag = (String)map.get("package_bag_money");
            if (StringUtils.isNotBlank((String)packageBag)) {
                BigDecimal price = new BigDecimal(Double.parseDouble(packageBag)).multiply(BigDecimal.valueOf(100L));
                disContractDomain.setContractPaymoney(price == null ? BigDecimal.ZERO : price);
            }
        }
        String shippingFee = null == map.get("shipping_fee") ? "0" : (String)map.get("shipping_fee");
        disContractDomain.setGoodsLogmoney(new BigDecimal(shippingFee));
        this.setContractPro(disContractDomain, "orderCancelTime", String.valueOf(map.get("order_cancel_time")), "\u7528\u6237\u7533\u8bf7\u53d6\u6d88\u65f6\u95f4");
        Object pumodeObj = map.get("pick_type");
        String pumode = "0";
        if (null != pumodeObj && "1".equals(pumodeObj.toString())) {
            pumode = "1";
        }
        disContractDomain.setContractPumode(pumode);
        disContractDomain.setContractProperty("0");
        String skuBenefitDetail = (String)map.get("sku_benefit_detail");
        skuBenefitDetail = this.decodeParam(skuBenefitDetail);
        disContractDomain.setContractActives(skuBenefitDetail);
        List<DisPackageDomain> disPackageDomains = this.makeDisPackageDomain(detailList, disContractDomain, skuBenefitDetail);
        disContractDomain.setPackageList(disPackageDomains);
        return disContractDomain;
    }

    private String decodeParam(String detail) {
        if (StringUtils.isBlank((String)detail)) {
            this.logger.error(this.SYS_CODE + ".decodeParam.detail");
            return null;
        }
        try {
            this.logger.error(this.SYS_CODE + ".decodeParam.detail=1", (Object)detail);
            detail = new String(detail.getBytes("ISO-8859-1"), "utf-8");
            detail = URLDecoder.decode(detail, "UTF-8");
            this.logger.error(this.SYS_CODE + ".decodeParam.detail=2", (Object)detail);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".decodeParam.e", (Throwable)e);
        }
        return detail;
    }

    private List<DisPackageDomain> makeDisPackageDomain(List<Map<String, Object>> goodsDetail, DisContractDomain disContractDomain, String skuBenefitDetail) {
        if (ListUtil.isEmpty(goodsDetail)) {
            this.logger.error(this.SYS_CODE + ".makeDisPackageDomain.goodsDetail");
            return null;
        }
        ArrayList<DisPackageDomain> rePagList = new ArrayList<DisPackageDomain>();
        DisPackageDomain pag = new DisPackageDomain();
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal goodsNum = BigDecimal.ZERO;
        try {
            BeanUtils.copyAllPropertys((Object)pag, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeDisPackageDomain.e", (Throwable)e);
        }
        List<DisContractGoodsDomain> goodsList = this.makeDisContractGoodsDomain(goodsDetail, pag, disContractDomain, skuBenefitDetail);
        goodsNum = goodsNum.add(pag.getGoodsNum() == null ? BigDecimal.ZERO : pag.getGoodsNum());
        goodsWeight = goodsWeight.add(pag.getGoodsWeight() == null ? BigDecimal.ZERO : pag.getGoodsWeight());
        pag.setContractGoodsList(goodsList);
        rePagList.add(pag);
        disContractDomain.setGoodsNum(goodsNum);
        disContractDomain.setDataBnum(goodsNum);
        disContractDomain.setGoodsWeight(goodsWeight);
        disContractDomain.setDataBweight(goodsWeight);
        disContractDomain.setGoodsMoney(pag.getGoodsInmoney());
        return rePagList;
    }

    private BigDecimal buildSkuBenefitDetail(String skuId, String skuBenefitDetail) {
        if (StringUtils.isBlank((String)skuId) || StringUtils.isBlank((String)skuBenefitDetail)) {
            return BigDecimal.ZERO;
        }
        List skuBenefitDetailList = (List)JsonUtil.buildNormalBinder().getJsonToList(skuBenefitDetail, Map.class);
        if (ListUtil.isEmpty((Collection)skuBenefitDetailList)) {
            return BigDecimal.ZERO;
        }
        Double totalOriginPrice = 0.0;
        for (Map benefitMap : skuBenefitDetailList) {
            if (!skuId.equals(benefitMap.get("sku_id"))) continue;
            totalOriginPrice = (Double)benefitMap.get("totalOriginPrice");
            return totalOriginPrice == null ? BigDecimal.ZERO : BigDecimal.valueOf(totalOriginPrice);
        }
        return BigDecimal.valueOf(totalOriginPrice);
    }

    private List<DisContractGoodsDomain> makeDisContractGoodsDomain(List<Map<String, Object>> items, DisPackageDomain disPackageDomain, DisContractDomain disContractDomain, String skuBenefitDetail) {
        if (ListUtil.isEmpty(items)) {
            this.logger.error(this.SYS_CODE + ".makeDisContractGoodsDomain.items");
            return null;
        }
        ArrayList<DisContractGoodsDomain> goodsDomainList = new ArrayList<DisContractGoodsDomain>();
        DisContractGoodsDomain disContractGoodsDomain = null;
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsPef = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        for (Map<String, Object> oGoodsItem : items) {
            BigDecimal oldtotalOriginPrice;
            GoodsBean goodsBean;
            disContractGoodsDomain = new DisContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)disPackageDomain);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".makeDisContractGoodsDomain.e", (Throwable)e);
            }
            if (StringUtils.isNotBlank((String)disContractDomain.getMemberCcode()) && null != (goodsBean = this.getResourceBySkuNo((String)oGoodsItem.get("sku_id"), disContractDomain.getMemberCode(), disContractDomain.getMemberCcode(), disContractDomain.getChannelCode(), disContractDomain.getTenantCode())) && null != goodsBean.getRsSku()) {
                disContractGoodsDomain.setSkuCode(goodsBean.getRsSku().getSkuCode());
            }
            String skuId = String.valueOf(oGoodsItem.get("sku_id"));
            disContractGoodsDomain.setSkuNo(skuId);
            disContractGoodsDomain.setSkuEocode(skuId);
            disContractGoodsDomain.setGoodsEocode(String.valueOf(oGoodsItem.get("app_food_code")));
            disContractGoodsDomain.setSkuName((String)oGoodsItem.get("food_name"));
            disContractGoodsDomain.setContractGoodsGtype("0");
            disContractGoodsDomain.setPricesetNprice(BigDecimal.valueOf((Double)oGoodsItem.get("price")));
            BigDecimal goodsNum = new BigDecimal(String.valueOf(oGoodsItem.get("quantity")));
            disContractGoodsDomain.setGoodsCamount(goodsNum);
            disContractGoodsDomain.setGoodsNum(goodsNum);
            BigDecimal totalOriginPrice = disContractGoodsDomain.getPricesetNprice().multiply(goodsNum);
            if (StringUtils.isNotBlank((String)skuBenefitDetail) && null != (oldtotalOriginPrice = this.buildSkuBenefitDetail(skuId, skuBenefitDetail)) && oldtotalOriginPrice.compareTo(BigDecimal.ZERO) > 0) {
                totalOriginPrice = oldtotalOriginPrice;
            }
            disContractGoodsDomain.setContractGoodsInmoney(totalOriginPrice);
            disContractGoodsDomain.setContractGoodsMoney(disContractGoodsDomain.getPricesetNprice().multiply(goodsNum));
            disContractGoodsDomain.setGoodsProtins((String)oGoodsItem.get("food_property"));
            if (null == disContractGoodsDomain.getGoodsNum()) {
                disContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            packageGoodsNum = packageGoodsNum.add(disContractGoodsDomain.getGoodsNum());
            if (null == disContractGoodsDomain.getContractGoodsInmoney()) {
                disContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            goodsInmoney = goodsInmoney.add(disContractGoodsDomain.getContractGoodsInmoney());
            if (null == disContractGoodsDomain.getContractGoodsMoney()) {
                disContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            goodsMoney = goodsMoney.add(disContractGoodsDomain.getContractGoodsMoney());
            if (null == disContractGoodsDomain.getContractGoodsPefinmoney()) {
                disContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            goodsPef = goodsPef.add(disContractGoodsDomain.getContractGoodsPefinmoney());
            if (null == disContractGoodsDomain.getGoodsWeight()) {
                disContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            packageGoodsWeight = packageGoodsWeight.add(disContractGoodsDomain.getGoodsWeight());
            goodsDomainList.add(disContractGoodsDomain);
        }
        disPackageDomain.setGoodsWeight(packageGoodsWeight);
        disPackageDomain.setGoodsNum(packageGoodsNum);
        disPackageDomain.setMemberBcode(disContractDomain.getMemberBcode());
        disPackageDomain.setMemberBname(disContractDomain.getMemberBname());
        disPackageDomain.setGoodsMoney(goodsInmoney);
        disPackageDomain.setPricesetRefrice(goodsPef);
        disPackageDomain.setGoodsPmoney(goodsMoney.subtract(goodsInmoney));
        disPackageDomain.setGoodsInmoney(goodsMoney);
        return goodsDomainList;
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName) {
        this.setContractPro(disContractDomain, contractproKey, contractproValue, contractproName, null);
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName, String contractproValue1) {
        if (null == disContractDomain || StringUtils.isBlank((String)contractproKey) || StringUtils.isBlank((String)contractproValue) || StringUtils.isBlank((String)contractproName)) {
            return;
        }
        DisContractproDomain contractproDomain = new DisContractproDomain();
        contractproDomain.setContractproKey(contractproKey);
        contractproDomain.setContractproValue(contractproValue);
        contractproDomain.setContractproName(contractproName);
        contractproDomain.setContractproValue1(contractproValue1);
        this.setContractPro(disContractDomain, contractproDomain);
    }

    private void setContractPro(DisContractDomain disContractDomain, DisContractproDomain disContractproDomain) {
        if (null == disContractDomain || null == disContractproDomain) {
            return;
        }
        ArrayList<DisContractproDomain> disContractproDomainList = disContractDomain.getOcContractproDomainList();
        if (null == disContractproDomainList) {
            disContractproDomainList = new ArrayList<DisContractproDomain>();
            disContractDomain.setOcContractproDomainList(disContractproDomainList);
        }
        disContractproDomainList.add(disContractproDomain);
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return map;
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == sendhttpParam) {
            return "{\"data\":\"ok\"}";
        }
        this.logger.error(".saveOrderParam.param ****************", (Object)(":" + sendhttpParam.toString() + ";SNAPSHOT"));
        String order_id = (String)sendhttpParam.get("order_id");
        if (StringUtils.isBlank((String)order_id)) {
            return "{\"data\":\"ok\"}";
        }
        String page_in = (String)sendhttpParam.get("page_in");
        String status = (String)sendhttpParam.get("status");
        String reason_code = (String)sendhttpParam.get("reason_code");
        DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), order_id, disChannel);
        if (null == disContractDomain) {
            if (StringUtils.isNotBlank((String)page_in) || StringUtils.isNotBlank((String)reason_code)) {
                disContractDomain = this.getSendOrder(order_id, null, disChannel.getTenantCode());
                if (null == disContractDomain) {
                    return "{\"data\":\"\u8ba2\u5355\u4e3a\u7a7a\"}";
                }
                ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
                disContractDomainList.add(disContractDomain);
                this.saveOrder(disContractDomainList, disChannel);
                return "{\"data\":\"ok\"}";
            }
            if (this.creatOrder(disChannel, sendhttpParam)) {
                return "{\"data\":\"ok\"}";
            }
            return "{\"data\":\"error\"}";
        }
        if (StringUtils.isNotBlank((String)page_in)) {
            status = disContractDomain.getDataStatestr();
        } else {
            this.logger.error(".saveOrderParam.param11", (Object)(status + " : " + disContractDomain.getDataStatestr() + ";SNAPSHOT"));
            if (StringUtils.isEmpty((String)status) && StringUtils.isEmpty((String)reason_code)) {
                return "{\"data\":\"ok\"}";
            }
            if ("1003".equals(reason_code)) {
                status = "9";
            }
            String stateOld = disContractDomain.getDataStatestr();
            this.logger.error(".saveOrderParam.param 22 stateOld", (Object)(stateOld + ";SNAPSHOT"));
            if (StringUtils.isEmpty((String)stateOld)) {
                return "{\"data\":\"ok\"}";
            }
            if (Integer.parseInt(status) <= Integer.parseInt(stateOld)) {
                return "{\"data\":\"ok\"}";
            }
        }
        String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), status);
        if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
            dataStateStr = status;
        }
        Integer dataState = Integer.valueOf(dataStateStr);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataStatestr", status);
        this.updateOrder(disChannel.getTenantCode(), order_id, dataState, null, map, disChannel);
        return "{\"data\":\"ok\"}";
    }

    private boolean creatOrder(DisChannel disChannel, Map<String, Object> sendhttpParam) {
        DisContractDomain disContractDomain = this.createOrder(sendhttpParam, disChannel);
        if (null == disContractDomain || ListUtil.isEmpty((Collection)disContractDomain.getPackageList())) {
            this.logger.error(this.SYS_CODE + ".creatOrder.disContractDomain isnull ", (Object)sendhttpParam.toString());
            return false;
        }
        ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
        disContractDomainList.add(disContractDomain);
        this.saveOrder(disContractDomainList, disChannel);
        return true;
    }

    protected String getChannelCode() {
        return MtConstants.channelCode;
    }
}

