/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.mt.order.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisRefundBaseService;
import com.yqbsoft.laser.service.ext.channel.mt.MtConstants;
import com.yqbsoft.laser.service.ext.channel.mt.sevice.WebUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisRefundServiceImpl
extends DisRefundBaseService {
    private String SYS_CODE = "mt.DisRefundrServiceImpl";

    protected String getChannelCode() {
        return MtConstants.channelCode;
    }

    public Map<String, Object> buildComRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + " buildComRefundParam == ", (Object)(channelApiCode + " == " + sendParam + " == " + configMap + " === " + disChannel));
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        return sendParam;
    }

    public Map<String, String> convert(Map<String, Object> map) {
        HashMap<String, String> strMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            strMap.put(key, String.valueOf(map.get(key)));
        }
        return strMap;
    }

    public Object sendComRefund(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        List mapList;
        String json;
        this.logger.error(this.SYS_CODE + " sendComRefund == ", (Object)(channelApiCode + " == " + sendhttpParam + " == " + configMap + " === " + disChannel));
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(MtConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map<String, String> mapStr = this.convert(sendhttpParam);
        try {
            json = WebUtils.doGet(url, mapStr, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map mtOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)mtOrderMap)) {
            return null;
        }
        if (null != mtOrderMap.get("error")) {
            throw new ApiException(this.SYS_CODE + ".sendComRefund.mtResultListOrder", (String)mtOrderMap.get("error"));
        }
        if (null == mtOrderMap.get("data")) {
            return null;
        }
        if ("cmc.disRefund.getSendRefund".equals(channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".getSendRefund.come!!!!", (Object)(mtOrderMap + "=:=" + sendhttpParam));
            mapList = (List)mtOrderMap.get("data");
            if (ListUtil.isEmpty((Collection)mapList)) {
                this.logger.error(this.SYS_CODE + ".cmc.disRefund.getSendRefund", (Object)mtOrderMap);
                return null;
            }
            for (Map map : mapList) {
                if (!sendhttpParam.get("refundOcode").equals((String)map.get("refund_id"))) continue;
                return this.createRefund(map, disChannel);
            }
        }
        if ("cmc.disRefund.getRefundByOrderId".equals(channelApiCode)) {
            mapList = (List)mtOrderMap.get("data");
            this.logger.error(this.SYS_CODE + " mapList :", (Object)mapList);
            return mapList;
        }
        return null;
    }

    private DisRefundDomain createRefund(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        try {
            return this.makeRefund(param, disChannel);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".createRefund.e", (Throwable)e);
            return null;
        }
    }

    private Date transferLongToDate(Long millSec) {
        try {
            Date date = new Date(millSec);
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    private DisRefundDomain makeRefund(Map<String, Object> map, DisChannel disChannel) {
        if (MapUtil.isEmpty(map) || null == disChannel) {
            return null;
        }
        String tenantCode = disChannel.getTenantCode();
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        disRefundDomain.setChannelCode(disChannel.getChannelCode());
        disRefundDomain.setChannelName(disChannel.getChannelName());
        disRefundDomain.setTenantCode(tenantCode);
        String order_id = (String)map.get("order_id");
        this.logger.error(this.SYS_CODE + ".makRefund111.", map);
        DisContractDomain disContractDomain = this.getContractByNbCode(tenantCode, order_id, disChannel);
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain1", (Object)order_id);
            return null;
        }
        if (null == (disContractDomain = this.getContractDomainByCode(tenantCode, disContractDomain.getContractBillcode()))) {
            this.logger.error(this.SYS_CODE + ".makeRefund.disContractDomain", (Object)order_id);
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
        }
        disRefundDomain.setRefundOcode((String)map.get("refund_id"));
        String ctimeStr = (String)map.get("ctime");
        Date sendTime = null;
        if (null != ctimeStr) {
            sendTime = this.transferLongToDate(Long.valueOf(String.valueOf(ctimeStr) + "000"));
        }
        disRefundDomain.setRefundCreate(disContractDomain.getContractValidate());
        disRefundDomain.setRefundDate(sendTime);
        String time = this.getRefundAuditTime(disChannel.getTenantCode(), disChannel.getChannelCode());
        if (null != time && StringUtils.isNotBlank((String)time)) {
            disRefundDomain.setRefundInvstate(Integer.valueOf(Integer.parseInt(time)));
        }
        String res_reason = (String)map.get("res_reason");
        disRefundDomain.setRefundEx(res_reason);
        disRefundDomain.setRefundUsertype("0");
        disRefundDomain.setRefundMeo((String)map.get("apply_reason"));
        disRefundDomain.setDataStatestr(String.valueOf(map.get("res_type")));
        Object moneyObj = map.get("money");
        BigDecimal refundMoney = BigDecimal.ZERO;
        if (null != moneyObj) {
            refundMoney = new BigDecimal(String.valueOf(moneyObj));
        }
        disRefundDomain.setRefundMoney(refundMoney);
        if (null != map.get("pictures") && StringUtils.isNotBlank((String)((String)map.get("pictures")))) {
            String pictures = (String)map.get("pictures");
            String[] s = pictures.split("\\,");
            List<String> listStr = Arrays.asList(s);
            disRefundDomain.setOcRefundFileDomainList(this.createFile(listStr, disRefundDomain));
        }
        List goodlist = (List)JsonUtil.buildNormalBinder().getJsonToList(String.valueOf(map.get("food")), Map.class);
        disRefundDomain.setRefundType("mt1");
        if (ListUtil.isEmpty((Collection)goodlist)) {
            disRefundDomain.setRefundType("mt2");
        }
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(goodlist, disRefundDomain, disContractDomain, disChannel));
        return disRefundDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(List<Map<String, Object>> goodlist, DisRefundDomain disRefundDomain, DisContractDomain disContractDomain, DisChannel disChannel) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + " createRefundGoods.null");
            return null;
        }
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            this.logger.error(this.SYS_CODE + " createRefundGoods.map");
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        if (ListUtil.isEmpty(goodlist)) {
            BigDecimal amt = BigDecimal.ZERO;
            if (!"mt2".equals(disRefundDomain.getRefundType())) {
                this.logger.error(this.SYS_CODE + "RefundType", (Object)disRefundDomain.getRefundType());
                return null;
            }
            List listmap = this.getRefundByOrderId(disRefundDomain.getContractNbillcode(), disContractDomain.getMemberCode(), disContractDomain.getTenantCode());
            if (ListUtil.isNotEmpty((Collection)listmap)) {
                DisContractGoodsDomain disContractGoodsDomain;
                for (Map mapRefund : listmap) {
                    List refundGoods = (List)mapRefund.get("wmAppRetailForOrderPartRefundList");
                    if (ListUtil.isNotEmpty((Collection)refundGoods)) {
                        for (Map mapGoods : refundGoods) {
                            BigDecimal num;
                            String skuNo = (String)mapGoods.get("sku_id");
                            Integer count = (Integer)mapGoods.get("count");
                            if (!StringUtils.isNotBlank((String)skuNo) || !map.containsKey(skuNo) || null == (num = (disContractGoodsDomain = (DisContractGoodsDomain)map.get(skuNo)).getGoodsNum())) continue;
                            String numStr = String.valueOf(num.setScale(0, 1));
                            Integer disCount = Integer.valueOf(numStr);
                            if (disCount == count) {
                                map.remove(skuNo);
                                continue;
                            }
                            Integer val = disCount - count;
                            BigDecimal newNum = new BigDecimal(val.toString());
                            BigDecimal bmoney = newNum.multiply(disContractGoodsDomain.getPricesetNprice());
                            disContractGoodsDomain.setContractGoodsMoney(bmoney);
                            map.put(skuNo, disContractGoodsDomain);
                        }
                        continue;
                    }
                    disRefundDomain.setRefundMoney(new BigDecimal(mapRefund.get("money").toString()));
                }
                for (String key : map.keySet()) {
                    disContractGoodsDomain = (DisContractGoodsDomain)map.get(key);
                    if (null == disContractGoodsDomain) {
                        this.logger.error(this.SYS_CODE + " createRefundGoods.disContractGoodsDomain", (Object)key);
                        return null;
                    }
                    disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                    DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                    amt = amt.add(disRefundGoodsDomain.getRefundGoodsAmt());
                    refundGoodsList.add(disRefundGoodsDomain);
                }
            } else {
                for (String key : map.keySet()) {
                    DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.get(key);
                    if (null == disContractGoodsDomain) {
                        this.logger.error(this.SYS_CODE + " createRefundGoods.disContractGoodsDomain1", (Object)key);
                        return null;
                    }
                    disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                    DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                    amt = amt.add(disRefundGoodsDomain.getRefundGoodsAmt());
                    refundGoodsList.add(disRefundGoodsDomain);
                }
                disRefundDomain.setRefundMoney(amt);
            }
        } else {
            for (Map<String, Object> gmap : goodlist) {
                DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.remove(gmap.get("sku_id"));
                if (null == disContractGoodsDomain) {
                    this.logger.error(this.SYS_CODE + " createRefundGoods.remove", gmap.get("sku_id"));
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                disRefundGoodsDomain.setRefundGoodsNum(BigDecimal.valueOf(((Integer)gmap.get("count")).intValue()));
                if (null != gmap.get("refund_price")) {
                    disRefundGoodsDomain.setRefundGoodsPrice(BigDecimal.valueOf((Double)gmap.get("refund_price")));
                }
                if (null != gmap.get("refunded_weight")) {
                    disRefundGoodsDomain.setRefundGoodsWeight(BigDecimal.valueOf((Double)gmap.get("refunded_weight")));
                }
                disRefundGoodsDomain.setRefundGoodsAmt(disRefundGoodsDomain.getRefundGoodsPrice().multiply(disRefundGoodsDomain.getRefundGoodsNum()));
                refundGoodsList.add(disRefundGoodsDomain);
            }
        }
        return refundGoodsList;
    }

    public Map<String, Object> buildRefundParam(Map<String, Object> map) {
        return map;
    }

    public String saveRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == sendhttpParam) {
            return "{\"data\":\"ok\"}";
        }
        String order_id = (String)sendhttpParam.get("order_id");
        if (StringUtils.isBlank((String)order_id)) {
            return "{\"data\":\"ok\"}";
        }
        String refund_id = (String)sendhttpParam.get("refund_id");
        if (StringUtils.isBlank((String)refund_id)) {
            return "{\"data\":\"ok\"}";
        }
        String res_type = (String)sendhttpParam.get("res_type");
        DisRefundReDomain disRefundReDomain = this.getRefundByNbillcode(disChannel.getTenantCode(), order_id, disChannel);
        if (null != disRefundReDomain) {
            this.logger.error(this.SYS_CODE + ":" + res_type + ":", (Object)(JsonUtil.buildNormalBinder().toJson((Object)disRefundReDomain) + "=:=" + sendhttpParam));
            HashMap<String, String> mapP = new HashMap<String, String>();
            mapP.put("dataStatestr", res_type);
            this.sendUpdateRefundStateByCode(disChannel.getTenantCode(), disRefundReDomain.getRefundCode(), disChannel.getChannelCode(), Integer.parseInt(res_type), disRefundReDomain.getDataState(), mapP);
        }
        this.logger.error(this.SYS_CODE + ".disRefundDomain---", (Object)(param + "=:=" + JsonUtil.buildNormalBinder().toJson((Object)disChannel)));
        DisRefundDomain disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), refund_id, disChannel);
        if (null == disRefundDomain) {
            disRefundDomain = this.getSendRefund(order_id, refund_id, param.get("memberCode").toString(), disChannel.getTenantCode());
            if (null == disRefundDomain) {
                this.logger.error(this.SYS_CODE + ".disRefundDomain", (Object)(order_id + "=:=" + refund_id + "=:=" + disChannel.getTenantCode() + "=:=" + param));
                return "{\"data\":\"\u9000\u5355\u4e3a\u7a7a\"}";
            }
            ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
            disRefundDomainList.add(disRefundDomain);
            this.saveRefund(disRefundDomainList, disChannel);
            return "{\"data\":\"ok\" }";
        }
        String stateOld = disRefundDomain.getDataStatestr();
        if (StringUtils.isEmpty((String)stateOld)) {
            return "{\"data\":\"ok\"}";
        }
        if (Integer.parseInt(res_type) <= Integer.parseInt(stateOld)) {
            return "{\"data\":\"ok\"}";
        }
        String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), res_type);
        if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
            dataStateStr = res_type;
        }
        Integer dataState = Integer.valueOf(dataStateStr);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataStatestr", dataStateStr);
        this.updateRefund(disChannel.getTenantCode(), refund_id, dataState, null, map, disChannel);
        return "{\"data\":\"ok\"}";
    }
}

