/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.mt.order.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisRefundBaseService;
import com.yqbsoft.laser.service.ext.channel.mt.MtConstants;
import com.yqbsoft.laser.service.ext.channel.mt.sevice.WebUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisRefundServiceImpl
extends DisRefundBaseService {
    private String SYS_CODE = "mt.DisRefundrServiceImpl";

    protected String getChannelCode() {
        return MtConstants.channelCode;
    }

    public Map<String, Object> buildComRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + " buildComRefundParam  ", (Object)channelApiCode);
            return null;
        }
        sendParam.put("app_id", configMap.get("app_id"));
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        return sendParam;
    }

    public Map<String, String> convert(Map<String, Object> map) {
        HashMap<String, String> strMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            strMap.put(key, String.valueOf(map.get(key)));
        }
        return strMap;
    }

    public Object sendComRefund(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        List mapList;
        String json;
        this.logger.error(this.SYS_CODE + " sendComRefund ", (Object)(param + "=:=" + channelApiCode + " == " + sendhttpParam + " == " + configMap + " === " + disChannel));
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(MtConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map<String, String> mapStr = this.convert(sendhttpParam);
        try {
            json = WebUtils.doGet(url, mapStr, null);
            this.logger.error(this.SYS_CODE + " =channelApiCode : ", (Object)(channelApiCode + " == " + json + "url:" + url + "=:=" + mapStr));
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComRefund.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map mtOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)mtOrderMap)) {
            return null;
        }
        if (null != mtOrderMap.get("error")) {
            throw new ApiException(this.SYS_CODE + ".sendComRefund.mtResultListOrder", JsonUtil.buildNormalBinder().toJson(mtOrderMap.get("error")));
        }
        if (null == mtOrderMap.get("data")) {
            return null;
        }
        if ("cmc.disRefund.getSendRefund".equals(channelApiCode)) {
            mapList = (List)mtOrderMap.get("data");
            if (ListUtil.isEmpty((Collection)mapList)) {
                this.logger.error(this.SYS_CODE + ".cmc.disRefund.getSendRefund", (Object)mtOrderMap);
                return null;
            }
            for (Map map : mapList) {
                String refund_id;
                Object o = map.get("refund_id");
                String string = refund_id = null == o ? "" : String.valueOf(o);
                if (!param.get("refundOcode").equals(refund_id)) continue;
                return this.createRefund(map, disChannel);
            }
        }
        if ("cmc.disRefund.getRefundByOrderId".equals(channelApiCode)) {
            mapList = (List)mtOrderMap.get("data");
            this.logger.error(this.SYS_CODE + " mapList :", (Object)mapList);
            return mapList;
        }
        return null;
    }

    private DisRefundDomain createRefund(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        try {
            return this.makeRefund(param, disChannel);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".createRefund.e", (Throwable)e);
            return null;
        }
    }

    private Date transferLongToDate(Long millSec) {
        try {
            Date date = new Date(millSec);
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    private DisRefundDomain makeRefund(Map<String, Object> map, DisChannel disChannel) {
        if (MapUtil.isEmpty(map) || null == disChannel) {
            return null;
        }
        String tenantCode = disChannel.getTenantCode();
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        disRefundDomain.setChannelCode(disChannel.getChannelCode());
        disRefundDomain.setChannelName(disChannel.getChannelName());
        disRefundDomain.setTenantCode(tenantCode);
        disRefundDomain.setGoodsWeight(BigDecimal.ZERO);
        DisContractDomain disContractDomain = this.getDisContract(map, disChannel, tenantCode);
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
            return null;
        }
        this.makeRefundInfo(disRefundDomain, map, disContractDomain);
        return disRefundDomain;
    }

    private DisContractDomain getDisContract(Map<String, Object> map, DisChannel disChannel, String tenantCode) {
        Object ob;
        String order_id = null == map.get("order_id") ? "" : String.valueOf(map.get("order_id"));
        DisContractDomain disContractDomain = this.getContractByNbCode(tenantCode, order_id, disChannel);
        if (null == disContractDomain && null == (disContractDomain = this.getContractByNbCode(tenantCode, order_id = null == (ob = map.get("wm_order_id_view")) ? null : String.valueOf(map.get("wm_order_id_view")), disChannel))) {
            this.logger.error(this.SYS_CODE + ".makeRefund.getContractByNbCode..", (Object)order_id);
            return null;
        }
        if (null == (disContractDomain = this.getContractDomainByCode(tenantCode, disContractDomain.getContractBillcode()))) {
            this.logger.error(this.SYS_CODE + ".makeRefund.getContractDomainByCode", (Object)order_id);
            return null;
        }
        return disContractDomain;
    }

    private void makeRefundInfo(DisRefundDomain disRefundDomain, Map<String, Object> map, DisContractDomain disContractDomain) {
        String refund_id = null == map.get("refund_id") ? "" : String.valueOf(map.get("refund_id"));
        disRefundDomain.setRefundOcode(refund_id);
        disRefundDomain.setRefundCreate(disContractDomain.getContractValidate());
        Date sendTime = new Date();
        Object ctimeStr = map.get("ctime");
        if (null != ctimeStr) {
            sendTime = this.transferLongToDate(Long.valueOf(String.valueOf(ctimeStr) + "000"));
        }
        disRefundDomain.setRefundDate(sendTime);
        String time = this.getRefundAuditTime(disContractDomain.getTenantCode(), disContractDomain.getChannelCode());
        if (null != time && StringUtils.isNotBlank((String)time)) {
            disRefundDomain.setRefundInvstate(Integer.valueOf(Integer.parseInt(time)));
        }
        disRefundDomain.setRefundEx(null == map.get("res_reason") ? null : String.valueOf(map.get("res_reason")));
        disRefundDomain.setRefundUsertype("0");
        disRefundDomain.setRefundMeo(null == map.get("apply_reason") ? "" : map.get("apply_reason").toString());
        disRefundDomain.setDataStatestr(null == map.get("res_type") ? "" : map.get("res_type").toString());
        disRefundDomain.setRefundMoney(null == map.get("money") ? BigDecimal.ZERO : new BigDecimal(map.get("money").toString()));
        if (null != map.get("pictures") && StringUtils.isNotBlank((String)((String)map.get("pictures")))) {
            String pictures = (String)map.get("pictures");
            String[] s = pictures.split("\\,");
            List<String> listStr = Arrays.asList(s);
            disRefundDomain.setOcRefundFileDomainList(this.createFile(listStr, disRefundDomain));
        }
        List goodlist = (List)JsonUtil.buildNormalBinder().getJsonToList(String.valueOf(map.get("food")), Map.class);
        disRefundDomain.setRefundType("mt1");
        if (ListUtil.isEmpty((Collection)goodlist)) {
            disRefundDomain.setRefundType("mt2");
        }
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(goodlist, disRefundDomain, disContractDomain));
    }

    private List<DisRefundGoodsDomain> createRefundGoods(List<Map<String, Object>> goodlist, DisRefundDomain disRefundDomain, DisContractDomain disContractDomain) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + " createRefundGoods.null");
            return null;
        }
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            this.logger.error(this.SYS_CODE + " createRefundGoods.map", (Object)"map is null");
            return null;
        }
        if (ListUtil.isEmpty(goodlist)) {
            return this.allRefundInformation(disRefundDomain, map, disContractDomain);
        }
        return this.partRefundInformation(disRefundDomain, goodlist, map);
    }

    private List<DisRefundGoodsDomain> partRefundInformation(DisRefundDomain disRefundDomain, List<Map<String, Object>> goodlist, Map<String, DisContractGoodsDomain> map) {
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        for (Map<String, Object> gmap : goodlist) {
            DisContractGoodsDomain disContractGoodsDomain = map.remove(gmap.get("sku_id"));
            if (null == disContractGoodsDomain) {
                this.logger.error(this.SYS_CODE + " createRefundGoods.remove", gmap.get("sku_id"));
                return null;
            }
            disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
            DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
            disRefundGoodsDomain.setRefundGoodsNum(BigDecimal.valueOf(((Integer)gmap.get("count")).intValue()));
            if (null != gmap.get("refund_price")) {
                disRefundGoodsDomain.setRefundGoodsPrice(BigDecimal.valueOf((Double)gmap.get("refund_price")));
            }
            if (null != gmap.get("refunded_weight")) {
                disRefundGoodsDomain.setRefundGoodsWeight(BigDecimal.valueOf((Double)gmap.get("refunded_weight")));
            }
            disRefundGoodsDomain.setRefundGoodsAmt(disRefundGoodsDomain.getRefundGoodsPrice().multiply(disRefundGoodsDomain.getRefundGoodsNum()));
            refundGoodsList.add(disRefundGoodsDomain);
        }
        return refundGoodsList;
    }

    private List<DisRefundGoodsDomain> allRefundInformation(DisRefundDomain disRefundDomain, Map<String, DisContractGoodsDomain> map, DisContractDomain disContractDomain) {
        BigDecimal amt = BigDecimal.ZERO;
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        boolean changeAmtFlag = false;
        List listmap = this.getRefundByOrderId(disRefundDomain.getContractNbillcode(), disContractDomain.getMemberCode(), disContractDomain.getTenantCode());
        if (ListUtil.isNotEmpty((Collection)listmap)) {
            map = this.dealRefundGoods(listmap, map, disRefundDomain);
            this.logger.error(this.SYS_CODE + ".allRefundInformation.map", (Object)("\u5f53\u524d\u9000\u6b3e\u91d1\u989dRefundMoney\uff1a" + disRefundDomain.getRefundMoney() + ",\u9000\u8d27\u5546\u54c1\u5904\u7406\u540e\u7684\u6570\u636e\uff01" + map));
            if (disRefundDomain.getRefundMoney().compareTo(amt) == 0) {
                changeAmtFlag = true;
            }
            if (MapUtil.isEmpty(map)) {
                return null;
            }
            for (String key : map.keySet()) {
                DisContractGoodsDomain disContractGoodsDomain = map.get(key);
                if (null == disContractGoodsDomain) {
                    this.logger.error(this.SYS_CODE + " createRefundGoods.disContractGoodsDomain", (Object)key);
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                if (changeAmtFlag) {
                    amt = amt.add(disRefundGoodsDomain.getRefundGoodsAmt());
                }
                refundGoodsList.add(disRefundGoodsDomain);
            }
            if (changeAmtFlag) {
                disRefundDomain.setRefundMoney(amt);
            }
        } else {
            for (String key : map.keySet()) {
                DisContractGoodsDomain disContractGoodsDomain = map.get(key);
                if (null == disContractGoodsDomain) {
                    this.logger.error(this.SYS_CODE + " createRefundGoods.disContractGoodsDomain1", (Object)key);
                    return null;
                }
                disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
                DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
                amt = amt.add(disRefundGoodsDomain.getRefundGoodsAmt());
                refundGoodsList.add(disRefundGoodsDomain);
            }
            disRefundDomain.setRefundMoney(amt);
        }
        return refundGoodsList;
    }

    private Map<String, DisContractGoodsDomain> dealRefundGoods(List<Map<String, Object>> listmap, Map<String, DisContractGoodsDomain> map, DisRefundDomain disRefundDomain) {
        for (Map<String, Object> mapRefund : listmap) {
            List refundGoods = (List)mapRefund.get("wmAppRetailForOrderPartRefundList");
            if (ListUtil.isEmpty((Collection)refundGoods)) {
                if (listmap.size() == 1) {
                    disRefundDomain.setRefundMoney(new BigDecimal(null == mapRefund.get("money") ? "0" : mapRefund.get("money").toString()));
                    this.logger.error(this.SYS_CODE + ".dealRefundGoods.money", (Object)(disRefundDomain.getRefundMoney() + "|" + mapRefund.get("money")));
                    return map;
                }
                disRefundDomain.setRefundMoney(new BigDecimal(null == mapRefund.get("money") ? "0" : mapRefund.get("money").toString()));
                continue;
            }
            for (Map mapGoods : refundGoods) {
                Integer count;
                String skuNo = null == mapGoods.get("sku_id") ? null : mapGoods.get("sku_id").toString();
                Integer n = count = null == mapGoods.get("count") ? null : Integer.valueOf(mapGoods.get("count").toString());
                if (StringUtils.isBlank((String)skuNo) || !map.containsKey(skuNo)) {
                    this.logger.error(this.SYS_CODE + ".dealRefundGoods.skuNo", (Object)(skuNo + "(result:skuNo is null or skuNo not exit ordergoods)" + "===:===" + mapRefund));
                    return null;
                }
                DisContractGoodsDomain disContractGoodsDomain = map.get(skuNo);
                BigDecimal num = disContractGoodsDomain.getGoodsNum();
                if (null == num) continue;
                Integer disCount = Integer.valueOf(String.valueOf(num.setScale(0, 1)));
                if (disCount == count) {
                    map.remove(skuNo);
                    continue;
                }
                Integer val = disCount - count;
                BigDecimal newNum = new BigDecimal(val.toString());
                BigDecimal bmoney = newNum.multiply(disContractGoodsDomain.getPricesetNprice());
                disContractGoodsDomain.setContractGoodsMoney(bmoney);
                map.put(skuNo, disContractGoodsDomain);
            }
        }
        return map;
    }

    public Map<String, Object> buildRefundParam(Map<String, Object> map) {
        return map;
    }

    public String saveRefundParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + ".saveRefundParam.intoparam", sendhttpParam);
        if (null == sendhttpParam) {
            return "{\"data\":\"ok\"}";
        }
        String order_id = (String)sendhttpParam.get("order_id");
        if (StringUtils.isBlank((String)order_id)) {
            return "{\"data\":\"ok\"}";
        }
        String refund_id = (String)sendhttpParam.get("refund_id");
        if (StringUtils.isBlank((String)refund_id)) {
            return "{\"data\":\"ok\"}";
        }
        String res_type = (String)sendhttpParam.get("res_type");
        DisRefundDomain disRefundDomain = this.getRefundByOCode(disChannel.getTenantCode(), refund_id, disChannel);
        this.logger.error(this.SYS_CODE + ".saveRefundParam.getRefundByOCode", (Object)("refund_id:" + refund_id + "|disChannel:" + disChannel + "|tenantCode" + disChannel.getTenantCode() + ",\u5f53\u524d\u5bf9\u8c61" + disRefundDomain));
        if (null == disRefundDomain) {
            disRefundDomain = this.createRefund(sendhttpParam, disChannel);
            if (null == disRefundDomain) {
                this.logger.error(this.SYS_CODE + ".disRefundDomain.2.", (Object)(order_id + "=:=" + refund_id + "=:=" + disChannel.getTenantCode() + "=:=" + param));
                disRefundDomain = this.getSendRefund(order_id, refund_id, param.get("memberCode").toString(), disChannel.getTenantCode());
                if (null == disRefundDomain) {
                    this.logger.error(this.SYS_CODE + ".disRefundDomain", (Object)(order_id + "=:=" + refund_id + "=:=" + disChannel.getTenantCode() + "=:=" + param));
                    return "{\"data\":\"\u9000\u5355\u4e3a\u7a7a\"}";
                }
                ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
                disRefundDomainList.add(disRefundDomain);
                this.saveRefund(disRefundDomainList, disChannel);
                return "{\"data\":\"ok\" }";
            }
            ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
            this.logger.error(this.SYS_CODE + ".saveRefundParam.disRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)disRefundDomain));
            disRefundDomainList.add(disRefundDomain);
            this.saveRefund(disRefundDomainList, disChannel);
            return "{\"data\":\"ok\"}";
        }
        String stateOld = disRefundDomain.getDataStatestr();
        if (StringUtils.isEmpty((String)stateOld)) {
            return "{\"data\":\"ok\"}";
        }
        if (Integer.parseInt(res_type) <= Integer.parseInt(stateOld)) {
            return "{\"data\":\"ok\"}";
        }
        String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), res_type);
        this.logger.error(this.SYS_CODE + ".saveRefundParam.updateDataStateStr", (Object)(dataStateStr + "-" + res_type));
        if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
            dataStateStr = res_type;
        }
        Integer dataState = Integer.valueOf(dataStateStr);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataStatestr", dataStateStr);
        this.logger.error(this.SYS_CODE + ".saveRefundParam.updateRefund", (Object)(disChannel.getTenantCode() + "-" + refund_id + "-" + dataState + "-" + map + "-" + disChannel));
        this.sendUpdateRefundStateByCode(disChannel.getTenantCode(), disRefundDomain.getRefundCode(), disChannel.getChannelCode(), Integer.parseInt(res_type), disRefundDomain.getDataState(), map);
        return "{\"data\":\"ok\"}";
    }
}

