/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.nanwang.login.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.common.ApiCodeEnums;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.domain.UmUserBean;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.service.SSOService;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.utils.ASCIIUtils;
import com.yqbsoft.laser.service.ext.channel.nanwang.login.utils.SHA256Util;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class SSOServiceImpl
extends BaseServiceImpl
implements SSOService {
    private final String SYS_CODE = "nanwang.login.service.impl.SSOServiceImpl";
    private RestTemplate restTemplate = new RestTemplate();

    @Override
    public UmUserBean getCode() throws ApiException {
        return null;
    }

    @Override
    public UmUserBean refreshToken() throws ApiException {
        return null;
    }

    @Override
    public UmUserBean getLogin(String userName, String password, String appmanageIcode, String tenantCode, String isValid) throws ApiException {
        String custNumber;
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userName)) {
            UmUserBean userBean = new UmUserBean();
            userBean.setFlag(false);
            userBean.setMsg("\u4f20\u5165\u53c2\u6570\u9519\u8bef");
            return userBean;
        }
        String url = this.getUrl("url", tenantCode);
        String redirectUri = this.getUrl("redirectUri", tenantCode);
        String clientSecret = this.getUrl("clientSecret", tenantCode);
        String clientId = this.getUrl("clientId", tenantCode);
        Map map = new LinkedHashMap(16);
        try {
            map = (Map)this.authorization_code(userName, clientId, clientSecret, url, redirectUri);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (!"00".equals(map.get("sta"))) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.oauthCsgLogin.errorCode", map.get("message"));
            UmUserBean userBean = new UmUserBean();
            userBean.setFlag(false);
            userBean.setMsg(null != map.get("message") ? map.get("message").toString() : "\u8c03\u7528\u4e09\u65b9\u63a5\u53e3\u5931\u8d25");
            return userBean;
        }
        Map csgUserBean = (Map)map.get("data");
        String string = custNumber = null != csgUserBean.get("custNumber") ? csgUserBean.get("custNumber").toString() : "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)custNumber)) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.oauthCsgLogin.getCustNumber", map.get("message"));
            UmUserBean userBean = new UmUserBean();
            userBean.setFlag(false);
            userBean.setMsg("custNumber is null");
            return userBean;
        }
        UmUserBean umUserBean = this.checkUserAndSave(csgUserBean, url, tenantCode);
        if (!umUserBean.isFlag()) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.oauthCsgLogin.checkUserAndSave.getMsg", (Object)umUserBean.getMsg());
            return umUserBean;
        }
        return this.loginUser(tenantCode, umUserBean);
    }

    private UmUserBean loginUser(String tenantCode, UmUserBean execute) {
        String userBeanStr;
        if (null == execute || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> inventoryMap = new HashMap<String, Object>(16);
        inventoryMap.put("userName", execute.getUserName());
        inventoryMap.put("tenantCode", tenantCode);
        inventoryMap.put("isValid", 3);
        UmUserBean userBean = new UmUserBean();
        try {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.loginUser");
            String api = ApiCodeEnums.checkUmApi.getApiCode();
            userBeanStr = (String)this.getInternalRouter().inInvoke(api, inventoryMap);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userBeanStr)) {
                this.logger.error("nanwang.login.service.impl.SSOServiceImpl.loginUser.userBeanStr", (Object)("\u8fd4\u56de\u7ed3\u679cuserBeanStr\uff1a" + userBeanStr + "," + "\u8bf7\u6c42\u53c2\u6570inventoryMap\uff1a" + inventoryMap));
                userBean.setFlag(false);
                userBean.setMsg("queryUmuserCheck\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return userBean;
            }
        }
        catch (Exception e) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.loginUser.userBeanStr.exception", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570inventoryMap\uff1a" + inventoryMap), (Throwable)e);
            userBean.setFlag(false);
            userBean.setMsg("\u8acb\u6c42um.user.queryUmuserCheck\u5f02\u5e38\uff01\uff01\uff01");
            return userBean;
        }
        userBean = (UmUserBean)JsonUtil.buildNormalBinder().getJsonToObject(userBeanStr, UmUserBean.class);
        if (null == userBean || !userBean.isFlag()) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.loginUser.userBean", (Object)("\u8fd4\u56de\u7ed3\u679cuserBeanStr\uff1a" + userBeanStr + "," + "\u8bf7\u6c42\u53c2\u6570inventoryMap\uff1a" + inventoryMap));
        }
        return userBean;
    }

    private UmUserBean checkUserAndSave(Map<String, Object> execute, String url, String tenantCode) {
        String custNumber;
        UmUserBean userBean = new UmUserBean();
        if (null == execute || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)url)) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.null");
            userBean.setFlag(false);
            userBean.setMsg("checkUserAndSave.null");
            return userBean;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("userPhone", null != execute.get("mobilePhone") ? execute.get("mobilePhone").toString() : "");
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> map = new HashMap<String, String>(16);
        this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.queryParam", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.sendReSupObject(ApiCodeEnums.queryUser.getApiCode(), map, UmUserBean.class);
        UmUserBean umUserBean = null;
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.queryResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()));
            umUserBean = (UmUserBean)queryResult.getList().get(0);
        }
        this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.queryUser", (Object)JsonUtil.buildNormalBinder().toJson(umUserBean));
        if (null != umUserBean && StringUtils.isEmpty((Object)execute.get("custNumber"))) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.custNumber.null");
            userBean.setFlag(false);
            userBean.setMsg("custNumber is null");
            return userBean;
        }
        String mobilePhone = null != execute.get("mobilePhone") ? execute.get("mobilePhone").toString() : "";
        String string = custNumber = null != execute.get("custNumber") ? execute.get("custNumber").toString() : "";
        if (null != umUserBean && com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)mobilePhone) && mobilePhone.equals(umUserBean.getUserOcode())) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.custNumber == userOcode");
            umUserBean.setFlag(true);
            return umUserBean;
        }
        this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.umUserBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserBean));
        if (null != umUserBean && com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)mobilePhone) && !mobilePhone.equals(umUserBean.getUserPhone())) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.updateCustNumber", (Object)"===");
            try {
                HashMap<String, Object> inventoryMap = new HashMap<String, Object>(16);
                inventoryMap.put("userId", umUserBean.getUserId());
                inventoryMap.put("dataState", umUserBean.getDataState());
                inventoryMap.put("oldDataState", umUserBean.getDataState());
                HashMap<String, String> umap = new HashMap<String, String>(16);
                umap.put("userOcode", custNumber);
                inventoryMap.put("map", JsonUtil.buildNormalBinder().toJson(umap));
                this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.updateCustNumber.umap", (Object)JsonUtil.buildNormalBinder().toJson(umap));
                String api = ApiCodeEnums.updateOpenid.getApiCode();
                this.getInternalRouter().inInvoke(api, inventoryMap);
                this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.updateCustNumber", (Object)((Object)inventoryMap).toString());
            }
            catch (Exception e) {
                this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.updateCustNumber.e", (Throwable)e);
                userBean.setMsg(e.getMessage());
                userBean.setFlag(false);
                return userBean;
            }
        }
        String access_token = null != execute.get("access_token") ? execute.get("access_token").toString() : "";
        Map<String, Object> csgUserBean = this.queryCsgUserBean(access_token, tenantCode);
        this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.saveCustNumber", (Object)"===");
        UmUserDomainBean umUserDomainBean = this.copyFields(csgUserBean, tenantCode);
        try {
            HashMap<String, String> inventoryMap = new HashMap<String, String>(16);
            inventoryMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            String api = ApiCodeEnums.openUserinfo.getApiCode();
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.umUserDomainBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            this.getInternalRouter().inInvoke(api, inventoryMap);
        }
        catch (Exception e) {
            this.logger.error("nanwang.login.service.impl.SSOServiceImpl.checkUserAndSave.saveCustNumber.exception", (Throwable)e);
            userBean.setMsg(e.getMessage());
            userBean.setFlag(false);
            return userBean;
        }
        userBean.setUserName(umUserDomainBean.getUserName());
        userBean.setUserNickname(umUserDomainBean.getUserNickname());
        userBean.setUserinfoOcode(umUserDomainBean.getUserinfoOcode());
        userBean.setFlag(true);
        return userBean;
    }

    private UmUserDomainBean copyFields(Map<String, Object> csgUserBean, String tenantCode) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserName(null != csgUserBean.get("mobilePhone") ? csgUserBean.get("mobilePhone").toString() : "");
        umUserDomainBean.setUserPhone(null != csgUserBean.get("mobilePhone") ? csgUserBean.get("mobilePhone").toString() : "");
        umUserDomainBean.setUserNickname(null != csgUserBean.get("nickName") ? csgUserBean.get("nickName").toString() : "");
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserinfoCompname(null != csgUserBean.get("mobilePhone") ? csgUserBean.get("mobilePhone").toString() : "");
        umUserDomainBean.setUserinfoOcode(null != csgUserBean.get("custNumber") ? csgUserBean.get("custNumber").toString() : "");
        umUserDomainBean.setUserOcode(null != csgUserBean.get("custNumber") ? csgUserBean.get("custNumber").toString() : "");
        String compname = umUserDomainBean.getUserinfoCompname();
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)compname)) {
            compname = umUserDomainBean.getUserName();
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)compname)) {
            compname = umUserDomainBean.getUserPhone();
        }
        umUserDomainBean.setUserinfoCompname(compname);
        umUserDomainBean.setUserinfoQuality("buy");
        return umUserDomainBean;
    }

    private Map<String, Object> queryCsgUserBean(String token, String tenantCode) {
        String url = this.getUrl("url", tenantCode);
        Map execute = (Map)this.getCustInfo(token, url);
        return (Map)execute.get("data");
    }

    private String getUrl(String flagSettingCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat("csgSso").concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        this.logger.error("nanwang.login.service.impl.SSOServiceImpl.getUrl", (Object)(tenantCode + "=" + "csgSso" + "=" + flagSettingCode + "=" + value));
        return value;
    }

    public Object authorization_code(String code, String clientId, String clientSecret, String url, String redirectUri) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("client_id", clientId);
        map.put("code", code);
        map.put("grant_type", "authorization_code");
        map.put("redirect_uri", URLEncoder.encode(redirectUri, "UTF-8"));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String authentication = clientId + ":" + clientSecret;
        headers.set("authorization", "Basic " + Base64.encodeBase64String((byte[])authentication.getBytes()));
        HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headers);
        ResponseEntity exchange = this.restTemplate.postForEntity(url + "/ucs/ma/ucc/oauth/token", (Object)httpEntity, Object.class, new Object[0]);
        return exchange.getBody();
    }

    private Object getCustInfo(String accessToken, String url) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"access_token", (Object)accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity httpEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity exchange = this.restTemplate.postForEntity(url + "/ucs/ma/ucc/oauth/getCustInfo", (Object)httpEntity, Object.class, new Object[0]);
        return exchange.getBody();
    }

    public static void main(String[] args) {
        HashMap<String, String> bodyParam = new HashMap<String, String>(16);
        String method = "cmc.csgSSO.getLogin";
        String url = "https://yy-nanwang.jd.com/";
        bodyParam.put("method", "cmc.csgSSO.getLogin");
        bodyParam.put("code", "eX7em6oovA8OMQxu");
        bodyParam.put("app_id", "zhaoshang");
        bodyParam.put("version", "1.0");
        bodyParam.put("timestamp", "2021-05-11 09:59:00");
        bodyParam.put("tenantCode", "422890374118244352");
        bodyParam.put("sign_type", "SHA256");
        Map confMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(bodyParam), String.class, String.class);
        String value = ASCIIUtils.stringToAscii(confMap);
        String str1 = value + "66987CB115214E59E6EC978214934FB8";
        String sign = SHA256Util.getSHA256String(str1);
        bodyParam.put("sign", sign);
        String result = "";
        try {
            result = WebUtils.doPost((String)(url + "/laserEr/http/post/+" + method + "+/1.0/422890374118244352/utf-8/zhaoshang"), bodyParam, (int)100000, (int)100000);
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(result);
    }

    public static String sortSpcList(List<String> spcList) {
        if (null == spcList || spcList.isEmpty()) {
            return null;
        }
        Collections.sort(spcList);
        String result = "";
        for (String spc : spcList) {
            result = result + "/" + spc;
        }
        return result.substring(1);
    }
}

