/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptUtil.class);

    private EncryptUtil() {
    }

    public static String generateAESSecretKey() {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom());
            return Base64.encodeBase64String((byte[])kgen.generateKey().getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("AesCypher.genKey NoSuchAlgorithmException", (Throwable)e);
            return null;
        }
    }

    public static String aesEncrypt(String originText, String secret) throws Exception {
        AesCypher cypher = new AesCypher(secret);
        return cypher.encrypt(originText);
    }

    public static String aesDecrypt(String encryptedText, String secret) throws Exception {
        AesCypher cypher = new AesCypher(secret);
        return cypher.decrypt(encryptedText);
    }

    public static void main(String[] args) throws Exception {
        String plainText = "{\"contractBillcode\":\"2024081300000075\",\"dataState\":3,\"cardNumber\":\"1244\",\"termOfValidity\":\"2024-09-12 11:40:31\"}";
        String aesKey = EncryptUtil.generateAESSecretKey();
        System.out.println("AES\u79d8\u94a5: " + aesKey);
        String aesEncrypted = EncryptUtil.aesEncrypt(plainText, aesKey);
        System.out.println("AES\u5bc6\u6587: " + aesEncrypted);
        System.out.println("AES\u660e\u6587: " + EncryptUtil.aesDecrypt(aesEncrypted, aesKey));
    }

    static class AesCypher {
        private static final Logger LOGGER = LoggerFactory.getLogger(AesCypher.class);
        private byte[] linebreak = new byte[0];
        private SecretKey key;
        private Cipher cipher;
        private Base64 coder;

        public AesCypher(String secret) {
            try {
                this.coder = new Base64(32, this.linebreak, true);
                byte[] secrets = this.coder.decode(secret);
                this.key = new SecretKeySpec(secrets, "AES");
                this.cipher = Cipher.getInstance("AES/ECB/PKCS5Padding", "SunJCE");
            }
            catch (Exception e) {
                LOGGER.error("AesCypher.genKey NoSuchAlgorithmException", (Throwable)e);
            }
        }

        public synchronized String encrypt(String plainText) throws Exception {
            this.cipher.init(1, this.key);
            byte[] cipherText = this.cipher.doFinal(plainText.getBytes("UTF-8"));
            return new String(this.coder.encode(cipherText));
        }

        public synchronized String decrypt(String codedText) throws Exception {
            byte[] encypted = this.coder.decode(codedText.getBytes());
            this.cipher.init(2, this.key);
            byte[] decrypted = this.cipher.doFinal(encypted);
            return new String(decrypted, "UTF-8");
        }
    }
}

