/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataInChuanHangCardRollService;
import com.yqbsoft.laser.service.ext.data.api.DataOutMessageService;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.HttpUtils;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.config.RequestConfiguration;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.CouponOrderInfoRQ;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCustomerInfo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.RightsSpecPricing;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.BenefitOrderChildren;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.PayOrderVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.MyCardVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.OrderDetailCoupons;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ProductVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.RefundDataVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ResponseVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.productItemVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.task.TaskService;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.service.DateBaseService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.crypto.hash.SimpleHash;

public class DataInChuanHangCardRollServiceImpl
extends DateBaseService
implements DataInChuanHangCardRollService {
    private static final String SYS_CODE = "DataInChuanHangCardRollServiceImpl";
    private DataOutMessageService dataOutMessageService;
    private TaskService taskService;

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setDataOutMessageService(DataOutMessageService dataOutMessageService) {
        this.dataOutMessageService = dataOutMessageService;
    }

    public String createBenefitOrder(OcContractDomain ocContractDomain) {
        if (ocContractDomain == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.createBenefitOrder.ocContractDomain is null");
            return "fail";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocContractDomain.getMemberBcode(), tenantCode);
        if (userinfoByCode == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.createCouponOrder.userinfoByCode is null");
            return "fail";
        }
        Map customer = this.dataOutMessageService.getCustomer(tenantCode, userinfoByCode.getUserinfoOcode());
        if (MapUtil.isEmpty((Map)customer) || !customer.containsKey("CustomerID")) {
            this.logger.error("DataInChuanHangCardRollServiceImplcustomer error", (Object)JSON.toJSONString((Object)customer));
            return "fail";
        }
        if (ListUtil.isEmpty((Collection)ocContractDomain.getGoodsList())) {
            this.logger.error("DataInChuanHangCardRollServiceImplcreateBenefitOrder.getGoodsList is null");
            return "fail";
        }
        ProductVo productVo = null;
        try {
            productVo = this.getProductofr(ocContractDomain, userinfoByCode);
            if (productVo == null) {
                this.logger.error("DataInChuanHangCardRollServiceImplproductVo is null");
                return "fail";
            }
        }
        catch (Exception e) {
            this.logger.error("DataInChuanHangCardRollServiceImplgetProductofr.e", (Object)e.getMessage());
            return "fail";
        }
        CouponOrderInfoRQ couponOrderInfoRQ = this.makeCouponOrderInfoRQ(ocContractDomain, customer, productVo);
        try {
            this.logger.error("DataInChuanHangCardRollServiceImpl.createBenefitOrder.couponOrderInfoRQ", (Object)JSON.toJSONString((Object)couponOrderInfoRQ));
            String doPostJSON = HttpUtils.doPostJSON(RequestConfiguration.CREATEBENEFITORDER, JSON.toJSONString((Object)couponOrderInfoRQ), tenantCode);
            ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)doPostJSON, ResponseVo.class);
            if (responseVo != null && responseVo.getCode() == 200 && "\u64cd\u4f5c\u6210\u529f".equals(responseVo.getMessage())) {
                ocContractDomain.setContractNbillcode(responseVo.getData().toString());
                ocContractDomain.setContractNbbillcode(responseVo.getData().toString());
                this.updateContract(ocContractDomain);
                String makePayParam = this.makePayParam(ocContractDomain, userinfoByCode);
                if (StringUtils.isBlank((String)makePayParam)) {
                    return "fail";
                }
                doPostJSON = HttpUtils.doPostJSON(RequestConfiguration.PAYURL, makePayParam, tenantCode);
                if (StringUtils.isBlank((String)doPostJSON)) {
                    return "fail";
                }
                responseVo = (ResponseVo)JSON.parseObject((String)doPostJSON, ResponseVo.class);
                if (responseVo.getCode() == 200 && "\u64cd\u4f5c\u6210\u529f".equals(responseVo.getMessage())) {
                    return "success";
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "fail";
    }

    private String makePayParam(OcContractDomain ocContractDomain, UmUserinfoReDomain userinfoByCode) {
        RefundDataVo refundDataVo = this.getByOrderNo(ocContractDomain, userinfoByCode);
        if (refundDataVo != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String payTime = formatter.format(new Date());
            this.logger.error("DataInChuanHangCardRollServiceImpl.makePayParam", (Object)(ocContractDomain.getContractNbbillcode() + "-" + payTime + "-" + RequestConfiguration.CH_PRIVATEKEY));
            String id = this.getOrderChID(refundDataVo);
            if (StringUtils.isBlank((String)id)) {
                this.logger.error("DataInChuanHangCardRollServiceImpl.makePayParam.refundDataVo", (Object)JsonUtil.buildNormalBinder().toJson((Object)refundDataVo));
                return null;
            }
            return JSON.toJSONString((Object)new PayOrderVo(id, ocContractDomain.getContractNbbillcode(), this.getSnowflakeId(), this.getSnowflakeId(), new BigDecimal("0"), formatter.format(new Date()), payTime, "3", RequestConfiguration.CH_CHANNELCODE, "\u798f\u5229\u5b98\u6a21\u62df\u652f\u4ed8", RequestConfiguration.CH_CHANNELCODE, "JXMFLG", this.getSnowflakeId(), "\u5361\u5377\u652f\u4ed8", "\u5361\u5377\u652f\u4ed8", new SimpleHash("MD5", (Object)(ocContractDomain.getContractNbbillcode() + payTime + RequestConfiguration.CH_PRIVATEKEY)).toString()));
        }
        return null;
    }

    private String getOrderChID(RefundDataVo refundDataVo) {
        String id = null;
        switch (refundDataVo.getMyOrderSubListDtos().get(0).getProductType()) {
            case "COUPON": {
                id = refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCoupons().get(0).getId();
                break;
            }
            case "BENEFIT": {
                id = refundDataVo.getMyOrderSubListDtos().get(0).getBenefitsCoupons().get(0).getId();
                break;
            }
            case "COUPON_UPGRADE": {
                id = refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCouponUpgrades().get(0).getId();
                break;
            }
            case "COUPON_REFUND": {
                id = refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCouponRefunds().get(0).getId();
                break;
            }
            case "COUPON_DEDUCT": {
                id = refundDataVo.getMyOrderSubListDtos().get(0).getOdrOrderDetailCouponDeductDtos().get(0).getId();
            }
        }
        return id;
    }

    public synchronized String getSnowflakeId() {
        return String.valueOf(IdUtil.getSnowflake((long)1L, (long)1L).nextId());
    }

    private CouponOrderInfoRQ makeCouponOrderInfoRQ(OcContractDomain ocContractDomain, Map<String, Object> customer, ProductVo productVo) {
        BigDecimal productPrice;
        OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)ocContractDomain.getGoodsList().get(0);
        CouponOrderInfoRQ couponOrderInfoRQ = new CouponOrderInfoRQ();
        couponOrderInfoRQ.setActiveCode(ocContractGoodsDomain.getGoodsNo());
        couponOrderInfoRQ.setPhone(ocContractDomain.getGoodsReceiptPhone());
        couponOrderInfoRQ.setCustomerId(customer.get("CustomerID").toString());
        BigDecimal orderPrice = new BigDecimal("0");
        if (StringUtils.isNotBlank((String)productVo.getProductPrice()) && (productPrice = new BigDecimal(productVo.getProductPrice())).compareTo(BigDecimal.ZERO) > 0) {
            orderPrice = orderPrice.add(productPrice);
        }
        if (ListUtil.isNotEmpty(productVo.getRightsSpecPricingList()) && productVo.getRightsSpecPricingList().size() != 0) {
            RightsSpecPricing specPricing = productVo.getRightsSpecPricingList().get(0);
            orderPrice = specPricing.getSpecPrice();
            couponOrderInfoRQ.setBenefitOrderChildrenDtos(Arrays.asList(new BenefitOrderChildren(ocContractGoodsDomain.getSkuNo(), 1, specPricing.getSpecPrice(), orderPrice, productVo.getProductType(), specPricing.getSpecName(), specPricing.getSpecNo())));
        } else {
            couponOrderInfoRQ.setBenefitOrderChildrenDtos(Arrays.asList(new BenefitOrderChildren(ocContractGoodsDomain.getSkuNo(), 1, orderPrice, orderPrice, productVo.getProductType())));
        }
        couponOrderInfoRQ.setOrderPrice(orderPrice);
        couponOrderInfoRQ.setChannel(RequestConfiguration.CH_CHANNELCODE);
        couponOrderInfoRQ.setIsPackage(productVo.getIfPackage());
        couponOrderInfoRQ.setProductCode(ocContractGoodsDomain.getSkuNo());
        couponOrderInfoRQ.setProductUnitPrice(orderPrice);
        couponOrderInfoRQ.setCount(1);
        return couponOrderInfoRQ;
    }

    private ProductVo getProductofr(OcContractDomain ocContractDomain, UmUserinfoReDomain userinfoByCode) throws Exception {
        OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)ocContractDomain.getGoodsList().get(0);
        HashMap<String, String> rsRsParam = new HashMap<String, String>();
        rsRsParam.put("benefitActivityCode", ocContractGoodsDomain.getGoodsNo());
        rsRsParam.put("productCode", ocContractGoodsDomain.getSkuNo());
        rsRsParam.put("channel", RequestConfiguration.CH_CHANNELCODE);
        rsRsParam.put("userId", userinfoByCode.getUserinfoCompname());
        String doPostJSON = HttpUtils.doPostJSON(RequestConfiguration.PRODUCTOFR, JSON.toJSONString(rsRsParam), null);
        ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)doPostJSON, ResponseVo.class);
        if (responseVo != null && responseVo.getCode() == 200) {
            return (ProductVo)JSON.parseObject((String)responseVo.getData(), ProductVo.class);
        }
        return null;
    }

    public String returnOrder(OcRefundDomain ocRefundDomain) {
        if (ocRefundDomain == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.returnOrder.ocRefundDomain is null");
            return "fail";
        }
        if (!"41".equals(ocRefundDomain.getContractType())) {
            return "success";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocRefundDomain.getMemberBcode(), tenantCode);
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractBillcode,tenantCode,fuzzy", new Object[]{ocRefundDomain.getContractBillcode(), tenantCode, false}));
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList()) || queryResult.getList().size() == 0) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.queryResult is null");
            return "fail";
        }
        String requestParamMsg = this.makeRefundParam((OcContractReDomain)queryResult.getList().get(0), ocRefundDomain, userinfoByCode);
        if (StringUtils.isBlank((String)requestParamMsg)) {
            throw new ApiException("requestParam is null");
        }
        try {
            String doPostJSON = HttpUtils.doPostJSON(RequestConfiguration.RETURNCARD, requestParamMsg, null);
            ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)doPostJSON, ResponseVo.class);
            if (responseVo != null && responseVo.getCode() == 200) {
                this.taskService.cancelOrder((OcContractReDomain)queryResult.getList().get(0));
                return "success";
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "fail";
    }

    private String updateContract(OcContractDomain ocContractDomain) {
        String apiCode = "oc.contract.updateContract";
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    private QueryResult<OcContractReDomain> queryOrderPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.queryOrderPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractPageReDomain";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
    }

    public RefundDataVo getByOrderNo(OcContractDomain ocContractDomain, UmUserinfoReDomain userinfoByCode) {
        HashMap<String, String> rsParam = new HashMap<String, String>();
        rsParam.put("customerId", userinfoByCode.getUserinfoOcode());
        rsParam.put("orderNo", ocContractDomain.getContractNbbillcode());
        try {
            RefundDataVo refundDataVo;
            String message;
            String resultMsg = HttpUtils.doGetWithQuery(RequestConfiguration.BYORDERNO, rsParam, null);
            ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)resultMsg, ResponseVo.class);
            if (responseVo.getCode() == 200 && StringUtils.isNotBlank((String)(message = responseVo.getData())) && (refundDataVo = (RefundDataVo)JSON.parseObject((String)message, RefundDataVo.class)) != null) {
                return refundDataVo;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private String makeRefundParam(OcContractReDomain ocContractReDomain, OcRefundDomain ocRefundDomain, UmUserinfoReDomain userinfoByCode) {
        HashMap<String, String> rsParam = new HashMap<String, String>();
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        rsParam.put("customerId", userinfoByCode.getUserinfoOcode());
        rsParam.put("orderNo", ocContractReDomain.getContractNbbillcode());
        try {
            RefundDataVo refundDataVo;
            String message;
            String resultMsg = HttpUtils.doGetWithQuery(RequestConfiguration.BYORDERNO, rsParam, null);
            ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)resultMsg, ResponseVo.class);
            if (responseVo.getCode() == 200 && StringUtils.isNotBlank((String)(message = responseVo.getData())) && (refundDataVo = (RefundDataVo)JSON.parseObject((String)message, RefundDataVo.class)) != null) {
                OrderDetailCoupons orderDetailCoupons = null;
                switch (refundDataVo.getMyOrderSubListDtos().get(0).getProductType()) {
                    case "COUPON": {
                        orderDetailCoupons = refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCoupons().get(0);
                        break;
                    }
                    case "BENEFIT": {
                        orderDetailCoupons = refundDataVo.getMyOrderSubListDtos().get(0).getBenefitsCoupons().get(0);
                        break;
                    }
                    case "COUPON_UPGRADE": {
                        orderDetailCoupons = refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCouponUpgrades().get(0);
                        break;
                    }
                    case "COUPON_REFUND": {
                        orderDetailCoupons = refundDataVo.getMyOrderSubListDtos().get(0).getOrderDetailCouponRefunds().get(0);
                        break;
                    }
                    case "COUPON_DEDUCT": {
                        orderDetailCoupons = refundDataVo.getMyOrderSubListDtos().get(0).getOdrOrderDetailCouponDeductDtos().get(0);
                    }
                }
                if (orderDetailCoupons == null) {
                    this.logger.error("DataInChuanHangCardRollServiceImpl.makePayParam.orderDetailCoupons is null", (Object)JSON.toJSONString((Object)refundDataVo));
                    return null;
                }
                requestParam.put("customerId", refundDataVo.getCustomerId());
                requestParam.put("detailOrderId", orderDetailCoupons.getOrderDetailId());
                requestParam.put("mainOrderId", refundDataVo.getMyOrderSubListDtos().get(0).getMainOrderId());
                requestParam.put("mainOrderNo", orderDetailCoupons.getMainOrderNo());
                requestParam.put("orderNo", orderDetailCoupons.getOrderNo());
                requestParam.put("orderSource", refundDataVo.getOrderSource());
                requestParam.put("productType", refundDataVo.getMyOrderSubListDtos().get(0).getProductType());
                requestParam.put("refundRemark", refundDataVo.getMyOrderSubListDtos().get(0).getProductType() + "\u9000\u6b3e");
                requestParam.put("returnPrice", refundDataVo.getOrderPrice());
                return JSON.toJSONString(requestParam);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public String returnCheck(OcRefundDomain ocRefundDomain) {
        if (ocRefundDomain == null) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.returnOrder.ocRefundDomain is null");
            return "fail";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocRefundDomain.getMemberBcode(), tenantCode);
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractBillcode,tenantCode,fuzzy", new Object[]{ocRefundDomain.getContractBillcode(), tenantCode, false}));
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("DataInChuanHangCardRollServiceImpl.queryResult is null");
            return "fail";
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
        try {
            String doPostJSON = HttpUtils.doGetWithQuery(RequestConfiguration.RETURNCHECK + userinfoByCode.getUserinfoOcode(), null, null);
            ResponseVo responseVo = (ResponseVo)JSON.parseObject((String)doPostJSON, ResponseVo.class);
            MyCardVo thisMyCardVo = null;
            Boolean checkCardFlag = false;
            if (responseVo != null && responseVo.getCode() == 200) {
                List myCardVos = JSON.parseArray((String)responseVo.getData(), MyCardVo.class);
                if (ListUtil.isEmpty((Collection)myCardVos)) {
                    this.logger.error("DataInChuanHangCardRollServiceImpl.returnCheck.myCardVos is null");
                    return "fail";
                }
                for (MyCardVo myCardVo : myCardVos) {
                    if (!ocContractReDomain.getContractNbbillcode().equals(myCardVo.getSaleOrderNo())) continue;
                    thisMyCardVo = myCardVo;
                    break;
                }
                if (thisMyCardVo == null || ListUtil.isEmpty(thisMyCardVo.getProductList())) {
                    this.logger.error("DataInChuanHangCardRollServiceImpl.returnCheck.thisMyCardVo is null");
                    return "fail";
                }
                for (productItemVo productItemVo2 : thisMyCardVo.getProductList()) {
                    if ("4".equals(productItemVo2.getRightsStatus())) continue;
                    checkCardFlag = true;
                    break;
                }
                if (checkCardFlag.booleanValue()) {
                    this.logger.error("DataInChuanHangCardRollServiceImpl.returnCheck.productItemVo.checkCardFlag", (Object)checkCardFlag);
                    return "fail";
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "success";
    }

    public OrderCustomerInfo makeOrderCustomerInfo(Map<String, Object> customer) {
        if (MapUtil.isNotEmpty(customer)) {
            String MobileNumber = customer.get("MobileNumber") == null ? "" : customer.get("MobileNumber").toString();
            String CustomerID = customer.get("CustomerID") == null ? "" : customer.get("CustomerID").toString();
            String CustomerName = customer.get("CustomerName") == null ? "" : customer.get("CustomerName").toString();
            String Email = customer.get("Email") == null ? "" : customer.get("Email").toString();
            return new OrderCustomerInfo(MobileNumber, CustomerName, CustomerID, null, null);
        }
        return null;
    }

    private UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    public static void main(String[] args) {
        String msg = "{\"validDesc\":\"\u65e0\u539f\u5219\u5347\u8231\u5238\",\"resDesc\":\"<span>\u65e0\u539f\u5219\u5347\u8231\u5238</span>\",\"endDate\":\"2029-12-31 00:00:00\",\"source\":\"0\",\"userCanBuy\":\"1\",\"ifPackage\":0,\"rightsProductStatus\":\"1\",\"productDesc\":\"<p>\u65e0\u539f\u5219\u5347\u8231\u5238</p>\",\"prdExtendInfo\":{\"auto_return_flag\":\"1\",\"activityCode\":\"ACT250430C9042\",\"validDesc\":\"\u65e0\u539f\u5219\u5347\u8231\u5238\",\"couponResView\":\"X20250430002\",\"subTitle\":\"\u65e0\u539f\u5219\u5347\u8231\u5238\",\"salePrice\":\"18\",\"ifNoPayActived\":\"0\",\"productShowName\":\"\u65e0\u539f\u5219\u5347\u8231\u5238\",\"listShortDesc\":\"\u65e0\u539f\u5219\u5347\u8231\u5238\"},\"rightsSpecPricingList\":[{\"specName\":\"123\",\"specNo\":\"SPEC_IMG_000077\",\"simpleImageUrl\":\"http://47.108.178.2/s/spec/02676bad-e7a7-46a9-b0f4-cd286df027eb.jpg\",\"specPrice\":100,\"productNo\":\"P20250430010\"}],\"productCode\":\"P20250430010\",\"rightShowName\":\"\u65e0\u539f\u5219\u5347\u8231\u5238\",\"ifNeedPay\":\"1\",\"rightsTitle\":\"\u65e0\u539f\u5219\u5347\u8231\u5238\",\"productPicList\":[{\"picURL\":[\"http://47.108.178.2/s/resourceImg/43f39512-9261-4d26-ad7c-dfe75c0c0be3.jpg\"],\"picType\":\"resPic\"},{\"picURL\":[\"http://47.108.178.2/s/topImg/1079f4b2-8889-408c-8a19-399c7529b6c7.jpg\"],\"picType\":\"prdTopPic\"},{\"picURL\":[\"http://47.108.178.2/s/productImg/c2813ed8-88d4-4438-b168-ae1053de3158.jpg\"],\"picType\":\"prdPic\"}],\"productPrice\":\"18\",\"productType\":\"couponUpgrade\"}";
        ProductVo productVo = (ProductVo)JSON.parseObject((String)msg, (TypeReference)new TypeReference<ProductVo>(){}, (Feature[])new Feature[0]);
        System.out.println(JSON.toJSONString((Object)productVo));
    }
}

