/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.dao.CrpRechargeMapper;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeReDomain;
import com.yqbsoft.laser.service.crp.model.CrpRecharge;
import com.yqbsoft.laser.service.crp.service.CrpRechargeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrpRechargeServiceImpl
extends BaseServiceImpl
implements CrpRechargeService {
    private static final String SYS_CODE = "service.adapter.crp.CrpRechargeServiceImpl";
    private CrpRechargeMapper crpRechargeMapper;

    public void setCrpRechargeMapper(CrpRechargeMapper crpRechargeMapper) {
        this.crpRechargeMapper = crpRechargeMapper;
    }

    private Date getSysDate() {
        try {
            return this.crpRechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCrp(CrpRechargeDomain crpRechargeDomain) {
        if (null == crpRechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crpRechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCrpDefault(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return;
        }
        if (null == crpRecharge.getDataState()) {
            crpRecharge.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crpRecharge.getGmtCreate()) {
            crpRecharge.setGmtCreate(date);
        }
        crpRecharge.setGmtModified(date);
        if (StringUtils.isBlank((String)crpRecharge.getRechargeCode())) {
            crpRecharge.setRechargeCode(this.getNo(null, "CrpRecharge", "crpRecharge", crpRecharge.getTenantCode()));
        }
    }

    private int getCrpMaxCode() {
        int code = 0;
        try {
            return this.crpRechargeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getCrpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCrpUpdataDefault(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return;
        }
        crpRecharge.setGmtModified(this.getSysDate());
    }

    private void saveCrpModel(CrpRecharge crpRecharge) throws ApiException {
        if (null == crpRecharge) {
            return;
        }
        try {
            this.crpRechargeMapper.insert(crpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.saveCrpModel.ex", (Throwable)e);
        }
    }

    private void saveCrpBatchModel(List<CrpRecharge> crpRechargeList) throws ApiException {
        if (null == crpRechargeList || crpRechargeList.isEmpty()) {
            return;
        }
        try {
            this.crpRechargeMapper.insertBatch(crpRechargeList);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.saveCrpBatchModel.ex", (Throwable)e);
        }
    }

    private CrpRecharge getCrpModelById(Integer rechargeId) {
        if (null == rechargeId) {
            return null;
        }
        try {
            return this.crpRechargeMapper.selectByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpRecharge getCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crpRechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.getCrpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.delCrpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.delCrpModelByCode.num");
        }
    }

    private void deleteCrpModel(Integer rechargeId) throws ApiException {
        if (null == rechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.deleteByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.deleteCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.deleteCrpModel.num");
        }
    }

    private void updateCrpModel(CrpRecharge crpRecharge) throws ApiException {
        if (null == crpRecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateByPrimaryKey(crpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrpModel.num");
        }
    }

    private void updateStateCrpModel(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeId", rechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModel.null");
        }
    }

    private void updateStateCrpModelByCode(String tenantCode, String rechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.null");
        }
    }

    private CrpRecharge makeCrp(CrpRechargeDomain crpRechargeDomain, CrpRecharge crpRecharge) {
        if (null == crpRechargeDomain) {
            return null;
        }
        if (null == crpRecharge) {
            crpRecharge = new CrpRecharge();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crpRecharge, (Object)crpRechargeDomain);
            return crpRecharge;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.makeCrp", (Throwable)e);
            return null;
        }
    }

    private CrpRechargeReDomain makeCrpRechargeReDomain(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return null;
        }
        CrpRechargeReDomain crpRechargeReDomain = new CrpRechargeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpRechargeReDomain, (Object)crpRecharge);
            return crpRechargeReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.makeCrpRechargeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrpRecharge> queryCrpModelPage(Map<String, Object> parammap) {
        try {
            return this.crpRechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private int countCrp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpRechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpRechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private CrpRecharge createCrpRecharge(CrpRechargeDomain crpRechargeDomain) {
        String msg = this.checkCrp(crpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.saveCrp.checkCrp", msg);
        }
        CrpRecharge crpRecharge = this.makeCrp(crpRechargeDomain, null);
        this.setCrpDefault(crpRecharge);
        return crpRecharge;
    }

    @Override
    public String saveCrp(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        CrpRecharge crpRecharge = this.createCrpRecharge(crpRechargeDomain);
        this.saveCrpModel(crpRecharge);
        return crpRecharge.getRechargeCode();
    }

    @Override
    public String saveCrpBatch(List<CrpRechargeDomain> crpRechargeDomainList) throws ApiException {
        if (null == crpRechargeDomainList || crpRechargeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrpRecharge> crpRechargeList = new ArrayList<CrpRecharge>();
        String code = "";
        for (CrpRechargeDomain crpRechargeDomain : crpRechargeDomainList) {
            CrpRecharge crpRecharge = this.createCrpRecharge(crpRechargeDomain);
            code = crpRecharge.getRechargeCode();
            crpRechargeList.add(crpRecharge);
        }
        this.saveCrpBatchModel(crpRechargeList);
        return code;
    }

    @Override
    public void updateCrpState(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == rechargeId) {
            return;
        }
        this.updateStateCrpModel(rechargeId, dataState, oldDataState, map);
    }

    @Override
    public void updateCrpStateByCode(String tenantCode, String rechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCrpModelByCode(tenantCode, rechargeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCrp(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        String msg = this.checkCrp(crpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpRecharge oldCrpRecharge = this.getCrpModelById(crpRechargeDomain.getRechargeId());
        if (null == oldCrpRecharge) {
            throw new ApiException("service.adapter.crp.CrpRechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrpRecharge crpRecharge = this.makeCrp(crpRechargeDomain, oldCrpRecharge);
        this.setCrpUpdataDefault(crpRecharge);
        this.updateCrpModel(crpRecharge);
    }

    @Override
    public CrpRecharge getCrp(Integer rechargeId) {
        if (null == rechargeId) {
            return null;
        }
        return this.getCrpModelById(rechargeId);
    }

    @Override
    public void deleteCrp(Integer rechargeId) throws ApiException {
        if (null == rechargeId) {
            return;
        }
        this.deleteCrpModel(rechargeId);
    }

    @Override
    public QueryResult<CrpRecharge> queryCrpPage(Map<String, Object> map) {
        List<CrpRecharge> crpRechargeList = this.queryCrpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpRechargeList);
        return queryResult;
    }

    @Override
    public CrpRecharge getCrpByCode(String tenantCode, String rechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        return this.getCrpModelByCode(map);
    }

    @Override
    public void deleteCrpByCode(String tenantCode, String rechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        this.delCrpModelByCode(map);
    }
}

