/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.dao.CrpUrechargeMapper;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeReDomain;
import com.yqbsoft.laser.service.crp.model.CrpUrecharge;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrpUrechargeServiceImpl
extends BaseServiceImpl
implements CrpUrechargeService {
    private static final String SYS_CODE = "service.adapter.crp.CrpUrechargeServiceImpl";
    private CrpUrechargeMapper crpUrechargeMapper;

    public void setCrpUrechargeMapper(CrpUrechargeMapper crpUrechargeMapper) {
        this.crpUrechargeMapper = crpUrechargeMapper;
    }

    private Date getSysDate() {
        try {
            return this.crpUrechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCrp(CrpUrechargeDomain crpUrechargeDomain) {
        if (null == crpUrechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crpUrechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCrpDefault(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return;
        }
        if (null == crpUrecharge.getDataState()) {
            crpUrecharge.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crpUrecharge.getGmtCreate()) {
            crpUrecharge.setGmtCreate(date);
        }
        crpUrecharge.setGmtModified(date);
        if (StringUtils.isBlank((String)crpUrecharge.getUrechargeCode())) {
            crpUrecharge.setUrechargeCode(this.getNo(null, "CrpUrecharge", "crpUrecharge", crpUrecharge.getTenantCode()));
        }
    }

    private int getCrpMaxCode() {
        int code = 0;
        try {
            return this.crpUrechargeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCrpUpdataDefault(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return;
        }
        crpUrecharge.setGmtModified(this.getSysDate());
    }

    private void saveCrpModel(CrpUrecharge crpUrecharge) throws ApiException {
        if (null == crpUrecharge) {
            return;
        }
        try {
            this.crpUrechargeMapper.insert(crpUrecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.saveCrpModel.ex", (Throwable)e);
        }
    }

    private void saveCrpBatchModel(List<CrpUrecharge> crpUrechargeList) throws ApiException {
        if (null == crpUrechargeList || crpUrechargeList.isEmpty()) {
            return;
        }
        try {
            this.crpUrechargeMapper.insertBatch(crpUrechargeList);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.saveCrpBatchModel.ex", (Throwable)e);
        }
    }

    private CrpUrecharge getCrpModelById(Integer urechargeId) {
        if (null == urechargeId) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.selectByPrimaryKey(urechargeId);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrecharge getCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.delCrpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.delCrpModelByCode.num");
        }
    }

    private void deleteCrpModel(Integer urechargeId) throws ApiException {
        if (null == urechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.deleteByPrimaryKey(urechargeId);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.deleteCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.deleteCrpModel.num");
        }
    }

    private void updateCrpModel(CrpUrecharge crpUrecharge) throws ApiException {
        if (null == crpUrecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateByPrimaryKey(crpUrecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpModel.num");
        }
    }

    private void updateStateCrpModel(Integer urechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == urechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("urechargeId", urechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModel.null");
        }
    }

    private void updateStateCrpModelByCode(String tenantCode, String urechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)urechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.null");
        }
    }

    private CrpUrecharge makeCrp(CrpUrechargeDomain crpUrechargeDomain, CrpUrecharge crpUrecharge) {
        if (null == crpUrechargeDomain) {
            return null;
        }
        if (null == crpUrecharge) {
            crpUrecharge = new CrpUrecharge();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crpUrecharge, (Object)crpUrechargeDomain);
            return crpUrecharge;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.makeCrp", (Throwable)e);
            return null;
        }
    }

    private CrpUrechargeReDomain makeCrpUrechargeReDomain(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return null;
        }
        CrpUrechargeReDomain crpUrechargeReDomain = new CrpUrechargeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargeReDomain, (Object)crpUrecharge);
            return crpUrechargeReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.makeCrpUrechargeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrpUrecharge> queryCrpModelPage(Map<String, Object> parammap) {
        try {
            return this.crpUrechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private int countCrp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpUrechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private CrpUrecharge createCrpUrecharge(CrpUrechargeDomain crpUrechargeDomain) {
        String msg = this.checkCrp(crpUrechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.saveCrp.checkCrp", msg);
        }
        CrpUrecharge crpUrecharge = this.makeCrp(crpUrechargeDomain, null);
        this.setCrpDefault(crpUrecharge);
        return crpUrecharge;
    }

    @Override
    public String saveCrp(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        CrpUrecharge crpUrecharge = this.createCrpUrecharge(crpUrechargeDomain);
        this.saveCrpModel(crpUrecharge);
        return crpUrecharge.getUrechargeCode();
    }

    @Override
    public String saveCrpBatch(List<CrpUrechargeDomain> crpUrechargeDomainList) throws ApiException {
        if (null == crpUrechargeDomainList || crpUrechargeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrpUrecharge> crpUrechargeList = new ArrayList<CrpUrecharge>();
        String code = "";
        for (CrpUrechargeDomain crpUrechargeDomain : crpUrechargeDomainList) {
            CrpUrecharge crpUrecharge = this.createCrpUrecharge(crpUrechargeDomain);
            code = crpUrecharge.getUrechargeCode();
            crpUrechargeList.add(crpUrecharge);
        }
        this.saveCrpBatchModel(crpUrechargeList);
        return code;
    }

    @Override
    public void updateCrpState(Integer urechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == urechargeId) {
            return;
        }
        this.updateStateCrpModel(urechargeId, dataState, oldDataState, map);
    }

    @Override
    public void updateCrpStateByCode(String tenantCode, String urechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)urechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCrpModelByCode(tenantCode, urechargeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCrp(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        String msg = this.checkCrp(crpUrechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpUrecharge oldCrpUrecharge = this.getCrpModelById(crpUrechargeDomain.getUrechargeId());
        if (null == oldCrpUrecharge) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrpUrecharge crpUrecharge = this.makeCrp(crpUrechargeDomain, oldCrpUrecharge);
        this.setCrpUpdataDefault(crpUrecharge);
        this.updateCrpModel(crpUrecharge);
    }

    @Override
    public CrpUrecharge getCrp(Integer urechargeId) {
        if (null == urechargeId) {
            return null;
        }
        return this.getCrpModelById(urechargeId);
    }

    @Override
    public void deleteCrp(Integer urechargeId) throws ApiException {
        if (null == urechargeId) {
            return;
        }
        this.deleteCrpModel(urechargeId);
    }

    @Override
    public QueryResult<CrpUrecharge> queryCrpPage(Map<String, Object> map) {
        List<CrpUrecharge> crpUrechargeList = this.queryCrpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpUrechargeList);
        return queryResult;
    }

    @Override
    public CrpUrecharge getCrpByCode(String tenantCode, String urechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)urechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        return this.getCrpModelByCode(map);
    }

    @Override
    public void deleteCrpByCode(String tenantCode, String urechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)urechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        this.delCrpModelByCode(map);
    }
}

