/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfShopMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.adapter.fuji.model.InfShop;
import com.yqbsoft.laser.service.adapter.fuji.model.UmUser;
import com.yqbsoft.laser.service.adapter.fuji.service.InfShopService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfShopServiceImpl
extends BaseServiceImpl
implements InfShopService {
    private static final String SYS_CODE = "service.adapter.fuji.InfShopServiceImpl";
    private InfShopMapper infShopMapper;
    private String fujiShopKey = "fujiShop";

    public void setInfShopMapper(InfShopMapper infShopMapper) {
        this.infShopMapper = infShopMapper;
    }

    private InfShop getShopModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.infShopMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfShopServiceImpl.getShopModelByCode", (Throwable)e);
            return null;
        }
    }

    private List<InfShop> queryShopModelPage(Map<String, Object> parammap) {
        try {
            return this.infShopMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfShopServiceImpl.queryShopModel", (Throwable)e);
            return null;
        }
    }

    private int countShop(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infShopMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfShopServiceImpl.countShop", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<InfShop> queryShopPage(Map<String, Object> map) {
        List<InfShop> infShopList = this.queryShopModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countShop(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infShopList);
        return queryResult;
    }

    @Override
    public InfShop getShopByCode(String shopid) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shopid", shopid);
        return this.getShopModelByCode(map);
    }

    @Override
    public List<InfShop> queryShopByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo * pageSize);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfShop> infShopQueryResult = this.queryShopPage(map);
        List infShopList = infShopQueryResult.getList();
        return infShopList;
    }

    @Override
    public void inertShopByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfShopServiceImpl.inertShopByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            DisUtil.del((String)this.fujiShopKey);
            pageNo = "0";
            pageSize = "50";
            tenantCode = "00000001";
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiShopKey);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfShopServiceImpl.inertShopByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> shopMap = new HashMap<String, String>();
        ArrayList<String> errShopIdList = new ArrayList<String>();
        while (true) {
            List<InfShop> infShopsList;
            if (ListUtil.isEmpty(infShopsList = this.queryShopByPage(pn, ps, lasttime))) {
                DisUtil.set((String)this.fujiShopKey, (String)sdf.format(new Date()));
                this.logger.error("service.adapter.fuji.InfShopServiceImpl.inertShopByPage.errShopID.end", (Object)("\u6dfb\u52a0\u5931\u8d25\u7684\uff01\uff01\uff01\u5931\u8d25\u6761\u6570\uff1a" + errShopIdList.size() + ",errShopIdList:" + errShopIdList + "\uff0c\u5f53\u524d\u65f6\u95f4" + DisUtil.get((String)this.fujiShopKey)));
                return;
            }
            for (InfShop infShop : infShopsList) {
                String userinfocode;
                map.clear();
                shopMap.clear();
                shopMap.put("userOcode", infShop.getShopid());
                shopMap.put("tenantCode", tenantCode);
                map.put("map", JsonUtil.buildNonDefaultBinder().toJson(shopMap));
                String umUserStr = null;
                try {
                    umUserStr = (String)this.getInternalRouter().inInvoke("um.user.queryUserPage", map);
                }
                catch (Exception e) {
                    DisUtil.set((String)this.fujiShopKey, (String)sdf.format(infShop.getLasttime()));
                    this.logger.error("service.adapter.fuji.InfShopServiceImpl.inertShopByPage.queryUserPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01map:" + map + ",\u5f53\u524d\u65f6\u95f4\u4e3a\uff1a" + DisUtil.get((String)this.fujiShopKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(umUserStr, SupQueryResult.class);
                List umUserStrList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), UmUser.class);
                if (ListUtil.isNotEmpty((Collection)umUserStrList) || !StringUtils.isBlank((String)(userinfocode = this.saveUmuser(tenantCode, infShop)))) continue;
                errShopIdList.add(infShop.getShopid());
                this.logger.error("service.adapter.fuji.InfShopServiceImpl.inertShopByPage.saveUmuser", (Object)("\u95e8\u5e97\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01infShopID:" + infShop.getShopid() + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
            }
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }

    public String saveUmuser(String tenantCode, InfShop infShop) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserName(infShop.getShopid());
        umUserDomainBean.setUserRelname(infShop.getShopname());
        umUserDomainBean.setUserPhone(infShop.getShopid());
        umUserDomainBean.setUserType(0);
        umUserDomainBean.setUserinfoPhone(infShop.getTelephone());
        String parent = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("fujishop").concat("-").concat("parentCode"));
        String[] split = parent.split("-");
        umUserDomainBean.setUserinfoParentCode(split[0]);
        umUserDomainBean.setUserinfoParentName(split[1]);
        umUserDomainBean.setCompanyAddress(infShop.getDeliveryaddress());
        umUserDomainBean.setUserinfoOcode(infShop.getShopid());
        if (null == umUserDomainBean.getUserinfoType()) {
            umUserDomainBean.setUserinfoType(1);
        }
        umUserDomainBean.setUserinfoCompname(infShop.getShopname());
        umUserDomainBean.setUserinfoQuality("store,supplier");
        HashMap<String, String> umUserParamMap = new HashMap<String, String>();
        umUserParamMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
        String userinfoCode = null;
        try {
            userinfoCode = (String)this.getInternalRouter().inInvoke("um.user.sendOpenUserinfo", umUserParamMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfShopServiceImpl.inertShopByPage.saveUmuser.e", (Object)("\u65b0\u589e\u5f02\u5e38\uff01\uff01\uff01umUserParamMap:" + umUserParamMap));
        }
        return userinfoCode;
    }
}

