/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfdbShopstockMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.WhStoreGoodsDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.WhStoreSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.WhStoreSkuNumBean;
import com.yqbsoft.laser.service.adapter.fuji.model.DisChannel;
import com.yqbsoft.laser.service.adapter.fuji.model.InfdbShopstock;
import com.yqbsoft.laser.service.adapter.fuji.model.RsResourceGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSku;
import com.yqbsoft.laser.service.adapter.fuji.model.UmUserinfo;
import com.yqbsoft.laser.service.adapter.fuji.model.WhStoreSku;
import com.yqbsoft.laser.service.adapter.fuji.service.InfdbShopstockService;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpRequest;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfdbShopstockServiceImpl
extends BaseServiceImpl
implements InfdbShopstockService {
    private static final String SYS_CODE = "service.adapter.fuji.InfdbShopstockServiceImpl";
    private InfdbShopstockMapper infdbShopstockMapper;
    private String fujiShopstockKey = "fujiShopstock";

    public void setInfdbShopstockMapper(InfdbShopstockMapper infdbShopstockMapper) {
        this.infdbShopstockMapper = infdbShopstockMapper;
    }

    private InfdbShopstock getInfdbShopstockModelById(Map<String, Object> map) {
        try {
            return this.infdbShopstockMapper.selectByPrimaryKey(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.getInfdbShopstockModelById", (Throwable)e);
            return null;
        }
    }

    private List<InfdbShopstock> queryInfdbShopstockModelPage(Map<String, Object> parammap) {
        try {
            return this.infdbShopstockMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.queryInfdbShopstockModel", (Throwable)e);
            return null;
        }
    }

    private int countInfdbShopstock(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infdbShopstockMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.countInfdbShopstock", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfdbShopstock getInfdbShopstock(String shopid, String goodsid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shopid", shopid);
        map.put("goodsid", goodsid);
        return this.getInfdbShopstockModelById(map);
    }

    @Override
    public QueryResult<InfdbShopstock> queryInfdbShopstockPage(Map<String, Object> map) {
        List<InfdbShopstock> infdbShopstockList = this.queryInfdbShopstockModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInfdbShopstock(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infdbShopstockList);
        return queryResult;
    }

    @Override
    public List<InfdbShopstock> queryShopstockByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo * pageSize);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfdbShopstock> goodsshopQueryResult = this.queryInfdbShopstockPage(map);
        List goodsshopList = goodsshopQueryResult.getList();
        return goodsshopList;
    }

    @Override
    public void inertShopstockByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            DisUtil.del((String)this.fujiShopstockKey);
            pageNo = "0";
            pageSize = "5";
            tenantCode = "00000001";
        }
        boolean flag = false;
        if ("0".equals(pageNo) && "5".equals(pageSize)) {
            flag = true;
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiShopstockKey);
        this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.start", (Object)("\u540c\u6b65\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        ArrayList<WhStoreGoodsDomain> whStoreGoodsDomainList = new ArrayList<WhStoreGoodsDomain>();
        ArrayList<WhStoreSkuNumBean> whStoreSkuNumBeanList = new ArrayList<WhStoreSkuNumBean>();
        ArrayList<String> listError = new ArrayList<String>();
        while (true) {
            HashMap<String, String> map;
            long requestTime = System.currentTimeMillis();
            String jsonResult = null;
            try {
                jsonResult = HttpRequest.httpPost("/qj/queryShopstockByPage", pageNo, pageSize, lasttime);
                if (StringUtils.isBlank((String)jsonResult)) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockByPage", (Object)"response is null");
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockByPage.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
                return;
            }
            long responseTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.time", (Object)("===========\u8bf7\u6c42\u7684\u65f6\u95f4:" + (responseTime - requestTime)));
            Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
            if (!"S".equals(mapResult.get("resCode"))) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockByPage.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
                return;
            }
            Object dataStr = mapResult.get("dataStr");
            if (dataStr == null) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
                return;
            }
            List infdbShopstocksList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(dataStr.toString(), InfdbShopstock.class);
            if (ListUtil.isEmpty((Collection)infdbShopstocksList)) {
                if (ListUtil.isEmpty(listError)) {
                    DisUtil.set((String)this.fujiShopstockKey, (String)sdf.format(new Date()));
                }
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiShopstockKey) + ",\u540c\u6b65\u5931\u8d25\u7684listError:" + JsonUtil.buildNonDefaultBinder().toJson(listError)));
                return;
            }
            whStoreGoodsDomainList.clear();
            whStoreSkuNumBeanList.clear();
            for (InfdbShopstock infdbShopstock : infdbShopstocksList) {
                WhStoreSkuNumBean whStoreSkuNumBean = this.queryStoke(infdbShopstock, tenantCode);
                if (whStoreSkuNumBean == null) {
                    WhStoreGoodsDomain whStoreGoodsDomain = this.saveWhStoreSku(infdbShopstock, tenantCode);
                    if (whStoreGoodsDomain != null) {
                        whStoreGoodsDomainList.add(whStoreGoodsDomain);
                        continue;
                    }
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.saveWhStoreSku", (Object)("\u65b0\u589e\u5931\u8d25\uff01\uff01\uff01whStoreSkuNumBean:" + JsonUtil.buildNonDefaultBinder().toJson((Object)whStoreSkuNumBean) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    BigDecimal qty = infdbShopstock.getQty();
                    if (qty == null) {
                        qty = new BigDecimal(0);
                    }
                    String res = this.errorShopStock("\u5546\u54c1\u6216\u95e8\u5e97\u5bf9\u5e94\u6e20\u9053\u4e0d\u5b58\u5728\uff01\uff01\uff01", infdbShopstock.getShopid(), qty.toString(), infdbShopstock.getGoodsid());
                    listError.add(res);
                    continue;
                }
                if (StringUtils.isBlank((String)whStoreSkuNumBean.getMemberCcode())) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.channelcode", (Object)"channelcode .is . null");
                    BigDecimal qty = infdbShopstock.getQty();
                    if (qty == null) {
                        qty = new BigDecimal(0);
                    }
                    String res = this.errorShopStock("\u95e8\u5e97\u5bf9\u5e94\u6e20\u9053\u4e0d\u5b58\u5728\uff01\uff01\uff01", infdbShopstock.getShopid(), qty.toString(), infdbShopstock.getGoodsid());
                    listError.add(res);
                    continue;
                }
                whStoreSkuNumBeanList.add(whStoreSkuNumBean);
            }
            if (ListUtil.isNotEmpty(whStoreGoodsDomainList)) {
                map = new HashMap<String, String>();
                map.put("whStoreGoodsDomainList", JsonUtil.buildNonDefaultBinder().toJson(whStoreGoodsDomainList));
                try {
                    this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveStoreGoodsBatch", map);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.sendSaveStoreGoodsBatch.e", (Object)"\u5e93\u5b58\u65b0\u589e\u5931\u8d25\uff01\uff01!");
                    DisUtil.set((String)this.fujiShopstockKey, (String)(sdf.format(((InfdbShopstock)infdbShopstocksList.get(0)).getLasttime()) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
            }
            if (ListUtil.isNotEmpty(whStoreSkuNumBeanList)) {
                map = new HashMap();
                map.put("whStoreSkuNumBeanList", JsonUtil.buildNonDefaultBinder().toJson(whStoreSkuNumBeanList));
                try {
                    this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendUpdateStoreSkuNum", map);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.sendSaveStoreGoodsBatch.e", (Object)"\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff01\uff01!");
                    DisUtil.set((String)this.fujiShopstockKey, (String)(sdf.format(((InfdbShopstock)infdbShopstocksList.get(0)).getLasttime()) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
            }
            long endTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.time", (Object)("===========\u65b9\u6cd5\u63d2\u5165\u65f6\u95f4:" + (endTime - requestTime)));
            if (flag) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.test", (Object)"\u6d4b\u8bd5\u7ed3\u675f\uff01\uff01\uff01");
                return;
            }
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }

    private WhStoreSkuNumBean queryStoke(InfdbShopstock infdbShopstock, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("skuEocode", infdbShopstock.getGoodsid());
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String whStoreSkuPageJson = (String)this.getInternalRouter().inInvoke("wh.whStoreGoods.queryStoreSkuPage", map);
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(whStoreSkuPageJson, SupQueryResult.class);
        List whStoreStrList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), WhStoreSku.class);
        if (ListUtil.isEmpty((Collection)whStoreStrList)) {
            return null;
        }
        WhStoreSku whStoreSku = (WhStoreSku)whStoreStrList.get(0);
        WhStoreSkuNumBean whStoreSkuNumBean = new WhStoreSkuNumBean();
        whStoreSkuNumBean.setTenantCode(whStoreSku.getTenantCode());
        whStoreSkuNumBean.setGoodsEocode(whStoreSku.getGoodsEocode());
        whStoreSkuNumBean.setSkuEocode(whStoreSku.getSkuEocode());
        whStoreSkuNumBean.setGoodsNum(whStoreSku.getGoodsNum());
        whStoreSkuNumBean.setMemberCode(whStoreSku.getMemberCode());
        whStoreSkuNumBean.setMemberCcode(whStoreSku.getMemberCcode());
        return whStoreSkuNumBean;
    }

    protected WhStoreGoodsDomain saveWhStoreSku(InfdbShopstock infdbShopstock, String tenantCode) {
        HashMap<String, String> goodsBnparamMap = new HashMap<String, String>();
        goodsBnparamMap.put("goodsNo", infdbShopstock.getGoodsid());
        goodsBnparamMap.put("tenantCode", tenantCode);
        List resourceGoodsList = null;
        String resourceGoodsListStr = "";
        try {
            resourceGoodsListStr = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.checkGoodsNo", goodsBnparamMap);
            if (StringUtils.isBlank((String)resourceGoodsListStr)) {
                this.logger.error(".checkGoodsNoApiCode.resourceGoodsListStr", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01goodsBnparamMap:" + goodsBnparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".checkGoodsNoApiCode.resourceGoodsListStr.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01goodsBnparamMap:" + goodsBnparamMap));
            return null;
        }
        resourceGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(resourceGoodsListStr, RsResourceGoods.class);
        if (ListUtil.isEmpty((Collection)resourceGoodsList)) {
            this.logger.error(".checkGoodsNoApiCode.resourceGoodsList", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01goodsBnparamMap:" + goodsBnparamMap));
            return null;
        }
        RsResourceGoods rsResourceGoods = (RsResourceGoods)resourceGoodsList.get(0);
        HashMap<String, String> skuMap = new HashMap<String, String>();
        skuMap.put("skuNo", infdbShopstock.getGoodsid());
        skuMap.put("tenantCode", tenantCode);
        List rsSkuList = null;
        String rsSkuListStr = "";
        try {
            rsSkuListStr = (String)this.getInternalRouter().inInvoke("rs.sku.checkSkuNo", skuMap);
            if (StringUtils.isBlank((String)rsSkuListStr)) {
                this.logger.error(".checkGoodsNoApiCode.checkSkuNo.rsSkuListStr", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01skuMap:" + skuMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".checkGoodsNoApiCode.checkSkuNo.rsSkuListStr.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01skuMap:" + skuMap));
            return null;
        }
        rsSkuList = (List)JsonUtil.buildNormalBinder().getJsonToList(rsSkuListStr, RsSku.class);
        if (ListUtil.isEmpty((Collection)rsSkuList)) {
            this.logger.error(".checkGoodsNoApiCode.checkSkuNo.rsSkuList", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01skuMap:" + skuMap));
            return null;
        }
        RsSku rsSku = (RsSku)rsSkuList.get(0);
        return this.creatParam(rsResourceGoods, rsSku, infdbShopstock);
    }

    private WhStoreGoodsDomain creatParam(RsResourceGoods rsResourceGoods, RsSku rsSku, InfdbShopstock infdbShopstock) {
        DisChannel disChannel = this.getChannelCodeByshopId(infdbShopstock.getShopid(), rsSku.getTenantCode());
        if (disChannel == null) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.checkGoodsNoApiCode.getChannelCodeByshopId", (Object)"\u83b7\u53d6\u95e8\u5e97\u6e20\u9053\u4e3a\u7a7a\uff01\uff01\uff01disChannel\uff1anull");
            return null;
        }
        WhStoreGoodsDomain whStoreGoodsDomain = new WhStoreGoodsDomain();
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)rsSku.getTenantCode());
        try {
            BeanUtils.copyAllPropertys((Object)whStoreGoodsDomain, (Object)rsResourceGoods);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.whStoreGoodsDomain.rsResourceGoods.e", (Throwable)e);
        }
        whStoreGoodsDomain.setPricesetPurrice(infdbShopstock.getCost());
        whStoreGoodsDomain.setGoodsSupplynum(infdbShopstock.getQty());
        whStoreGoodsDomain.setGoodsEocode(infdbShopstock.getGoodsid());
        whStoreGoodsDomain.setMemberCode(memberCode);
        whStoreGoodsDomain.setMemberName(memberCode);
        whStoreGoodsDomain.setMemberCcode(disChannel.getChannelCode());
        ArrayList<WhStoreSkuDomain> whStoreSkuDomainList = new ArrayList<WhStoreSkuDomain>();
        WhStoreSkuDomain whStoreSkuDomain = new WhStoreSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whStoreSkuDomain, (Object)rsSku);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.whStoreSkuDomain.rsSku.e", (Throwable)e);
        }
        whStoreSkuDomain.setPricesetPurrice(infdbShopstock.getCost());
        whStoreSkuDomain.setGoodsNum(infdbShopstock.getQty());
        whStoreSkuDomain.setSkuEocode(infdbShopstock.getGoodsid());
        whStoreSkuDomain.setGoodsEocode(infdbShopstock.getGoodsid());
        whStoreSkuDomain.setMemberCode(memberCode);
        whStoreSkuDomain.setMemberName(memberCode);
        whStoreSkuDomain.setMemberCcode(disChannel.getChannelCode());
        whStoreSkuDomainList.add(whStoreSkuDomain);
        whStoreGoodsDomain.setWhStoreSkuDomainList(whStoreSkuDomainList);
        return whStoreGoodsDomain;
    }

    private DisChannel getChannelCodeByshopId(String shopId, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("userinfoOcode", shopId);
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String umJosnStr = null;
        try {
            umJosnStr = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", map);
            if (StringUtils.isBlank((String)umJosnStr)) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryUserinfoPage", (Object)("\u67e5\u8be2\u4e3a\u7a7a!!!mapStr:" + mapStr));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryUserinfoPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38!!!mapStr:" + mapStr));
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(umJosnStr, SupQueryResult.class);
        List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), UmUserinfo.class);
        if (ListUtil.isEmpty((Collection)pList)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryUserinfoPage", (Object)("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        UmUserinfo umUserinfo = (UmUserinfo)pList.get(0);
        map.clear();
        mapStr.clear();
        mapStr.put("memberCcode", umUserinfo.getUserinfoCode());
        mapStr.put("tenantCode", tenantCode);
        mapStr.put("channelType", "1");
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String disChannelJson = null;
        try {
            disChannelJson = (String)this.getInternalRouter().inInvoke("dis.channel.queryChannelPage", map);
            if (StringUtils.isBlank((String)disChannelJson)) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryChannelPage", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryChannelPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map));
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disChannelJson, SupQueryResult.class);
        List disChannelList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisChannel.class);
        if (ListUtil.isEmpty((Collection)disChannelList)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryDictionaryPage", (Object)("\u95e8\u5e97\u672a\u7ed1\u5b9a\u6e20\u9053,\u8bf7\u524d\u5f80\u7ed1\u5b9a\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        return (DisChannel)disChannelList.get(0);
    }

    public String errorShopStock(String msg, String shopId, String stock, String goodid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("msg", msg);
        map.put("shopid", shopId);
        map.put("stock", stock);
        map.put("goodid", goodid);
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }
}

