/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfBrandMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsBrandDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.InfBrand;
import com.yqbsoft.laser.service.adapter.fuji.service.InfBrandService;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfBrandServiceImpl
extends BaseServiceImpl
implements InfBrandService {
    private static final String SYS_CODE = "service.adapter.fuji.InfBrandServiceImpl";
    private InfBrandMapper infBrandMapper;
    private String fujiBrandKey = "fujiBrand";

    public void setInfBrandMapper(InfBrandMapper infBrandMapper) {
        this.infBrandMapper = infBrandMapper;
    }

    private List<InfBrand> queryBrandModelPage(Map<String, Object> parammap) {
        try {
            return this.infBrandMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfBrandServiceImpl.queryBrandModel", (Throwable)e);
            return null;
        }
    }

    private int countBrand(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infBrandMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfBrandServiceImpl.countBrand", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfBrand getInfBrandById(Integer brandId) {
        if (brandId == null) {
            return null;
        }
        return this.infBrandMapper.getInfBrandById(brandId);
    }

    @Override
    public QueryResult<InfBrand> queryBrandPage(Map<String, Object> map) {
        List<InfBrand> infBrandList = this.queryBrandModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBrand(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infBrandList);
        return queryResult;
    }

    @Override
    public List<InfBrand> queryBrandByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfBrand> infBrandQueryResult = this.queryBrandPage(map);
        List infBrandList = infBrandQueryResult.getList();
        return infBrandList;
    }

    @Override
    public void inertBrandByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            if ("0".equals(pageNo)) {
                DisUtil.del((String)this.fujiBrandKey);
            }
            return;
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiBrandKey);
        this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.start", (Object)("\u540c\u6b65\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (true) {
            List<InfBrand> infBrandsList;
            if (ListUtil.isEmpty(infBrandsList = this.queryBrandByPage(pn, ps, lasttime))) {
                List<InfBrand> infBrandslistStr = this.queryBrandByPage(pn - 1, ps, lasttime);
                InfBrand infBrand = infBrandslistStr.get(infBrandslistStr.size() - 1);
                if (infBrand == null || infBrand.getLasttime() == null) {
                    this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.infBrandslistStr", (Object)("\u83b7\u53d6\u4e0a\u6b21\u6700\u540e\u4e00\u6761\u8bb0\u5f55\u4e3a\u7a7a\uff01\uff01\uff01infBrand\uff1a" + infBrand + ",lasttime:" + infBrand.getLasttime()));
                    return;
                }
                DisUtil.set((String)this.fujiBrandKey, (String)sdf.format(sdf.format(new Date())));
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiBrandKey)));
                return;
            }
            for (InfBrand infBrand : infBrandsList) {
                map.clear();
                map.put("brandName", infBrand.getBrandname());
                map.put("tenantCode", tenantCode);
                String brandStr = null;
                try {
                    brandStr = (String)this.getInternalRouter().inInvoke("rs.brand.getBrandByName", map);
                    if (StringUtils.isNotBlank((String)brandStr)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    DisUtil.set((String)this.fujiBrandKey, (String)sdf.format(sdf.format(new Date())));
                    this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.getBrandByName.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiBrandKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                map.clear();
                RsBrandDomain rsBrandDomain = new RsBrandDomain();
                rsBrandDomain.setBrandName(infBrand.getBrandname());
                rsBrandDomain.setBrandEocode(infBrand.getBrandid().toString());
                rsBrandDomain.setTenantCode(tenantCode);
                map.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain));
                String brandCode = null;
                try {
                    brandCode = (String)this.getInternalRouter().inInvoke("rs.brand.saveBrand", map);
                    if (!StringUtils.isBlank((String)brandCode)) continue;
                    DisUtil.set((String)this.fujiBrandKey, (String)sdf.format(sdf.format(new Date())));
                    this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.saveBrand", (Object)("\u65b0\u589e\u5931\u8d25\uff01\uff01\uff01\u5165\u53c2rsBrandDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain) + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiBrandKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                catch (Exception e) {
                    DisUtil.set((String)this.fujiBrandKey, (String)sdf.format(sdf.format(new Date())));
                    this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.saveBrand.e", (Object)("\u65b0\u589e\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2rsBrandDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain) + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiBrandKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
            }
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }
}

