/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfCategoryMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.InfCategory;
import com.yqbsoft.laser.service.adapter.fuji.model.RsClasstree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsPntree;
import com.yqbsoft.laser.service.adapter.fuji.service.InfCategoryService;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfCategoryServiceImpl
extends BaseServiceImpl
implements InfCategoryService {
    private static final String SYS_CODE = "service.adpter.fiji.InfCategoryServiceImpl";
    private InfCategoryMapper infCategoryMapper;
    private String fujiCategoryKey = "fujiCategory";
    private String pntreeCode = "";

    public void setInfCategoryMapper(InfCategoryMapper infCategoryMapper) {
        this.infCategoryMapper = infCategoryMapper;
    }

    private int getCategoryMaxCode() {
        int code = 0;
        try {
            return this.infCategoryMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.getCategoryMaxCode", (Throwable)e);
            return code;
        }
    }

    private InfCategory getCategoryModelById(Integer categoryid) {
        if (null == categoryid) {
            return null;
        }
        try {
            return this.infCategoryMapper.selectByPrimaryKey(categoryid);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.getCategoryModelById", (Throwable)e);
            return null;
        }
    }

    private List<InfCategory> queryCategoryModelPage(Map<String, Object> parammap) {
        try {
            return this.infCategoryMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryCategoryModel", (Throwable)e);
            return null;
        }
    }

    private int countCategory(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infCategoryMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.countCategory", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfCategory getCategory(Integer categoryid) {
        return this.getCategoryModelById(categoryid);
    }

    @Override
    public QueryResult<InfCategory> queryCategoryPage(Map<String, Object> map) {
        List<InfCategory> infCategoryList = this.queryCategoryModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCategory(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infCategoryList);
        return queryResult;
    }

    @Override
    public List<InfCategory> queryCategoryByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfCategory> infCategoryQueryResult = this.queryCategoryPage(map);
        List infCategoryList = infCategoryQueryResult.getList();
        return infCategoryList;
    }

    @Override
    public void inertCategoryByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            if ("0".equals(pageNo)) {
                DisUtil.del((String)this.fujiCategoryKey);
            }
            return;
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiCategoryKey);
        this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.start", (Object)("\u540c\u6b65\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (true) {
            List<InfCategory> infCategories;
            if (ListUtil.isEmpty(infCategories = this.queryCategoryByPage(pn, ps, lasttime))) {
                List<InfCategory> infCategoriesStr = this.queryCategoryByPage(pn - 1, ps, lasttime);
                InfCategory infCategory = infCategoriesStr.get(infCategoriesStr.size() - 1);
                if (infCategory == null || infCategory.getLasttime() == null) {
                    this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.infCategoriesStr", (Object)("\u83b7\u53d6\u4e0a\u6b21\u6700\u540e\u4e00\u6761\u8bb0\u5f55\u4e3a\u7a7a\uff01\uff01\uff01infCategory\uff1a" + infCategory + ",lasttime:" + infCategory.getLasttime()));
                    return;
                }
                DisUtil.set((String)this.fujiCategoryKey, (String)sdf.format(infCategory.getLasttime()));
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiCategoryKey)));
                return;
            }
            for (InfCategory infCategory : infCategories) {
                map.clear();
                map.put("classtreeName", infCategory.getCategoryname());
                map.put("tenantCode", tenantCode);
                String rsClasstreeStr = null;
                try {
                    rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.getClasstreeByName", map);
                }
                catch (Exception e) {
                    DisUtil.set((String)this.fujiCategoryKey, (String)sdf.format(infCategory.getLasttime()));
                    this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.getClasstreeByName.e", (Object)("\u67e5\u8be2\u5206\u7c7b\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map:" + map + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiCategoryKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                if (StringUtils.isNotBlank((String)rsClasstreeStr)) {
                    RsClasstree rsClasstree = (RsClasstree)JsonUtil.buildNonDefaultBinder().getJsonToObject(rsClasstreeStr, RsClasstree.class);
                    if (!StringUtils.isBlank((String)rsClasstree.getPntreeCode())) continue;
                    this.queryOneClasstree(rsClasstree);
                    map.clear();
                    map.put("classtreeName", infCategory.getCategoryname());
                    map.put("pntreeCode", this.pntreeCode);
                    map.put("tenantCode", tenantCode);
                    try {
                        this.getInternalRouter().inInvoke("rs.rsClasstree.updateClasstreePtreeCode", map);
                    }
                    catch (Exception e) {
                        DisUtil.set((String)this.fujiCategoryKey, (String)sdf.format(infCategory.getLasttime()));
                        this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.updateClasstreePtreeCode.e", (Object)("\u5df2\u5b58\u5728,\u66f4\u65b0\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2map:" + map + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiCategoryKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                        return;
                    }
                    this.pntreeCode = "";
                    continue;
                }
                this.saveClassTree(infCategory, tenantCode, null);
                if (StringUtils.isBlank((String)this.pntreeCode)) {
                    DisUtil.set((String)this.fujiCategoryKey, (String)sdf.format(infCategory.getLasttime()));
                    this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.saveClassTree", (Object)("\u540c\u6b65\u5931\u8d25\uff01\uff01\uff01infCategory\uff1a" + JsonUtil.buildNonDefaultBinder().toJson((Object)infCategory) + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiCategoryKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                map.clear();
                map.put("classtreeName", infCategory.getCategoryname());
                map.put("pntreeCode", this.pntreeCode);
                map.put("tenantCode", tenantCode);
                try {
                    this.getInternalRouter().inInvoke("rs.rsClasstree.updateClasstreePtreeCode", map);
                }
                catch (Exception e) {
                    DisUtil.set((String)this.fujiCategoryKey, (String)sdf.format(infCategory.getLasttime()));
                    this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.updateClasstreePtreeCode.e", (Object)("\u672a\u5b58\u5728\uff0c\u66f4\u65b0\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2map:" + map + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiCategoryKey)));
                    return;
                }
                this.pntreeCode = "";
            }
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }

    public void saveClassTree(InfCategory infCategory, String tenantCode, String classtreeCodeStr) {
        RsClasstreeDomain rsClasstreeDomainStr = new RsClasstreeDomain();
        if (infCategory.getDeptlevelid() == 1) {
            rsClasstreeDomainStr.setClasstreeParentcode("-1");
            rsClasstreeDomainStr.setClasstreeLast("0");
        }
        rsClasstreeDomainStr.setClasstreeLast("1");
        rsClasstreeDomainStr.setClasstreeName(infCategory.getCategoryname());
        rsClasstreeDomainStr.setClasstreeEocode(infCategory.getCategoryid().toString());
        rsClasstreeDomainStr.setTenantCode(tenantCode);
        String classtreeCode = this.saveClasstree(rsClasstreeDomainStr);
        if (StringUtils.isBlank((String)classtreeCode)) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.saveClassTree", (Object)("\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsClasstreeDomainStr:" + JsonUtil.buildNonDefaultBinder().toJson((Object)rsClasstreeDomainStr)));
            return;
        }
        if (StringUtils.isNotBlank((String)classtreeCodeStr)) {
            this.updateClasstreeParentcode(classtreeCodeStr, classtreeCode, tenantCode);
        }
        if (infCategory.getDeptlevelid() == 1) {
            HashMap<String, String> map = new HashMap<String, String>();
            RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
            rsPntreeDomain.setPntreeName(infCategory.getCategoryname());
            rsPntreeDomain.setPntreeStep(1);
            rsPntreeDomain.setPntreeParentcode("-1");
            rsPntreeDomain.setPntreeEocode(infCategory.getCategoryid().toString());
            rsPntreeDomain.setTenantCode(tenantCode);
            map.put("rsPntreeDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsPntreeDomain));
            this.pntreeCode = (String)this.getInternalRouter().inInvoke("rs.pntree.savePntree", map);
            if (StringUtils.isBlank((String)this.pntreeCode)) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.savePntree", (Object)("\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsPntreeDomain\uff1a" + JsonUtil.buildNonDefaultBinder().toJson((Object)rsPntreeDomain)));
            }
            return;
        }
        InfCategory category = this.getCategory(infCategory.getHeadcatid());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("classtreeName", category.getCategoryname());
        map.put("tenantCode", tenantCode);
        String rsClasstreeStr = null;
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.getClasstreeByName", map);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.savePntree.getClasstreeByName.e", (Object)("\u6839\u636e\u540d\u79f0\u83b7\u53d6\u5206\u7c7b\u5f02\u5e38\uff01\uff01\uff01map:" + map));
            return;
        }
        RsClasstree rsClasstree = (RsClasstree)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, RsClasstree.class);
        if (rsClasstree == null) {
            this.saveClassTree(category, tenantCode, classtreeCode);
        } else {
            this.updateClasstreeParentcode(classtreeCode, rsClasstree.getClasstreeCode(), rsClasstree.getTenantCode());
            this.queryOneClasstree(rsClasstree);
        }
    }

    public void queryOneClasstree(RsClasstree rsClasstree) {
        if ("-1".equals(rsClasstree.getClasstreeParentcode())) {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> mapStr = new HashMap<String, String>();
            mapStr.put("pntreeName", rsClasstree.getClasstreeName());
            mapStr.put("tenantCode", rsClasstree.getTenantCode());
            map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
            String pntreeJson = null;
            try {
                pntreeJson = (String)this.getInternalRouter().inInvoke("rs.pntree.queryPntreePage", map);
            }
            catch (Exception e) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryOneClasstree.queryPntreePage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2map:" + map));
                return;
            }
            SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(pntreeJson, SupQueryResult.class);
            List rsPntreeStrList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsPntree.class);
            if (ListUtil.isEmpty((Collection)rsPntreeStrList)) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryOneClasstree.queryPntreePage", (Object)("\u67e5\u8be2\u5931\u8d25\uff01\uff01\uff01map:" + mapStr));
                return;
            }
            this.pntreeCode = ((RsPntree)rsPntreeStrList.get(0)).getPntreeCode();
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("classtreeCode", rsClasstree.getClasstreeParentcode());
        mapStr.put("tenantCode", rsClasstree.getTenantCode());
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String rsClasstreeJson = null;
        try {
            rsClasstreeJson = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryOneClasstree.queryClasstreePage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2map:" + map));
            return;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeJson, SupQueryResult.class);
        List rsClasstreeList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstreeList)) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryOneClasstree.queryClasstreePage", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01\u5165\u53c2map:" + map));
            return;
        }
        this.queryOneClasstree((RsClasstree)rsClasstreeList.get(0));
    }

    public void updateClasstreeParentcode(String classtreeCode, String classtreeParentcode, String tenantCode) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("classtreeCode", classtreeCode);
        mapStr.put("classtreeParentcode", classtreeParentcode);
        mapStr.put("tenantCode", tenantCode);
        try {
            this.getInternalRouter().inInvoke("rs.rsClasstree.updateclasstreeParentcode", mapStr);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.updateClasstreeParentcod.updateclasstreeParentcode.e", (Object)("\u66f4\u65b0\u5f02\u5e38\uff01\uff01\uff01\uff0c\u5165\u53c2mapStr:" + mapStr));
        }
    }

    public String saveClasstree(RsClasstreeDomain rsClasstreeDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
        String classtreeCode = "";
        try {
            classtreeCode = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.saveClasstree", map);
            if (StringUtils.isBlank((String)classtreeCode)) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.saveClasstree", (Object)("\u65b0\u589e\u5931\u8d25\uff01\uff01\uff01\u5165\u53c2rsClasstreeDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain)));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.saveClasstree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2rsClasstreeDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain)));
        }
        return classtreeCode;
    }
}

