/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfGoodsshopMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.DisDgoodsDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.DisDgoodsScopelistDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.DisChannel;
import com.yqbsoft.laser.service.adapter.fuji.model.InfGoodsshop;
import com.yqbsoft.laser.service.adapter.fuji.model.RsResourceGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.UmUser;
import com.yqbsoft.laser.service.adapter.fuji.service.InfGoodsshopService;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InfGoodsshopServiceImpl
extends BaseServiceImpl
implements InfGoodsshopService {
    private static final String SYS_CODE = "service.adapter.fuji.InfGoodsshopServiceImpl";
    private InfGoodsshopMapper infGoodsshopMapper;
    private String fujiGoodsshopKey = "goodsShop";
    private static Set<String> channelSet = new HashSet<String>();

    public void setInfGoodsshopMapper(InfGoodsshopMapper infGoodsshopMapper) {
        this.infGoodsshopMapper = infGoodsshopMapper;
    }

    private List<InfGoodsshop> getInfGoodsshopModelById(String shopid) {
        if (null == shopid) {
            return null;
        }
        try {
            return this.infGoodsshopMapper.selectByPrimaryKey(shopid);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.getInfGoodsshopModelById", (Throwable)e);
            return null;
        }
    }

    private List<InfGoodsshop> queryInfGoodsshopModelPage(Map<String, Object> parammap) {
        try {
            return this.infGoodsshopMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.queryInfGoodsshopModel", (Throwable)e);
            return null;
        }
    }

    private int countInfGoodsshop(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infGoodsshopMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.countInfGoodsshop", (Throwable)e);
        }
        return i;
    }

    @Override
    public List<InfGoodsshop> getInfGoodsshop(String shopid) {
        return this.getInfGoodsshopModelById(shopid);
    }

    @Override
    public QueryResult<InfGoodsshop> queryInfGoodsshopPage(Map<String, Object> map) {
        List<InfGoodsshop> infGoodsshopList = this.queryInfGoodsshopModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInfGoodsshop(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infGoodsshopList);
        return queryResult;
    }

    @Override
    public List<InfGoodsshop> queryGoodsshopByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfGoodsshop> goodsshopQueryResult = this.queryInfGoodsshopPage(map);
        return goodsshopQueryResult.getList();
    }

    @Override
    public void inertGoodsshopByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            pageNo = "1";
            pageSize = "50";
            tenantCode = "00000001";
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiGoodsshopKey);
        this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.start", (Object)("\u540c\u6b65\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        while (true) {
            List<InfGoodsshop> infGoodsshopList;
            if (ListUtil.isEmpty(infGoodsshopList = this.queryGoodsshopByPage(pn, ps, lasttime))) {
                List<InfGoodsshop> infGoodsshopListStr;
                InfGoodsshop infGoodsshop;
                if (!channelSet.isEmpty()) {
                    Iterator<String> iterator = channelSet.iterator();
                    HashMap<String, String> map = new HashMap<String, String>();
                    while (iterator.hasNext()) {
                        map.clear();
                        map.put("channelCode", iterator.next());
                        map.put("tenantCode", tenantCode);
                        try {
                            this.getInternalRouter().inInvoke("dis.channelsendBase.sendSaveDgoodsUpdate", map);
                        }
                        catch (Exception e) {
                            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.sendSaveDgoodsUpdate", (Object)("\u66f4\u65b0\u6e20\u9053\u5546\u54c1\u8303\u56f4\u5931\u8d25map:" + map));
                            return;
                        }
                    }
                    channelSet.clear();
                }
                if ((infGoodsshop = (infGoodsshopListStr = this.queryGoodsshopByPage(pn - 1, ps, lasttime)).get(infGoodsshopListStr.size() - 1)) == null || infGoodsshop.getIndate() == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.infGoodsshopList", (Object)("\u83b7\u53d6\u4e0a\u6b21\u6700\u540e\u4e00\u6761\u8bb0\u5f55\u4e3a\u7a7a\uff01\uff01\uff01infGoodsshop\uff1a" + infGoodsshop + ",lasttime:" + infGoodsshop.getLasttime()));
                    return;
                }
                DisUtil.set((String)this.fujiGoodsshopKey, (String)sdf.format(new Date()));
                this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiGoodsshopKey)));
                return;
            }
            for (InfGoodsshop infGoodsshop : infGoodsshopList) {
                String channelCode = this.getChannelCodeByshopId(infGoodsshop.getShopid(), tenantCode);
                channelSet.add(channelCode);
                if (StringUtils.isBlank((String)channelCode)) {
                    DisUtil.set((String)this.fujiGoodsshopKey, (String)sdf.format(new Date()));
                    this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.getChannelCodeByshopId", (Object)("\u83b7\u53d6\u95e8\u5e97\u6e20\u9053\u4e3a\u7a7a\uff01\uff01\uff01channelCode\uff1a" + channelCode + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                String disDgoodsCode = this.saveDgoods(channelCode, infGoodsshop, tenantCode);
                if (!StringUtils.isBlank((String)disDgoodsCode)) continue;
                this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.saveDgoods", (Object)("\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01infGoodsshop:" + JsonUtil.buildNonDefaultBinder().toJson((Object)infGoodsshop) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                DisUtil.set((String)this.fujiGoodsshopKey, (String)sdf.format(new Date()));
                return;
            }
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }

    private String saveDgoods(String channelCode, InfGoodsshop infGoodsshop, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.clear();
        map.put("goodsNo", infGoodsshop.getGoodsid());
        map.put("tenantCode", tenantCode);
        String rsResourceGoodsStr = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.checkGoodsNo", map);
        List rsResourceGoodsList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(rsResourceGoodsStr, RsResourceGoods.class);
        if (ListUtil.isEmpty((Collection)rsResourceGoodsList)) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.checkGoodsNo", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728\uff01\uff01\uff01\u5165\u53c2map\uff1a" + map));
            return null;
        }
        RsResourceGoods rsResourceGoods = (RsResourceGoods)rsResourceGoodsList.get(0);
        map.clear();
        DisDgoodsDomain disDgoodsDomain = new DisDgoodsDomain();
        disDgoodsDomain.setChannelCode(channelCode);
        disDgoodsDomain.setDgoodsType("1");
        disDgoodsDomain.setDgoodsSync("1");
        disDgoodsDomain.setDgoodsPut("1");
        disDgoodsDomain.setMemberCode(SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode));
        disDgoodsDomain.setTenantCode(tenantCode);
        ArrayList<DisDgoodsScopelistDomain> disDgoodsScopelistDomainList = new ArrayList<DisDgoodsScopelistDomain>();
        disDgoodsDomain.setDisDgoodsScopelistDomainList(disDgoodsScopelistDomainList);
        DisDgoodsScopelistDomain disDgoodsScopelistDomain = new DisDgoodsScopelistDomain();
        disDgoodsScopelistDomain.setDgoodsScopelistType("goodsNo");
        disDgoodsScopelistDomain.setDgoodsScopelistValue(rsResourceGoods.getGoodsNo());
        disDgoodsScopelistDomain.setDgoodsScopelistValuen(rsResourceGoods.getGoodsName());
        disDgoodsScopelistDomain.setMemberCode(SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode));
        disDgoodsScopelistDomain.setTenantCode(tenantCode);
        map.put("disDgoodsDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)disDgoodsDomain));
        String disDgoodsCodeStr = null;
        try {
            disDgoodsCodeStr = (String)this.getInternalRouter().inInvoke("dis.dgoods.saveDgoods", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.saveDgoods.e", (Object)("\u6dfb\u52a0\u6e20\u9053\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01map:" + map));
            return null;
        }
        if (StringUtils.isBlank((String)disDgoodsCodeStr)) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.saveDgoods", (Object)("\u6dfb\u52a0\u6e20\u9053\u5546\u54c1\u5931\u8d25\uff01\uff01\uff01\u5165\u53c2map:" + map));
            return null;
        }
        return disDgoodsCodeStr;
    }

    private String getChannelCodeByshopId(String shopId, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("userOcode", shopId);
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String umJosnStr = null;
        try {
            umJosnStr = (String)this.getInternalRouter().inInvoke("um.user.getUserByUserOcode", mapStr);
            if (StringUtils.isBlank((String)umJosnStr)) {
                this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.getUserByUserOcode", (Object)("\u67e5\u8be2\u4e3a\u7a7a!!!mapStr:" + mapStr));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.getUserByUserOcode.e", (Object)("\u67e5\u8be2\u5f02\u5e38!!!mapStr:" + mapStr));
            return null;
        }
        UmUser umUser = (UmUser)JsonUtil.buildNormalBinder().getJsonToObject(umJosnStr, UmUser.class);
        if (umUser == null) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.getUserByUserOcode", (Object)("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        map.clear();
        mapStr.clear();
        mapStr.put("memberCcode", umUser.getUserPcode());
        mapStr.put("tenantCode", tenantCode);
        mapStr.put("channelType", "1");
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String disChannelJson = null;
        try {
            disChannelJson = (String)this.getInternalRouter().inInvoke("dis.channel.queryChannelPage", map);
            if (StringUtils.isBlank((String)disChannelJson)) {
                this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.queryChannelPage", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.queryChannelPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map));
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disChannelJson, SupQueryResult.class);
        List disChannelList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisChannel.class);
        if (ListUtil.isEmpty((Collection)disChannelList)) {
            this.logger.error("service.adapter.fuji.InfGoodsshopServiceImpl.inertGoodsshopByPage.queryDictionaryPage", (Object)("\u95e8\u5e97\u672a\u7ed1\u5b9a\u6e20\u9053,\u8bf7\u524d\u5f80\u7ed1\u5b9a\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        return ((DisChannel)disChannelList.get(0)).getChannelCode();
    }
}

