/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfdbShopstockMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.WhStoreGoodsDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.WhStoreSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.WhStoreSkuNumBean;
import com.yqbsoft.laser.service.adapter.fuji.model.DisChannel;
import com.yqbsoft.laser.service.adapter.fuji.model.InfdbShopstock;
import com.yqbsoft.laser.service.adapter.fuji.model.RsResourceGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSku;
import com.yqbsoft.laser.service.adapter.fuji.model.UmUser;
import com.yqbsoft.laser.service.adapter.fuji.model.WhStoreSku;
import com.yqbsoft.laser.service.adapter.fuji.service.InfdbShopstockService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfdbShopstockServiceImpl
extends BaseServiceImpl
implements InfdbShopstockService {
    private static final String SYS_CODE = "service.adapter.fuji.InfdbShopstockServiceImpl";
    private InfdbShopstockMapper infdbShopstockMapper;
    private String fujiShopstockKey = "fujiShopstock";

    public void setInfdbShopstockMapper(InfdbShopstockMapper infdbShopstockMapper) {
        this.infdbShopstockMapper = infdbShopstockMapper;
    }

    private InfdbShopstock getInfdbShopstockModelById(Map<String, Object> map) {
        try {
            return this.infdbShopstockMapper.selectByPrimaryKey(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.getInfdbShopstockModelById", (Throwable)e);
            return null;
        }
    }

    private List<InfdbShopstock> queryInfdbShopstockModelPage(Map<String, Object> parammap) {
        try {
            return this.infdbShopstockMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.queryInfdbShopstockModel", (Throwable)e);
            return null;
        }
    }

    private int countInfdbShopstock(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infdbShopstockMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.countInfdbShopstock", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfdbShopstock getInfdbShopstock(String shopid, String goodsid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shopid", shopid);
        map.put("goodsid", goodsid);
        return this.getInfdbShopstockModelById(map);
    }

    @Override
    public QueryResult<InfdbShopstock> queryInfdbShopstockPage(Map<String, Object> map) {
        List<InfdbShopstock> infdbShopstockList = this.queryInfdbShopstockModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInfdbShopstock(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infdbShopstockList);
        return queryResult;
    }

    @Override
    public List<InfdbShopstock> queryShopstockByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfdbShopstock> goodsshopQueryResult = this.queryInfdbShopstockPage(map);
        List goodsshopList = goodsshopQueryResult.getList();
        return goodsshopList;
    }

    @Override
    public void inertShopstockByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            pageNo = "1";
            pageSize = "50";
            tenantCode = "00000001";
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiShopstockKey);
        this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.start", (Object)("\u540c\u6b65\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        ArrayList<WhStoreGoodsDomain> whStoreGoodsDomainList = new ArrayList<WhStoreGoodsDomain>();
        ArrayList<WhStoreSkuNumBean> whStoreSkuNumBeanList = new ArrayList<WhStoreSkuNumBean>();
        while (true) {
            HashMap<String, String> map;
            List<InfdbShopstock> infdbShopstocksList;
            if (ListUtil.isEmpty(infdbShopstocksList = this.queryShopstockByPage(pn, ps, lasttime))) {
                List<InfdbShopstock> infdbShopstocksListStr = this.queryShopstockByPage(pn - 1, ps, lasttime);
                InfdbShopstock infdbShopstock = infdbShopstocksListStr.get(infdbShopstocksListStr.size() - 1);
                if (infdbShopstock == null || infdbShopstock.getLasttime() == null) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.infBrandslistStr", (Object)("\u83b7\u53d6\u4e0a\u6b21\u6700\u540e\u4e00\u6761\u8bb0\u5f55\u4e3a\u7a7a\uff01\uff01\uff01infdbShopstock\uff1a" + infdbShopstock + ",lasttime:" + infdbShopstock.getLasttime()));
                    return;
                }
                DisUtil.set((String)this.fujiShopstockKey, (String)sdf.format(new Date()));
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiShopstockKey)));
                return;
            }
            whStoreGoodsDomainList.clear();
            whStoreSkuNumBeanList.clear();
            for (InfdbShopstock infdbShopstock : infdbShopstocksList) {
                WhStoreSkuNumBean whStoreSkuNumBean = this.queryStoke(infdbShopstock, tenantCode);
                if (whStoreSkuNumBean == null) {
                    WhStoreGoodsDomain whStoreGoodsDomain = this.saveWhStoreSku(infdbShopstock, tenantCode);
                    if (whStoreGoodsDomain != null) {
                        whStoreGoodsDomainList.add(whStoreGoodsDomain);
                        continue;
                    }
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.saveWhStoreSku", (Object)("\u65b0\u589e\u5931\u8d25\uff01\uff01\uff01whStoreSkuNumBean:" + JsonUtil.buildNonDefaultBinder().toJson((Object)whStoreSkuNumBean) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                whStoreSkuNumBeanList.add(whStoreSkuNumBean);
            }
            if (ListUtil.isNotEmpty(whStoreGoodsDomainList)) {
                map = new HashMap<String, String>();
                map.put("whStoreGoodsDomainList", JsonUtil.buildNonDefaultBinder().toJson(whStoreGoodsDomainList));
                try {
                    this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveStoreGoodsBatch", map);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.sendSaveStoreGoodsBatch.e", (Object)"\u5e93\u5b58\u65b0\u589e\u5931\u8d25\uff01\uff01!");
                    DisUtil.set((String)this.fujiShopstockKey, (String)(sdf.format(new Date()) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
            }
            if (!ListUtil.isNotEmpty(whStoreSkuNumBeanList)) continue;
            map = new HashMap();
            map.put("whStoreSkuNumBeanList", JsonUtil.buildNonDefaultBinder().toJson(whStoreSkuNumBeanList));
            try {
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendUpdateStoreSkuNum", map);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.sendSaveStoreGoodsBatch.e", (Object)"\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff01\uff01!");
                DisUtil.set((String)this.fujiShopstockKey, (String)(sdf.format(new Date()) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                return;
            }
        }
    }

    private WhStoreSkuNumBean queryStoke(InfdbShopstock infdbShopstock, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("skuEocode", infdbShopstock.getGoodsid());
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String whStoreSkuPageJson = (String)this.getInternalRouter().inInvoke("wh.whStoreGoods.queryStoreSkuPage", map);
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(whStoreSkuPageJson, SupQueryResult.class);
        List whStoreStrList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), WhStoreSku.class);
        if (ListUtil.isEmpty((Collection)whStoreStrList)) {
            return null;
        }
        WhStoreSku whStoreSku = (WhStoreSku)whStoreStrList.get(0);
        WhStoreSkuNumBean whStoreSkuNumBean = new WhStoreSkuNumBean();
        whStoreSkuNumBean.setTenantCode(whStoreSku.getTenantCode());
        whStoreSkuNumBean.setGoodsEocode(whStoreSku.getGoodsEocode());
        whStoreSkuNumBean.setSkuEocode(whStoreSku.getSkuEocode());
        whStoreSkuNumBean.setGoodsNum(whStoreSku.getGoodsNum());
        whStoreSkuNumBean.setMemberCode(whStoreSku.getMemberCode());
        whStoreSkuNumBean.setMemberCcode(this.getChannelCodeByshopId(infdbShopstock.getShopid(), tenantCode));
        return whStoreSkuNumBean;
    }

    protected WhStoreGoodsDomain saveWhStoreSku(InfdbShopstock infdbShopstock, String tenantCode) {
        HashMap<String, String> goodsBnparamMap = new HashMap<String, String>();
        goodsBnparamMap.put("goodsCodeOld", infdbShopstock.getGoodsid());
        goodsBnparamMap.put("tenantCode", tenantCode);
        List resourceGoodsList = null;
        String resourceGoodsListStr = "";
        try {
            resourceGoodsListStr = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.checkGoodsNo", goodsBnparamMap);
            if (StringUtils.isBlank((String)resourceGoodsListStr)) {
                this.logger.error(".checkGoodsNoApiCode.resourceGoodsList", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01goodsBnparamMap:" + goodsBnparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".checkGoodsNoApiCode.resourceGoodsList.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01goodsBnparamMap:" + goodsBnparamMap));
            return null;
        }
        resourceGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(resourceGoodsListStr, RsResourceGoods.class);
        RsResourceGoods rsResourceGoods = (RsResourceGoods)resourceGoodsList.get(0);
        HashMap<String, String> skuMap = new HashMap<String, String>();
        skuMap.put("skuCodeOld", infdbShopstock.getGoodsid());
        skuMap.put("tenantCode", tenantCode);
        List rsSkuList = null;
        String rsSkuListStr = "";
        try {
            rsSkuListStr = (String)this.getInternalRouter().inInvoke("rs.sku.checkSkuNo", skuMap);
            if (StringUtils.isBlank((String)rsSkuListStr)) {
                this.logger.error(".checkGoodsNoApiCode.checkSkuNo.e", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01skuMap:" + skuMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".checkGoodsNoApiCode.checkSkuNo.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01skuMap:" + skuMap));
            return null;
        }
        rsSkuList = (List)JsonUtil.buildNormalBinder().getJsonToList(rsSkuListStr, RsSku.class);
        RsSku rsSku = (RsSku)rsSkuList.get(0);
        return this.creatParam(rsResourceGoods, rsSku, infdbShopstock);
    }

    private WhStoreGoodsDomain creatParam(RsResourceGoods rsResourceGoods, RsSku rsSku, InfdbShopstock infdbShopstock) {
        String channelCode = this.getChannelCodeByshopId(infdbShopstock.getShopid(), rsSku.getTenantCode());
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.checkGoodsNoApiCode.getChannelCodeByshopId", (Object)("\u83b7\u53d6\u95e8\u5e97\u6e20\u9053\u4e3a\u7a7a\uff01\uff01\uff01channelCode\uff1a" + channelCode));
            return null;
        }
        WhStoreGoodsDomain whStoreGoodsDomain = new WhStoreGoodsDomain();
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)rsSku.getTenantCode());
        try {
            BeanUtils.copyAllPropertys((Object)whStoreGoodsDomain, (Object)rsResourceGoods);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.whStoreGoodsDomain.rsResourceGoods.e", (Throwable)e);
        }
        whStoreGoodsDomain.setPricesetPurrice(infdbShopstock.getCost());
        whStoreGoodsDomain.setGoodsSupplynum(infdbShopstock.getQty());
        whStoreGoodsDomain.setGoodsEocode(infdbShopstock.getGoodsid());
        whStoreGoodsDomain.setMemberCode(memberCode);
        whStoreGoodsDomain.setMemberName(memberCode);
        whStoreGoodsDomain.setMemberCcode(channelCode);
        ArrayList<WhStoreSkuDomain> whStoreSkuDomainList = new ArrayList<WhStoreSkuDomain>();
        WhStoreSkuDomain whStoreSkuDomain = new WhStoreSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whStoreSkuDomain, (Object)rsSku);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.whStoreSkuDomain.rsSku.e", (Throwable)e);
        }
        whStoreSkuDomain.setPricesetPurrice(infdbShopstock.getCost());
        whStoreSkuDomain.setGoodsNum(infdbShopstock.getQty());
        whStoreSkuDomain.setSkuEocode(infdbShopstock.getGoodsid());
        whStoreSkuDomain.setGoodsEocode(infdbShopstock.getGoodsid());
        whStoreSkuDomain.setMemberCode(memberCode);
        whStoreSkuDomain.setMemberName(memberCode);
        whStoreSkuDomain.setMemberCcode(channelCode);
        whStoreSkuDomainList.add(whStoreSkuDomain);
        whStoreGoodsDomain.setWhStoreSkuDomainList(whStoreSkuDomainList);
        return whStoreGoodsDomain;
    }

    private String getChannelCodeByshopId(String shopId, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("userOcode", shopId);
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String umJosnStr = (String)this.getInternalRouter().inInvoke("um.user.getUserByUserOcode", mapStr);
        UmUser umUser = (UmUser)JsonUtil.buildNormalBinder().getJsonToObject(umJosnStr, UmUser.class);
        if (umUser == null) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.getUserByUserOcode", (Object)("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        map.clear();
        mapStr.clear();
        mapStr.put("memberCcode", umUser.getUserPcode());
        mapStr.put("tenantCode", tenantCode);
        mapStr.put("channelType", "1");
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String disChannelJson = (String)this.getInternalRouter().inInvoke("dis.channel.queryChannelPage", map);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disChannelJson, SupQueryResult.class);
        List disChannelList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisChannel.class);
        if (ListUtil.isEmpty((Collection)disChannelList)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryDictionaryPage", (Object)("\u95e8\u5e97\u672a\u7ed1\u5b9a\u6e20\u9053,\u8bf7\u524d\u5f80\u7ed1\u5b9a\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        return ((DisChannel)disChannelList.get(0)).getChannelCode();
    }
}

