/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfBrandMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsBrandDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.InfBrand;
import com.yqbsoft.laser.service.adapter.fuji.model.InfdbShopstock;
import com.yqbsoft.laser.service.adapter.fuji.service.InfBrandService;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpOneRequest;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpRequest;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfBrandServiceImpl
extends BaseServiceImpl
implements InfBrandService {
    private static final String SYS_CODE = "service.adapter.fuji.InfBrandServiceImpl";
    private InfBrandMapper infBrandMapper;
    private String fujiBrandKey = "fujiBrand";

    public void setInfBrandMapper(InfBrandMapper infBrandMapper) {
        this.infBrandMapper = infBrandMapper;
    }

    private List<InfBrand> queryBrandModelPage(Map<String, Object> parammap) {
        try {
            return this.infBrandMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfBrandServiceImpl.queryBrandModel", (Throwable)e);
            return null;
        }
    }

    private int countBrand(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infBrandMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfBrandServiceImpl.countBrand", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfBrand getInfBrandById(Integer brandId) {
        if (brandId == null) {
            return null;
        }
        return this.infBrandMapper.getInfBrandById(brandId);
    }

    @Override
    public QueryResult<InfBrand> queryBrandPage(Map<String, Object> map) {
        List<InfBrand> infBrandList = this.queryBrandModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBrand(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infBrandList);
        return queryResult;
    }

    @Override
    public List<InfBrand> queryBrandByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo * pageSize);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfBrand> infBrandQueryResult = this.queryBrandPage(map);
        List infBrandList = infBrandQueryResult.getList();
        return infBrandList;
    }

    @Override
    public void inertBrandByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            DisUtil.del((String)this.fujiBrandKey);
            pageNo = "0";
            pageSize = "50";
            tenantCode = "2019071800001392";
        }
        boolean flag = false;
        if ("0".equals(pageNo) && "5".equals(pageSize)) {
            flag = true;
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiBrandKey);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> errorAddBrands = new ArrayList<String>();
        while (true) {
            long requestTime = System.currentTimeMillis();
            String jsonResult = null;
            try {
                jsonResult = HttpRequest.httpPost("/qj/queryBrandByPage", pn, ps, lasttime);
                if (StringUtils.isBlank((String)jsonResult)) {
                    this.logger.error("service.adapter.fuji.InfBrandServiceImpl.httpPost.queryBrandByPage", (Object)"response is null");
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.httpPost.queryBrandByPage.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
                return;
            }
            long responseTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfBrandServiceImpl.httpPost.time", (Object)("===========\u8bf7\u6c42\u7684\u65f6\u95f4:" + (responseTime - requestTime)));
            Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
            if (!"S".equals(mapResult.get("resCode"))) {
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.httpPost.queryBrandByPage.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
                return;
            }
            Object dataStr = mapResult.get("dataStr");
            if (dataStr == null) {
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.httpPost.queryBrandByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
                return;
            }
            List infBrandsList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(dataStr.toString(), InfBrand.class);
            if (ListUtil.isEmpty((Collection)infBrandsList)) {
                if (ListUtil.isEmpty(errorAddBrands)) {
                    DisUtil.set((String)this.fujiBrandKey, (String)sdf.format(new Date()));
                }
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiBrandKey) + ",\u9519\u8bef\u7684\u54c1\u724cerrorAddBrands:" + JsonUtil.buildNormalBinder().toJson(errorAddBrands)));
                return;
            }
            for (InfBrand infBrand : infBrandsList) {
                map.clear();
                map.put("brandName", infBrand.getBrandname());
                map.put("tenantCode", tenantCode);
                String brandStr = null;
                try {
                    brandStr = (String)this.getInternalRouter().inInvoke("rs.brand.getBrandByName", map);
                    if (StringUtils.isNotBlank((String)brandStr)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.getBrandByName.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiBrandKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                map.clear();
                RsBrandDomain rsBrandDomain = new RsBrandDomain();
                rsBrandDomain.setBrandName(infBrand.getBrandname());
                rsBrandDomain.setBrandEocode(infBrand.getBrandid().toString());
                rsBrandDomain.setTenantCode(tenantCode);
                map.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain));
                String brandCode = null;
                try {
                    brandCode = (String)this.getInternalRouter().inInvoke("rs.brand.saveBrand", map);
                    if (!StringUtils.isBlank((String)brandCode)) continue;
                    errorAddBrands.add(infBrand.getBrandid().toString());
                    this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.saveBrand", (Object)("\u65b0\u589e\u5931\u8d25\uff01\uff01\uff01\u5165\u53c2rsBrandDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain) + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiBrandKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                }
                catch (Exception e) {
                    errorAddBrands.add(infBrand.getBrandid().toString());
                    this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.saveBrand.e", (Object)("\u65b0\u589e\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2rsBrandDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain) + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiBrandKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                }
            }
            long endTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfBrandServiceImpl.inertBrandByPage.time", (Object)("===========\u65b9\u6cd5\u63d2\u5165\u65f6\u95f4:" + (endTime - requestTime)));
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }

    @Override
    public Boolean insertOneBrand(String brandId, String tenantCode, InfBrand infBrand) {
        if (infBrand == null) {
            InfBrand infBrand1 = new InfBrand();
            infBrand1.setBrandid(Integer.valueOf(brandId));
            String jsonResult = null;
            try {
                jsonResult = HttpOneRequest.httpPost("/qj/queryBrandByPage", infBrand1);
                if (StringUtils.isBlank((String)jsonResult)) {
                    this.logger.error("service.adapter.fuji.InfBrandServiceImpl.httpPost.queryBrandByPage", (Object)"response is null");
                    return false;
                }
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.httpPost.queryBrandByPage.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
                return false;
            }
            Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
            if (!"S".equals(mapResult.get("resCode"))) {
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.httpPost.queryBrandByPage.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
                return false;
            }
            Object dataStr = mapResult.get("dataStr");
            if (dataStr == null) {
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.httpPost.queryBrandByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
                return false;
            }
            infBrand = (InfBrand)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataStr.toString(), InfBrand.class);
            if (infBrand == null) {
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.httpPost.queryBrandByPage.dataStr.e", (Object)("\u83b7\u53d6\u7ed3\u679c\u4e3a\u7a7a\uff01\uff01\uff01jsonResult\uff1a" + jsonResult));
                return false;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        RsBrandDomain rsBrandDomain = new RsBrandDomain();
        rsBrandDomain.setBrandName(infBrand.getBrandname());
        rsBrandDomain.setBrandEocode(infBrand.getBrandid().toString());
        rsBrandDomain.setTenantCode(tenantCode);
        map.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain));
        String brandCode = null;
        try {
            brandCode = (String)this.getInternalRouter().inInvoke("rs.brand.saveBrand", map);
            if (StringUtils.isBlank((String)brandCode)) {
                this.logger.error("service.adapter.fuji.InfBrandServiceImpl.insertOneBrand.saveBrand", (Object)("\u65b0\u589e\u5931\u8d25\uff01\uff01\uff01\u5165\u53c2rsBrandDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain)));
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfBrandServiceImpl.insertOneBrand.saveBrand.e", (Object)("\u65b0\u589e\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2rsBrandDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain)));
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        String format = sdf1.format(date);
        long time = date.getTime();
        System.out.println("\u54c1\u724c\u540c\u6b65\u5f00\u59cb\u65f6\u95f4\uff1a" + sdf.format(date));
        String jsonResult = null;
        try {
            InfdbShopstock infdbShopstock = new InfdbShopstock();
            infdbShopstock.setShopid("SH001");
            infdbShopstock.setGoodsid("17668");
            jsonResult = HttpOneRequest.httpPost("/qj/queryShopstockById", infdbShopstock);
            if (StringUtils.isBlank((String)jsonResult)) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        Date date1 = new Date();
        long time1 = date1.getTime();
        System.out.println("\u54c1\u724c\u540c\u6b65\u7ed3\u675f\u65f6\u95f4\uff1a" + sdf.format(date1));
        System.out.println("=====================");
        System.out.println("\u65f6\u95f4\u5dee\uff1a" + (time1 - time));
        System.out.println(jsonResult);
    }
}

