/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfCategoryMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.InfCategory;
import com.yqbsoft.laser.service.adapter.fuji.model.RsClasstree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsPntree;
import com.yqbsoft.laser.service.adapter.fuji.service.InfCategoryService;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpOneRequest;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpRequest;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfCategoryServiceImpl
extends BaseServiceImpl
implements InfCategoryService {
    private static final String SYS_CODE = "service.adpter.fiji.InfCategoryServiceImpl";
    private InfCategoryMapper infCategoryMapper;
    private String fujiCategoryKey = "fujiCategory";
    private String pntreeCode = "";

    public void setInfCategoryMapper(InfCategoryMapper infCategoryMapper) {
        this.infCategoryMapper = infCategoryMapper;
    }

    private int getCategoryMaxCode() {
        int code = 0;
        try {
            return this.infCategoryMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.getCategoryMaxCode", (Throwable)e);
            return code;
        }
    }

    private InfCategory getCategoryModelById(Integer categoryid) {
        if (null == categoryid) {
            return null;
        }
        try {
            return this.infCategoryMapper.selectByPrimaryKey(categoryid);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.getCategoryModelById", (Throwable)e);
            return null;
        }
    }

    private List<InfCategory> queryCategoryModelPage(Map<String, Object> parammap) {
        try {
            return this.infCategoryMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryCategoryModel", (Throwable)e);
            return null;
        }
    }

    private int countCategory(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infCategoryMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.countCategory", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfCategory getCategory(Integer categoryid) {
        return this.getCategoryModelById(categoryid);
    }

    @Override
    public QueryResult<InfCategory> queryCategoryPage(Map<String, Object> map) {
        List<InfCategory> infCategoryList = this.queryCategoryModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCategory(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infCategoryList);
        return queryResult;
    }

    @Override
    public List<InfCategory> queryCategoryByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo * pageSize);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfCategory> infCategoryQueryResult = this.queryCategoryPage(map);
        List infCategoryList = infCategoryQueryResult.getList();
        return infCategoryList;
    }

    @Override
    public void inertCategoryByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            DisUtil.del((String)this.fujiCategoryKey);
            pageNo = "0";
            pageSize = "5";
            tenantCode = "2019071800001392";
        }
        boolean flag = false;
        if ("0".equals(pageNo) && "5".equals(pageSize)) {
            flag = true;
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiCategoryKey);
        this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.start", (Object)("\u540c\u6b65\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> errorAddCats = new ArrayList<String>();
        while (true) {
            long requestTime = System.currentTimeMillis();
            String jsonResult = null;
            try {
                jsonResult = HttpRequest.httpPost("/qj/queryCategoryByPage", pn, ps, lasttime);
                if (StringUtils.isBlank((String)jsonResult)) {
                    this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.httpPost.queryCategoryByPage", (Object)"response is null");
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.httpPost.queryCategoryByPage.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
                return;
            }
            long responseTime = System.currentTimeMillis();
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.httpPost.time", (Object)("===========\u8bf7\u6c42\u7684\u65f6\u95f4:" + (responseTime - requestTime)));
            Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
            if (!"S".equals(mapResult.get("resCode"))) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.httpPost.queryCategoryByPage.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
                return;
            }
            Object dataStr = mapResult.get("dataStr");
            if (dataStr == null) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.httpPost.queryCategoryByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
                return;
            }
            List infCategories = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(dataStr.toString(), InfCategory.class);
            if (ListUtil.isEmpty((Collection)infCategories)) {
                if (ListUtil.isEmpty(errorAddCats)) {
                    DisUtil.set((String)this.fujiCategoryKey, (String)sdf.format(new Date()));
                }
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiCategoryKey) + "\uff0c\u9519\u8bef\u7684\u5206\u7c7berrorAddCat:" + JsonUtil.buildNormalBinder().toJson(errorAddCats)));
                return;
            }
            for (InfCategory infCategory : infCategories) {
                map.clear();
                map.put("classtreeName", infCategory.getCategoryname());
                map.put("tenantCode", tenantCode);
                String rsClasstreeStr = null;
                try {
                    rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.getClasstreeByName", map);
                }
                catch (Exception e) {
                    this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.getClasstreeByName.e", (Object)("\u67e5\u8be2\u5206\u7c7b\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map:" + map + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiCategoryKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                if (StringUtils.isNotBlank((String)rsClasstreeStr)) {
                    RsClasstree rsClasstree = (RsClasstree)JsonUtil.buildNonDefaultBinder().getJsonToObject(rsClasstreeStr, RsClasstree.class);
                    if (!StringUtils.isBlank((String)rsClasstree.getPntreeCode())) continue;
                    this.queryOneClasstree(rsClasstree);
                    rsClasstree.setPntreeCode(this.pntreeCode);
                    RsClasstreeDomain rsClasstreeDomain = this.makeClassTreeDomain(rsClasstree);
                    map.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
                    this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.updateClasstree", (Object)("===========================rsClasstreeDomain:" + JsonUtil.buildNonDefaultBinder().toJson((Object)rsClasstreeDomain)));
                    try {
                        this.getInternalRouter().inInvoke("rs.rsClasstree.updateClasstree", map);
                    }
                    catch (Exception e) {
                        errorAddCats.add(infCategory.getCategoryid().toString());
                        this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.updateClasstree.e", (Object)("\u5df2\u5b58\u5728\u5206\u7c7b,\u66f4\u65b0\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2map:" + map + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiCategoryKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    }
                    this.pntreeCode = "";
                    continue;
                }
                this.saveClassTree(infCategory, tenantCode, null);
                if (StringUtils.isBlank((String)this.pntreeCode)) {
                    errorAddCats.add(infCategory.getCategoryid().toString());
                    this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.saveClassTree", (Object)("\u540c\u6b65\u5931\u8d25\uff01\uff01\uff01infCategory\uff1a" + JsonUtil.buildNonDefaultBinder().toJson((Object)infCategory) + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiCategoryKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    continue;
                }
                map.clear();
                map.put("classtreeName", infCategory.getCategoryname());
                map.put("pntreeCode", this.pntreeCode);
                map.put("tenantCode", tenantCode);
                try {
                    this.getInternalRouter().inInvoke("rs.rsClasstree.updateClasstreePtreeCode", map);
                }
                catch (Exception e) {
                    errorAddCats.add(infCategory.getCategoryid().toString());
                    this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.updateClasstreePtreeCode.e", (Object)("\u672a\u5b58\u5728\u5206\u7c7b\uff0c\u6dfb\u52a0,\u66f4\u65b0\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2map:" + map + ",\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiCategoryKey)));
                }
                this.pntreeCode = "";
            }
            long endTime = System.currentTimeMillis();
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.time", (Object)("===========\u65b9\u6cd5\u63d2\u5165\u65f6\u95f4:" + (endTime - requestTime)));
            if (flag) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.test", (Object)"\u6d4b\u8bd5\u7ed3\u675f\uff01\uff01\uff01");
                return;
            }
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }

    @Override
    public Boolean insertOneCategory(String categoryid, String tenantCode, InfCategory infCategory) {
        if (infCategory == null && (infCategory = this.queryCategory(Integer.valueOf(categoryid))) == null) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.insertOneCategory", (Object)("\u67e5\u8be2\u5931\u8d25categoryid\uff1a" + categoryid));
            return false;
        }
        this.saveClassTree(infCategory, tenantCode, null);
        if (StringUtils.isBlank((String)this.pntreeCode)) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.insertOneCategory.saveClassTree", (Object)("\u540c\u6b65\u5931\u8d25\uff01\uff01\uff01infCategory\uff1a" + JsonUtil.buildNonDefaultBinder().toJson((Object)infCategory)));
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("classtreeName", infCategory.getCategoryname());
        map.put("pntreeCode", this.pntreeCode);
        map.put("tenantCode", tenantCode);
        try {
            this.getInternalRouter().inInvoke("rs.rsClasstree.updateClasstreePtreeCode", map);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.insertOneCategory.updateClasstreePtreeCode.e", (Object)("\u672a\u5b58\u5728\u5206\u7c7b\uff0c\u6dfb\u52a0,\u66f4\u65b0\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2map:" + map));
        }
        this.pntreeCode = "";
        return true;
    }

    public void saveClassTree(InfCategory infCategory, String tenantCode, String classtreeCodeStr) {
        RsClasstreeDomain rsClasstreeDomainStr = new RsClasstreeDomain();
        if (infCategory.getDeptlevelid() == 1) {
            rsClasstreeDomainStr.setClasstreeParentcode("-1");
            rsClasstreeDomainStr.setClasstreeLast("0");
        }
        rsClasstreeDomainStr.setClasstreeLast("0");
        rsClasstreeDomainStr.setClasstreeType("0");
        rsClasstreeDomainStr.setClasstreeName(infCategory.getCategoryname());
        rsClasstreeDomainStr.setClasstreeEocode(infCategory.getCategoryid().toString());
        rsClasstreeDomainStr.setTenantCode(tenantCode);
        String classtreeCode = this.saveClasstree(rsClasstreeDomainStr);
        if (StringUtils.isBlank((String)classtreeCode)) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.saveClassTree", (Object)("\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsClasstreeDomainStr:" + JsonUtil.buildNonDefaultBinder().toJson((Object)rsClasstreeDomainStr)));
            return;
        }
        if (StringUtils.isNotBlank((String)classtreeCodeStr)) {
            this.updateClasstreeParentcode(classtreeCodeStr, classtreeCode, tenantCode);
        }
        if (infCategory.getDeptlevelid() == 1) {
            HashMap<String, String> map = new HashMap<String, String>();
            RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
            rsPntreeDomain.setPntreeName(infCategory.getCategoryname());
            rsPntreeDomain.setPntreeStep(1);
            rsPntreeDomain.setPntreeParentcode("-1");
            rsPntreeDomain.setPntreeEocode(infCategory.getCategoryid().toString());
            rsPntreeDomain.setTenantCode(tenantCode);
            map.put("rsPntreeDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsPntreeDomain));
            this.pntreeCode = (String)this.getInternalRouter().inInvoke("rs.pntree.savePntree", map);
            if (StringUtils.isBlank((String)this.pntreeCode)) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.savePntree", (Object)("\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsPntreeDomain\uff1a" + JsonUtil.buildNonDefaultBinder().toJson((Object)rsPntreeDomain)));
            }
            return;
        }
        InfCategory category = this.queryCategory(infCategory.getHeadcatid());
        if (category == null) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryCategory", (Object)("\u67e5\u8be2\u5931\u8d25\uff01Headcatid:" + infCategory.getHeadcatid()));
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("classtreeName", category.getCategoryname());
        map.put("tenantCode", tenantCode);
        String rsClasstreeStr = null;
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.getClasstreeByName", map);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.savePntree.getClasstreeByName.e", (Object)("\u6839\u636e\u540d\u79f0\u83b7\u53d6\u5206\u7c7b\u5f02\u5e38\uff01\uff01\uff01map:" + map));
            return;
        }
        RsClasstree rsClasstree = (RsClasstree)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, RsClasstree.class);
        if (rsClasstree == null) {
            this.saveClassTree(category, tenantCode, classtreeCode);
        } else {
            this.updateClasstreeParentcode(classtreeCode, rsClasstree.getClasstreeCode(), rsClasstree.getTenantCode());
            this.queryOneClasstree(rsClasstree);
        }
    }

    public void queryOneClasstree(RsClasstree rsClasstree) {
        if ("-1".equals(rsClasstree.getClasstreeParentcode())) {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> mapStr = new HashMap<String, String>();
            mapStr.put("pntreeName", rsClasstree.getClasstreeName());
            mapStr.put("tenantCode", rsClasstree.getTenantCode());
            map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
            String pntreeJson = null;
            try {
                pntreeJson = (String)this.getInternalRouter().inInvoke("rs.pntree.queryPntreePage", map);
            }
            catch (Exception e) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryOneClasstree.queryPntreePage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2map:" + map));
                return;
            }
            SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(pntreeJson, SupQueryResult.class);
            List rsPntreeStrList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsPntree.class);
            if (ListUtil.isEmpty((Collection)rsPntreeStrList)) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryOneClasstree.queryPntreePage", (Object)("\u67e5\u8be2\u5931\u8d25\uff01\uff01\uff01map:" + mapStr));
                return;
            }
            this.pntreeCode = ((RsPntree)rsPntreeStrList.get(0)).getPntreeCode();
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("classtreeCode", rsClasstree.getClasstreeParentcode());
        mapStr.put("tenantCode", rsClasstree.getTenantCode());
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String rsClasstreeJson = null;
        try {
            rsClasstreeJson = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryOneClasstree.queryClasstreePage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2map:" + map));
            return;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeJson, SupQueryResult.class);
        List rsClasstreeList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstreeList)) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.queryOneClasstree.queryClasstreePage", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01\u5165\u53c2map:" + map));
            return;
        }
        this.queryOneClasstree((RsClasstree)rsClasstreeList.get(0));
    }

    public void updateClasstreeParentcode(String classtreeCode, String classtreeParentcode, String tenantCode) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("classtreeCode", classtreeCode);
        mapStr.put("classtreeParentcode", classtreeParentcode);
        mapStr.put("tenantCode", tenantCode);
        try {
            this.getInternalRouter().inInvoke("rs.rsClasstree.updateclasstreeParentcode", mapStr);
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.updateClasstreeParentcod.updateclasstreeParentcode.e", (Object)("\u66f4\u65b0\u5f02\u5e38\uff01\uff01\uff01\uff0c\u5165\u53c2mapStr:" + mapStr));
        }
    }

    public String saveClasstree(RsClasstreeDomain rsClasstreeDomain) {
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)rsClasstreeDomain.getTenantCode());
        rsClasstreeDomain.setMemberCode(memberCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
        String classtreeCode = "";
        try {
            classtreeCode = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.saveClasstree", map);
            if (StringUtils.isBlank((String)classtreeCode)) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.saveClasstree", (Object)("\u65b0\u589e\u5931\u8d25\uff01\uff01\uff01\u5165\u53c2rsClasstreeDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain)));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.inertCategoryByPage.saveClasstree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u5165\u53c2rsClasstreeDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain)));
        }
        return classtreeCode;
    }

    private InfCategory queryCategory(Integer headcatid) {
        InfCategory infCategory = new InfCategory();
        infCategory.setCategoryid(headcatid);
        String jsonResult = null;
        try {
            jsonResult = HttpOneRequest.httpPost("/qj/queryCategoryById", infCategory);
            if (StringUtils.isBlank((String)jsonResult)) {
                this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.httpPost.queryCategoryById", (Object)"response is null");
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.httpPost.queryCategoryById.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
            return null;
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.httpPost.queryCategoryById.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
            return null;
        }
        Object dataStr = mapResult.get("dataStr");
        if (dataStr == null) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.httpPost.queryCategoryById.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
            return null;
        }
        return (InfCategory)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataStr.toString(), InfCategory.class);
    }

    private RsClasstreeDomain makeClassTreeDomain(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return null;
        }
        RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeDomain, (Object)rsClasstree);
            return rsClasstreeDomain;
        }
        catch (Exception e) {
            this.logger.error("service.adpter.fiji.InfCategoryServiceImpl.makeClassTreeDomain", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        String format = sdf1.format(date);
        long time = date.getTime();
        System.out.println("\u5206\u7c7b\u540c\u6b65\u5f00\u59cb\u65f6\u95f4\uff1a" + sdf.format(date));
        String jsonResult = null;
        try {
            jsonResult = HttpRequest.httpPost("/qj/queryCategoryByPage", 0, 5, null);
            if (StringUtils.isBlank((String)jsonResult)) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        Date date1 = new Date();
        long time1 = date1.getTime();
        System.out.println("\u54c1\u724c\u540c\u6b65\u7ed3\u675f\u65f6\u95f4\uff1a" + sdf.format(date1));
        System.out.println("=====================");
        System.out.println("\u65f6\u95f4\u5dee\uff1a" + (time1 - time));
        System.out.println(jsonResult);
    }
}

