/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfGoodsMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.InfGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsBrand;
import com.yqbsoft.laser.service.adapter.fuji.model.RsClasstree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsGoodsClass;
import com.yqbsoft.laser.service.adapter.fuji.model.RsPntree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsResourceGoods;
import com.yqbsoft.laser.service.adapter.fuji.service.InfBrandService;
import com.yqbsoft.laser.service.adapter.fuji.service.InfCategoryService;
import com.yqbsoft.laser.service.adapter.fuji.service.InfGoodsService;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpOneRequest;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpRequest;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfGoodsServiceImpl
extends BaseServiceImpl
implements InfGoodsService {
    private static final String SYS_CODE = "service.adapter.fuji.InfGoodsServiceImpl";
    private InfGoodsMapper infGoodsMapper;
    private InfBrandService infBrandService;
    private InfCategoryService infCategoryService;
    private String fujiGoodsKey = "fujiGoods";

    public void setInfBrandService(InfBrandService infBrandService) {
        this.infBrandService = infBrandService;
    }

    public void setInfCategoryService(InfCategoryService infCategoryService) {
        this.infCategoryService = infCategoryService;
    }

    public void setInfGoodsMapper(InfGoodsMapper infGoodsMapper) {
        this.infGoodsMapper = infGoodsMapper;
    }

    private InfGoods getGoodsModelById(String goodsId) {
        if (null == goodsId) {
            return null;
        }
        try {
            return this.infGoodsMapper.selectByPrimaryKey(goodsId);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.getGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private InfGoods getGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.infGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.getGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private List<InfGoods> queryGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.infGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.countGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfGoods getGoods(String goodsId) {
        return this.getGoodsModelById(goodsId);
    }

    @Override
    public QueryResult<InfGoods> queryGoodsPage(Map<String, Object> map) {
        List<InfGoods> infGoodsList = this.queryGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infGoodsList);
        return queryResult;
    }

    @Override
    public InfGoods getGoodsByCode(String goodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        return this.getGoodsModelByCode(map);
    }

    @Override
    public void inertGoodsByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            DisUtil.del((String)this.fujiGoodsKey);
            pageNo = "0";
            pageSize = "50";
            tenantCode = "2019071800001392";
        }
        boolean flag = false;
        if ("0".equals(pageNo) && "5".equals(pageSize)) {
            flag = true;
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiGoodsKey);
        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.start", (Object)("\u540c\u6b65\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> errorAddGoods = new ArrayList<String>();
        while (true) {
            long requestTime = System.currentTimeMillis();
            String jsonResult = null;
            try {
                jsonResult = HttpRequest.httpPost("/qj/queryGoodsByPage", pn, ps, lasttime);
                if (StringUtils.isBlank((String)jsonResult)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage", (Object)"response is null");
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
                return;
            }
            long responseTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.time", (Object)("===========\u8bf7\u6c42\u7684\u65f6\u95f4:" + (responseTime - requestTime)));
            Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
            if (!"S".equals(mapResult.get("resCode"))) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
                return;
            }
            Object dataStr = mapResult.get("dataStr");
            if (dataStr == null) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
                return;
            }
            List infGoodsList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(dataStr.toString(), InfGoods.class);
            if (ListUtil.isEmpty((Collection)infGoodsList)) {
                if (ListUtil.isEmpty(errorAddGoods)) {
                    DisUtil.set((String)this.fujiGoodsKey, (String)sdf.format(new Date()));
                }
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiGoodsKey) + ",\u9519\u8bef\u7684\u5546\u54c1errorAddGoods:" + JsonUtil.buildNormalBinder().toJson(errorAddGoods)));
                return;
            }
            goodsList.clear();
            for (InfGoods infGoods : infGoodsList) {
                map.clear();
                map.put("goodsNo", infGoods.getGoodsid());
                map.put("tenantCode", tenantCode);
                List resourceGoodsList = null;
                try {
                    String resourceGoodsListStr = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.checkGoodsNo", map);
                    resourceGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(resourceGoodsListStr, RsResourceGoods.class);
                }
                catch (Exception e) {
                    this.logger.error(".inertGoodsByPage.checkGoodsNoApiCode.resourceGoodsList", (Object)(resourceGoodsList + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                if (!ListUtil.isEmpty((Collection)resourceGoodsList)) continue;
                RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, tenantCode);
                if (rsResourceGoodsDomain == null) {
                    errorAddGoods.add(infGoods.getGoodsid());
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.checkGoods", (Object)"\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01");
                    continue;
                }
                goodsList.add(rsResourceGoodsDomain);
            }
            if (ListUtil.isNotEmpty(goodsList)) {
                map.clear();
                map.put("goodsList", JsonUtil.buildNonDefaultBinder().toJson(goodsList));
                try {
                    this.getInternalRouter().inInvoke("rs.resource.sendSavePassResourceGoodsBatch", map);
                }
                catch (Exception e) {
                    this.logger.error(".inertGoodsByPage.sendSavePassResourceGoodsBatch.e", (Object)("\u6279\u91cf\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01,\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiGoodsKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
            }
            long endTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.time", (Object)("===========\u65b9\u6cd5\u63d2\u5165\u65f6\u95f4:" + (endTime - requestTime)));
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }

    @Override
    public Boolean insertOneGoods(String goodsId, String tenantCode, InfGoods infGoods) {
        if (infGoods == null && (infGoods = this.queryGoods(goodsId)) == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.queryGoods", (Object)("\u67e5\u8be2\u5931\u8d25goodsId\uff1a" + goodsId));
            return false;
        }
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, tenantCode);
        if (rsResourceGoodsDomain == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.checkGoods", (Object)"\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01");
            return false;
        }
        goodsList.add(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(goodsList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsList", JsonUtil.buildNonDefaultBinder().toJson(goodsList));
            try {
                this.getInternalRouter().inInvoke("rs.resource.sendSavePassResourceGoodsBatch", map);
            }
            catch (Exception e) {
                this.logger.error(".insertOneGoods.sendSavePassResourceGoodsBatch.e", (Object)"\u6279\u91cf\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01");
                return false;
            }
        }
        return true;
    }

    private InfGoods queryGoods(String goodsId) {
        InfGoods infGoods1 = new InfGoods();
        infGoods1.setGoodsid(goodsId);
        String jsonResult = null;
        try {
            jsonResult = HttpOneRequest.httpPost("/qj/queryGoodsById", infGoods1);
            if (StringUtils.isBlank((String)jsonResult)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById", (Object)"response is null");
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
            return null;
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
            return null;
        }
        Object dataStr = mapResult.get("dataStr");
        if (dataStr == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
            return null;
        }
        return (InfGoods)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataStr.toString(), InfGoods.class);
    }

    public RsResourceGoodsDomain checkGoods(InfGoods infGoods, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> brandNameparamMap = new HashMap<String, String>();
        brandNameparamMap.put("brandEocode", infGoods.getBrandid().toString());
        brandNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandNameparamMap));
        String brandStr = "";
        try {
            brandStr = (String)this.getInternalRouter().inInvoke("rs.brand.queryBrandPage", map);
            if (StringUtils.isBlank((String)brandStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStrStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(brandStr, SupQueryResult.class);
        List rsBrands = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStrStr.getList()), RsBrand.class);
        if (ListUtil.isEmpty((Collection)rsBrands)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            return null;
        }
        RsBrand rsBrand = (RsBrand)rsBrands.get(0);
        map.clear();
        HashMap<String, String> classtreeNameparamMap = new HashMap<String, String>();
        classtreeNameparamMap.put("classtreeEocode", infGoods.getCategoryid().toString());
        classtreeNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeNameparamMap));
        String rsClasstreeStr = "";
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
            if (StringUtils.isBlank((String)rsClasstreeStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.rsClasstreeStr", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.checkClasstreeNameApiCode.rsClasstree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, SupQueryResult.class);
        List rsClasstrees = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstrees)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.rsClasstrees", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        RsClasstree rsClasstree = (RsClasstree)rsClasstrees.get(0);
        String pntreeCode = rsClasstree.getPntreeCode();
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.pntreeCode", (Object)("\u8be5\u5206\u7c7b\u6ca1\u6709\u5173\u8054\u7c7b\u522b\uff01\uff01\uff01rsClassTreeName:" + rsClasstree.getClasstreeName() + ",pntreeCode:" + pntreeCode));
            return null;
        }
        HashMap<String, String> pntreeCodeparamMap = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("pntreeCode", pntreeCode);
        mapStr.put("tenantCode", tenantCode);
        pntreeCodeparamMap.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        RsPntree rsPntree = null;
        try {
            String rsPntreeStr = (String)this.getInternalRouter().inInvoke("rs.pntree.getPntreeByCode", pntreeCodeparamMap);
            if (StringUtils.isBlank((String)rsPntreeStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.getPntreeByCodeApiCode.rsPntree", (Object)("rsPntreeStr:" + rsPntreeStr + ",\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
                return null;
            }
            rsPntree = (RsPntree)JsonUtil.buildNormalBinder().getJsonToObject(rsPntreeStr, RsPntree.class);
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.getPntreeByCodeApiCode.rsPntree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
            return null;
        }
        map.clear();
        mapStr.clear();
        mapStr.put("classtreeCode", rsClasstree.getClasstreeCode());
        mapStr.put("tenantCode", rsClasstree.getTenantCode());
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String goodsClassJson = "";
        try {
            goodsClassJson = (String)this.getInternalRouter().inInvoke("rs.goodsClass.queryGoodsClassPage", map);
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryGoodsClassPage.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map:" + mapStr));
            return null;
        }
        SupQueryResult supQueryResultGoodsClass = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(goodsClassJson, SupQueryResult.class);
        List goodsClassList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultGoodsClass.getList()), RsGoodsClass.class);
        return this.saveGoods(rsBrand, rsClasstree, rsPntree, null, infGoods, goodsClassList);
    }

    public RsResourceGoodsDomain saveGoods(RsBrand rsBrand, RsClasstree rsClasstree, RsPntree rsPntree, List<RsSpecValueDomain> rsSpecValueDomainsList, InfGoods infGoods, List<RsGoodsClass> goodsClassList) {
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsEocode(infGoods.getGoodsid());
        rsResourceGoodsDomain.setTenantCode(rsBrand.getTenantCode());
        rsResourceGoodsDomain.setBrandCode(rsBrand.getBrandCode());
        rsResourceGoodsDomain.setBrandName(rsBrand.getBrandName());
        rsResourceGoodsDomain.setPntreeCode(rsPntree.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(rsPntree.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(rsClasstree.getClasstreeName());
        rsResourceGoodsDomain.setGoodsNo(infGoods.getGoodscode());
        rsResourceGoodsDomain.setGoodsName(infGoods.getGoodsname());
        rsResourceGoodsDomain.setGoodsShowname(infGoods.getGoodsname());
        rsResourceGoodsDomain.setPricesetNprice(infGoods.getAdviceprice());
        if (ListUtil.isNotEmpty(goodsClassList)) {
            rsResourceGoodsDomain.setClasstreeShopcode(goodsClassList.get(0).getGoodsClassCode());
            rsResourceGoodsDomain.setClasstreeShopname(goodsClassList.get(0).getGoodsClassName());
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)rsBrand.getTenantCode());
        rsResourceGoodsDomain.setMemberCode(memberCode);
        rsResourceGoodsDomain.setMemberName(memberCode);
        rsResourceGoodsDomain.setProductareaName(infGoods.getProducingarea());
        rsResourceGoodsDomain.setGoodsPro("2");
        rsResourceGoodsDomain.setGoodsOrigin("0");
        rsResourceGoodsDomain.setGoodsType("00");
        rsResourceGoodsDomain.setGoodsCodeOld(infGoods.getGoodsid());
        ArrayList<RsSkuDomain> rsSkuDomainsList = new ArrayList<RsSkuDomain>();
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        rsSkuDomain.setSkuNo(infGoods.getGoodscode());
        rsSkuDomain.setSkuCodeOld(infGoods.getGoodsid());
        rsSkuDomain.setSkuName(infGoods.getGoodsname());
        rsSkuDomain.setPricesetNprice(infGoods.getAdviceprice());
        rsSkuDomain.setPricesetAsprice(infGoods.getAdvicecost());
        rsSkuDomain.setSkuBarcode(infGoods.getBarcode());
        rsSkuDomain.setGoodsWeight(new BigDecimal(infGoods.getGoodsweight()));
        rsSkuDomain.setTenantCode(rsBrand.getTenantCode());
        rsSkuDomain.setGoodsNo(infGoods.getGoodscode());
        rsSkuDomainsList.add(rsSkuDomain);
        rsSkuDomain.setSpecList(rsSpecValueDomainsList);
        if (ListUtil.isNotEmpty(goodsClassList)) {
            rsSkuDomain.setClasstreeShopcode(goodsClassList.get(0).getGoodsClassCode());
        }
        rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainsList);
        return rsResourceGoodsDomain;
    }

    @Override
    public List<InfGoods> queryGoodsByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo * pageSize);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfGoods> infGoodsQueryResult = this.queryGoodsPage(map);
        return infGoodsQueryResult.getList();
    }

    public static void main(String[] args) {
        String jsonResult = null;
        try {
            jsonResult = HttpRequest.httpPost("/qj/queryGoodsByPage", 0, 5, null);
            if (StringUtils.isBlank((String)jsonResult)) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            return;
        }
        System.out.println(mapResult.get("dataStr"));
    }
}

