/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfGoodsMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.InfGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsBrand;
import com.yqbsoft.laser.service.adapter.fuji.model.RsClasstree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsGoodsClass;
import com.yqbsoft.laser.service.adapter.fuji.model.RsPntree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsResourceGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSku;
import com.yqbsoft.laser.service.adapter.fuji.model.ViewChangeunitgoods;
import com.yqbsoft.laser.service.adapter.fuji.service.InfBrandService;
import com.yqbsoft.laser.service.adapter.fuji.service.InfCategoryService;
import com.yqbsoft.laser.service.adapter.fuji.service.InfGoodsService;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpOneRequest;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpRequest;
import com.yqbsoft.laser.service.adapter.fuji.utils.HttpRequestUtiles;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfGoodsServiceImpl
extends BaseServiceImpl
implements InfGoodsService {
    private static final String SYS_CODE = "service.adapter.fuji.InfGoodsServiceImpl";
    private InfGoodsMapper infGoodsMapper;
    private InfBrandService infBrandService;
    private InfCategoryService infCategoryService;
    private String fujiGoodsKey = "fujiGoods";

    public void setInfBrandService(InfBrandService infBrandService) {
        this.infBrandService = infBrandService;
    }

    public void setInfCategoryService(InfCategoryService infCategoryService) {
        this.infCategoryService = infCategoryService;
    }

    public void setInfGoodsMapper(InfGoodsMapper infGoodsMapper) {
        this.infGoodsMapper = infGoodsMapper;
    }

    private InfGoods getGoodsModelById(String goodsId) {
        if (null == goodsId) {
            return null;
        }
        try {
            return this.infGoodsMapper.selectByPrimaryKey(goodsId);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.getGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private InfGoods getGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.infGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.getGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private List<InfGoods> queryGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.infGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.countGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfGoods getGoods(String goodsId) {
        return this.getGoodsModelById(goodsId);
    }

    @Override
    public QueryResult<InfGoods> queryGoodsPage(Map<String, Object> map) {
        List<InfGoods> infGoodsList = this.queryGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infGoodsList);
        return queryResult;
    }

    @Override
    public InfGoods getGoodsByCode(String goodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        return this.getGoodsModelByCode(map);
    }

    @Override
    public void inertGoodsByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            DisUtil.del((String)this.fujiGoodsKey);
            pageNo = "0";
            pageSize = "50";
            tenantCode = "2019071800001392";
        }
        boolean flag = false;
        if ("0".equals(pageNo) && "5".equals(pageSize)) {
            flag = true;
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiGoodsKey);
        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.start", (Object)("\u540c\u6b65\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> errorAddGoods = new ArrayList<String>();
        while (true) {
            long requestTime = System.currentTimeMillis();
            String jsonResult = null;
            try {
                jsonResult = HttpRequest.httpPost("/qj/queryGoodsByPage", pn, ps, null, lasttime);
                if (StringUtils.isBlank((String)jsonResult)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage", (Object)"response is null");
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
                return;
            }
            long responseTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.time", (Object)("===========\u8bf7\u6c42\u7684\u65f6\u95f4:" + (responseTime - requestTime)));
            Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
            if (!"S".equals(mapResult.get("resCode"))) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
                return;
            }
            Object dataStr = mapResult.get("dataStr");
            if (dataStr == null) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
                return;
            }
            List infGoodsList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(dataStr.toString(), InfGoods.class);
            if (ListUtil.isEmpty((Collection)infGoodsList)) {
                if (ListUtil.isEmpty(errorAddGoods)) {
                    DisUtil.set((String)this.fujiGoodsKey, (String)sdf.format(new Date()));
                }
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiGoodsKey) + ",\u9519\u8bef\u7684\u5546\u54c1errorAddGoods:" + JsonUtil.buildNormalBinder().toJson(errorAddGoods)));
                return;
            }
            goodsList.clear();
            for (InfGoods infGoods : infGoodsList) {
                map.clear();
                map.put("goodsNo", infGoods.getGoodsid());
                map.put("tenantCode", tenantCode);
                List resourceGoodsList = null;
                try {
                    String resourceGoodsListStr = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.checkGoodsNo", map);
                    resourceGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(resourceGoodsListStr, RsResourceGoods.class);
                }
                catch (Exception e) {
                    this.logger.error(".inertGoodsByPage.checkGoodsNoApiCode.resourceGoodsList", (Object)(resourceGoodsList + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                if (!ListUtil.isEmpty((Collection)resourceGoodsList)) continue;
                RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, false, null, tenantCode);
                if (rsResourceGoodsDomain == null) {
                    errorAddGoods.add(infGoods.getGoodsid());
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.checkGoods", (Object)"\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01");
                    continue;
                }
                goodsList.add(rsResourceGoodsDomain);
            }
            if (ListUtil.isNotEmpty(goodsList)) {
                map.clear();
                map.put("goodsList", JsonUtil.buildNonDefaultBinder().toJson(goodsList));
                try {
                    this.getInternalRouter().inInvoke("rs.resource.sendSavePassResourceGoodsBatch", map);
                }
                catch (Exception e) {
                    this.logger.error(".inertGoodsByPage.sendSavePassResourceGoodsBatch.e", (Object)("\u6279\u91cf\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01,\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiGoodsKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
            }
            long endTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.time", (Object)("===========\u65b9\u6cd5\u63d2\u5165\u65f6\u95f4:" + (endTime - requestTime)));
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }

    public void updateGoods() {
    }

    @Override
    public Boolean insertOneGoods(String goodsId, String tenantCode, InfGoods infGoods) {
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode));
            return false;
        }
        if (infGoods == null && (infGoods = this.queryGoods(goodsId, requestUrl)) == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.queryGoods", (Object)("\u67e5\u8be2\u5931\u8d25goodsId\uff1a" + goodsId));
            return false;
        }
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, false, null, tenantCode);
        if (rsResourceGoodsDomain == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.checkGoods", (Object)"\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01");
            return false;
        }
        goodsList.add(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(goodsList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsList", JsonUtil.buildNonDefaultBinder().toJson(goodsList));
            try {
                this.getInternalRouter().inInvoke("rs.resource.sendSavePassResourceGoodsBatch", map);
            }
            catch (Exception e) {
                this.logger.error(".insertOneGoods.sendSavePassResourceGoodsBatch.e", (Object)"\u6279\u91cf\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01");
                return false;
            }
        }
        return true;
    }

    @Override
    public String saveExcelGoods(String goodsCode, String barCode, String goodsName, String brandFlag, String categoryFlag, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)barCode) || StringUtils.isBlank((String)goodsName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.intoparam", (Object)("\u5165\u53c2\u4e3a\u7a7agoodsCode:" + goodsCode + ",barCode:" + barCode + ",goodsName:" + goodsName + ",tenantCode:" + tenantCode));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u5b58\u5728\u7a7a\u503c\uff01goodsCode:" + goodsCode + ",barCode:" + barCode + ",goodsName:" + goodsName + ",tenantCode:" + tenantCode);
        }
        if ("1".equals(brandFlag)) {
            try {
                this.infBrandService.inertBrandByPage("1", "10", tenantCode);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.inertBrandByPage.e", (Object)"\u6dfb\u52a0\u54c1\u724c\u5f02\u5e38\uff01\uff01\uff01");
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u54c1\u724c\u5931\u8d25\uff01\uff01\uff01goodsCode:" + goodsCode + ",barCode:" + barCode + ",goodsName:" + goodsName + ",tenantCode:" + tenantCode);
            }
        }
        if ("1".equals(categoryFlag)) {
            try {
                this.infCategoryService.inertCategoryByPage("1", "10", tenantCode);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.inertCategoryByPage.e", (Object)"\u6dfb\u52a0\u5206\u7c7b\u5f02\u5e38\uff01\uff01\uff01");
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u5206\u7c7b\u5931\u8d25\uff01\uff01\uff01goodsCode:" + goodsCode + ",barCode:" + barCode + ",goodsName:" + goodsName + ",tenantCode:" + tenantCode);
            }
        }
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u67e5\u8be2\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        InfGoods infGoods = this.queryGoods(goodsCode, requestUrl);
        if (infGoods == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.getGoodsByCode", (Object)("\u6839\u636egoodsCode\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01goodsCode:" + goodsCode));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u83b7\u53d6\u8be5\u5546\u54c1\u5931\u8d25\uff01\uff01\uff01");
        }
        List<ViewChangeunitgoods> viewChangeunitgoodsList = this.queryViewChangeunitgoods(infGoods.getGoodscode());
        if (ListUtil.isEmpty(viewChangeunitgoodsList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> mapStr = new HashMap<String, String>();
            mapStr.put("skuNo", infGoods.getGoodsid());
            mapStr.put("goodsOrigin", "0");
            mapStr.put("tenantCode", tenantCode);
            map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
            String skuJson = "";
            try {
                skuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", map);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01");
            }
            SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuJson, SupQueryResult.class);
            List rsSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsSkuDomain.class);
            if (ListUtil.isNotEmpty((Collection)rsSkuDomainList)) {
                return this.responseAddGoods("success", goodsCode, barCode, goodsName, "\u5546\u54c1\u5df2\u5b58\u5728\uff01\uff01\uff01\u5982\u82e5\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u8bf7\u5728\u9875\u9762\u64cd\u4f5c\uff01\uff01\uff01");
            }
            String msg = this.sendSavePassResourceGoodsBatch(infGoods, false, null, tenantCode);
            if (!"success".equals(msg)) {
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, msg);
            }
            return this.responseAddGoods("success", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u6210\u529f\uff01\uff01\uff01");
        }
        ViewChangeunitgoods viewChangeunitgoods = viewChangeunitgoodsList.get(0);
        InfGoods momtherGoods = this.queryGoods(viewChangeunitgoods.getMgoodsid(), requestUrl);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("skuNo", momtherGoods.getGoodsid());
        mapStr.put("goodsOrigin", "0");
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String skuJson = "";
        try {
            skuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u8be5\u5546\u54c1\u662f\u5b50\u5546\u54c1\uff0c\u67e5\u8be2\u6bcd\u5546\u54c1sku\u5f02\u5e38\uff01\uff01\uff01");
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuJson, SupQueryResult.class);
        List rsSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsSkuDomain.class);
        RsSkuDomain rsSkuMomDomain = null;
        if (ListUtil.isEmpty((Collection)rsSkuDomainList)) {
            String msg = this.sendSavePassResourceGoodsBatch(momtherGoods, false, null, tenantCode);
            if (!"success".equals(msg)) {
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u6bcd\u5546\u54c1:" + msg);
            }
            HashMap<String, String> queryMomGoodsMap = new HashMap<String, String>();
            HashMap<String, String> queryMomGoodsMapStr = new HashMap<String, String>();
            queryMomGoodsMapStr.put("skuNo", momtherGoods.getGoodsid());
            queryMomGoodsMapStr.put("goodsOrigin", "0");
            queryMomGoodsMapStr.put("tenantCode", tenantCode);
            queryMomGoodsMap.put("map", JsonUtil.buildNormalBinder().toJson(queryMomGoodsMapStr));
            String querySkuJson = "";
            try {
                querySkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", queryMomGoodsMap);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u8be5\u5546\u54c1\u662f\u5b50\u5546\u54c1\uff0c\u6dfb\u52a0\u6bcd\u5546\u54c1\u4e4b\u540e\u67e5\u8be2\u6bcd\u5546\u54c1sku\u5f02\u5e38\uff01\uff01\uff01");
            }
            SupQueryResult queryMomQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(querySkuJson, SupQueryResult.class);
            List queryMomDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryMomQueryResultStr.getList()), RsSkuDomain.class);
            rsSkuMomDomain = (RsSkuDomain)queryMomDomainList.get(0);
        } else {
            rsSkuMomDomain = (RsSkuDomain)rsSkuDomainList.get(0);
        }
        HashMap<String, String> childMap = new HashMap<String, String>();
        HashMap<String, String> childMapStr = new HashMap<String, String>();
        childMapStr.put("skuNo", infGoods.getGoodsid());
        childMapStr.put("goodsOrigin", "20");
        childMapStr.put("tenantCode", tenantCode);
        childMap.put("map", JsonUtil.buildNormalBinder().toJson(childMapStr));
        String skuChildJson = "";
        try {
            skuChildJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", childMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u8be5\u5546\u54c1\u662f\u5b50\u5546\u54c1\uff0c\u67e5\u8be2\u5b50\u5546\u54c1sku\u5f02\u5e38\uff01\uff01\uff01");
        }
        SupQueryResult supChileQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuChildJson, SupQueryResult.class);
        List rsSkuChildDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supChileQueryResultStr.getList()), RsSkuDomain.class);
        if (ListUtil.isEmpty((Collection)rsSkuChildDomainList)) {
            String msg = this.sendSavePassResourceGoodsBatch(infGoods, true, rsSkuMomDomain, tenantCode);
            if (!"success".equals(msg)) {
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u5b50\u5546\u54c1\u548c\u6bcd\u5b50\u5173\u7cfb:" + msg);
            }
            return this.responseAddGoods("success", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u5b50\u5546\u54c1\u6210\u529f\u5e76\u6dfb\u52a0\u6bcd\u5b50\u5173\u7cfb\u6210\u529f\uff01\uff01\uff01");
        }
        RsSkuDomain rsSkuChildDomain = (RsSkuDomain)rsSkuChildDomainList.get(0);
        Boolean goodsReslFlag = this.saveGoodsRel(rsSkuMomDomain, rsSkuChildDomain);
        if (!goodsReslFlag.booleanValue()) {
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u5b50\u5546\u54c1\u5df2\u5b58\u5728\uff0c\u4f46\u6dfb\u52a0\u6bcd\u5b50\u5173\u7cfb\u5931\u8d25");
        }
        return this.responseAddGoods("success", goodsCode, barCode, goodsName, "\u5b50\u5546\u54c1\u5df2\u5b58\u5728\u5e76\u6dfb\u52a0\u6bcd\u5b50\u5173\u7cfb\u6210\u529f\uff01\uff01\uff01");
    }

    public Boolean saveGoodsRel(RsSkuDomain rsSkuMomDomain, RsSkuDomain rsSkuChildDomain) {
        RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
        rsGoodsRelDomain.setGoodsCode(rsSkuChildDomain.getGoodsCode());
        rsGoodsRelDomain.setGoodsRelGcode(rsSkuMomDomain.getGoodsCode());
        rsGoodsRelDomain.setGoodsRelType("4");
        rsGoodsRelDomain.setMemberCode(rsSkuMomDomain.getMemberCcode());
        rsGoodsRelDomain.setMemberName(rsSkuMomDomain.getMemberCname());
        rsGoodsRelDomain.setSkuCode(rsSkuMomDomain.getSkuCode());
        rsGoodsRelDomain.setSkuName(rsSkuMomDomain.getSkuName());
        rsGoodsRelDomain.setPricesetNprice(rsSkuMomDomain.getPricesetNprice());
        rsGoodsRelDomain.setGoodsNum(rsSkuMomDomain.getGoodsNum());
        rsGoodsRelDomain.setSkuNo(rsSkuMomDomain.getSkuNo());
        rsGoodsRelDomain.setDataPic(rsSkuMomDomain.getDataPic());
        rsGoodsRelDomain.setTenantCode(rsSkuMomDomain.getTenantCode());
        RsGoodsRelDomain rsGoodsRelDomainStr = new RsGoodsRelDomain();
        rsGoodsRelDomainStr.setGoodsSkuCode(rsSkuChildDomain.getSkuCode());
        rsGoodsRelDomainStr.setGoodsRelGcode(rsSkuMomDomain.getGoodsCode());
        rsGoodsRelDomainStr.setGoodsRelType("4");
        rsGoodsRelDomainStr.setMemberCode(rsSkuMomDomain.getMemberCcode());
        rsGoodsRelDomainStr.setMemberName(rsSkuMomDomain.getMemberCname());
        rsGoodsRelDomainStr.setSkuCode(rsSkuMomDomain.getSkuCode());
        rsGoodsRelDomainStr.setSkuName(rsSkuMomDomain.getSkuName());
        rsGoodsRelDomainStr.setPricesetNprice(rsSkuMomDomain.getPricesetNprice());
        rsGoodsRelDomainStr.setGoodsNum(rsSkuMomDomain.getGoodsNum());
        rsGoodsRelDomainStr.setSkuNo(rsSkuMomDomain.getSkuNo());
        rsGoodsRelDomainStr.setDataPic(rsSkuMomDomain.getDataPic());
        rsGoodsRelDomainStr.setTenantCode(rsSkuMomDomain.getTenantCode());
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        rsGoodsRelDomainList.add(rsGoodsRelDomain);
        rsGoodsRelDomainList.add(rsGoodsRelDomainStr);
        HashMap<String, String> saveGoodsRelMap = new HashMap<String, String>();
        saveGoodsRelMap.put("rsGoodsRelDomainList", JsonUtil.buildNonDefaultBinder().toJson(rsGoodsRelDomainList));
        try {
            String goodsRelJson = (String)this.getInternalRouter().inInvoke("rs.goodsOther.saveGoodsRelList", saveGoodsRelMap);
            if (StringUtils.isBlank((String)goodsRelJson)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl..saveExcelGoods.saveGoodsRel.saveGoodsRel", (Object)("\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01saveGoodsRelMap:" + saveGoodsRelMap));
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl..saveExcelGoods.saveGoodsRel.saveGoodsRel.e", (Object)("\u6dfb\u52a0\u5f02\u5e38\uff01\uff01\uff01saveGoodsRelMap:" + saveGoodsRelMap));
            return false;
        }
        return true;
    }

    public boolean queryMomGoodsAndChildGoods(InfGoods momtherGoods, InfGoods childGoods, String tenantCode) {
        HashMap<String, String> momSkuMap = new HashMap<String, String>();
        momSkuMap.put("skuNo", momtherGoods.getGoodsid());
        momSkuMap.put("tenantCode", tenantCode);
        String momSkusJson = "";
        try {
            momSkusJson = (String)this.getInternalRouter().inInvoke("rs.sku.checkSkuNo", momSkuMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryMomGoodsAndChildGoods.e", (Object)("\u67e5\u8be2sku\u5f02\u5e38\uff01\uff01\uff01momSkuMap:" + momSkuMap));
            return false;
        }
        List rsMomSkuList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(momSkusJson, RsSku.class);
        HashMap<String, String> childSkuMap = new HashMap<String, String>();
        childSkuMap.put("skuNo", momtherGoods.getGoodsid());
        childSkuMap.put("tenantCode", tenantCode);
        String childSkuJson = "";
        try {
            childSkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.checkSkuNo", childSkuMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryMomGoodsAndChildGoods.e", (Object)("\u67e5\u8be2sku\u5f02\u5e38\uff01\uff01\uff01momSkuMap:" + momSkuMap));
            return false;
        }
        List rsChildSkuList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(childSkuJson, RsSku.class);
        return true;
    }

    public Boolean makeUpdateGoodsAndSku(InfGoods infGoods, RsResourceGoods rsResourceGoods, RsSkuDomain rsSkuDomain, String tenantCode) {
        RsBrand rsBrand = this.queryBrand(infGoods, tenantCode);
        if (rsBrand == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.queryBrand", (Object)("\u83b7\u53d6\u54c1\u724c\u4e3a\u7a7a\uff01\uff01\uff01\u54c1\u724cID:" + infGoods.getBrandid()));
            return false;
        }
        RsClasstree rsClasstree = this.queryClasstree(infGoods, tenantCode);
        if (rsClasstree == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.queryClasstree", (Object)("\u83b7\u53d6\u54c1\u724c\u4e3a\u7a7a\uff01\uff01\uff01\u5206\u7c7bID:" + infGoods.getCategoryid()));
            return false;
        }
        RsPntree rsPntree = this.queryPntree(rsClasstree, tenantCode);
        if (rsPntree == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.queryPntree", (Object)("\u83b7\u53d6\u7c7b\u578b\u4e3a\u7a7a\uff01\uff01\uff01\u5206\u7c7bID:" + rsClasstree.getPntreeCode()));
            return false;
        }
        rsResourceGoods.setBrandCode(rsBrand.getBrandCode());
        rsResourceGoods.setBrandName(rsBrand.getBrandName());
        rsResourceGoods.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsResourceGoods.setClasstreeName(rsClasstree.getClasstreeName());
        rsResourceGoods.setPntreeCode(rsPntree.getPntreeCode());
        rsResourceGoods.setPntreeName(rsPntree.getPntreeName());
        rsResourceGoods.setProductareaName(infGoods.getProducingarea());
        rsResourceGoods.setGoodsName(infGoods.getGoodsname());
        rsResourceGoods.setPartsnameNumunit(infGoods.getUnitname());
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsResourceGoodsDomain, (Object)rsResourceGoods);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.makeResourceGoodsDomain", (Throwable)e);
            return false;
        }
        HashMap<String, String> updateResourceGoodsMap = new HashMap<String, String>();
        updateResourceGoodsMap.put("rsResourceGoodsDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsDomain));
        try {
            this.getInternalRouter().inInvoke("rs.resourceGoods.updateResourceGoods", updateResourceGoodsMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.updateResourceGoods.e", (Object)("\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01rsSkuDomain:" + JsonUtil.buildNonEmptyBinder().toJson((Object)rsSkuDomain)));
            return false;
        }
        RsSkuDomain rsSkuDomainStr = new RsSkuDomain();
        rsSkuDomainStr.setSkuId(rsSkuDomain.getSkuId());
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("rsSkuDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSkuDomainStr));
        this.getInternalRouter().inInvoke("rs.sku.updateSku", mapStr);
        rsSkuDomain.setSkuCodeOld(infGoods.getGoodsid());
        rsSkuDomain.setSkuName(infGoods.getGoodsspec());
        rsSkuDomain.setPricesetNprice(infGoods.getAdviceprice());
        rsSkuDomain.setPricesetAsprice(infGoods.getAdvicecost());
        rsSkuDomain.setGoodsWeight(new BigDecimal(infGoods.getGoodsweight()));
        rsSkuDomain.setPartsnameNumunit(infGoods.getUnitname());
        rsSkuDomain.setBrandCode(rsBrand.getBrandCode());
        rsSkuDomain.setBrandName(rsBrand.getBrandName());
        rsSkuDomain.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsSkuDomain.setPntreeCode(rsPntree.getPntreeCode());
        rsSkuDomain.setPntreeName(rsPntree.getPntreeName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsSkuDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSkuDomain));
        try {
            this.getInternalRouter().inInvoke("rs.sku.updateSku", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.updateSku.e", (Object)("\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01rsSkuDomain:" + JsonUtil.buildNonEmptyBinder().toJson((Object)rsSkuDomain)));
            return false;
        }
        return true;
    }

    public RsBrand queryBrand(InfGoods infGoods, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> brandNameparamMap = new HashMap<String, String>();
        brandNameparamMap.put("brandEocode", infGoods.getBrandid().toString());
        brandNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandNameparamMap));
        String brandStr = "";
        try {
            brandStr = (String)this.getInternalRouter().inInvoke("rs.brand.queryBrandPage", map);
            if (StringUtils.isBlank((String)brandStr)) {
                this.logger.error(".queryBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".queryBrand.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStrStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(brandStr, SupQueryResult.class);
        List rsBrands = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStrStr.getList()), RsBrand.class);
        if (ListUtil.isEmpty((Collection)rsBrands)) {
            this.logger.error(".queryBrand.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            return null;
        }
        return (RsBrand)rsBrands.get(0);
    }

    public RsClasstree queryClasstree(InfGoods infGoods, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> classtreeNameparamMap = new HashMap<String, String>();
        classtreeNameparamMap.put("classtreeEocode", infGoods.getCategoryid().toString());
        classtreeNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeNameparamMap));
        String rsClasstreeStr = "";
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
            if (StringUtils.isBlank((String)rsClasstreeStr)) {
                this.logger.error(".queryClasstree.rsClasstreeStr", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".queryClasstree.rsClasstree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, SupQueryResult.class);
        List rsClasstrees = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstrees)) {
            this.logger.error(".queryClasstree.rsClasstrees", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        return (RsClasstree)rsClasstrees.get(0);
    }

    public RsPntree queryPntree(RsClasstree rsClasstree, String tenantCode) {
        String pntreeCode = rsClasstree.getPntreeCode();
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(".queryPntree.pntreeCode", (Object)("\u8be5\u5206\u7c7b\u6ca1\u6709\u5173\u8054\u7c7b\u522b\uff01\uff01\uff01rsClassTreeName:" + rsClasstree.getClasstreeName() + ",pntreeCode:" + pntreeCode));
            return null;
        }
        HashMap<String, String> pntreeCodeparamMap = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("pntreeCode", pntreeCode);
        mapStr.put("tenantCode", tenantCode);
        pntreeCodeparamMap.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        RsPntree rsPntree = null;
        try {
            String rsPntreeStr = (String)this.getInternalRouter().inInvoke("rs.pntree.getPntreeByCode", pntreeCodeparamMap);
            if (StringUtils.isBlank((String)rsPntreeStr)) {
                this.logger.error(".queryPntree.rsPntree", (Object)("rsPntreeStr:" + rsPntreeStr + ",\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
                return null;
            }
            rsPntree = (RsPntree)JsonUtil.buildNormalBinder().getJsonToObject(rsPntreeStr, RsPntree.class);
        }
        catch (Exception e) {
            this.logger.error(".queryPntree.rsPntree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
            return null;
        }
        return rsPntree;
    }

    private String sendSavePassResourceGoodsBatch(InfGoods infGoods, boolean isChildFlag, RsSkuDomain rsSkuMomDomain, String tenantCode) {
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, isChildFlag, rsSkuMomDomain, tenantCode);
        if (rsResourceGoodsDomain == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoods", (Object)"\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01");
            return "\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01";
        }
        goodsList.add(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(goodsList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsList", JsonUtil.buildNonDefaultBinder().toJson(goodsList));
            try {
                this.getInternalRouter().inInvoke("rs.resource.sendSavePassResourceGoodsBatch", map);
            }
            catch (Exception e) {
                this.logger.error(".saveExcelGoods.sendSavePassResourceGoodsBatch.e", (Object)"\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01");
                return "\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01";
            }
        }
        return "success";
    }

    public String responseAddGoods(String result, String goodsCode, String barCode, String goodsName, String errorMsg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("result", result);
        HashMap<String, String> mapMsg = new HashMap<String, String>();
        mapMsg.put("goodsCode", goodsCode);
        mapMsg.put("barCode", barCode);
        mapMsg.put("goodsName", goodsName);
        mapMsg.put("errorMsg", errorMsg);
        map.put("msg", JsonUtil.buildNonEmptyBinder().toJson(mapMsg));
        return JsonUtil.buildNonEmptyBinder().toJson(map);
    }

    public List<ViewChangeunitgoods> queryViewChangeunitgoods(String zGoodsId) {
        ViewChangeunitgoods viewChangeunitgoods1 = new ViewChangeunitgoods();
        viewChangeunitgoods1.setzGoodsid(zGoodsId);
        String jsonResult = null;
        try {
            jsonResult = HttpOneRequest.httpPost("/qj/queryChildGoodsByZid", viewChangeunitgoods1);
            if (StringUtils.isBlank((String)jsonResult)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods", (Object)"response is null");
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
            return null;
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
            return null;
        }
        Object dataStr = mapResult.get("dataStr");
        if (dataStr == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
            return null;
        }
        return (List)JsonUtil.buildNonEmptyBinder().getJsonToList(dataStr.toString(), ViewChangeunitgoods.class);
    }

    private InfGoods queryGoods(String goodsId, String requestUrl) {
        InfGoods infGoodsRes = new InfGoods();
        infGoodsRes.setGoodsid(goodsId);
        String requestJson = JsonUtil.buildNonNullBinder().toJson((Object)infGoodsRes);
        String jsonResult = null;
        try {
            jsonResult = HttpRequestUtiles.httpPost("/qj/queryGoodsById", requestJson, requestUrl);
            if (StringUtils.isBlank((String)jsonResult)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById", (Object)("response is null,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById"));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.e", (Object)("\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById"));
            return null;
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.resCode", (Object)("respose is false,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById" + ",\u54cd\u5e94\u7ed3\u679c:" + jsonResult));
            return null;
        }
        Object dataStr = mapResult.get("dataStr");
        if (dataStr == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.dataStr", (Object)("dataStr is null\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById" + ",\u54cd\u5e94\u7ed3\u679c:" + jsonResult));
            return null;
        }
        return (InfGoods)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataStr.toString(), InfGoods.class);
    }

    public RsResourceGoodsDomain checkGoods(InfGoods infGoods, boolean isChildFlag, RsSkuDomain rsSkuMomDomain, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> brandNameparamMap = new HashMap<String, String>();
        brandNameparamMap.put("brandEocode", infGoods.getBrandid().toString());
        brandNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandNameparamMap));
        String brandStr = "";
        try {
            brandStr = (String)this.getInternalRouter().inInvoke("rs.brand.queryBrandPage", map);
            if (StringUtils.isBlank((String)brandStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStrStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(brandStr, SupQueryResult.class);
        List rsBrands = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStrStr.getList()), RsBrand.class);
        if (ListUtil.isEmpty((Collection)rsBrands)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            return null;
        }
        RsBrand rsBrand = (RsBrand)rsBrands.get(0);
        map.clear();
        HashMap<String, String> classtreeNameparamMap = new HashMap<String, String>();
        classtreeNameparamMap.put("classtreeEocode", infGoods.getCategoryid().toString());
        classtreeNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeNameparamMap));
        String rsClasstreeStr = "";
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
            if (StringUtils.isBlank((String)rsClasstreeStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.rsClasstreeStr", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.checkClasstreeNameApiCode.rsClasstree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, SupQueryResult.class);
        List rsClasstrees = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstrees)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.rsClasstrees", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        RsClasstree rsClasstree = (RsClasstree)rsClasstrees.get(0);
        String pntreeCode = rsClasstree.getPntreeCode();
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.pntreeCode", (Object)("\u8be5\u5206\u7c7b\u6ca1\u6709\u5173\u8054\u7c7b\u522b\uff01\uff01\uff01rsClassTreeName:" + rsClasstree.getClasstreeName() + ",pntreeCode:" + pntreeCode));
            return null;
        }
        HashMap<String, String> pntreeCodeparamMap = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("pntreeCode", pntreeCode);
        mapStr.put("tenantCode", tenantCode);
        pntreeCodeparamMap.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        RsPntree rsPntree = null;
        try {
            String rsPntreeStr = (String)this.getInternalRouter().inInvoke("rs.pntree.getPntreeByCode", pntreeCodeparamMap);
            if (StringUtils.isBlank((String)rsPntreeStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.getPntreeByCodeApiCode.rsPntree", (Object)("rsPntreeStr:" + rsPntreeStr + ",\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
                return null;
            }
            rsPntree = (RsPntree)JsonUtil.buildNormalBinder().getJsonToObject(rsPntreeStr, RsPntree.class);
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.getPntreeByCodeApiCode.rsPntree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
            return null;
        }
        map.clear();
        mapStr.clear();
        mapStr.put("classtreeCode", rsClasstree.getClasstreeCode());
        mapStr.put("tenantCode", rsClasstree.getTenantCode());
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String goodsClassJson = "";
        try {
            goodsClassJson = (String)this.getInternalRouter().inInvoke("rs.goodsClass.queryGoodsClassPage", map);
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryGoodsClassPage.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map:" + mapStr));
            return null;
        }
        SupQueryResult supQueryResultGoodsClass = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(goodsClassJson, SupQueryResult.class);
        List goodsClassList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultGoodsClass.getList()), RsGoodsClass.class);
        if (ListUtil.isEmpty((Collection)goodsClassList) || goodsClassList.size() != 1) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryGoodsClassPage", (Object)("\u6ca1\u6709\u5173\u8054\u7684\u5e97\u94fa\u5206\u7c7b\u6216\u8005\u5173\u8054\u591a\u4e2a\u5e97\u94fa\u5206\u7c7b\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map:" + mapStr));
            return null;
        }
        return this.saveGoods(rsBrand, rsClasstree, rsPntree, rsSkuMomDomain, null, infGoods, goodsClassList, isChildFlag);
    }

    public RsResourceGoodsDomain saveGoods(RsBrand rsBrand, RsClasstree rsClasstree, RsPntree rsPntree, RsSkuDomain rsSkuMomDomain, List<RsSpecValueDomain> rsSpecValueDomainsList, InfGoods infGoods, List<RsGoodsClass> goodsClassList, boolean isChildFlag) {
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsEocode(infGoods.getGoodsid());
        rsResourceGoodsDomain.setTenantCode(rsBrand.getTenantCode());
        rsResourceGoodsDomain.setBrandCode(rsBrand.getBrandCode());
        rsResourceGoodsDomain.setBrandName(rsBrand.getBrandName());
        rsResourceGoodsDomain.setPntreeCode(rsPntree.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(rsPntree.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(rsClasstree.getClasstreeName());
        rsResourceGoodsDomain.setGoodsNo(infGoods.getGoodsid());
        rsResourceGoodsDomain.setGoodsName(infGoods.getGoodsname());
        rsResourceGoodsDomain.setGoodsShowname(infGoods.getGoodsname());
        rsResourceGoodsDomain.setPricesetNprice(infGoods.getAdviceprice());
        if (ListUtil.isNotEmpty(goodsClassList)) {
            rsResourceGoodsDomain.setClasstreeShopcode(goodsClassList.get(0).getGoodsClassCode());
            rsResourceGoodsDomain.setClasstreeShopname(goodsClassList.get(0).getGoodsClassName());
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)rsBrand.getTenantCode());
        rsResourceGoodsDomain.setMemberCode(memberCode);
        rsResourceGoodsDomain.setMemberName(memberCode);
        rsResourceGoodsDomain.setMemberCode(memberCode);
        rsResourceGoodsDomain.setMemberName(memberCode);
        rsResourceGoodsDomain.setProductareaName(infGoods.getProducingarea());
        if (isChildFlag) {
            rsResourceGoodsDomain.setGoodsOrigin("20");
            rsResourceGoodsDomain.setGoodsPro("3");
        } else {
            rsResourceGoodsDomain.setGoodsOrigin("0");
        }
        rsResourceGoodsDomain.setGoodsType("00");
        rsResourceGoodsDomain.setGoodsCodeOld(infGoods.getGoodsid());
        ArrayList<RsSkuDomain> rsSkuDomainsList = new ArrayList<RsSkuDomain>();
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        rsSkuDomain.setSkuNo(infGoods.getGoodscode());
        rsSkuDomain.setSkuCodeOld(infGoods.getGoodsid());
        rsSkuDomain.setMemberCcode(rsResourceGoodsDomain.getMemberCcode());
        rsSkuDomain.setMemberCname(rsResourceGoodsDomain.getMemberCname());
        rsSkuDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
        rsSkuDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
        rsSkuDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
        rsSkuDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
        rsSkuDomain.setSkuName(infGoods.getGoodsspec());
        rsSkuDomain.setPricesetNprice(infGoods.getAdviceprice());
        rsSkuDomain.setPricesetAsprice(infGoods.getAdvicecost());
        rsSkuDomain.setSkuBarcode(infGoods.getBarcode());
        rsSkuDomain.setGoodsWeight(new BigDecimal(infGoods.getGoodsweight()));
        rsSkuDomain.setPartsnameNumunit(infGoods.getUnitname());
        rsSkuDomain.setTenantCode(rsBrand.getTenantCode());
        rsSkuDomain.setGoodsNo(infGoods.getGoodscode());
        rsSkuDomainsList.add(rsSkuDomain);
        rsSkuDomain.setSpecList(rsSpecValueDomainsList);
        if (ListUtil.isNotEmpty(goodsClassList)) {
            rsSkuDomain.setClasstreeShopcode(goodsClassList.get(0).getGoodsClassCode());
        }
        rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainsList);
        if (rsSkuMomDomain != null) {
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
            RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
            rsGoodsRelDomain.setGoodsRelGcode(rsSkuMomDomain.getGoodsCode());
            rsGoodsRelDomain.setGoodsRelType("4");
            rsGoodsRelDomain.setSkuCode(rsSkuMomDomain.getSkuCode());
            rsGoodsRelDomain.setSkuName(rsSkuMomDomain.getSkuName());
            rsGoodsRelDomain.setPricesetNprice(rsSkuMomDomain.getPricesetNprice());
            rsGoodsRelDomain.setSkuNo(rsSkuMomDomain.getSkuNo());
            rsGoodsRelDomain.setGoodsName(rsSkuMomDomain.getGoodsName());
            rsGoodsRelDomainList.add(rsGoodsRelDomain);
            rsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
            rsSkuDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
        }
        return rsResourceGoodsDomain;
    }

    @Override
    public List<InfGoods> queryGoodsByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo * pageSize);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfGoods> infGoodsQueryResult = this.queryGoodsPage(map);
        return infGoodsQueryResult.getList();
    }

    public static void main(String[] args) {
        InfGoodsServiceImpl infGoodsService = new InfGoodsServiceImpl();
        List<ViewChangeunitgoods> viewChangeunitgoods = infGoodsService.queryViewChangeunitgoods("5198");
        System.out.println(viewChangeunitgoods);
    }
}

