/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfGoodsMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsGoodsClassconfDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSpecDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.InfGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsBrand;
import com.yqbsoft.laser.service.adapter.fuji.model.RsClasstree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsGoodsClass;
import com.yqbsoft.laser.service.adapter.fuji.model.RsPntree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsResourceGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSku;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSpec;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSpecGroup;
import com.yqbsoft.laser.service.adapter.fuji.model.ViewChangeunitgoods;
import com.yqbsoft.laser.service.adapter.fuji.service.InfBrandService;
import com.yqbsoft.laser.service.adapter.fuji.service.InfCategoryService;
import com.yqbsoft.laser.service.adapter.fuji.service.InfGoodsService;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpOneRequest;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpRequest;
import com.yqbsoft.laser.service.adapter.fuji.utils.HttpRequestUtiles;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class InfGoodsServiceImpl
extends BaseServiceImpl
implements InfGoodsService {
    private static final String SYS_CODE = "service.adapter.fuji.InfGoodsServiceImpl";
    private InfGoodsMapper infGoodsMapper;
    private InfBrandService infBrandService;
    private InfCategoryService infCategoryService;
    private String fujiGoodsKey = "fujiGoods";

    public void setInfBrandService(InfBrandService infBrandService) {
        this.infBrandService = infBrandService;
    }

    public void setInfCategoryService(InfCategoryService infCategoryService) {
        this.infCategoryService = infCategoryService;
    }

    public void setInfGoodsMapper(InfGoodsMapper infGoodsMapper) {
        this.infGoodsMapper = infGoodsMapper;
    }

    private InfGoods getGoodsModelById(String goodsId) {
        if (null == goodsId) {
            return null;
        }
        try {
            return this.infGoodsMapper.selectByPrimaryKey(goodsId);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.getGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private InfGoods getGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.infGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.getGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private List<InfGoods> queryGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.infGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.countGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfGoods getGoods(String goodsId) {
        return this.getGoodsModelById(goodsId);
    }

    @Override
    public QueryResult<InfGoods> queryGoodsPage(Map<String, Object> map) {
        List<InfGoods> infGoodsList = this.queryGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infGoodsList);
        return queryResult;
    }

    @Override
    public InfGoods getGoodsByCode(String goodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        return this.getGoodsModelByCode(map);
    }

    @Override
    public void inertGoodsByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            DisUtil.del((String)this.fujiGoodsKey);
            pageNo = "0";
            pageSize = "50";
            tenantCode = "2019071800001392";
        }
        boolean flag = false;
        if ("0".equals(pageNo) && "5".equals(pageSize)) {
            flag = true;
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiGoodsKey);
        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.start", (Object)("\u540c\u6b65\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> errorAddGoods = new ArrayList<String>();
        while (true) {
            long requestTime = System.currentTimeMillis();
            String jsonResult = null;
            try {
                jsonResult = HttpRequest.httpPost("/qj/queryGoodsByPage", pn, ps, null, lasttime);
                if (StringUtils.isBlank((String)jsonResult)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage", (Object)"response is null");
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
                return;
            }
            long responseTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.time", (Object)("===========\u8bf7\u6c42\u7684\u65f6\u95f4:" + (responseTime - requestTime)));
            Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
            if (!"S".equals(mapResult.get("resCode"))) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
                return;
            }
            Object dataStr = mapResult.get("dataStr");
            if (dataStr == null) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
                return;
            }
            List infGoodsList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(dataStr.toString(), InfGoods.class);
            if (ListUtil.isEmpty((Collection)infGoodsList)) {
                if (ListUtil.isEmpty(errorAddGoods)) {
                    DisUtil.set((String)this.fujiGoodsKey, (String)sdf.format(new Date()));
                }
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiGoodsKey) + ",\u9519\u8bef\u7684\u5546\u54c1errorAddGoods:" + JsonUtil.buildNormalBinder().toJson(errorAddGoods)));
                return;
            }
            goodsList.clear();
            for (InfGoods infGoods : infGoodsList) {
                map.clear();
                map.put("goodsNo", infGoods.getGoodsid());
                map.put("tenantCode", tenantCode);
                List resourceGoodsList = null;
                try {
                    String resourceGoodsListStr = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.checkGoodsNo", map);
                    resourceGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(resourceGoodsListStr, RsResourceGoods.class);
                }
                catch (Exception e) {
                    this.logger.error(".inertGoodsByPage.checkGoodsNoApiCode.resourceGoodsList", (Object)(resourceGoodsList + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                if (!ListUtil.isEmpty((Collection)resourceGoodsList)) continue;
                RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, false, null, null, tenantCode);
                if (rsResourceGoodsDomain == null) {
                    errorAddGoods.add(infGoods.getGoodsid());
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.checkGoods", (Object)"\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01");
                    continue;
                }
                goodsList.add(rsResourceGoodsDomain);
            }
            if (ListUtil.isNotEmpty(goodsList)) {
                map.clear();
                map.put("goodsList", JsonUtil.buildNonDefaultBinder().toJson(goodsList));
                try {
                    this.getInternalRouter().inInvoke("rs.resource.sendSavePassResourceGoodsBatch", map);
                }
                catch (Exception e) {
                    this.logger.error(".inertGoodsByPage.sendSavePassResourceGoodsBatch.e", (Object)("\u6279\u91cf\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01,\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiGoodsKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
            }
            long endTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.time", (Object)("===========\u65b9\u6cd5\u63d2\u5165\u65f6\u95f4:" + (endTime - requestTime)));
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }

    public void updateGoods() {
    }

    @Override
    public Boolean insertOneGoods(String goodsId, String tenantCode, InfGoods infGoods) {
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode));
            return false;
        }
        if (infGoods == null && (infGoods = this.queryGoods(goodsId, requestUrl)) == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.queryGoods", (Object)("\u67e5\u8be2\u5931\u8d25goodsId\uff1a" + goodsId));
            return false;
        }
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, false, null, null, tenantCode);
        if (rsResourceGoodsDomain == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.checkGoods", (Object)"\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01");
            return false;
        }
        goodsList.add(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(goodsList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsList", JsonUtil.buildNonDefaultBinder().toJson(goodsList));
            try {
                this.getInternalRouter().inInvoke("rs.resource.sendSavePassResourceGoodsBatch", map);
            }
            catch (Exception e) {
                this.logger.error(".insertOneGoods.sendSavePassResourceGoodsBatch.e", (Object)"\u6279\u91cf\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01");
                return false;
            }
        }
        return true;
    }

    @Override
    public String saveExcelGoods(String goodsCode, String barCode, String goodsName, String brandFlag, String categoryFlag, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)barCode) || StringUtils.isBlank((String)goodsName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.intoparam", (Object)("\u5165\u53c2\u4e3a\u7a7agoodsCode:" + goodsCode + ",barCode:" + barCode + ",goodsName:" + goodsName + ",tenantCode:" + tenantCode));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u5b58\u5728\u7a7a\u503c\uff01goodsCode:" + goodsCode + ",barCode:" + barCode + ",goodsName:" + goodsName + ",tenantCode:" + tenantCode);
        }
        if ("1".equals(brandFlag)) {
            try {
                this.infBrandService.inertBrandByPage("1", "10", tenantCode);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.inertBrandByPage.e", (Object)"\u6dfb\u52a0\u54c1\u724c\u5f02\u5e38\uff01\uff01\uff01");
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u54c1\u724c\u5931\u8d25\uff01\uff01\uff01goodsCode:" + goodsCode + ",barCode:" + barCode + ",goodsName:" + goodsName + ",tenantCode:" + tenantCode);
            }
        }
        if ("1".equals(categoryFlag)) {
            try {
                this.infCategoryService.inertCategoryByPage("1", "10", tenantCode);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.inertCategoryByPage.e", (Object)"\u6dfb\u52a0\u5206\u7c7b\u5f02\u5e38\uff01\uff01\uff01");
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u5206\u7c7b\u5931\u8d25\uff01\uff01\uff01goodsCode:" + goodsCode + ",barCode:" + barCode + ",goodsName:" + goodsName + ",tenantCode:" + tenantCode);
            }
        }
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u67e5\u8be2\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        InfGoods infGoods = this.queryGoods(goodsCode, requestUrl);
        if (infGoods == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.getGoodsByCode", (Object)("\u6839\u636egoodsCode\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01goodsCode:" + goodsCode));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u83b7\u53d6\u8be5\u5546\u54c1\u5931\u8d25\uff01\uff01\uff01");
        }
        List<ViewChangeunitgoods> viewChangeunitgoodsList = null;
        try {
            viewChangeunitgoodsList = this.queryViewChangeunitgoods(infGoods.getGoodscode());
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.queryViewChangeunitgoods", (Object)("\u5b50\u5546\u54c1id:" + infGoods.getGoodscode()));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u67e5\u8be2\u5bcc\u57fa\u6bcd\u5b50\u5173\u7cfb\u5f02\u5e38\uff01\uff01\uff01");
        }
        if (ListUtil.isEmpty(viewChangeunitgoodsList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> mapStr = new HashMap<String, String>();
            mapStr.put("skuNo", infGoods.getGoodsid());
            mapStr.put("goodsOrigin", "0");
            mapStr.put("tenantCode", tenantCode);
            map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
            String skuJson = "";
            try {
                skuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", map);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01");
            }
            SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuJson, SupQueryResult.class);
            List rsSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsSkuDomain.class);
            if (ListUtil.isNotEmpty((Collection)rsSkuDomainList)) {
                return this.responseAddGoods("success", goodsCode, barCode, goodsName, "\u5546\u54c1\u5df2\u5b58\u5728\uff01\uff01\uff01\u5982\u82e5\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u8bf7\u5728\u9875\u9762\u64cd\u4f5c\uff01\uff01\uff01");
            }
            String msg = this.sendSavePassResourceGoodsBatch(infGoods, false, null, tenantCode);
            if (!"success".equals(msg)) {
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, msg);
            }
            return this.responseAddGoods("success", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u6210\u529f\uff01\uff01\uff01");
        }
        ViewChangeunitgoods viewChangeunitgoods = viewChangeunitgoodsList.get(0);
        InfGoods momtherGoods = this.queryGoods(viewChangeunitgoods.getMgoodsid(), requestUrl);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("skuNo", momtherGoods.getGoodsid());
        mapStr.put("goodsOrigin", "0");
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String skuJson = "";
        try {
            skuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u8be5\u5546\u54c1\u662f\u5b50\u5546\u54c1\uff0c\u67e5\u8be2\u6bcd\u5546\u54c1sku\u5f02\u5e38\uff01\uff01\uff01");
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuJson, SupQueryResult.class);
        List rsSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsSkuDomain.class);
        RsSkuDomain rsSkuMomDomain = null;
        if (ListUtil.isEmpty((Collection)rsSkuDomainList)) {
            String msg = this.sendSavePassResourceGoodsBatch(momtherGoods, false, null, tenantCode);
            if (!"success".equals(msg)) {
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u6bcd\u5546\u54c1:" + msg);
            }
            HashMap<String, String> queryMomGoodsMap = new HashMap<String, String>();
            HashMap<String, String> queryMomGoodsMapStr = new HashMap<String, String>();
            queryMomGoodsMapStr.put("skuNo", momtherGoods.getGoodsid());
            queryMomGoodsMapStr.put("goodsOrigin", "0");
            queryMomGoodsMapStr.put("tenantCode", tenantCode);
            queryMomGoodsMap.put("map", JsonUtil.buildNormalBinder().toJson(queryMomGoodsMapStr));
            String querySkuJson = "";
            try {
                querySkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", queryMomGoodsMap);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u8be5\u5546\u54c1\u662f\u5b50\u5546\u54c1\uff0c\u6dfb\u52a0\u6bcd\u5546\u54c1\u4e4b\u540e\u67e5\u8be2\u6bcd\u5546\u54c1sku\u5f02\u5e38\uff01\uff01\uff01");
            }
            SupQueryResult queryMomQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(querySkuJson, SupQueryResult.class);
            List queryMomDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryMomQueryResultStr.getList()), RsSkuDomain.class);
            rsSkuMomDomain = (RsSkuDomain)queryMomDomainList.get(0);
        } else {
            rsSkuMomDomain = (RsSkuDomain)rsSkuDomainList.get(0);
        }
        HashMap<String, String> childMap = new HashMap<String, String>();
        HashMap<String, String> childMapStr = new HashMap<String, String>();
        childMapStr.put("skuNo", infGoods.getGoodsid());
        childMapStr.put("goodsOrigin", "20");
        childMapStr.put("tenantCode", tenantCode);
        childMap.put("map", JsonUtil.buildNormalBinder().toJson(childMapStr));
        String skuChildJson = "";
        try {
            skuChildJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", childMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u8be5\u5546\u54c1\u662f\u5b50\u5546\u54c1\uff0c\u67e5\u8be2\u5b50\u5546\u54c1sku\u5f02\u5e38\uff01\uff01\uff01");
        }
        SupQueryResult supChileQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuChildJson, SupQueryResult.class);
        List rsSkuChildDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supChileQueryResultStr.getList()), RsSkuDomain.class);
        if (ListUtil.isEmpty((Collection)rsSkuChildDomainList)) {
            String msg = this.sendSavePassResourceGoodsBatch(infGoods, true, rsSkuMomDomain, tenantCode);
            if (!"success".equals(msg)) {
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u5b50\u5546\u54c1\u548c\u6bcd\u5b50\u5173\u7cfb:" + msg);
            }
            return this.responseAddGoods("success", goodsCode, barCode, goodsName, "\u6dfb\u52a0\u5b50\u5546\u54c1\u6210\u529f\u5e76\u6dfb\u52a0\u6bcd\u5b50\u5173\u7cfb\u6210\u529f\uff01\uff01\uff01");
        }
        RsSkuDomain rsSkuChildDomain = (RsSkuDomain)rsSkuChildDomainList.get(0);
        Boolean goodsReslFlag = this.saveGoodsRel(rsSkuMomDomain, rsSkuChildDomain);
        if (!goodsReslFlag.booleanValue()) {
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, "\u5b50\u5546\u54c1\u5df2\u5b58\u5728\uff0c\u4f46\u6dfb\u52a0\u6bcd\u5b50\u5173\u7cfb\u5931\u8d25");
        }
        return this.responseAddGoods("success", goodsCode, barCode, goodsName, "\u5b50\u5546\u54c1\u5df2\u5b58\u5728\u5e76\u6dfb\u52a0\u6bcd\u5b50\u5173\u7cfb\u6210\u529f\uff01\uff01\uff01");
    }

    @Override
    public Boolean insertEntityAndVirtualClasstree(Map<String, Object> map) {
        String virtualOneClasstreeName = null == map.get("virtualOneClasstreeName") ? "" : String.valueOf(map.get("virtualOneClasstreeName"));
        String virtualTwoClasstreeName = null == map.get("virtualTwoClasstreeName") ? "" : String.valueOf(map.get("virtualTwoClasstreeName"));
        String virtualThreeClasstreeName = null == map.get("virtualThreeClasstreeName") ? "" : String.valueOf(map.get("virtualThreeClasstreeName"));
        String entityClasstreeCode = null == map.get("entityClasstreeCode") ? "" : String.valueOf(map.get("entityClasstreeCode"));
        String level = null == map.get("level") ? "" : String.valueOf(map.get("level"));
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)virtualOneClasstreeName) || StringUtils.isBlank((String)entityClasstreeCode) || StringUtils.isBlank((String)level) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertEntityAndVirtualClasstree.param", (Object)("\u53c2\u6570\u4e3a\u7a7a\uff01\uff01\uff01virtualOneClasstreeName:" + virtualOneClasstreeName + ",entityClasstreeCode:" + entityClasstreeCode + ",level:" + level));
            return false;
        }
        if ("1".equals(level)) {
            RsGoodsClass rsOneGoodsClass = this.queryGoodsClass(virtualOneClasstreeName, tenantCode);
            if (rsOneGoodsClass == null) {
                RsClasstree rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                RsGoodsClass rsGoodsClass = this.saveRsGoodsClass(virtualOneClasstreeName, rsClasstree, tenantCode, "-1", "0", true);
                if (rsGoodsClass == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:1,\u4fdd\u5b58\u4e00\u7ea7\u5206\u7c7b");
                    return false;
                }
            } else {
                RsClasstree rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                RsGoodsClassconfDomain rsGoodsClassconfDomain = new RsGoodsClassconfDomain();
                rsGoodsClassconfDomain.setGoodsClassCode(rsOneGoodsClass.getGoodsClassCode());
                rsGoodsClassconfDomain.setGoodsClassconfType("classtreeCode");
                rsGoodsClassconfDomain.setGoodsClassconfName(rsClasstree.getClasstreeName());
                rsGoodsClassconfDomain.setGoodsClassconfValue(rsClasstree.getClasstreeCode());
                rsGoodsClassconfDomain.setMemberCode("20021000262816");
                rsGoodsClassconfDomain.setTenantCode(tenantCode);
                String rsGoodsClassConfCode = this.saveRsGoodsClassConf(rsGoodsClassconfDomain);
                if (StringUtils.isBlank((String)rsGoodsClassConfCode)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:1");
                    return false;
                }
            }
            return true;
        }
        if ("2".equals(level)) {
            RsGoodsClass rsTwoGoodsClass = this.queryGoodsClass(virtualTwoClasstreeName, tenantCode);
            if (rsTwoGoodsClass == null) {
                RsClasstree rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                RsGoodsClass rsOneGoodsClass = this.saveRsGoodsClass(virtualOneClasstreeName, rsClasstree, tenantCode, "-1", "1", false);
                if (rsOneGoodsClass == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:2,\u4fdd\u5b58\u4e00\u7ea7\u5206\u7c7b");
                    return false;
                }
                RsGoodsClass rsGoodsClass = this.saveRsGoodsClass(virtualTwoClasstreeName, rsClasstree, tenantCode, rsOneGoodsClass.getGoodsClassCode(), "0", true);
                if (rsGoodsClass == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:2,\u4fdd\u5b58\u4e8c\u7ea7\u5206\u7c7b");
                    return false;
                }
            } else {
                RsClasstree rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                RsGoodsClassconfDomain rsGoodsClassconfDomain = new RsGoodsClassconfDomain();
                rsGoodsClassconfDomain.setGoodsClassCode(rsTwoGoodsClass.getGoodsClassCode());
                rsGoodsClassconfDomain.setGoodsClassconfType("classtreeCode");
                rsGoodsClassconfDomain.setGoodsClassconfName(rsClasstree.getClasstreeName());
                rsGoodsClassconfDomain.setGoodsClassconfValue(rsClasstree.getClasstreeCode());
                rsGoodsClassconfDomain.setMemberCode("20021000262816");
                rsGoodsClassconfDomain.setTenantCode(tenantCode);
                String rsGoodsClassConfCode = this.saveRsGoodsClassConf(rsGoodsClassconfDomain);
                if (StringUtils.isBlank((String)rsGoodsClassConfCode)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:2");
                    return false;
                }
            }
            return true;
        }
        if ("3".equals(level)) {
            RsGoodsClass rsThreeGoodsClass = this.queryGoodsClass(virtualThreeClasstreeName, tenantCode);
            if (rsThreeGoodsClass == null) {
                RsClasstree rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                RsGoodsClass rsOneGoodsClass = this.saveRsGoodsClass(virtualOneClasstreeName, rsClasstree, tenantCode, "-1", "1", false);
                if (rsOneGoodsClass == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3,\u4fdd\u5b58\u4e00\u7ea7\u5206\u7c7b");
                    return false;
                }
                RsGoodsClass rsTwoGoodsClass = this.saveRsGoodsClass(virtualTwoClasstreeName, rsClasstree, tenantCode, rsOneGoodsClass.getGoodsClassCode(), "1", false);
                if (rsTwoGoodsClass == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3,\u4fdd\u5b58\u4e8c\u7ea7\u5206\u7c7b");
                    return false;
                }
                RsGoodsClass rsGoodsClass = this.saveRsGoodsClass(virtualThreeClasstreeName, rsClasstree, tenantCode, rsTwoGoodsClass.getGoodsClassCode(), "0", true);
                if (rsGoodsClass == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3,\u4fdd\u5b58\u4e09\u7ea7\u5206\u7c7b");
                    return false;
                }
            } else {
                RsClasstree rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                RsGoodsClassconfDomain rsGoodsClassconfDomain = new RsGoodsClassconfDomain();
                rsGoodsClassconfDomain.setGoodsClassCode(rsThreeGoodsClass.getGoodsClassCode());
                rsGoodsClassconfDomain.setGoodsClassconfType("classtreeCode");
                rsGoodsClassconfDomain.setGoodsClassconfName(rsClasstree.getClasstreeName());
                rsGoodsClassconfDomain.setGoodsClassconfValue(rsClasstree.getClasstreeCode());
                rsGoodsClassconfDomain.setMemberCode("20021000262816");
                rsGoodsClassconfDomain.setTenantCode(tenantCode);
                String rsGoodsClassConfCode = this.saveRsGoodsClassConf(rsGoodsClassconfDomain);
                if (StringUtils.isBlank((String)rsGoodsClassConfCode)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3");
                    return false;
                }
            }
        }
        return true;
    }

    public RsGoodsClass saveRsGoodsClass(String virtualClasstreeName, RsClasstree rsClasstree, String tenantCode, String parentCode, String classLast, Boolean falg) {
        RsGoodsClassDomain rsGoodsClassDomain = new RsGoodsClassDomain();
        rsGoodsClassDomain.setGoodsClassParentcode(parentCode);
        rsGoodsClassDomain.setGoodsClassLast(classLast);
        rsGoodsClassDomain.setGoodsClassName(virtualClasstreeName);
        rsGoodsClassDomain.setGoodsClassHide("0");
        rsGoodsClassDomain.setGoodsClassOrder(0);
        rsGoodsClassDomain.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsGoodsClassDomain.setMemberCode("20021000262816");
        rsGoodsClassDomain.setTenantCode(tenantCode);
        if (falg.booleanValue()) {
            ArrayList<RsGoodsClassconfDomain> rsGoodsClassconfDomainList = new ArrayList<RsGoodsClassconfDomain>();
            RsGoodsClassconfDomain rsGoodsClassconfDomain = new RsGoodsClassconfDomain();
            rsGoodsClassconfDomainList.add(rsGoodsClassconfDomain);
            rsGoodsClassDomain.setRsGoodsClassconfDomainList(rsGoodsClassconfDomainList);
            rsGoodsClassconfDomain.setGoodsClassconfType("classtreeCode");
            rsGoodsClassconfDomain.setGoodsClassconfName(rsClasstree.getClasstreeName());
            rsGoodsClassconfDomain.setGoodsClassconfValue(rsClasstree.getClasstreeCode());
            rsGoodsClassconfDomain.setMemberCode("20021000262816");
            rsGoodsClassconfDomain.setTenantCode(tenantCode);
        }
        return this.saveRsGoodsClass(rsGoodsClassDomain);
    }

    public RsClasstree queryClasstree(String classtreeEocode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> classtreeNameparamMap = new HashMap<String, String>();
        classtreeNameparamMap.put("classtreeEocode", classtreeEocode);
        classtreeNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeNameparamMap));
        String rsClasstreeStr = "";
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
            if (StringUtils.isBlank((String)rsClasstreeStr)) {
                this.logger.error(".queryClasstree.queryClasstreePage", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".queryClasstree.queryClasstreePage.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, SupQueryResult.class);
        List rsClasstrees = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstrees)) {
            this.logger.error(".queryClasstree.queryClasstreePage", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        return (RsClasstree)rsClasstrees.get(0);
    }

    public RsGoodsClass saveRsGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsGoodsClassDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsGoodsClassDomain));
        String rsGoodsClassJson = (String)this.getInternalRouter().inInvoke("rs.goodsClass.saveRsGoodsClass", map);
        if (StringUtils.isBlank((String)rsGoodsClassJson)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass.saveRsGoodsClass.null", (Object)("rsGoodsClassJson:" + rsGoodsClassJson + ",rsGoodsClassDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsGoodsClassDomain)));
            return null;
        }
        RsGoodsClass rsGoodsClass = (RsGoodsClass)JsonUtil.buildNormalBinder().getJsonToObject(rsGoodsClassJson, RsGoodsClass.class);
        return rsGoodsClass;
    }

    public String saveRsGoodsClassConf(RsGoodsClassconfDomain rsGoodsClassconfDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsGoodsClassconfDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsGoodsClassconfDomain));
        String goodsClassCode = (String)this.getInternalRouter().inInvoke("rs.goodsClassconf.saveGoodsClassconf", map);
        if (StringUtils.isBlank((String)goodsClassCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClassConf.saveGoodsClassconf.null", (Object)("rsGoodsClassconfDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsGoodsClassconfDomain)));
            return null;
        }
        return goodsClassCode;
    }

    public RsGoodsClass queryGoodsClass(String goodsClassName, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("goodsClassName", goodsClassName);
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String queryGoodsClassJson = "";
        try {
            queryGoodsClassJson = (String)this.getInternalRouter().inInvoke("rs.goodsClass.queryGoodsClassPage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryGoodsClass.queryGoodsClassPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + mapStr), (Throwable)e);
            return null;
        }
        SupQueryResult queryGoodsClassResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryGoodsClassJson, SupQueryResult.class);
        List queryGoodsClassList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryGoodsClassResult.getList()), RsGoodsClass.class);
        if (ListUtil.isEmpty((Collection)queryGoodsClassList)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryGoodsClass.queryGoodsClassList", (Object)("queryGoodsClassList:" + JsonUtil.buildNormalBinder().toJson((Object)queryGoodsClassList)));
            return null;
        }
        RsGoodsClass rsGoodsClass = (RsGoodsClass)queryGoodsClassList.get(0);
        return rsGoodsClass;
    }

    public Boolean saveGoodsRel(RsSkuDomain rsSkuMomDomain, RsSkuDomain rsSkuChildDomain) {
        RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
        rsGoodsRelDomain.setGoodsCode(rsSkuChildDomain.getGoodsCode());
        rsGoodsRelDomain.setGoodsRelGcode(rsSkuMomDomain.getGoodsCode());
        rsGoodsRelDomain.setGoodsRelType("4");
        rsGoodsRelDomain.setMemberCode(rsSkuMomDomain.getMemberCcode());
        rsGoodsRelDomain.setMemberName(rsSkuMomDomain.getMemberCname());
        rsGoodsRelDomain.setSkuCode(rsSkuMomDomain.getSkuCode());
        rsGoodsRelDomain.setSkuName(rsSkuMomDomain.getSkuName());
        rsGoodsRelDomain.setPricesetNprice(rsSkuMomDomain.getPricesetNprice());
        rsGoodsRelDomain.setGoodsNum(rsSkuMomDomain.getGoodsNum());
        rsGoodsRelDomain.setSkuNo(rsSkuMomDomain.getSkuNo());
        rsGoodsRelDomain.setDataPic(rsSkuMomDomain.getDataPic());
        rsGoodsRelDomain.setTenantCode(rsSkuMomDomain.getTenantCode());
        RsGoodsRelDomain rsGoodsRelDomainStr = new RsGoodsRelDomain();
        rsGoodsRelDomainStr.setGoodsSkuCode(rsSkuChildDomain.getSkuCode());
        rsGoodsRelDomainStr.setGoodsRelGcode(rsSkuMomDomain.getGoodsCode());
        rsGoodsRelDomainStr.setGoodsRelType("4");
        rsGoodsRelDomainStr.setMemberCode(rsSkuMomDomain.getMemberCcode());
        rsGoodsRelDomainStr.setMemberName(rsSkuMomDomain.getMemberCname());
        rsGoodsRelDomainStr.setSkuCode(rsSkuMomDomain.getSkuCode());
        rsGoodsRelDomainStr.setSkuName(rsSkuMomDomain.getSkuName());
        rsGoodsRelDomainStr.setPricesetNprice(rsSkuMomDomain.getPricesetNprice());
        rsGoodsRelDomainStr.setGoodsNum(rsSkuMomDomain.getGoodsNum());
        rsGoodsRelDomainStr.setSkuNo(rsSkuMomDomain.getSkuNo());
        rsGoodsRelDomainStr.setDataPic(rsSkuMomDomain.getDataPic());
        rsGoodsRelDomainStr.setTenantCode(rsSkuMomDomain.getTenantCode());
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        rsGoodsRelDomainList.add(rsGoodsRelDomain);
        rsGoodsRelDomainList.add(rsGoodsRelDomainStr);
        HashMap<String, String> saveGoodsRelMap = new HashMap<String, String>();
        saveGoodsRelMap.put("rsGoodsRelDomainList", JsonUtil.buildNonDefaultBinder().toJson(rsGoodsRelDomainList));
        try {
            this.getInternalRouter().inInvoke("rs.goodsOther.saveGoodsRelList", saveGoodsRelMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl..saveExcelGoods.saveGoodsRel.saveGoodsRel.e", (Object)("\u6dfb\u52a0\u5f02\u5e38\uff01\uff01\uff01saveGoodsRelMap:" + saveGoodsRelMap));
            return false;
        }
        return true;
    }

    public boolean queryMomGoodsAndChildGoods(InfGoods momtherGoods, InfGoods childGoods, String tenantCode) {
        HashMap<String, String> momSkuMap = new HashMap<String, String>();
        momSkuMap.put("skuNo", momtherGoods.getGoodsid());
        momSkuMap.put("tenantCode", tenantCode);
        String momSkusJson = "";
        try {
            momSkusJson = (String)this.getInternalRouter().inInvoke("rs.sku.checkSkuNo", momSkuMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryMomGoodsAndChildGoods.e", (Object)("\u67e5\u8be2sku\u5f02\u5e38\uff01\uff01\uff01momSkuMap:" + momSkuMap));
            return false;
        }
        List rsMomSkuList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(momSkusJson, RsSku.class);
        HashMap<String, String> childSkuMap = new HashMap<String, String>();
        childSkuMap.put("skuNo", momtherGoods.getGoodsid());
        childSkuMap.put("tenantCode", tenantCode);
        String childSkuJson = "";
        try {
            childSkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.checkSkuNo", childSkuMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryMomGoodsAndChildGoods.e", (Object)("\u67e5\u8be2sku\u5f02\u5e38\uff01\uff01\uff01momSkuMap:" + momSkuMap));
            return false;
        }
        List rsChildSkuList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(childSkuJson, RsSku.class);
        return true;
    }

    public Boolean makeUpdateGoodsAndSku(InfGoods infGoods, RsResourceGoods rsResourceGoods, RsSkuDomain rsSkuDomain, String tenantCode) {
        RsBrand rsBrand = this.queryBrand(infGoods, tenantCode);
        if (rsBrand == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.queryBrand", (Object)("\u83b7\u53d6\u54c1\u724c\u4e3a\u7a7a\uff01\uff01\uff01\u54c1\u724cID:" + infGoods.getBrandid()));
            return false;
        }
        RsClasstree rsClasstree = this.queryClasstree(infGoods, tenantCode);
        if (rsClasstree == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.queryClasstree", (Object)("\u83b7\u53d6\u54c1\u724c\u4e3a\u7a7a\uff01\uff01\uff01\u5206\u7c7bID:" + infGoods.getCategoryid()));
            return false;
        }
        RsPntree rsPntree = this.queryPntree(rsClasstree, tenantCode);
        if (rsPntree == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.queryPntree", (Object)("\u83b7\u53d6\u7c7b\u578b\u4e3a\u7a7a\uff01\uff01\uff01\u5206\u7c7bID:" + rsClasstree.getPntreeCode()));
            return false;
        }
        rsResourceGoods.setBrandCode(rsBrand.getBrandCode());
        rsResourceGoods.setBrandName(rsBrand.getBrandName());
        rsResourceGoods.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsResourceGoods.setClasstreeName(rsClasstree.getClasstreeName());
        rsResourceGoods.setPntreeCode(rsPntree.getPntreeCode());
        rsResourceGoods.setPntreeName(rsPntree.getPntreeName());
        rsResourceGoods.setProductareaName(infGoods.getProducingarea());
        rsResourceGoods.setGoodsName(infGoods.getGoodsname());
        rsResourceGoods.setPartsnameNumunit(infGoods.getUnitname());
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsResourceGoodsDomain, (Object)rsResourceGoods);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.makeResourceGoodsDomain", (Throwable)e);
            return false;
        }
        HashMap<String, String> updateResourceGoodsMap = new HashMap<String, String>();
        updateResourceGoodsMap.put("rsResourceGoodsDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsDomain));
        try {
            this.getInternalRouter().inInvoke("rs.resourceGoods.updateResourceGoods", updateResourceGoodsMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.updateResourceGoods.e", (Object)("\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01rsSkuDomain:" + JsonUtil.buildNonEmptyBinder().toJson((Object)rsSkuDomain)));
            return false;
        }
        RsSkuDomain rsSkuDomainStr = new RsSkuDomain();
        rsSkuDomainStr.setSkuId(rsSkuDomain.getSkuId());
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("rsSkuDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSkuDomainStr));
        this.getInternalRouter().inInvoke("rs.sku.updateSku", mapStr);
        rsSkuDomain.setSkuCodeOld(infGoods.getGoodsid());
        rsSkuDomain.setSkuName(infGoods.getGoodsspec());
        rsSkuDomain.setPricesetNprice(infGoods.getAdviceprice());
        rsSkuDomain.setPricesetAsprice(infGoods.getAdvicecost());
        rsSkuDomain.setGoodsWeight(new BigDecimal(infGoods.getGoodsweight()));
        rsSkuDomain.setPartsnameNumunit(infGoods.getUnitname());
        rsSkuDomain.setBrandCode(rsBrand.getBrandCode());
        rsSkuDomain.setBrandName(rsBrand.getBrandName());
        rsSkuDomain.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsSkuDomain.setPntreeCode(rsPntree.getPntreeCode());
        rsSkuDomain.setPntreeName(rsPntree.getPntreeName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsSkuDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSkuDomain));
        try {
            this.getInternalRouter().inInvoke("rs.sku.updateSku", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.updateSku.e", (Object)("\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01rsSkuDomain:" + JsonUtil.buildNonEmptyBinder().toJson((Object)rsSkuDomain)));
            return false;
        }
        return true;
    }

    public RsBrand queryBrand(InfGoods infGoods, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> brandNameparamMap = new HashMap<String, String>();
        brandNameparamMap.put("brandEocode", infGoods.getBrandid().toString());
        brandNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandNameparamMap));
        String brandStr = "";
        try {
            brandStr = (String)this.getInternalRouter().inInvoke("rs.brand.queryBrandPage", map);
            if (StringUtils.isBlank((String)brandStr)) {
                this.logger.error(".queryBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".queryBrand.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStrStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(brandStr, SupQueryResult.class);
        List rsBrands = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStrStr.getList()), RsBrand.class);
        if (ListUtil.isEmpty((Collection)rsBrands)) {
            this.logger.error(".queryBrand.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            return null;
        }
        return (RsBrand)rsBrands.get(0);
    }

    public RsClasstree queryClasstree(InfGoods infGoods, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> classtreeNameparamMap = new HashMap<String, String>();
        classtreeNameparamMap.put("classtreeEocode", infGoods.getCategoryid().toString());
        classtreeNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeNameparamMap));
        String rsClasstreeStr = "";
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
            if (StringUtils.isBlank((String)rsClasstreeStr)) {
                this.logger.error(".queryClasstree.rsClasstreeStr", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".queryClasstree.rsClasstree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, SupQueryResult.class);
        List rsClasstrees = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstrees)) {
            this.logger.error(".queryClasstree.rsClasstrees", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        return (RsClasstree)rsClasstrees.get(0);
    }

    public RsPntree queryPntree(RsClasstree rsClasstree, String tenantCode) {
        String pntreeCode = rsClasstree.getPntreeCode();
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(".queryPntree.pntreeCode", (Object)("\u8be5\u5206\u7c7b\u6ca1\u6709\u5173\u8054\u7c7b\u522b\uff01\uff01\uff01rsClassTreeName:" + rsClasstree.getClasstreeName() + ",pntreeCode:" + pntreeCode));
            return null;
        }
        HashMap<String, String> pntreeCodeparamMap = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("pntreeCode", pntreeCode);
        mapStr.put("tenantCode", tenantCode);
        pntreeCodeparamMap.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        RsPntree rsPntree = null;
        try {
            String rsPntreeStr = (String)this.getInternalRouter().inInvoke("rs.pntree.getPntreeByCode", pntreeCodeparamMap);
            if (StringUtils.isBlank((String)rsPntreeStr)) {
                this.logger.error(".queryPntree.rsPntree", (Object)("rsPntreeStr:" + rsPntreeStr + ",\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
                return null;
            }
            rsPntree = (RsPntree)JsonUtil.buildNormalBinder().getJsonToObject(rsPntreeStr, RsPntree.class);
        }
        catch (Exception e) {
            this.logger.error(".queryPntree.rsPntree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
            return null;
        }
        return rsPntree;
    }

    private String sendSavePassResourceGoodsBatch(InfGoods infGoods, boolean isChildFlag, RsSkuDomain rsSkuMomDomain, String tenantCode) {
        HashMap<String, Object> specMap = new HashMap<String, Object>();
        RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, isChildFlag, rsSkuMomDomain, specMap, tenantCode);
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsRemark())) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoods", (Object)("\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01" + rsResourceGoodsDomain.getGoodsRemark()));
            return "\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01" + rsResourceGoodsDomain.getGoodsRemark();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsResourceGoodsDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsDomain));
        String rsGoodsCode = "";
        try {
            rsGoodsCode = (String)this.getInternalRouter().inInvoke("rs.resource.sendSaveResourceGoods", map);
            if (StringUtils.isBlank((String)rsGoodsCode)) {
                return "\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01";
            }
        }
        catch (Exception e) {
            this.logger.error(".saveExcelGoods.sendSavePassResourceGoodsBatch.e", (Object)"\u6dfb\u52a0\u5f02\u5e38\uff01\uff01\uff01", (Throwable)e);
            return "\u6dfb\u52a0\u5f02\u5e38\uff01\uff01\uff01";
        }
        HashMap<String, String> queryGoodsMap = new HashMap<String, String>();
        HashMap<String, String> queryGoodsMapStr = new HashMap<String, String>();
        queryGoodsMapStr.put("goodsCode", rsGoodsCode);
        queryGoodsMapStr.put("tenantCode", tenantCode);
        queryGoodsMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryGoodsMapStr));
        String rsGoodsJson = "";
        try {
            rsGoodsJson = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.getResourceGoodsByCode", queryGoodsMap);
            if (StringUtils.isBlank((String)rsGoodsJson)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.getResourceGoodsByCode", (Object)("rsGoodsJson:" + rsGoodsJson + ",\u53c2\u6570map:" + queryGoodsMapStr));
                return "\u6dfb\u52a0\u5b8c\u6210\u4e4b\u540e\u67e5\u8be2\u4e0d\u5230\uff01\uff01\uff01";
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.getResourceGoodsByCode,e", (Object)("rsGoodsJson:" + rsGoodsJson + ",\u53c2\u6570map:" + queryGoodsMapStr), (Throwable)e);
            return "\u6dfb\u52a0\u5b8c\u6210\u4e4b\u540e\u67e5\u8be2\u4e0d\u5230\uff01\uff01\uff01";
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsGoodsJson, RsResourceGoodsReDomain.class);
        String specGroupCode = (String)specMap.get("specGroupCode");
        String specCode = (String)specMap.get("specCode");
        String specName = (String)specMap.get("specName");
        HashMap<String, String> saveSpecValueMap = new HashMap<String, String>();
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        rsSpecValueDomain.setTenantCode(tenantCode);
        rsSpecValueDomain.setSpuCode(rsResourceGoodsReDomain.getSpuCode());
        rsSpecValueDomain.setSpecGroupCode(specGroupCode);
        rsSpecValueDomain.setSpecCode(specCode);
        rsSpecValueDomain.setSpecName(specName);
        rsSpecValueDomain.setSpecValueValue(specName);
        rsSpecValueDomain.setSpecValueType("1");
        rsSpecValueDomain.setSpecValueFlag("1");
        rsSpecValueDomain.setSpecValueBillno(rsResourceGoodsReDomain.getGoodsCode());
        saveSpecValueMap.put("rsSpecValueDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecValueDomain));
        try {
            this.getInternalRouter().inInvoke("rs.specValue.saveSpecValue", saveSpecValueMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.saveSpecValue,e", (Object)("\u6dfb\u52a0specvalue\u5f02\u5e38,\u53c2\u6570rsSpecValueDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecValueDomain)), (Throwable)e);
            return "\u6dfb\u52a0specvalue\u5f02\u5e38\uff01\uff01\uff01";
        }
        return "success";
    }

    public String responseAddGoods(String result, String goodsCode, String barCode, String goodsName, String errorMsg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("result", result);
        HashMap<String, String> mapMsg = new HashMap<String, String>();
        mapMsg.put("goodsCode", goodsCode);
        mapMsg.put("barCode", barCode);
        mapMsg.put("goodsName", goodsName);
        mapMsg.put("errorMsg", errorMsg);
        map.put("msg", JsonUtil.buildNonEmptyBinder().toJson(mapMsg));
        return JsonUtil.buildNonEmptyBinder().toJson(map);
    }

    public List<ViewChangeunitgoods> queryViewChangeunitgoods(String zGoodsId) {
        ViewChangeunitgoods viewChangeunitgoods1 = new ViewChangeunitgoods();
        viewChangeunitgoods1.setzGoodsid(zGoodsId);
        String jsonResult = null;
        try {
            jsonResult = HttpOneRequest.httpPost("/qj/queryChildGoodsByZid", viewChangeunitgoods1);
            if (StringUtils.isBlank((String)jsonResult)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods", (Object)"response is null");
                throw new ApiException("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods", "response is null");
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
            throw new ApiException("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.e", "\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
            throw new ApiException("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.resCode", "respose is false,jsonResult:" + jsonResult);
        }
        Object dataStr = mapResult.get("dataStr");
        if (dataStr == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
            throw new ApiException("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.dataStr", "dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult);
        }
        return (List)JsonUtil.buildNonEmptyBinder().getJsonToList(dataStr.toString(), ViewChangeunitgoods.class);
    }

    private InfGoods queryGoods(String goodsId, String requestUrl) {
        InfGoods infGoodsRes = new InfGoods();
        infGoodsRes.setGoodsid(goodsId);
        String requestJson = JsonUtil.buildNonNullBinder().toJson((Object)infGoodsRes);
        String jsonResult = null;
        try {
            jsonResult = HttpRequestUtiles.httpPost("/qj/queryGoodsById", requestJson, requestUrl);
            if (StringUtils.isBlank((String)jsonResult)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById", (Object)("response is null,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById"));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.e", (Object)("\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById"));
            return null;
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.resCode", (Object)("respose is false,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById" + ",\u54cd\u5e94\u7ed3\u679c:" + jsonResult));
            return null;
        }
        Object dataStr = mapResult.get("dataStr");
        if (dataStr == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.dataStr", (Object)("dataStr is null\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById" + ",\u54cd\u5e94\u7ed3\u679c:" + jsonResult));
            return null;
        }
        return (InfGoods)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataStr.toString(), InfGoods.class);
    }

    public RsResourceGoodsDomain checkGoods(InfGoods infGoods, boolean isChildFlag, RsSkuDomain rsSkuMomDomain, Map<String, Object> specMap, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> brandNameparamMap = new HashMap<String, String>();
        brandNameparamMap.put("brandEocode", infGoods.getBrandid().toString());
        brandNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandNameparamMap));
        String brandStr = "";
        try {
            brandStr = (String)this.getInternalRouter().inInvoke("rs.brand.queryBrandPage", map);
            if (StringUtils.isBlank((String)brandStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + infGoods.getBrandid() + ":\u54c1\u724c\u4e0d\u5b58\u5728");
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u54c1\u724cid:" + infGoods.getBrandid() + "-\u5f02\u5e38\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        SupQueryResult supQueryResultStrStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(brandStr, SupQueryResult.class);
        List rsBrands = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStrStr.getList()), RsBrand.class);
        if (ListUtil.isEmpty((Collection)rsBrands)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u54c1\u724cid:" + infGoods.getBrandid() + "-\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        RsBrand rsBrand = (RsBrand)rsBrands.get(0);
        map.clear();
        HashMap<String, String> classtreeNameparamMap = new HashMap<String, String>();
        classtreeNameparamMap.put("classtreeEocode", infGoods.getCategoryid().toString());
        classtreeNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeNameparamMap));
        String rsClasstreeStr = "";
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
            if (StringUtils.isBlank((String)rsClasstreeStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.rsClasstreeStr", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "-\u4e0d\u5b58\u5728");
                return rsResourceGoodsDomain;
            }
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.checkClasstreeNameApiCode.rsClasstree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "-\u5f02\u5e38\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, SupQueryResult.class);
        List rsClasstrees = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstrees)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.rsClasstrees", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "-\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        RsClasstree rsClasstree = (RsClasstree)rsClasstrees.get(0);
        String pntreeCode = rsClasstree.getPntreeCode();
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.pntreeCode", (Object)("\u8be5\u5206\u7c7b\u6ca1\u6709\u5173\u8054\u7c7b\u522b\uff01\uff01\uff01rsClassTreeName:" + rsClasstree.getClasstreeName() + ",pntreeCode:" + pntreeCode));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u5206\u7c7bid:" + infGoods.getBrandid() + "\u5b58\u5728\uff0c\u5206\u7c7b\u5bf9\u5e94\u7684\u7c7b\u522b-\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        HashMap<String, String> pntreeCodeparamMap = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("pntreeCode", pntreeCode);
        mapStr.put("tenantCode", tenantCode);
        pntreeCodeparamMap.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        RsPntree rsPntree = null;
        try {
            String rsPntreeStr = (String)this.getInternalRouter().inInvoke("rs.pntree.getPntreeByCode", pntreeCodeparamMap);
            if (StringUtils.isBlank((String)rsPntreeStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.getPntreeByCodeApiCode.rsPntree", (Object)("rsPntreeStr:" + rsPntreeStr + ",\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "\u5173\u8054\u7684\u7c7b\u522b\uff08" + pntreeCode + "\uff09-\u4e0d\u5b58\u5728\uff01\uff01\uff01");
                return rsResourceGoodsDomain;
            }
            rsPntree = (RsPntree)JsonUtil.buildNormalBinder().getJsonToObject(rsPntreeStr, RsPntree.class);
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.getPntreeByCodeApiCode.rsPntree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "\u5173\u8054\u7684\u7c7b\u522b\uff08" + pntreeCode + "\uff09-\u5f02\u5e38\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        map.clear();
        mapStr.clear();
        mapStr.put("classtreeCode", rsClasstree.getClasstreeCode());
        mapStr.put("tenantCode", rsClasstree.getTenantCode());
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String goodsClassJson = "";
        try {
            goodsClassJson = (String)this.getInternalRouter().inInvoke("rs.goodsClass.queryGoodsClassPage", map);
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryGoodsClassPage.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map:" + mapStr));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "\u5bf9\u5e94\u7684\u524d\u53f0\u5206\u7c7b-\u5f02\u5e38\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        SupQueryResult supQueryResultGoodsClass = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(goodsClassJson, SupQueryResult.class);
        List goodsClassList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultGoodsClass.getList()), RsGoodsClass.class);
        HashMap<String, String> specGroupMap = new HashMap<String, String>();
        HashMap<String, String> specGroupMapStr = new HashMap<String, String>();
        specGroupMapStr.put("pntreeCode", pntreeCode);
        specGroupMapStr.put("tenantCode", tenantCode);
        specGroupMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(specGroupMapStr));
        String specGroupJsonList = "";
        try {
            specGroupJsonList = (String)this.getInternalRouter().inInvoke("rs.spec.querySpecGroupPage", specGroupMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.checkGoods.querySpecGroupPage.e", (Object)("\u6839\u636e\u7c7b\u522b\u67e5\u8be2\u89c4\u683c\u7ec4\u5f02\u5e38!!!map:" + specGroupMapStr), (Throwable)e);
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u6839\u636e\u7c7b\u522b\u67e5\u8be2\u89c4\u683c\u7ec4\u5f02\u5e38\uff01\uff01\uff01map:" + specGroupMapStr);
            return rsResourceGoodsDomain;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(specGroupJsonList, SupQueryResult.class);
        List specGroupList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsSpecGroup.class);
        if (ListUtil.isEmpty((Collection)specGroupList)) {
            mapStr.clear();
            RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
            rsSpecGroupDomain.setPntreeCode(rsPntree.getPntreeCode());
            rsSpecGroupDomain.setSpecGroupName(rsPntree.getPntreeName());
            rsSpecGroupDomain.setTenantCode(tenantCode);
            mapStr.put("rsSpecGroupDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecGroupDomain));
            String specGroupCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", mapStr);
            if (StringUtils.isBlank((String)specGroupCode)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.checkGoods.saveSpecGroup", (Object)("\u89c4\u683c\u7ec4\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsSpecGroupDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain)));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u89c4\u683c\u7ec4\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01");
                return rsResourceGoodsDomain;
            }
            RsSpecDomain rsSpecDomain = new RsSpecDomain();
            rsSpecDomain.setSpecName(infGoods.getGoodsspec());
            rsSpecDomain.setSpecGroupCode(specGroupCode);
            rsSpecDomain.setSpecDefault("1");
            rsSpecDomain.setTenantCode(tenantCode);
            mapStr.put("rsSpecDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecDomain));
            String specCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpec", mapStr);
            if (StringUtils.isBlank((String)specCode)) {
                this.logger.error(".inertGoodsByPage.checkGoods.saveSpec", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain)));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u89c4\u683c\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01");
                return rsResourceGoodsDomain;
            }
            HashMap<String, String> querySpecMap = new HashMap<String, String>();
            HashMap<String, String> querySpecMapStr = new HashMap<String, String>();
            querySpecMapStr.put("specCode", specCode);
            querySpecMapStr.put("tenantCode", tenantCode);
            querySpecMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(querySpecMapStr));
            String querySpecJson = "";
            try {
                querySpecJson = (String)this.getInternalRouter().inInvoke("rs.spec.getSpecByCode", querySpecMap);
                if (StringUtils.isBlank((String)querySpecJson)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.checkGoods.getSpecByCode", (Object)("\u63d2\u5165\u89c4\u683c\u4e4b\u540e\uff0c\u6839\u636e\u89c4\u683ccode\u67e5\u8be2\u8be5\u89c4\u683c\u4e3a\u7a7a!!!map:" + querySpecMapStr));
                    RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                    rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u63d2\u5165\u89c4\u683c\u4e4b\u540e\uff0c\u6839\u636e\u89c4\u683ccode\u67e5\u8be2\u8be5\u89c4\u683c\u4e3a\u7a7a\uff01\uff01\uff01map:" + specGroupMapStr);
                    return rsResourceGoodsDomain;
                }
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.checkGoods.getSpecByCode.e", (Object)("\u63d2\u5165\u89c4\u683c\u4e4b\u540e\uff0c\u6839\u636e\u89c4\u683ccode\u67e5\u8be2\u8be5\u89c4\u683c\u5f02\u5e38!!!map:" + querySpecMapStr), (Throwable)e);
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u63d2\u5165\u89c4\u683c\u4e4b\u540e\uff0c\u6839\u636e\u89c4\u683ccode\u67e5\u8be2\u8be5\u89c4\u683c\u5f02\u5e38\uff01\uff01\uff01map:" + specGroupMapStr);
                return rsResourceGoodsDomain;
            }
            RsSpec rsSpec = (RsSpec)JsonUtil.buildNormalBinder().getJsonToObject(querySpecJson, RsSpec.class);
            specMap.put("specGroupCode", specGroupCode);
            specMap.put("specCode", specCode);
            specMap.put("specName", rsSpec.getSpecName());
        } else {
            RsSpecGroup rsSpecGroup = (RsSpecGroup)specGroupList.get(0);
            specMap.put("specGroupCode", rsSpecGroup.getSpecGroupCode());
            HashMap<String, String> querySpecMap = new HashMap<String, String>();
            HashMap<String, String> querySpecMapStr = new HashMap<String, String>();
            querySpecMapStr.put("specGroupCode", rsSpecGroup.getSpecGroupCode());
            querySpecMapStr.put("tenantCode", tenantCode);
            querySpecMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(querySpecMapStr));
            String querySpecJson = "";
            try {
                querySpecJson = (String)this.getInternalRouter().inInvoke("rs.spec.querySpecPage", querySpecMap);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.checkGoods.querySpecPage.e", (Object)("\u6839\u636e\u89c4\u683c\u7ec4\u67e5\u8be2\u89c4\u683c\u5f02\u5e38!!!map:" + querySpecMapStr), (Throwable)e);
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u6839\u636e\u89c4\u683c\u7ec4\u67e5\u8be2\u89c4\u683c\u5f02\u5e38\uff01\uff01\uff01map:" + specGroupMapStr);
                return rsResourceGoodsDomain;
            }
            SupQueryResult querySpecQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(querySpecJson, SupQueryResult.class);
            List specList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)querySpecQueryResult.getList()), RsSpec.class);
            if (ListUtil.isEmpty((Collection)specList)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.checkGoods.querySpecPage", (Object)("\u6839\u636e\u89c4\u683c\u7ec4\u67e5\u8be2\u89c4\u683c\u4e3a\u7a7a!!!map:" + querySpecMapStr));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u6839\u636e\u89c4\u683c\u7ec4\u67e5\u8be2\u89c4\u683c\u4e3a\u7a7a\uff01\uff01\uff01map:" + specGroupMapStr);
                return rsResourceGoodsDomain;
            }
            specMap.put("specCode", ((RsSpec)specList.get(0)).getSpecCode());
            specMap.put("specName", ((RsSpec)specList.get(0)).getSpecName());
        }
        return this.saveGoods(rsBrand, rsClasstree, rsPntree, rsSkuMomDomain, null, infGoods, goodsClassList, isChildFlag);
    }

    public RsResourceGoodsDomain saveGoods(RsBrand rsBrand, RsClasstree rsClasstree, RsPntree rsPntree, RsSkuDomain rsSkuMomDomain, List<RsSpecValueDomain> rsSpecValueDomainsList, InfGoods infGoods, List<RsGoodsClass> goodsClassList, boolean isChildFlag) {
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsEocode(infGoods.getGoodsid());
        rsResourceGoodsDomain.setTenantCode(rsBrand.getTenantCode());
        rsResourceGoodsDomain.setBrandCode(rsBrand.getBrandCode());
        rsResourceGoodsDomain.setBrandName(rsBrand.getBrandName());
        rsResourceGoodsDomain.setPntreeCode(rsPntree.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(rsPntree.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(rsClasstree.getClasstreeName());
        rsResourceGoodsDomain.setGoodsNo(infGoods.getGoodsid());
        rsResourceGoodsDomain.setGoodsName(infGoods.getGoodsname());
        rsResourceGoodsDomain.setGoodsShowname(infGoods.getGoodsname());
        rsResourceGoodsDomain.setPricesetNprice(infGoods.getAdviceprice());
        rsResourceGoodsDomain.setGoodsMinnum(new BigDecimal(1));
        rsResourceGoodsDomain.setPartsnameNumunit(infGoods.getUnitname());
        rsResourceGoodsDomain.setGoodsWeight(new BigDecimal(infGoods.getGoodsweight()));
        if (ListUtil.isNotEmpty(goodsClassList) && goodsClassList.size() == 1) {
            rsResourceGoodsDomain.setClasstreeShopcode(goodsClassList.get(0).getGoodsClassCode());
            rsResourceGoodsDomain.setClasstreeShopname(goodsClassList.get(0).getGoodsClassName());
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)rsBrand.getTenantCode());
        rsResourceGoodsDomain.setMemberCode(memberCode);
        rsResourceGoodsDomain.setMemberName(memberCode);
        rsResourceGoodsDomain.setMemberCode(memberCode);
        rsResourceGoodsDomain.setMemberName(memberCode);
        rsResourceGoodsDomain.setProductareaName(infGoods.getProducingarea());
        if (isChildFlag) {
            rsResourceGoodsDomain.setGoodsOrigin("20");
            rsResourceGoodsDomain.setGoodsPro("3");
        } else {
            rsResourceGoodsDomain.setGoodsOrigin("0");
        }
        rsResourceGoodsDomain.setGoodsType("00");
        rsResourceGoodsDomain.setGoodsCodeOld(infGoods.getGoodsid());
        ArrayList<RsSkuDomain> rsSkuDomainsList = new ArrayList<RsSkuDomain>();
        rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainsList);
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        rsSkuDomainsList.add(rsSkuDomain);
        rsSkuDomain.setSkuCodeOld(infGoods.getGoodsid());
        if (ListUtil.isNotEmpty(goodsClassList) && goodsClassList.size() == 1) {
            rsSkuDomain.setClasstreeShopcode(goodsClassList.get(0).getGoodsClassCode());
        }
        rsSkuDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
        rsSkuDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
        rsSkuDomain.setGoodsMinnum(new BigDecimal(1));
        rsSkuDomain.setSkuName(infGoods.getGoodsspec());
        rsSkuDomain.setPricesetNprice(infGoods.getAdviceprice());
        rsSkuDomain.setPricesetAsprice(infGoods.getAdvicecost());
        rsSkuDomain.setSkuBarcode(infGoods.getBarcode());
        rsSkuDomain.setGoodsWeight(new BigDecimal(infGoods.getGoodsweight()));
        rsSkuDomain.setPartsnameNumunit(infGoods.getUnitname());
        rsSkuDomain.setTenantCode(rsBrand.getTenantCode());
        rsSkuDomain.setSkuNo(infGoods.getGoodsid());
        rsSkuDomain.setGoodsNo(infGoods.getGoodsid());
        rsSkuDomain.setSpecList(rsSpecValueDomainsList);
        if (ListUtil.isNotEmpty(goodsClassList)) {
            rsSkuDomain.setClasstreeShopcode(goodsClassList.get(0).getGoodsClassCode());
        }
        if (rsSkuMomDomain != null) {
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
            RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
            rsGoodsRelDomain.setGoodsRelGcode(rsSkuMomDomain.getGoodsCode());
            rsGoodsRelDomain.setGoodsRelType("4");
            rsGoodsRelDomain.setSkuCode(rsSkuMomDomain.getSkuCode());
            rsGoodsRelDomain.setSkuName(rsSkuMomDomain.getSkuName());
            rsGoodsRelDomain.setPricesetNprice(rsSkuMomDomain.getPricesetNprice());
            rsGoodsRelDomain.setSkuNo(rsSkuMomDomain.getSkuNo());
            rsGoodsRelDomain.setGoodsName(rsSkuMomDomain.getGoodsName());
            rsGoodsRelDomainList.add(rsGoodsRelDomain);
            rsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
            rsSkuDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
        }
        return rsResourceGoodsDomain;
    }

    @Override
    public List<InfGoods> queryGoodsByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo * pageSize);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfGoods> infGoodsQueryResult = this.queryGoodsPage(map);
        return infGoodsQueryResult.getList();
    }

    public static void main(String[] args) {
        File file = new File("C:\\Users\\cheng\\Desktop\\\u524d\u540e\u53f0\u5206\u7c7b\u5bfc\u5165-\u6574\u7406\u7248.xls");
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)in);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            for (int sheetIndex = 0; sheetIndex < wb.getNumberOfSheets(); ++sheetIndex) {
                HSSFSheet st = wb.getSheetAt(sheetIndex);
                for (int rowIndex = 0; rowIndex <= st.getLastRowNum(); ++rowIndex) {
                    HSSFRow row = st.getRow(rowIndex);
                    System.out.println(row.getCell(0));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

