/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfGoodsMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.DisDgmcnumDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.DisDgmcnumlistDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsGoodsClassconfDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSpecDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.DisChannel;
import com.yqbsoft.laser.service.adapter.fuji.model.DisDgmcnum;
import com.yqbsoft.laser.service.adapter.fuji.model.DisDgmcnumlist;
import com.yqbsoft.laser.service.adapter.fuji.model.InfGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsBrand;
import com.yqbsoft.laser.service.adapter.fuji.model.RsClasstree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsGoodsClass;
import com.yqbsoft.laser.service.adapter.fuji.model.RsGoodsClassconf;
import com.yqbsoft.laser.service.adapter.fuji.model.RsPntree;
import com.yqbsoft.laser.service.adapter.fuji.model.RsResourceGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSku;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSpec;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSpecGroup;
import com.yqbsoft.laser.service.adapter.fuji.model.UmUserinfo;
import com.yqbsoft.laser.service.adapter.fuji.model.ViewChangeunitgoods;
import com.yqbsoft.laser.service.adapter.fuji.service.InfBrandService;
import com.yqbsoft.laser.service.adapter.fuji.service.InfCategoryService;
import com.yqbsoft.laser.service.adapter.fuji.service.InfGoodsService;
import com.yqbsoft.laser.service.adapter.fuji.service.impl.HttpRequest;
import com.yqbsoft.laser.service.adapter.fuji.utils.HttpRequestUtiles;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfGoodsServiceImpl
extends BaseServiceImpl
implements InfGoodsService {
    private static final String SYS_CODE = "service.adapter.fuji.InfGoodsServiceImpl";
    private InfGoodsMapper infGoodsMapper;
    private InfBrandService infBrandService;
    private InfCategoryService infCategoryService;
    private String fujiGoodsKey = "fujiGoods";
    private String fujiMomAndChildGoodsKey = "";

    public void setInfBrandService(InfBrandService infBrandService) {
        this.infBrandService = infBrandService;
    }

    public void setInfCategoryService(InfCategoryService infCategoryService) {
        this.infCategoryService = infCategoryService;
    }

    public void setInfGoodsMapper(InfGoodsMapper infGoodsMapper) {
        this.infGoodsMapper = infGoodsMapper;
    }

    private InfGoods getGoodsModelById(String goodsId) {
        if (null == goodsId) {
            return null;
        }
        try {
            return this.infGoodsMapper.selectByPrimaryKey(goodsId);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.getGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private InfGoods getGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.infGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.getGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private List<InfGoods> queryGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.infGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.countGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfGoods getGoods(String goodsId) {
        return this.getGoodsModelById(goodsId);
    }

    @Override
    public QueryResult<InfGoods> queryGoodsPage(Map<String, Object> map) {
        List<InfGoods> infGoodsList = this.queryGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infGoodsList);
        return queryResult;
    }

    @Override
    public InfGoods getGoodsByCode(String goodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        return this.getGoodsModelByCode(map);
    }

    @Override
    public void inertGoodsByPage(String pageNo, String pageSize, String tenantCode) {
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            DisUtil.del((String)this.fujiGoodsKey);
            pageNo = "0";
            pageSize = "50";
            tenantCode = "2019071800001392";
        }
        boolean flag = false;
        if ("0".equals(pageNo) && "5".equals(pageSize)) {
            flag = true;
        }
        Integer pn = Integer.valueOf(pageNo);
        Integer ps = Integer.valueOf(pageSize);
        String lasttime = DisUtil.get((String)this.fujiGoodsKey);
        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.start", (Object)("\u540c\u6b65\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (StringUtils.isNotBlank((String)lasttime)) {
            try {
                Date dateTime = sdf.parse(lasttime);
                dateTime.setTime(dateTime.getTime() - 120000L);
                lasttime = sdf.format(dateTime);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                return;
            }
        }
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> errorAddGoods = new ArrayList<String>();
        while (true) {
            long requestTime = System.currentTimeMillis();
            String jsonResult = null;
            try {
                jsonResult = HttpRequest.httpPost("/qj/queryGoodsByPage", pn, ps, null, lasttime);
                if (StringUtils.isBlank((String)jsonResult)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage", (Object)"response is null");
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
                return;
            }
            long responseTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.time", (Object)("===========\u8bf7\u6c42\u7684\u65f6\u95f4:" + (responseTime - requestTime)));
            Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
            if (!"S".equals(mapResult.get("resCode"))) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
                return;
            }
            Object dataStr = mapResult.get("dataStr");
            if (dataStr == null) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
                return;
            }
            List infGoodsList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(dataStr.toString(), InfGoods.class);
            if (ListUtil.isEmpty((Collection)infGoodsList)) {
                if (ListUtil.isEmpty(errorAddGoods)) {
                    DisUtil.set((String)this.fujiGoodsKey, (String)sdf.format(new Date()));
                }
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.end", (Object)("\u540c\u6b65\u7ed3\u675f,\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.get((String)this.fujiGoodsKey) + ",\u9519\u8bef\u7684\u5546\u54c1errorAddGoods:" + JsonUtil.buildNormalBinder().toJson(errorAddGoods)));
                return;
            }
            goodsList.clear();
            for (InfGoods infGoods : infGoodsList) {
                map.clear();
                map.put("goodsNo", infGoods.getGoodsid());
                map.put("tenantCode", tenantCode);
                List resourceGoodsList = null;
                try {
                    String resourceGoodsListStr = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.checkGoodsNo", map);
                    resourceGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(resourceGoodsListStr, RsResourceGoods.class);
                }
                catch (Exception e) {
                    this.logger.error(".inertGoodsByPage.checkGoodsNoApiCode.resourceGoodsList", (Object)(resourceGoodsList + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
                if (!ListUtil.isEmpty((Collection)resourceGoodsList)) continue;
                RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, false, null, null, null, null, tenantCode);
                if (rsResourceGoodsDomain == null) {
                    errorAddGoods.add(infGoods.getGoodsid());
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.checkGoods", (Object)"\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01");
                    continue;
                }
                goodsList.add(rsResourceGoodsDomain);
            }
            if (ListUtil.isNotEmpty(goodsList)) {
                map.clear();
                map.put("goodsList", JsonUtil.buildNonDefaultBinder().toJson(goodsList));
                try {
                    this.getInternalRouter().inInvoke("rs.resource.sendSavePassResourceGoodsBatch", map);
                }
                catch (Exception e) {
                    this.logger.error(".inertGoodsByPage.sendSavePassResourceGoodsBatch.e", (Object)("\u6279\u91cf\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01,\u5f53\u524d\u65f6\u95f4:" + DisUtil.get((String)this.fujiGoodsKey) + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                    return;
                }
            }
            long endTime = System.currentTimeMillis();
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.time", (Object)("===========\u65b9\u6cd5\u63d2\u5165\u65f6\u95f4:" + (endTime - requestTime)));
            Integer n = pn;
            Integer n2 = pn = Integer.valueOf(pn + 1);
        }
    }

    public void updateGoods() {
    }

    @Override
    public Boolean insertOneGoods(String goodsId, String tenantCode, InfGoods infGoods) {
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode));
            return false;
        }
        if (infGoods == null && (infGoods = this.queryGoods(goodsId, requestUrl)) == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.queryGoods", (Object)("\u67e5\u8be2\u5931\u8d25goodsId\uff1a" + goodsId));
            return false;
        }
        ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
        RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, false, null, null, null, null, tenantCode);
        if (rsResourceGoodsDomain == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertOneGoods.checkGoods", (Object)"\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01");
            return false;
        }
        goodsList.add(rsResourceGoodsDomain);
        if (ListUtil.isNotEmpty(goodsList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsList", JsonUtil.buildNonDefaultBinder().toJson(goodsList));
            try {
                this.getInternalRouter().inInvoke("rs.resource.sendSavePassResourceGoodsBatch", map);
            }
            catch (Exception e) {
                this.logger.error(".insertOneGoods.sendSavePassResourceGoodsBatch.e", (Object)"\u6279\u91cf\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01");
                return false;
            }
        }
        return true;
    }

    @Override
    public String saveExcelGoods(Map<String, Object> map) {
        String tenantCode;
        String goodsCode = null == map.get("goodsCode") ? "" : String.valueOf(map.get("goodsCode"));
        String barCode = null == map.get("barCode") ? "" : String.valueOf(map.get("barCode"));
        String goodsName = null == map.get("goodsName") ? "" : String.valueOf(map.get("goodsName"));
        String goodsPrice = null == map.get("goodsPrice") ? "" : String.valueOf(map.get("goodsPrice"));
        String goodsStockNum = null == map.get("goodsStockNum") ? "" : String.valueOf(map.get("goodsStockNum"));
        String string = tenantCode = null == map.get("tenantCode") ? "" : String.valueOf(map.get("tenantCode"));
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)barCode) || StringUtils.isBlank((String)goodsName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.intoparam", (Object)("\u5165\u53c2\u4e3a\u7a7agoodsCode:" + goodsCode + ",barCode:" + barCode + ",goodsName:" + goodsName + ",tenantCode:" + tenantCode));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u5b58\u5728\u7a7a\u503c\uff01goodsCode:" + goodsCode + ",barCode:" + barCode + ",goodsName:" + goodsName + ",tenantCode:" + tenantCode);
        }
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u67e5\u8be2\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        InfGoods infGoods = this.queryGoods(goodsCode, requestUrl);
        if (infGoods == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.getGoodsByCode", (Object)("\u6839\u636egoodsCode\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01goodsCode:" + goodsCode));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u83b7\u53d6\u8be5\u5546\u54c1\u5931\u8d25\uff01\uff01\uff01");
        }
        List<ViewChangeunitgoods> viewChangeunitgoodsList = null;
        try {
            viewChangeunitgoodsList = this.queryViewChangeunitgoods(infGoods.getGoodsid(), requestUrl);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.queryViewChangeunitgoods", (Object)("\u5b50\u5546\u54c1id:" + infGoods.getGoodscode()));
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u67e5\u8be2\u5bcc\u57fa\u6bcd\u5b50\u5173\u7cfb\u5f02\u5e38\uff01\uff01\uff01");
        }
        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.goods", (Object)("\u4f20\u5165\u53c2\u6570:" + goodsCode + "\uff0c\u67e5\u8be2\u5230\u7684\u5546\u54c1:" + infGoods.getGoodsid() + ",\u83b7\u53d6\u5230\u7684\u6bcd\u5b50\u5546\u54c1\u5173\u7cfb:" + viewChangeunitgoodsList.size()));
        if (ListUtil.isEmpty(viewChangeunitgoodsList)) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            HashMap<String, String> mapStr = new HashMap<String, String>();
            mapStr.put("skuNo", infGoods.getGoodsid());
            mapStr.put("goodsOrigin", "0");
            mapStr.put("tenantCode", tenantCode);
            queryMap.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
            String skuJson = "";
            try {
                skuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", queryMap);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01");
            }
            SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuJson, SupQueryResult.class);
            List rsSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsSkuDomain.class);
            if (ListUtil.isNotEmpty((Collection)rsSkuDomainList)) {
                return this.responseAddGoods("success", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u5546\u54c1\u5df2\u5b58\u5728\uff01\uff01\uff01\u5982\u82e5\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u8bf7\u5728\u9875\u9762\u64cd\u4f5c\uff01\uff01\uff01");
            }
            String msg = this.sendSavePassResourceGoodsBatch(infGoods, false, null, goodsPrice, goodsStockNum, tenantCode);
            if (!"success".equals(msg)) {
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, msg);
            }
            return this.responseAddGoods("success", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u6dfb\u52a0\u6210\u529f\uff01\uff01\uff01");
        }
        ViewChangeunitgoods viewChangeunitgoods = viewChangeunitgoodsList.get(0);
        InfGoods momtherGoods = this.queryGoods(viewChangeunitgoods.getMgoodsid(), requestUrl);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("skuNo", momtherGoods.getGoodsid());
        mapStr.put("goodsOrigin", "0");
        mapStr.put("tenantCode", tenantCode);
        queryMap.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String skuJson = "";
        try {
            skuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", queryMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u8be5\u5546\u54c1\u662f\u5b50\u5546\u54c1\uff0c\u67e5\u8be2\u6bcd\u5546\u54c1sku\u5f02\u5e38\uff01\uff01\uff01");
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuJson, SupQueryResult.class);
        List rsSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsSkuDomain.class);
        RsSkuDomain rsSkuMomDomain = null;
        if (ListUtil.isEmpty((Collection)rsSkuDomainList)) {
            String msg = this.sendSavePassResourceGoodsBatch(momtherGoods, false, null, null, null, tenantCode);
            if (!"success".equals(msg)) {
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u6dfb\u52a0\u6bcd\u5546\u54c1:" + msg);
            }
            HashMap<String, String> queryMomGoodsMap = new HashMap<String, String>();
            HashMap<String, String> queryMomGoodsMapStr = new HashMap<String, String>();
            queryMomGoodsMapStr.put("skuNo", momtherGoods.getGoodsid());
            queryMomGoodsMapStr.put("goodsOrigin", "0");
            queryMomGoodsMapStr.put("tenantCode", tenantCode);
            queryMomGoodsMap.put("map", JsonUtil.buildNormalBinder().toJson(queryMomGoodsMapStr));
            String querySkuJson = "";
            try {
                querySkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", queryMomGoodsMap);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u8be5\u5546\u54c1\u662f\u5b50\u5546\u54c1\uff0c\u6dfb\u52a0\u6bcd\u5546\u54c1\u4e4b\u540e\u67e5\u8be2\u6bcd\u5546\u54c1sku\u5f02\u5e38\uff01\uff01\uff01");
            }
            SupQueryResult queryMomQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(querySkuJson, SupQueryResult.class);
            List queryMomDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryMomQueryResultStr.getList()), RsSkuDomain.class);
            rsSkuMomDomain = (RsSkuDomain)queryMomDomainList.get(0);
        } else {
            rsSkuMomDomain = (RsSkuDomain)rsSkuDomainList.get(0);
        }
        HashMap<String, String> childMap = new HashMap<String, String>();
        HashMap<String, String> childMapStr = new HashMap<String, String>();
        childMapStr.put("skuNo", infGoods.getGoodsid());
        childMapStr.put("goodsOrigin", "20");
        childMapStr.put("tenantCode", tenantCode);
        childMap.put("map", JsonUtil.buildNormalBinder().toJson(childMapStr));
        String skuChildJson = "";
        try {
            skuChildJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", childMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoodsNoApiCode.querySkuPage.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map:" + map), (Throwable)e);
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u8be5\u5546\u54c1\u662f\u5b50\u5546\u54c1\uff0c\u67e5\u8be2\u5b50\u5546\u54c1sku\u5f02\u5e38\uff01\uff01\uff01");
        }
        SupQueryResult supChileQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuChildJson, SupQueryResult.class);
        List rsSkuChildDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supChileQueryResultStr.getList()), RsSkuDomain.class);
        if (ListUtil.isEmpty((Collection)rsSkuChildDomainList)) {
            String msg = this.sendSavePassResourceGoodsBatch(infGoods, true, rsSkuMomDomain, goodsPrice, goodsStockNum, tenantCode);
            if (!"success".equals(msg)) {
                return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u6dfb\u52a0\u5b50\u5546\u54c1\u548c\u6bcd\u5b50\u5173\u7cfb:" + msg);
            }
            return this.responseAddGoods("success", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u6dfb\u52a0\u5b50\u5546\u54c1\u6210\u529f\u5e76\u6dfb\u52a0\u6bcd\u5b50\u5173\u7cfb\u6210\u529f\uff01\uff01\uff01");
        }
        RsSkuDomain rsSkuChildDomain = (RsSkuDomain)rsSkuChildDomainList.get(0);
        Boolean goodsReslFlag = this.saveGoodsRel(rsSkuMomDomain, rsSkuChildDomain);
        if (!goodsReslFlag.booleanValue()) {
            return this.responseAddGoods("false", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u5b50\u5546\u54c1\u5df2\u5b58\u5728\uff0c\u4f46\u6dfb\u52a0\u6bcd\u5b50\u5173\u7cfb\u5931\u8d25");
        }
        return this.responseAddGoods("success", goodsCode, barCode, goodsName, goodsPrice, goodsStockNum, "\u5b50\u5546\u54c1\u5df2\u5b58\u5728\u5e76\u6dfb\u52a0\u6bcd\u5b50\u5173\u7cfb\u6210\u529f\uff01\uff01\uff01");
    }

    @Override
    public String insertEntityAndVirtualClasstree(Map<String, Object> map) {
        String rsGoodsClassConfCode;
        RsGoodsClassconfDomain rsGoodsClassconfDomain;
        String msg;
        String rsGoodsClassCode;
        RsGoodsClass rsOneGoodsClass;
        RsClasstree rsClasstree;
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.map", (Object)"map is null");
            return null;
        }
        String virtualOneClasstreeName = null == map.get("virtualOneClasstreeName") ? "" : String.valueOf(map.get("virtualOneClasstreeName"));
        String virtualTwoClasstreeName = null == map.get("virtualTwoClasstreeName") ? "" : String.valueOf(map.get("virtualTwoClasstreeName"));
        String virtualThreeClasstreeName = null == map.get("virtualThreeClasstreeName") ? "" : String.valueOf(map.get("virtualThreeClasstreeName"));
        String entityClasstreeCode = null == map.get("entityClasstreeCode") ? "" : String.valueOf(map.get("entityClasstreeCode"));
        String level = null == map.get("level") ? "" : String.valueOf(map.get("level"));
        String tenantCode = (String)map.get("tenantCode");
        String userinfoCode = (String)map.get("userinfoCode");
        if (StringUtils.isBlank((String)virtualOneClasstreeName) || StringUtils.isBlank((String)entityClasstreeCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertEntityAndVirtualClasstree.param", (Object)("\u53c2\u6570\u4e3a\u7a7a\uff01\uff01\uff01virtualOneClasstreeName:" + virtualOneClasstreeName + ",entityClasstreeCode:" + entityClasstreeCode));
            return null;
        }
        if (StringUtils.isNotBlank((String)virtualThreeClasstreeName)) {
            if (StringUtils.isBlank((String)virtualOneClasstreeName) || StringUtils.isBlank((String)virtualTwoClasstreeName)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass.rsClasstree", (Object)("\u6dfb\u52a0\u4e09\u7ea7\u5206\u7c7b\uff0c\u5bf9\u5e94\u4e00\u7ea7\uff0c\u4e8c\u7ea7\u6709\u7a7a\u503c!virtualOneClasstreeName:" + virtualOneClasstreeName + ",virtualTwoClasstreeName:" + virtualTwoClasstreeName));
                return null;
            }
            RsGoodsClass rsThreeGoodsClass = this.queryGoodsClass(virtualThreeClasstreeName, tenantCode);
            if (rsThreeGoodsClass == null) {
                rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                if (rsClasstree == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass.rsClasstree", (Object)("\u6dfb\u52a0\u4e09\u7ea7\u524d\u53f0\u5206\u7c7b\uff0c\u67e5\u8be2\u8be5\u5b9e\u4f53\u5206\u7c7b\u4e3a\u7a7aentityClasstreeCode:" + entityClasstreeCode));
                    return null;
                }
                rsOneGoodsClass = this.queryGoodsClass(virtualOneClasstreeName, tenantCode);
                if (rsOneGoodsClass == null) {
                    String rsOneGoodsClassCode = this.saveRsGoodsClass(virtualOneClasstreeName, rsClasstree, tenantCode, "-1", "1", userinfoCode, false);
                    if (StringUtils.isBlank((String)rsOneGoodsClassCode)) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3,\u4fdd\u5b58\u4e00\u7ea7\u5206\u7c7b");
                        return null;
                    }
                    String rsTwoGoodsClassCode = this.saveRsGoodsClass(virtualTwoClasstreeName, rsClasstree, tenantCode, rsOneGoodsClassCode, "1", userinfoCode, false);
                    if (StringUtils.isBlank((String)rsTwoGoodsClassCode)) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3,\u4fdd\u5b58\u4e8c\u7ea7\u5206\u7c7b");
                        return null;
                    }
                    String rsGoodsClassCode2 = this.saveRsGoodsClass(virtualThreeClasstreeName, rsClasstree, tenantCode, rsTwoGoodsClassCode, "0", userinfoCode, true);
                    if (rsGoodsClassCode2 == null) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3,\u4fdd\u5b58\u4e09\u7ea7\u5206\u7c7b");
                        return null;
                    }
                    return "success";
                }
                RsGoodsClass rsTwoGoodsClass = this.queryGoodsClass(virtualTwoClasstreeName, tenantCode);
                if (rsTwoGoodsClass == null) {
                    String rsTwoGoodsClassCode = this.saveRsGoodsClass(virtualTwoClasstreeName, rsClasstree, tenantCode, rsOneGoodsClass.getGoodsClassCode(), "1", userinfoCode, false);
                    if (StringUtils.isBlank((String)rsTwoGoodsClassCode)) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3,\u4fdd\u5b58\u4e8c\u7ea7\u5206\u7c7b");
                        return null;
                    }
                    String rsGoodsClassCode3 = this.saveRsGoodsClass(virtualThreeClasstreeName, rsClasstree, tenantCode, rsTwoGoodsClassCode, "0", userinfoCode, true);
                    if (rsGoodsClassCode3 == null) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3,\u4fdd\u5b58\u4e09\u7ea7\u5206\u7c7b");
                        return null;
                    }
                    return "success";
                }
                rsGoodsClassCode = this.saveRsGoodsClass(virtualThreeClasstreeName, rsClasstree, tenantCode, rsTwoGoodsClass.getGoodsClassCode(), "0", userinfoCode, true);
                if (rsGoodsClassCode == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3,\u4fdd\u5b58\u4e09\u7ea7\u5206\u7c7b");
                    return null;
                }
            } else {
                rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                if (rsClasstree == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass.rsClasstree", (Object)("\u6dfb\u52a0\u4e09\u7ea7\u524d\u53f0\u5206\u7c7b\u5173\u8054\u540e\u53f0\uff0c\u67e5\u8be2\u8be5\u5b9e\u4f53\u5206\u7c7b\u4e3a\u7a7aentityClasstreeCode:" + entityClasstreeCode));
                    return null;
                }
                msg = this.queryRsClassConf(rsThreeGoodsClass.getGoodsClassCode(), rsClasstree.getClasstreeCode(), rsClasstree.getTenantCode());
                if (StringUtils.isNotBlank((String)msg)) {
                    if ("\u5df2\u5b58\u5728".equals(msg)) {
                        return "success";
                    }
                    return null;
                }
                rsGoodsClassconfDomain = new RsGoodsClassconfDomain();
                rsGoodsClassconfDomain.setGoodsClassCode(rsThreeGoodsClass.getGoodsClassCode());
                rsGoodsClassconfDomain.setGoodsClassconfType("classtreeCode");
                rsGoodsClassconfDomain.setGoodsClassconfName(rsClasstree.getClasstreeName());
                rsGoodsClassconfDomain.setGoodsClassconfValue(rsClasstree.getClasstreeCode());
                rsGoodsClassconfDomain.setMemberCode(userinfoCode);
                rsGoodsClassconfDomain.setTenantCode(tenantCode);
                rsGoodsClassConfCode = this.saveRsGoodsClassConf(rsGoodsClassconfDomain);
                if (StringUtils.isBlank((String)rsGoodsClassConfCode)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:3");
                    return null;
                }
            }
        }
        if (StringUtils.isNotBlank((String)virtualTwoClasstreeName)) {
            if (StringUtils.isBlank((String)virtualOneClasstreeName)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass.rsClasstree", (Object)("\u6dfb\u52a0\u4e8c\u7ea7\u5206\u7c7b\uff0c\u5bf9\u5e94\u4e00\u7ea7\u6709\u7a7a\u503c!virtualOneClasstreeName:" + virtualOneClasstreeName));
                return null;
            }
            RsGoodsClass rsTwoGoodsClass = this.queryGoodsClass(virtualTwoClasstreeName, tenantCode);
            if (rsTwoGoodsClass == null) {
                rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                if (rsClasstree == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass.rsClasstree", (Object)("\u6dfb\u52a0\u4e8c\u7ea7\u524d\u53f0\u5206\u7c7b\uff0c\u67e5\u8be2\u8be5\u5b9e\u4f53\u5206\u7c7b\u4e3a\u7a7aentityClasstreeCode:" + entityClasstreeCode));
                    return null;
                }
                rsOneGoodsClass = this.queryGoodsClass(virtualOneClasstreeName, tenantCode);
                if (rsOneGoodsClass == null) {
                    String rsOneGoodsClassCode = this.saveRsGoodsClass(virtualOneClasstreeName, rsClasstree, tenantCode, "-1", "1", userinfoCode, false);
                    if (StringUtils.isBlank((String)rsOneGoodsClassCode)) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:2,\u4fdd\u5b58\u4e00\u7ea7\u5206\u7c7b");
                        return null;
                    }
                    rsGoodsClassCode = this.saveRsGoodsClass(virtualTwoClasstreeName, rsClasstree, tenantCode, rsOneGoodsClassCode, "0", userinfoCode, true);
                    if (StringUtils.isBlank((String)rsGoodsClassCode)) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:2,\u4fdd\u5b58\u4e8c\u7ea7\u5206\u7c7b");
                        return null;
                    }
                    return "success";
                }
                String rsGoodsClassCode4 = this.saveRsGoodsClass(virtualTwoClasstreeName, rsClasstree, tenantCode, rsOneGoodsClass.getGoodsClassCode(), "0", userinfoCode, true);
                if (StringUtils.isBlank((String)rsGoodsClassCode4)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:2,\u4fdd\u5b58\u4e8c\u7ea7\u5206\u7c7b");
                    return null;
                }
            } else {
                rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                if (rsClasstree == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass.rsClasstree", (Object)("\u6dfb\u52a0\u4e8c\u7ea7\u524d\u53f0\u5206\u7c7b\u5173\u8054\u540e\u53f0\uff0c\u67e5\u8be2\u8be5\u5b9e\u4f53\u5206\u7c7b\u4e3a\u7a7aentityClasstreeCode:" + entityClasstreeCode));
                    return null;
                }
                msg = this.queryRsClassConf(rsTwoGoodsClass.getGoodsClassCode(), rsClasstree.getClasstreeCode(), rsClasstree.getTenantCode());
                if (StringUtils.isNotBlank((String)msg)) {
                    if ("\u5df2\u5b58\u5728".equals(msg)) {
                        return "success";
                    }
                    return null;
                }
                rsGoodsClassconfDomain = new RsGoodsClassconfDomain();
                rsGoodsClassconfDomain.setGoodsClassCode(rsTwoGoodsClass.getGoodsClassCode());
                rsGoodsClassconfDomain.setGoodsClassconfType("classtreeCode");
                rsGoodsClassconfDomain.setGoodsClassconfName(rsClasstree.getClasstreeName());
                rsGoodsClassconfDomain.setGoodsClassconfValue(rsClasstree.getClasstreeCode());
                rsGoodsClassconfDomain.setMemberCode(userinfoCode);
                rsGoodsClassconfDomain.setTenantCode(tenantCode);
                rsGoodsClassConfCode = this.saveRsGoodsClassConf(rsGoodsClassconfDomain);
                if (StringUtils.isBlank((String)rsGoodsClassConfCode)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:2");
                    return null;
                }
            }
            return "success";
        }
        if (StringUtils.isNotBlank((String)virtualOneClasstreeName)) {
            RsGoodsClass rsOneGoodsClass2 = this.queryGoodsClass(virtualOneClasstreeName, tenantCode);
            if (rsOneGoodsClass2 == null) {
                rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                if (rsClasstree == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass.rsClasstree", (Object)("\u6dfb\u52a0\u4e00\u7ea7\u524d\u53f0\u5206\u7c7b\uff0c\u67e5\u8be2\u8be5\u5b9e\u4f53\u5206\u7c7b\u4e3a\u7a7aentityClasstreeCode:" + entityClasstreeCode));
                    return null;
                }
                String rsGoodsClassCode5 = this.saveRsGoodsClass(virtualOneClasstreeName, rsClasstree, tenantCode, "-1", "0", userinfoCode, true);
                if (StringUtils.isBlank((String)rsGoodsClassCode5)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7b\u548c\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:1,\u4fdd\u5b58\u4e00\u7ea7\u5206\u7c7b");
                    return null;
                }
            } else {
                rsClasstree = this.queryClasstree(entityClasstreeCode, tenantCode);
                if (rsClasstree == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass.rsClasstree", (Object)("\u6dfb\u52a0\u4e00\u7ea7\u524d\u53f0\u5206\u7c7b\u5173\u8054\u540e\u53f0\uff0c\u67e5\u8be2\u8be5\u5b9e\u4f53\u5206\u7c7b\u4e3a\u7a7aentityClasstreeCode:" + entityClasstreeCode));
                    return null;
                }
                msg = this.queryRsClassConf(rsOneGoodsClass2.getGoodsClassCode(), rsClasstree.getClasstreeCode(), rsClasstree.getTenantCode());
                if (StringUtils.isNotBlank((String)msg)) {
                    if ("\u5df2\u5b58\u5728".equals(msg)) {
                        return "success";
                    }
                    return null;
                }
                rsGoodsClassconfDomain = new RsGoodsClassconfDomain();
                rsGoodsClassconfDomain.setGoodsClassCode(rsOneGoodsClass2.getGoodsClassCode());
                rsGoodsClassconfDomain.setGoodsClassconfType("classtreeCode");
                rsGoodsClassconfDomain.setGoodsClassconfName(rsClasstree.getClasstreeName());
                rsGoodsClassconfDomain.setGoodsClassconfValue(rsClasstree.getClasstreeCode());
                rsGoodsClassconfDomain.setMemberCode(userinfoCode);
                rsGoodsClassconfDomain.setTenantCode(tenantCode);
                rsGoodsClassConfCode = this.saveRsGoodsClassConf(rsGoodsClassconfDomain);
                if (StringUtils.isBlank((String)rsGoodsClassConfCode)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass", (Object)"\u6dfb\u52a0\u865a\u62df\u5206\u7c7bconf\u8868\u5931\u8d25\uff01\uff01\uff01level:1");
                    return null;
                }
            }
            return "success";
        }
        return "success";
    }

    @Override
    public void insertMomtherAndChild(String pageNo, String pageSize, String tenantCode) {
        List<UmUserinfo> umUserinfoList;
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            DisUtil.del((String)this.fujiMomAndChildGoodsKey);
            pageNo = "0";
            pageSize = "50";
            tenantCode = "2019071800001392";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode));
            return;
        }
        String onLineShop = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            String onLineShopKey = tenantCode.concat("-").concat("SSURL").concat("-").concat("onLineShop");
            onLineShop = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)onLineShopKey);
        }
        if (ListUtil.isEmpty(umUserinfoList = this.getOnlineShop(onLineShop, tenantCode))) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.queryUserinfoPage.umUserinfoList", (Object)("\u6ca1\u6709\u95e8\u5e97umUserinfoList:" + umUserinfoList.size()));
            return;
        }
        ArrayList listAllError = new ArrayList();
        boolean shopchannel = false;
        for (int i = 0; i < umUserinfoList.size(); ++i) {
            DisChannel disChannel;
            UmUserinfo umUserinfo = umUserinfoList.get(i);
            Integer pn = Integer.valueOf(pageNo);
            Integer ps = Integer.valueOf(pageSize);
            this.fujiMomAndChildGoodsKey = umUserinfo.getUserinfoOcode() + "StockKey";
            String lasttime = DisUtil.getRemot((String)this.fujiMomAndChildGoodsKey);
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.start", (Object)("\u540c\u6b65\u8be5" + umUserinfo.getUserinfoOcode() + "-" + umUserinfo.getUserinfoCompname() + "\u95e8\u5e97\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
            if (StringUtils.isNotBlank((String)lasttime)) {
                try {
                    Date dateTime = sdf.parse(lasttime);
                    dateTime.setTime(dateTime.getTime() - 120000L);
                    lasttime = sdf.format(dateTime);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertShopstockByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                    return;
                }
            }
            if ((disChannel = this.getChannelCodeByshopId(umUserinfo.getUserinfoOcode(), tenantCode)) == null) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.getChannelCodeByshopId", (Object)("\u83b7\u53d6\u95e8\u5e97\u6e20\u9053\u4e3a\u7a7a\uff01\uff01\uff01disChannel\uff1a" + disChannel + ",Shopid:" + umUserinfo.getUserinfoOcode() + ",pn:" + pn + ",ps:" + ps + ",lasttime" + lasttime));
                continue;
            }
            int count = 0;
            ArrayList<String> listError = new ArrayList<String>();
            while (true) {
                long requestTime = System.currentTimeMillis();
                ViewChangeunitgoods viewChangeunitgoods = new ViewChangeunitgoods();
                viewChangeunitgoods.setShopid(umUserinfo.getUserinfoOcode());
                viewChangeunitgoods.setPageNo(pn.toString());
                viewChangeunitgoods.setPageSize(ps.toString());
                viewChangeunitgoods.setQueryTime(lasttime);
                String requestJson = JsonUtil.buildNonNullBinder().toJson((Object)viewChangeunitgoods);
                String jsonResult = null;
                try {
                    jsonResult = HttpRequestUtiles.httpPost("/qj/queryChildGoodsInfo", requestJson, requestUrl);
                    if (StringUtils.isBlank((String)jsonResult)) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryChildGoodsInfo", (Object)("response is null,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryChildGoodsInfo"));
                        return;
                    }
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryChildGoodsInfo.e", (Object)("\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryChildGoodsInfo"));
                    return;
                }
                long responseTime = System.currentTimeMillis();
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.time", (Object)("===========\u8bf7\u6c42\u7684\u65f6\u95f4:" + (responseTime - requestTime)));
                Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
                if (!"S".equals(mapResult.get("resCode"))) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryCategoryByPage.resCode", (Object)("respose is false,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryCategoryByPage" + ",\u54cd\u5e94\u7ed3\u679c:" + jsonResult));
                    return;
                }
                Object dataStr = mapResult.get("dataStr");
                if (dataStr == null) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryCategoryByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryCategoryByPage" + ",\u54cd\u5e94\u7ed3\u679c:" + jsonResult));
                    return;
                }
                List viewChangeunitgoodsList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(dataStr.toString(), ViewChangeunitgoods.class);
                if (ListUtil.isEmpty((Collection)viewChangeunitgoodsList)) {
                    if (StringUtils.isBlank((String)DisUtil.getRemot((String)this.fujiMomAndChildGoodsKey))) {
                        DisUtil.set((String)this.fujiMomAndChildGoodsKey, (String)sdf.format(new Date()));
                    }
                    if (!ListUtil.isEmpty(listError)) break;
                    DisUtil.set((String)this.fujiMomAndChildGoodsKey, (String)sdf.format(new Date()));
                    break;
                }
                for (ViewChangeunitgoods changeunitgoods : viewChangeunitgoodsList) {
                    ++count;
                    InfGoods infMomGoods = this.queryGoods(changeunitgoods.getMgoodsid(), requestUrl);
                    if (infMomGoods == null) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.queryMGoods", (Object)("\u67e5\u8be2\u5bcc\u57fa\u6bcd\u5546\u54c1\u4e3a\u7a7a\uff01\uff01\uff01goodsid" + changeunitgoods.getMgoodsid() + "," + requestUrl));
                        continue;
                    }
                    HashMap<String, String> queryDisDgmcnumMap = new HashMap<String, String>();
                    HashMap<String, String> queryDisDgmcnumMapStr = new HashMap<String, String>();
                    queryDisDgmcnumMapStr.put("channelCode", disChannel.getChannelCode());
                    queryDisDgmcnumMapStr.put("skuNo", infMomGoods.getGoodsid());
                    queryDisDgmcnumMapStr.put("tenantCode", disChannel.getTenantCode());
                    queryDisDgmcnumMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryDisDgmcnumMapStr));
                    String queryDgmcnumJson = null;
                    try {
                        queryDgmcnumJson = (String)this.getInternalRouter().inInvoke("dis.dgmcnum.queryDgmcnumPage", queryDisDgmcnumMap);
                    }
                    catch (Exception e) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.queryDgmcnumPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + queryDisDgmcnumMap), (Throwable)e);
                        return;
                    }
                    SupQueryResult queryDgnumQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryDgmcnumJson, SupQueryResult.class);
                    List disDgmcnumList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryDgnumQueryResultStr.getList()), DisDgmcnum.class);
                    if (ListUtil.isEmpty((Collection)disDgmcnumList)) {
                        DisDgmcnumDomain disDgmcnumDomain = this.createParam(changeunitgoods, disChannel, infMomGoods, requestUrl, tenantCode);
                        if (disDgmcnumDomain == null) {
                            listError.add("\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff01" + changeunitgoods.getzGoodsid() + "-" + changeunitgoods.getMgoodsid() + "-" + changeunitgoods.getShopid());
                            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.createParam", (Object)("\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff01" + changeunitgoods.getzGoodsid() + "-" + changeunitgoods.getMgoodsid() + "-" + changeunitgoods.getShopid()));
                            continue;
                        }
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("disDgmcnumDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)disDgmcnumDomain));
                        String dgMcnumCode = null;
                        try {
                            dgMcnumCode = (String)this.getInternalRouter().inInvoke("dis.dgmcnum.saveDgmcnum", map);
                        }
                        catch (Exception e) {
                            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.saveDgmcnum.e", (Object)("\u6dfb\u52a0\u5f02\u5e38\uff01" + JsonUtil.buildNonDefaultBinder().toJson((Object)disDgmcnumDomain)), (Throwable)e);
                            return;
                        }
                        if (!StringUtils.isBlank((String)dgMcnumCode)) continue;
                        listError.add("\u6dfb\u52a0\u5931\u8d25\uff01" + JsonUtil.buildNonDefaultBinder().toJson((Object)disDgmcnumDomain));
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.createParam", (Object)("\u6dfb\u52a0\u5931\u8d25\uff01" + JsonUtil.buildNonDefaultBinder().toJson((Object)disDgmcnumDomain)));
                        continue;
                    }
                    InfGoods infChildGoods = this.queryGoods(changeunitgoods.getzGoodsid(), requestUrl);
                    if (infChildGoods == null) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.queryChildGoods", (Object)("\u67e5\u8be2\u5bcc\u57fa\u5b50\u5546\u54c1\u4e3a\u7a7a\uff01\uff01\uff01goodsid" + changeunitgoods.getzGoodsid() + "," + requestUrl));
                        continue;
                    }
                    DisDgmcnum disDgmcnum = (DisDgmcnum)disDgmcnumList.get(0);
                    HashMap<String, String> queryDgmcnumListMap = new HashMap<String, String>();
                    HashMap<String, String> queryDgmcnumListMapStr = new HashMap<String, String>();
                    queryDgmcnumListMapStr.put("channelCode", disDgmcnum.getChannelCode());
                    queryDgmcnumListMapStr.put("dgmcnumSkuNo", infChildGoods.getGoodsid());
                    queryDgmcnumListMapStr.put("skuNo", disDgmcnum.getSkuNo());
                    queryDgmcnumListMapStr.put("tenantCode", disDgmcnum.getTenantCode());
                    queryDgmcnumListMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryDgmcnumListMapStr));
                    String queryDgnumListJson = null;
                    try {
                        queryDgnumListJson = (String)this.getInternalRouter().inInvoke("dis.dgmcnum.queryDgmcnumlistPage", queryDgmcnumListMap);
                    }
                    catch (Exception e) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.queryDgmcnumlistPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + queryDisDgmcnumMap), (Throwable)e);
                        return;
                    }
                    SupQueryResult querynulListQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryDgnumListJson, SupQueryResult.class);
                    List queryDgnumList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)querynulListQueryResultStr.getList()), DisDgmcnumlist.class);
                    if (ListUtil.isEmpty((Collection)queryDgnumList)) {
                        DisDgmcnumlistDomain disDgmcnumlistDomain = new DisDgmcnumlistDomain();
                        disDgmcnumlistDomain.setChannelCode(disChannel.getChannelCode());
                        disDgmcnumlistDomain.setDgmcnumPric(1);
                        disDgmcnumlistDomain.setChannelName(disChannel.getChannelName());
                        disDgmcnumlistDomain.setChannelSort(disChannel.getChannelSort());
                        disDgmcnumlistDomain.setChannelType(disChannel.getChannelType());
                        disDgmcnumlistDomain.setMemberMcode(disChannel.getMemberMcode());
                        disDgmcnumlistDomain.setMemberMname(disChannel.getMemberMname());
                        disDgmcnumlistDomain.setMemberCode(disChannel.getMemberCcode());
                        disDgmcnumlistDomain.setMemberName(disChannel.getMemberCname());
                        disDgmcnumlistDomain.setDgmcnumPrice(new BigDecimal(changeunitgoods.getQty()));
                        disDgmcnumlistDomain.setDgmcnumSkuNo(infChildGoods.getGoodsid());
                        disDgmcnumlistDomain.setDgmcnumGoodsNo(infChildGoods.getGoodsid());
                        disDgmcnumlistDomain.setDgmcnumGoodsName(infChildGoods.getGoodsname());
                        disDgmcnumlistDomain.setDgmcnumCode(disDgmcnum.getDgmcnumCode());
                        disDgmcnumlistDomain.setSkuNo(disDgmcnum.getSkuNo());
                        disDgmcnumlistDomain.setGoodsName(disDgmcnum.getGoodsName());
                        disDgmcnumlistDomain.setTenantCode(tenantCode);
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("disDgmcnumlistDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)disDgmcnumlistDomain));
                        String dgmcnumCode = null;
                        try {
                            dgmcnumCode = (String)this.getInternalRouter().inInvoke("dis.dgmcnum.saveDgmcnumlist", map);
                        }
                        catch (Exception e) {
                            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.saveDgmcnumlist.e", (Object)("\u6dfb\u52a0\u660e\u7ec6\u5f02\u5e38\uff01" + JsonUtil.buildNonDefaultBinder().toJson((Object)disDgmcnumlistDomain)), (Throwable)e);
                            return;
                        }
                        if (!StringUtils.isBlank((String)dgmcnumCode)) continue;
                        listError.add("\u6dfb\u52a0\u660e\u7ec6\u5931\u8d25\uff01" + JsonUtil.buildNonDefaultBinder().toJson((Object)disDgmcnumlistDomain));
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.saveDgmcnumlist", (Object)("\u6dfb\u52a0\u660e\u7ec6\u5931\u8d25\uff01" + JsonUtil.buildNonDefaultBinder().toJson((Object)disDgmcnumlistDomain)));
                        continue;
                    }
                    DisDgmcnumlist disDgmcnumlist = (DisDgmcnumlist)queryDgnumList.get(0);
                    BigDecimal newQty = new BigDecimal(changeunitgoods.getQty());
                    if (newQty.equals(disDgmcnumlist.getDgmcnumPrice())) continue;
                    DisDgmcnumlistDomain disDgmcnumlistDomain = this.makeDisDgmcnumlistDomain(disDgmcnumlist);
                    disDgmcnumlistDomain.setDgmcnumPrice(newQty);
                    HashMap<String, String> updateMap = new HashMap<String, String>();
                    updateMap.put("disDgmcnumlistDomain", JsonUtil.buildNormalBinder().toJson((Object)disDgmcnumlistDomain));
                    try {
                        this.getInternalRouter().inInvoke("dis.dgmcnum.updateDgmcnumlist", updateMap);
                    }
                    catch (Exception e) {
                        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.saveDgmcnumlist.updateQty", (Object)"\u66f4\u65b0\u5931\u6557");
                        return;
                    }
                }
                long endTime = System.currentTimeMillis();
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.time", (Object)("===========\u65b9\u6cd5\u63d2\u5165\u65f6\u95f4:" + (endTime - requestTime)));
                if (shopchannel) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.shopchannel", (Object)("\u95e8\u5e97\u6ca1\u6709\u521b\u5efa\u5bf9\u5e94\u6e20\u9053\uff01\uff01\uff01" + umUserinfo.getUserinfoOcode()));
                    break;
                }
                Integer n = pn;
                Integer n2 = pn = Integer.valueOf(pn + 1);
            }
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.shopend", (Object)("\u540c\u6b65\u5f00\u59cb\u65f6\u95f4:" + lasttime + ",\u540c\u6b65\u8be5" + umUserinfo.getUserinfoOcode() + "-" + umUserinfo.getUserinfoCompname() + "\u95e8\u5e97\u7ed3\u675f\uff01\uff01\uff01\u603b\u6761\u6570:" + count + ",\u5931\u8d25\u7684\u6761\u6570:" + listError.size() + ",\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.getRemot((String)this.fujiMomAndChildGoodsKey)));
            listError.clear();
        }
        this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.end", (Object)("----------\u6240\u6709\u95e8\u5e97\u5e93\u5b58\u540c\u6b65\u7ed3\u675f\uff01\uff01\uff01\uff01\u5931\u8d25\u7684\u6761\u6570:" + listAllError.size() + ",\u603b\u5931\u8d25\u7684\u6709:" + listAllError));
    }

    private DisDgmcnumlistDomain makeDisDgmcnumlistDomain(DisDgmcnumlist disDgmcnumlist) {
        if (null == disDgmcnumlist) {
            return null;
        }
        DisDgmcnumlistDomain disDgmcnumlistDomain = new DisDgmcnumlistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgmcnumlistDomain, (Object)disDgmcnumlist);
            return disDgmcnumlistDomain;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.makeDisDgmcnumReDomain", (Throwable)e);
            return null;
        }
    }

    public DisDgmcnumDomain createParam(ViewChangeunitgoods changeunitgoods, DisChannel disChannel, InfGoods infMomGoods, String requestUrl, String tenantCode) {
        DisDgmcnumDomain disDgmcnumDomain = new DisDgmcnumDomain();
        disDgmcnumDomain.setChannelCode(disChannel.getChannelCode());
        disDgmcnumDomain.setChannelName(disChannel.getChannelName());
        disDgmcnumDomain.setChannelSort(disChannel.getChannelSort());
        disDgmcnumDomain.setChannelType(disChannel.getChannelType());
        disDgmcnumDomain.setMemberMcode(disChannel.getMemberMcode());
        disDgmcnumDomain.setMemberMname(disChannel.getMemberMname());
        disDgmcnumDomain.setMemberCode(disChannel.getMemberCcode());
        disDgmcnumDomain.setMemberName(disChannel.getMemberCname());
        disDgmcnumDomain.setDgmcnumType(1);
        disDgmcnumDomain.setDgmcnumSytype("0");
        disDgmcnumDomain.setDgmcnumSync("0");
        disDgmcnumDomain.setDgmcnumPro("1");
        disDgmcnumDomain.setDgmcnumOrg("0");
        disDgmcnumDomain.setSkuNo(infMomGoods.getGoodsid());
        disDgmcnumDomain.setGoodsName(infMomGoods.getGoodsname());
        disDgmcnumDomain.setTenantCode(tenantCode);
        ArrayList<DisDgmcnumlistDomain> disDgmcnumlistDomains = new ArrayList<DisDgmcnumlistDomain>();
        DisDgmcnumlistDomain disDgmcnumlistDomain = new DisDgmcnumlistDomain();
        disDgmcnumlistDomains.add(disDgmcnumlistDomain);
        disDgmcnumDomain.setDisDgmcnumlistDomainList(disDgmcnumlistDomains);
        disDgmcnumlistDomain.setChannelCode(disChannel.getChannelCode());
        disDgmcnumlistDomain.setChannelName(disChannel.getChannelName());
        disDgmcnumlistDomain.setChannelSort(disChannel.getChannelSort());
        disDgmcnumlistDomain.setDgmcnumPric(1);
        disDgmcnumlistDomain.setChannelType(disChannel.getChannelType());
        disDgmcnumlistDomain.setMemberMcode(disChannel.getMemberMcode());
        disDgmcnumlistDomain.setMemberMname(disChannel.getMemberMname());
        disDgmcnumlistDomain.setMemberCode(disChannel.getMemberCcode());
        disDgmcnumlistDomain.setMemberName(disChannel.getMemberCname());
        disDgmcnumlistDomain.setDgmcnumPrice(new BigDecimal(changeunitgoods.getQty()));
        InfGoods infChildGoods = this.queryGoods(changeunitgoods.getzGoodsid(), requestUrl);
        if (infChildGoods == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.createParam.param", (Object)("\u67e5\u8be2\u5bcc\u57fa\u5b50\u5546\u54c1\u4e3a\u7a7a\uff01\uff01\uff01goodsid" + changeunitgoods.getzGoodsid() + "," + requestUrl));
            return null;
        }
        disDgmcnumlistDomain.setDgmcnumSkuNo(infChildGoods.getGoodsid());
        disDgmcnumlistDomain.setDgmcnumGoodsNo(infChildGoods.getGoodsid());
        disDgmcnumlistDomain.setDgmcnumGoodsName(infChildGoods.getGoodsname());
        disDgmcnumlistDomain.setSkuNo(disDgmcnumDomain.getSkuNo());
        disDgmcnumlistDomain.setGoodsName(disDgmcnumDomain.getGoodsName());
        disDgmcnumlistDomain.setTenantCode(tenantCode);
        return disDgmcnumDomain;
    }

    private DisChannel getChannelCodeByshopId(String shopId, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("userinfoOcode", shopId);
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String umJosnStr = null;
        try {
            umJosnStr = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", map);
            if (StringUtils.isBlank((String)umJosnStr)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsshopByPage.queryUserinfoPage", (Object)("\u67e5\u8be2\u4e3a\u7a7a!!!mapStr:" + mapStr));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsshopByPage.queryUserinfoPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38!!!mapStr:" + mapStr));
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(umJosnStr, SupQueryResult.class);
        List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), UmUserinfo.class);
        if (ListUtil.isEmpty((Collection)pList)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsshopByPage.queryUserinfoPage", (Object)("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        UmUserinfo umUserinfo = (UmUserinfo)pList.get(0);
        map.clear();
        mapStr.clear();
        mapStr.put("memberCcode", umUserinfo.getUserinfoCode());
        mapStr.put("tenantCode", tenantCode);
        mapStr.put("channelType", "1");
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String disChannelJson = null;
        try {
            disChannelJson = (String)this.getInternalRouter().inInvoke("dis.channel.queryChannelPage", map);
            if (StringUtils.isBlank((String)disChannelJson)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsshopByPage.queryChannelPage", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsshopByPage.queryChannelPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map));
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disChannelJson, SupQueryResult.class);
        List disChannelList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisChannel.class);
        if (ListUtil.isEmpty((Collection)disChannelList)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsshopByPage.queryDictionaryPage", (Object)("\u95e8\u5e97\u672a\u7ed1\u5b9a\u6e20\u9053,\u8bf7\u524d\u5f80\u7ed1\u5b9a\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        return (DisChannel)disChannelList.get(0);
    }

    public String queryRsClassConf(String goodsClassCode, String classtreeCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("goodsClassCode", goodsClassCode);
        mapStr.put("goodsClassconfType", "classtreeCode");
        mapStr.put("goodsClassconfValue", classtreeCode);
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String rsGoodsClassConfJson = null;
        try {
            rsGoodsClassConfJson = (String)this.getInternalRouter().inInvoke("rs.goodsClassconf.queryGoodsClassconfPage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryRsClassConf.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map));
            return "queryRsClassConf\u67e5\u8be2\u5f02\u5e38";
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsGoodsClassConfJson, SupQueryResult.class);
        List rsGoodsClassConfList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsGoodsClassconf.class);
        if (ListUtil.isEmpty((Collection)rsGoodsClassConfList)) {
            return null;
        }
        return "\u5df2\u5b58\u5728";
    }

    private List<UmUserinfo> getOnlineShop(String onLineShop, String tenantCode) {
        ArrayList<UmUserinfo> umUserinfoList = new ArrayList<UmUserinfo>();
        if (StringUtils.isBlank((String)onLineShop)) {
            HashMap<String, String> umInfoMap = new HashMap<String, String>();
            HashMap<String, String> umInfoMapStr = new HashMap<String, String>();
            umInfoMapStr.put("userinfoQuality", "store,supplier");
            umInfoMapStr.put("tenantCode", tenantCode);
            umInfoMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(umInfoMapStr));
            String userListJson = "";
            try {
                userListJson = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", umInfoMap);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.queryUserinfoPage.e", (Object)("\u83b7\u53d6\u6240\u6709\u95e8\u5e97\u5f02\u5e38umInfoMapStr:" + umInfoMapStr), (Throwable)e);
                return null;
            }
            SupQueryResult supQueryUserResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(userListJson, SupQueryResult.class);
            List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryUserResult.getList()), UmUserinfo.class);
            if (ListUtil.isEmpty((Collection)pList)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.queryUserinfoPage", (Object)("\u67e5\u8be2\u4e0d\u5230\u95e8\u5e97umInfoMapStr:" + umInfoMapStr));
                return null;
            }
            ListUtil.addAll(umUserinfoList, (List)pList);
        } else {
            String[] shopIdArray;
            for (String shopId : shopIdArray = onLineShop.split("-")) {
                HashMap<String, String> umInfoMap = new HashMap<String, String>();
                HashMap<String, String> umInfoMapStr = new HashMap<String, String>();
                umInfoMapStr.put("userinfoOcode", shopId);
                umInfoMapStr.put("userinfoQuality", "store,supplier");
                umInfoMapStr.put("tenantCode", tenantCode);
                umInfoMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(umInfoMapStr));
                String userListJson = "";
                try {
                    userListJson = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", umInfoMap);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.queryUserinfoPage.e", (Object)("\u83b7\u53d6\u6240\u6709\u95e8\u5e97\u5f02\u5e38umInfoMapStr:" + umInfoMapStr), (Throwable)e);
                    return null;
                }
                SupQueryResult supQueryUserResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(userListJson, SupQueryResult.class);
                List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryUserResult.getList()), UmUserinfo.class);
                if (ListUtil.isEmpty((Collection)pList)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.insertMomtherAndChild.queryUserinfoPage", (Object)("\u67e5\u8be2\u4e0d\u5230\u95e8\u5e97umInfoMapStr:" + umInfoMapStr));
                    continue;
                }
                umUserinfoList.add((UmUserinfo)pList.get(0));
            }
        }
        return umUserinfoList;
    }

    public String saveRsGoodsClass(String virtualClasstreeName, RsClasstree rsClasstree, String tenantCode, String parentCode, String classLast, String userinfoCode, Boolean falg) {
        RsGoodsClassDomain rsGoodsClassDomain = new RsGoodsClassDomain();
        rsGoodsClassDomain.setGoodsClassParentcode(parentCode);
        rsGoodsClassDomain.setGoodsClassLast(classLast);
        rsGoodsClassDomain.setGoodsClassName(virtualClasstreeName);
        rsGoodsClassDomain.setGoodsClassHide("0");
        rsGoodsClassDomain.setGoodsClassOrder(0);
        rsGoodsClassDomain.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsGoodsClassDomain.setMemberCode(userinfoCode);
        rsGoodsClassDomain.setTenantCode(tenantCode);
        if (falg.booleanValue()) {
            ArrayList<RsGoodsClassconfDomain> rsGoodsClassconfDomainList = new ArrayList<RsGoodsClassconfDomain>();
            RsGoodsClassconfDomain rsGoodsClassconfDomain = new RsGoodsClassconfDomain();
            rsGoodsClassconfDomainList.add(rsGoodsClassconfDomain);
            rsGoodsClassDomain.setRsGoodsClassconfDomainList(rsGoodsClassconfDomainList);
            rsGoodsClassconfDomain.setGoodsClassconfType("classtreeCode");
            rsGoodsClassconfDomain.setGoodsClassconfName(rsClasstree.getClasstreeName());
            rsGoodsClassconfDomain.setGoodsClassconfValue(rsClasstree.getClasstreeCode());
            rsGoodsClassconfDomain.setMemberCode(userinfoCode);
            rsGoodsClassconfDomain.setTenantCode(tenantCode);
        }
        return this.saveRsGoodsClass(rsGoodsClassDomain);
    }

    public RsClasstree queryClasstree(String classtreeEocode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> classtreeNameparamMap = new HashMap<String, String>();
        classtreeNameparamMap.put("classtreeEocode", classtreeEocode);
        classtreeNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeNameparamMap));
        String rsClasstreeStr = "";
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
            if (StringUtils.isBlank((String)rsClasstreeStr)) {
                this.logger.error(".queryClasstree.queryClasstreePage", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".queryClasstree.queryClasstreePage.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, SupQueryResult.class);
        List rsClasstrees = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstrees)) {
            this.logger.error(".queryClasstree.queryClasstreePage", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        return (RsClasstree)rsClasstrees.get(0);
    }

    public String saveRsGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsGoodsClassDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsGoodsClassDomain));
        String rsGoodsClassCode = (String)this.getInternalRouter().inInvoke("rs.resource.saveGoodsClass", map);
        if (StringUtils.isBlank((String)rsGoodsClassCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClass.saveRsGoodsClass.null", (Object)("rsGoodsClassCode:" + rsGoodsClassCode + ",rsGoodsClassDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsGoodsClassDomain)));
            return null;
        }
        return rsGoodsClassCode;
    }

    public String saveRsGoodsClassConf(RsGoodsClassconfDomain rsGoodsClassconfDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsGoodsClassconfDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsGoodsClassconfDomain));
        String goodsClassCode = (String)this.getInternalRouter().inInvoke("rs.goodsClassconf.saveGoodsClassconf", map);
        if (StringUtils.isBlank((String)goodsClassCode)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveRsGoodsClassConf.saveGoodsClassconf.null", (Object)("rsGoodsClassconfDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsGoodsClassconfDomain)));
            return null;
        }
        return goodsClassCode;
    }

    public RsGoodsClass queryGoodsClass(String goodsClassName, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("goodsClassName", goodsClassName);
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String queryGoodsClassJson = "";
        try {
            queryGoodsClassJson = (String)this.getInternalRouter().inInvoke("rs.goodsClass.queryGoodsClassPage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryGoodsClass.queryGoodsClassPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + mapStr), (Throwable)e);
            return null;
        }
        SupQueryResult queryGoodsClassResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryGoodsClassJson, SupQueryResult.class);
        List queryGoodsClassList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryGoodsClassResult.getList()), RsGoodsClass.class);
        if (ListUtil.isEmpty((Collection)queryGoodsClassList)) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryGoodsClass.queryGoodsClassList", (Object)("queryGoodsClassList:" + JsonUtil.buildNormalBinder().toJson((Object)queryGoodsClassList)));
            return null;
        }
        RsGoodsClass rsGoodsClass = (RsGoodsClass)queryGoodsClassList.get(0);
        return rsGoodsClass;
    }

    public Boolean saveGoodsRel(RsSkuDomain rsSkuMomDomain, RsSkuDomain rsSkuChildDomain) {
        RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
        rsGoodsRelDomain.setGoodsCode(rsSkuChildDomain.getGoodsCode());
        rsGoodsRelDomain.setGoodsRelGcode(rsSkuMomDomain.getGoodsCode());
        rsGoodsRelDomain.setGoodsRelType("4");
        rsGoodsRelDomain.setMemberCode(rsSkuMomDomain.getMemberCcode());
        rsGoodsRelDomain.setMemberName(rsSkuMomDomain.getMemberCname());
        rsGoodsRelDomain.setSkuCode(rsSkuMomDomain.getSkuCode());
        rsGoodsRelDomain.setSkuName(rsSkuMomDomain.getSkuName());
        rsGoodsRelDomain.setPricesetNprice(rsSkuMomDomain.getPricesetNprice());
        rsGoodsRelDomain.setGoodsNum(rsSkuMomDomain.getGoodsNum());
        rsGoodsRelDomain.setSkuNo(rsSkuMomDomain.getSkuNo());
        rsGoodsRelDomain.setDataPic(rsSkuMomDomain.getDataPic());
        rsGoodsRelDomain.setTenantCode(rsSkuMomDomain.getTenantCode());
        RsGoodsRelDomain rsGoodsRelDomainStr = new RsGoodsRelDomain();
        rsGoodsRelDomainStr.setGoodsSkuCode(rsSkuChildDomain.getSkuCode());
        rsGoodsRelDomainStr.setGoodsRelGcode(rsSkuMomDomain.getGoodsCode());
        rsGoodsRelDomainStr.setGoodsRelType("4");
        rsGoodsRelDomainStr.setMemberCode(rsSkuMomDomain.getMemberCcode());
        rsGoodsRelDomainStr.setMemberName(rsSkuMomDomain.getMemberCname());
        rsGoodsRelDomainStr.setSkuCode(rsSkuMomDomain.getSkuCode());
        rsGoodsRelDomainStr.setSkuName(rsSkuMomDomain.getSkuName());
        rsGoodsRelDomainStr.setPricesetNprice(rsSkuMomDomain.getPricesetNprice());
        rsGoodsRelDomainStr.setGoodsNum(rsSkuMomDomain.getGoodsNum());
        rsGoodsRelDomainStr.setSkuNo(rsSkuMomDomain.getSkuNo());
        rsGoodsRelDomainStr.setDataPic(rsSkuMomDomain.getDataPic());
        rsGoodsRelDomainStr.setTenantCode(rsSkuMomDomain.getTenantCode());
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        rsGoodsRelDomainList.add(rsGoodsRelDomain);
        rsGoodsRelDomainList.add(rsGoodsRelDomainStr);
        HashMap<String, String> saveGoodsRelMap = new HashMap<String, String>();
        saveGoodsRelMap.put("rsGoodsRelDomainList", JsonUtil.buildNonDefaultBinder().toJson(rsGoodsRelDomainList));
        try {
            this.getInternalRouter().inInvoke("rs.goodsOther.saveGoodsRelList", saveGoodsRelMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl..saveExcelGoods.saveGoodsRel.saveGoodsRel.e", (Object)("\u6dfb\u52a0\u5f02\u5e38\uff01\uff01\uff01saveGoodsRelMap:" + saveGoodsRelMap));
            return false;
        }
        return true;
    }

    public boolean queryMomGoodsAndChildGoods(InfGoods momtherGoods, InfGoods childGoods, String tenantCode) {
        HashMap<String, String> momSkuMap = new HashMap<String, String>();
        momSkuMap.put("skuNo", momtherGoods.getGoodsid());
        momSkuMap.put("tenantCode", tenantCode);
        String momSkusJson = "";
        try {
            momSkusJson = (String)this.getInternalRouter().inInvoke("rs.sku.checkSkuNo", momSkuMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryMomGoodsAndChildGoods.e", (Object)("\u67e5\u8be2sku\u5f02\u5e38\uff01\uff01\uff01momSkuMap:" + momSkuMap));
            return false;
        }
        List rsMomSkuList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(momSkusJson, RsSku.class);
        HashMap<String, String> childSkuMap = new HashMap<String, String>();
        childSkuMap.put("skuNo", momtherGoods.getGoodsid());
        childSkuMap.put("tenantCode", tenantCode);
        String childSkuJson = "";
        try {
            childSkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.checkSkuNo", childSkuMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.queryMomGoodsAndChildGoods.e", (Object)("\u67e5\u8be2sku\u5f02\u5e38\uff01\uff01\uff01momSkuMap:" + momSkuMap));
            return false;
        }
        List rsChildSkuList = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(childSkuJson, RsSku.class);
        return true;
    }

    public Boolean makeUpdateGoodsAndSku(InfGoods infGoods, RsResourceGoods rsResourceGoods, RsSkuDomain rsSkuDomain, String tenantCode) {
        RsBrand rsBrand = this.queryBrand(infGoods, tenantCode);
        if (rsBrand == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.queryBrand", (Object)("\u83b7\u53d6\u54c1\u724c\u4e3a\u7a7a\uff01\uff01\uff01\u54c1\u724cID:" + infGoods.getBrandid()));
            return false;
        }
        RsClasstree rsClasstree = this.queryClasstree(infGoods, tenantCode);
        if (rsClasstree == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.queryClasstree", (Object)("\u83b7\u53d6\u54c1\u724c\u4e3a\u7a7a\uff01\uff01\uff01\u5206\u7c7bID:" + infGoods.getCategoryid()));
            return false;
        }
        RsPntree rsPntree = this.queryPntree(rsClasstree, tenantCode);
        if (rsPntree == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.queryPntree", (Object)("\u83b7\u53d6\u7c7b\u578b\u4e3a\u7a7a\uff01\uff01\uff01\u5206\u7c7bID:" + rsClasstree.getPntreeCode()));
            return false;
        }
        rsResourceGoods.setBrandCode(rsBrand.getBrandCode());
        rsResourceGoods.setBrandName(rsBrand.getBrandName());
        rsResourceGoods.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsResourceGoods.setClasstreeName(rsClasstree.getClasstreeName());
        rsResourceGoods.setPntreeCode(rsPntree.getPntreeCode());
        rsResourceGoods.setPntreeName(rsPntree.getPntreeName());
        rsResourceGoods.setProductareaName(infGoods.getProducingarea());
        rsResourceGoods.setGoodsName(infGoods.getGoodsname());
        rsResourceGoods.setPartsnameNumunit(infGoods.getUnitname());
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsResourceGoodsDomain, (Object)rsResourceGoods);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.makeResourceGoodsDomain", (Throwable)e);
            return false;
        }
        HashMap<String, String> updateResourceGoodsMap = new HashMap<String, String>();
        updateResourceGoodsMap.put("rsResourceGoodsDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsDomain));
        try {
            this.getInternalRouter().inInvoke("rs.resourceGoods.updateResourceGoods", updateResourceGoodsMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.updateResourceGoods.e", (Object)("\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01rsSkuDomain:" + JsonUtil.buildNonEmptyBinder().toJson((Object)rsSkuDomain)));
            return false;
        }
        RsSkuDomain rsSkuDomainStr = new RsSkuDomain();
        rsSkuDomainStr.setSkuId(rsSkuDomain.getSkuId());
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("rsSkuDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSkuDomainStr));
        this.getInternalRouter().inInvoke("rs.sku.updateSku", mapStr);
        rsSkuDomain.setSkuCodeOld(infGoods.getGoodsid());
        rsSkuDomain.setSkuName(infGoods.getGoodsspec());
        rsSkuDomain.setPricesetNprice(infGoods.getAdviceprice());
        rsSkuDomain.setPricesetAsprice(infGoods.getAdvicecost());
        rsSkuDomain.setGoodsWeight(new BigDecimal(infGoods.getGoodsweight()));
        rsSkuDomain.setPartsnameNumunit(infGoods.getUnitname());
        rsSkuDomain.setBrandCode(rsBrand.getBrandCode());
        rsSkuDomain.setBrandName(rsBrand.getBrandName());
        rsSkuDomain.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsSkuDomain.setPntreeCode(rsPntree.getPntreeCode());
        rsSkuDomain.setPntreeName(rsPntree.getPntreeName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsSkuDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSkuDomain));
        try {
            this.getInternalRouter().inInvoke("rs.sku.updateSku", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.makeUpdateGoodsAndSku.updateSku.e", (Object)("\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01rsSkuDomain:" + JsonUtil.buildNonEmptyBinder().toJson((Object)rsSkuDomain)));
            return false;
        }
        return true;
    }

    public RsBrand queryBrand(InfGoods infGoods, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> brandNameparamMap = new HashMap<String, String>();
        brandNameparamMap.put("brandEocode", infGoods.getBrandid().toString());
        brandNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandNameparamMap));
        String brandStr = "";
        try {
            brandStr = (String)this.getInternalRouter().inInvoke("rs.brand.queryBrandPage", map);
            if (StringUtils.isBlank((String)brandStr)) {
                this.logger.error(".queryBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".queryBrand.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStrStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(brandStr, SupQueryResult.class);
        List rsBrands = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStrStr.getList()), RsBrand.class);
        if (ListUtil.isEmpty((Collection)rsBrands)) {
            this.logger.error(".queryBrand.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            return null;
        }
        return (RsBrand)rsBrands.get(0);
    }

    public RsClasstree queryClasstree(InfGoods infGoods, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> classtreeNameparamMap = new HashMap<String, String>();
        classtreeNameparamMap.put("classtreeEocode", infGoods.getCategoryid().toString());
        classtreeNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeNameparamMap));
        String rsClasstreeStr = "";
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
            if (StringUtils.isBlank((String)rsClasstreeStr)) {
                this.logger.error(".queryClasstree.rsClasstreeStr", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".queryClasstree.rsClasstree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, SupQueryResult.class);
        List rsClasstrees = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstrees)) {
            this.logger.error(".queryClasstree.rsClasstrees", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            return null;
        }
        return (RsClasstree)rsClasstrees.get(0);
    }

    public RsPntree queryPntree(RsClasstree rsClasstree, String tenantCode) {
        String pntreeCode = rsClasstree.getPntreeCode();
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(".queryPntree.pntreeCode", (Object)("\u8be5\u5206\u7c7b\u6ca1\u6709\u5173\u8054\u7c7b\u522b\uff01\uff01\uff01rsClassTreeName:" + rsClasstree.getClasstreeName() + ",pntreeCode:" + pntreeCode));
            return null;
        }
        HashMap<String, String> pntreeCodeparamMap = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("pntreeCode", pntreeCode);
        mapStr.put("tenantCode", tenantCode);
        pntreeCodeparamMap.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        RsPntree rsPntree = null;
        try {
            String rsPntreeStr = (String)this.getInternalRouter().inInvoke("rs.pntree.getPntreeByCode", pntreeCodeparamMap);
            if (StringUtils.isBlank((String)rsPntreeStr)) {
                this.logger.error(".queryPntree.rsPntree", (Object)("rsPntreeStr:" + rsPntreeStr + ",\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
                return null;
            }
            rsPntree = (RsPntree)JsonUtil.buildNormalBinder().getJsonToObject(rsPntreeStr, RsPntree.class);
        }
        catch (Exception e) {
            this.logger.error(".queryPntree.rsPntree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
            return null;
        }
        return rsPntree;
    }

    private String sendSavePassResourceGoodsBatch(InfGoods infGoods, boolean isChildFlag, RsSkuDomain rsSkuMomDomain, String goodsPrice, String goodsStockNum, String tenantCode) {
        HashMap<String, Object> specMap = new HashMap<String, Object>();
        RsResourceGoodsDomain rsResourceGoodsDomain = this.checkGoods(infGoods, isChildFlag, rsSkuMomDomain, specMap, goodsPrice, goodsStockNum, tenantCode);
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsRemark())) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.checkGoods", (Object)("\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01" + rsResourceGoodsDomain.getGoodsRemark()));
            return "\u6821\u9a8c\u5931\u8d25\uff01\uff01\uff01" + rsResourceGoodsDomain.getGoodsRemark();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsResourceGoodsDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsDomain));
        String rsGoodsCode = "";
        try {
            rsGoodsCode = (String)this.getInternalRouter().inInvoke("rs.resource.sendSaveResourceGoods", map);
            if (StringUtils.isBlank((String)rsGoodsCode)) {
                return "\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01";
            }
        }
        catch (Exception e) {
            this.logger.error(".saveExcelGoods.sendSavePassResourceGoodsBatch.e", (Object)"\u6dfb\u52a0\u5f02\u5e38\uff01\uff01\uff01", (Throwable)e);
            return "\u6dfb\u52a0\u5f02\u5e38\uff01\uff01\uff01";
        }
        HashMap<String, String> queryGoodsMap = new HashMap<String, String>();
        HashMap<String, String> queryGoodsMapStr = new HashMap<String, String>();
        queryGoodsMapStr.put("goodsCode", rsGoodsCode);
        queryGoodsMapStr.put("tenantCode", tenantCode);
        queryGoodsMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryGoodsMapStr));
        String rsGoodsJson = "";
        try {
            rsGoodsJson = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.getResourceGoodsByCode", queryGoodsMap);
            if (StringUtils.isBlank((String)rsGoodsJson)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.getResourceGoodsByCode", (Object)("rsGoodsJson:" + rsGoodsJson + ",\u53c2\u6570map:" + queryGoodsMapStr));
                return "\u6dfb\u52a0\u5b8c\u6210\u4e4b\u540e\u67e5\u8be2\u4e0d\u5230\uff01\uff01\uff01";
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.getResourceGoodsByCode,e", (Object)("rsGoodsJson:" + rsGoodsJson + ",\u53c2\u6570map:" + queryGoodsMapStr), (Throwable)e);
            return "\u6dfb\u52a0\u5b8c\u6210\u4e4b\u540e\u67e5\u8be2\u4e0d\u5230\uff01\uff01\uff01";
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsGoodsJson, RsResourceGoodsReDomain.class);
        String specGroupCode = (String)specMap.get("specGroupCode");
        String specCode = (String)specMap.get("specCode");
        String specName = (String)specMap.get("specName");
        HashMap<String, String> saveSpecValueMap = new HashMap<String, String>();
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        rsSpecValueDomain.setTenantCode(tenantCode);
        rsSpecValueDomain.setSpuCode(rsResourceGoodsReDomain.getSpuCode());
        rsSpecValueDomain.setSpecGroupCode(specGroupCode);
        rsSpecValueDomain.setSpecCode(specCode);
        rsSpecValueDomain.setSpecName(specName);
        rsSpecValueDomain.setSpecValueValue(specName);
        rsSpecValueDomain.setSpecValueType("1");
        rsSpecValueDomain.setSpecValueFlag("1");
        rsSpecValueDomain.setSpecValueBillno(rsResourceGoodsReDomain.getGoodsCode());
        saveSpecValueMap.put("rsSpecValueDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecValueDomain));
        try {
            this.getInternalRouter().inInvoke("rs.specValue.saveSpecValue", saveSpecValueMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.saveExcelGoods.saveSpecValue,e", (Object)("\u6dfb\u52a0specvalue\u5f02\u5e38,\u53c2\u6570rsSpecValueDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecValueDomain)), (Throwable)e);
            return "\u6dfb\u52a0specvalue\u5f02\u5e38\uff01\uff01\uff01";
        }
        return "success";
    }

    public String responseAddGoods(String result, String goodsCode, String barCode, String goodsName, String goodsPrice, String goodsStockNum, String errorMsg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("result", result);
        HashMap<String, String> mapMsg = new HashMap<String, String>();
        mapMsg.put("goodsCode", goodsCode);
        mapMsg.put("barCode", barCode);
        mapMsg.put("goodsPrice", goodsPrice);
        mapMsg.put("goodsStockNum", goodsStockNum);
        mapMsg.put("goodsName", goodsName);
        mapMsg.put("errorMsg", errorMsg);
        map.put("msg", JsonUtil.buildNonEmptyBinder().toJson(mapMsg));
        return JsonUtil.buildNonEmptyBinder().toJson(map);
    }

    public List<ViewChangeunitgoods> queryViewChangeunitgoods(String zGoodsId, String requestUrl) {
        ViewChangeunitgoods viewChangeunitgoodsStr = new ViewChangeunitgoods();
        viewChangeunitgoodsStr.setzGoodsid(zGoodsId);
        String requestJson = JsonUtil.buildNonDefaultBinder().toJson((Object)viewChangeunitgoodsStr);
        String jsonResult = null;
        try {
            jsonResult = HttpRequestUtiles.httpPost("/qj/queryChildGoodsByZid", requestJson, requestUrl);
            if (StringUtils.isBlank((String)jsonResult)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods", (Object)"response is null");
                throw new ApiException("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods", "response is null");
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.e", (Object)"\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
            throw new ApiException("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.e", "\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.resCode", (Object)("respose is false,jsonResult:" + jsonResult));
            throw new ApiException("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.resCode", "respose is false,jsonResult:" + jsonResult);
        }
        Object dataStr = mapResult.get("dataStr");
        if (dataStr == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult));
            throw new ApiException("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryViewChangeunitgoods.dataStr", "dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult);
        }
        return (List)JsonUtil.buildNonEmptyBinder().getJsonToList(dataStr.toString(), ViewChangeunitgoods.class);
    }

    private InfGoods queryGoods(String goodsId, String requestUrl) {
        InfGoods infGoodsRes = new InfGoods();
        infGoodsRes.setGoodsid(goodsId);
        String requestJson = JsonUtil.buildNonNullBinder().toJson((Object)infGoodsRes);
        String jsonResult = null;
        try {
            jsonResult = HttpRequestUtiles.httpPost("/qj/queryGoodsById", requestJson, requestUrl);
            if (StringUtils.isBlank((String)jsonResult)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById", (Object)("response is null,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById"));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.e", (Object)("\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById"));
            return null;
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.resCode", (Object)("respose is false,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById" + ",\u54cd\u5e94\u7ed3\u679c:" + jsonResult));
            return null;
        }
        Object dataStr = mapResult.get("dataStr");
        if (dataStr == null) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.httpPost.queryGoodsById.dataStr", (Object)("dataStr is null\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryGoodsById" + ",\u54cd\u5e94\u7ed3\u679c:" + jsonResult));
            return null;
        }
        return (InfGoods)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataStr.toString(), InfGoods.class);
    }

    public RsResourceGoodsDomain checkGoods(InfGoods infGoods, boolean isChildFlag, RsSkuDomain rsSkuMomDomain, Map<String, Object> specMap, String goodsPrice, String goodsStockNum, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> brandNameparamMap = new HashMap<String, String>();
        brandNameparamMap.put("brandEocode", infGoods.getBrandid().toString());
        brandNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(brandNameparamMap));
        String brandStr = "";
        try {
            brandStr = (String)this.getInternalRouter().inInvoke("rs.brand.queryBrandPage", map);
            if (StringUtils.isBlank((String)brandStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + infGoods.getBrandid() + ":\u54c1\u724c\u4e0d\u5b58\u5728");
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u54c1\u724cid:" + infGoods.getBrandid() + "-\u5f02\u5e38\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        SupQueryResult supQueryResultStrStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(brandStr, SupQueryResult.class);
        List rsBrands = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStrStr.getList()), RsBrand.class);
        if (ListUtil.isEmpty((Collection)rsBrands)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryBrandPage.rsBrand", (Object)("brandStr:" + brandStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + brandNameparamMap));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u54c1\u724cid:" + infGoods.getBrandid() + "-\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        RsBrand rsBrand = (RsBrand)rsBrands.get(0);
        map.clear();
        HashMap<String, String> classtreeNameparamMap = new HashMap<String, String>();
        classtreeNameparamMap.put("classtreeEocode", infGoods.getCategoryid().toString());
        classtreeNameparamMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(classtreeNameparamMap));
        String rsClasstreeStr = "";
        try {
            rsClasstreeStr = (String)this.getInternalRouter().inInvoke("rs.rsClasstree.queryClasstreePage", map);
            if (StringUtils.isBlank((String)rsClasstreeStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.rsClasstreeStr", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "-\u4e0d\u5b58\u5728");
                return rsResourceGoodsDomain;
            }
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.checkClasstreeNameApiCode.rsClasstree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "-\u5f02\u5e38\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsClasstreeStr, SupQueryResult.class);
        List rsClasstrees = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), RsClasstree.class);
        if (ListUtil.isEmpty((Collection)rsClasstrees)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.rsClasstrees", (Object)("rsClasstreeStr:" + rsClasstreeStr + ",\u8bf7\u6c42\u53c2\u6570map\uff1a" + classtreeNameparamMap));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "-\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        RsClasstree rsClasstree = (RsClasstree)rsClasstrees.get(0);
        String pntreeCode = rsClasstree.getPntreeCode();
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryClasstreePage.pntreeCode", (Object)("\u8be5\u5206\u7c7b\u6ca1\u6709\u5173\u8054\u7c7b\u522b\uff01\uff01\uff01rsClassTreeName:" + rsClasstree.getClasstreeName() + ",pntreeCode:" + pntreeCode));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u5206\u7c7bid:" + infGoods.getBrandid() + "\u5b58\u5728\uff0c\u5206\u7c7b\u5bf9\u5e94\u7684\u7c7b\u522b-\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        HashMap<String, String> pntreeCodeparamMap = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("pntreeCode", pntreeCode);
        mapStr.put("tenantCode", tenantCode);
        pntreeCodeparamMap.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        RsPntree rsPntree = null;
        try {
            String rsPntreeStr = (String)this.getInternalRouter().inInvoke("rs.pntree.getPntreeByCode", pntreeCodeparamMap);
            if (StringUtils.isBlank((String)rsPntreeStr)) {
                this.logger.error(".inertGoodsByPage.checkGoods.getPntreeByCodeApiCode.rsPntree", (Object)("rsPntreeStr:" + rsPntreeStr + ",\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "\u5173\u8054\u7684\u7c7b\u522b\uff08" + pntreeCode + "\uff09-\u4e0d\u5b58\u5728\uff01\uff01\uff01");
                return rsResourceGoodsDomain;
            }
            rsPntree = (RsPntree)JsonUtil.buildNormalBinder().getJsonToObject(rsPntreeStr, RsPntree.class);
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.getPntreeByCodeApiCode.rsPntree.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570pntreeCodeparamMap\uff1a" + pntreeCodeparamMap));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "\u5173\u8054\u7684\u7c7b\u522b\uff08" + pntreeCode + "\uff09-\u5f02\u5e38\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        map.clear();
        mapStr.clear();
        mapStr.put("classtreeCode", rsClasstree.getClasstreeCode());
        mapStr.put("tenantCode", rsClasstree.getTenantCode());
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String goodsClassJson = "";
        try {
            goodsClassJson = (String)this.getInternalRouter().inInvoke("rs.goodsClass.queryGoodsClassPage", map);
        }
        catch (Exception e) {
            this.logger.error(".inertGoodsByPage.checkGoods.queryGoodsClassPage.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570map:" + mapStr));
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u67e5\u8be2\u5206\u7c7bid:" + infGoods.getBrandid() + "\u5bf9\u5e94\u7684\u524d\u53f0\u5206\u7c7b-\u5f02\u5e38\uff01\uff01\uff01");
            return rsResourceGoodsDomain;
        }
        SupQueryResult supQueryResultGoodsClass = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(goodsClassJson, SupQueryResult.class);
        List goodsClassList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultGoodsClass.getList()), RsGoodsClass.class);
        HashMap<String, String> specGroupMap = new HashMap<String, String>();
        HashMap<String, String> specGroupMapStr = new HashMap<String, String>();
        specGroupMapStr.put("pntreeCode", pntreeCode);
        specGroupMapStr.put("tenantCode", tenantCode);
        specGroupMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(specGroupMapStr));
        String specGroupJsonList = "";
        try {
            specGroupJsonList = (String)this.getInternalRouter().inInvoke("rs.spec.querySpecGroupPage", specGroupMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.checkGoods.querySpecGroupPage.e", (Object)("\u6839\u636e\u7c7b\u522b\u67e5\u8be2\u89c4\u683c\u7ec4\u5f02\u5e38!!!map:" + specGroupMapStr), (Throwable)e);
            RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
            rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u6839\u636e\u7c7b\u522b\u67e5\u8be2\u89c4\u683c\u7ec4\u5f02\u5e38\uff01\uff01\uff01map:" + specGroupMapStr);
            return rsResourceGoodsDomain;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(specGroupJsonList, SupQueryResult.class);
        List specGroupList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsSpecGroup.class);
        if (ListUtil.isEmpty((Collection)specGroupList)) {
            mapStr.clear();
            RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
            rsSpecGroupDomain.setPntreeCode(rsPntree.getPntreeCode());
            rsSpecGroupDomain.setSpecGroupName(rsPntree.getPntreeName());
            rsSpecGroupDomain.setTenantCode(tenantCode);
            mapStr.put("rsSpecGroupDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecGroupDomain));
            String specGroupCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", mapStr);
            if (StringUtils.isBlank((String)specGroupCode)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.inertGoodsByPage.checkGoods.saveSpecGroup", (Object)("\u89c4\u683c\u7ec4\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsSpecGroupDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain)));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u89c4\u683c\u7ec4\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01");
                return rsResourceGoodsDomain;
            }
            RsSpecDomain rsSpecDomain = new RsSpecDomain();
            rsSpecDomain.setSpecName(infGoods.getGoodsspec());
            rsSpecDomain.setSpecGroupCode(specGroupCode);
            rsSpecDomain.setSpecDefault("1");
            rsSpecDomain.setTenantCode(tenantCode);
            mapStr.put("rsSpecDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecDomain));
            String specCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpec", mapStr);
            if (StringUtils.isBlank((String)specCode)) {
                this.logger.error(".inertGoodsByPage.checkGoods.saveSpec", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain)));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u89c4\u683c\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01");
                return rsResourceGoodsDomain;
            }
            HashMap<String, String> querySpecMap = new HashMap<String, String>();
            HashMap<String, String> querySpecMapStr = new HashMap<String, String>();
            querySpecMapStr.put("specCode", specCode);
            querySpecMapStr.put("tenantCode", tenantCode);
            querySpecMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(querySpecMapStr));
            String querySpecJson = "";
            try {
                querySpecJson = (String)this.getInternalRouter().inInvoke("rs.spec.getSpecByCode", querySpecMap);
                if (StringUtils.isBlank((String)querySpecJson)) {
                    this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.checkGoods.getSpecByCode", (Object)("\u63d2\u5165\u89c4\u683c\u4e4b\u540e\uff0c\u6839\u636e\u89c4\u683ccode\u67e5\u8be2\u8be5\u89c4\u683c\u4e3a\u7a7a!!!map:" + querySpecMapStr));
                    RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                    rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u63d2\u5165\u89c4\u683c\u4e4b\u540e\uff0c\u6839\u636e\u89c4\u683ccode\u67e5\u8be2\u8be5\u89c4\u683c\u4e3a\u7a7a\uff01\uff01\uff01map:" + specGroupMapStr);
                    return rsResourceGoodsDomain;
                }
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.checkGoods.getSpecByCode.e", (Object)("\u63d2\u5165\u89c4\u683c\u4e4b\u540e\uff0c\u6839\u636e\u89c4\u683ccode\u67e5\u8be2\u8be5\u89c4\u683c\u5f02\u5e38!!!map:" + querySpecMapStr), (Throwable)e);
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u63d2\u5165\u89c4\u683c\u4e4b\u540e\uff0c\u6839\u636e\u89c4\u683ccode\u67e5\u8be2\u8be5\u89c4\u683c\u5f02\u5e38\uff01\uff01\uff01map:" + specGroupMapStr);
                return rsResourceGoodsDomain;
            }
            RsSpec rsSpec = (RsSpec)JsonUtil.buildNormalBinder().getJsonToObject(querySpecJson, RsSpec.class);
            specMap.put("specGroupCode", specGroupCode);
            specMap.put("specCode", specCode);
            specMap.put("specName", rsSpec.getSpecName());
        } else {
            RsSpecGroup rsSpecGroup = (RsSpecGroup)specGroupList.get(0);
            specMap.put("specGroupCode", rsSpecGroup.getSpecGroupCode());
            HashMap<String, String> querySpecMap = new HashMap<String, String>();
            HashMap<String, String> querySpecMapStr = new HashMap<String, String>();
            querySpecMapStr.put("specGroupCode", rsSpecGroup.getSpecGroupCode());
            querySpecMapStr.put("tenantCode", tenantCode);
            querySpecMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(querySpecMapStr));
            String querySpecJson = "";
            try {
                querySpecJson = (String)this.getInternalRouter().inInvoke("rs.spec.querySpecPage", querySpecMap);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.checkGoods.querySpecPage.e", (Object)("\u6839\u636e\u89c4\u683c\u7ec4\u67e5\u8be2\u89c4\u683c\u5f02\u5e38!!!map:" + querySpecMapStr), (Throwable)e);
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u6839\u636e\u89c4\u683c\u7ec4\u67e5\u8be2\u89c4\u683c\u5f02\u5e38\uff01\uff01\uff01map:" + specGroupMapStr);
                return rsResourceGoodsDomain;
            }
            SupQueryResult querySpecQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(querySpecJson, SupQueryResult.class);
            List specList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)querySpecQueryResult.getList()), RsSpec.class);
            if (ListUtil.isEmpty((Collection)specList)) {
                this.logger.error("service.adapter.fuji.InfGoodsServiceImpl.checkGoods.querySpecPage", (Object)("\u6839\u636e\u89c4\u683c\u7ec4\u67e5\u8be2\u89c4\u683c\u4e3a\u7a7a!!!map:" + querySpecMapStr));
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsRemark("\u5f53\u524d\u5546\u54c1:" + infGoods.getGoodsid() + "\u6839\u636e\u89c4\u683c\u7ec4\u67e5\u8be2\u89c4\u683c\u4e3a\u7a7a\uff01\uff01\uff01map:" + specGroupMapStr);
                return rsResourceGoodsDomain;
            }
            specMap.put("specCode", ((RsSpec)specList.get(0)).getSpecCode());
            specMap.put("specName", ((RsSpec)specList.get(0)).getSpecName());
        }
        return this.saveGoods(rsBrand, rsClasstree, rsPntree, rsSkuMomDomain, null, infGoods, goodsClassList, isChildFlag, goodsPrice, goodsStockNum);
    }

    public RsResourceGoodsDomain saveGoods(RsBrand rsBrand, RsClasstree rsClasstree, RsPntree rsPntree, RsSkuDomain rsSkuMomDomain, List<RsSpecValueDomain> rsSpecValueDomainsList, InfGoods infGoods, List<RsGoodsClass> goodsClassList, boolean isChildFlag, String goodsPrice, String goodsStockNum) {
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsEocode(infGoods.getGoodsid());
        rsResourceGoodsDomain.setTenantCode(rsBrand.getTenantCode());
        rsResourceGoodsDomain.setBrandCode(rsBrand.getBrandCode());
        rsResourceGoodsDomain.setBrandName(rsBrand.getBrandName());
        rsResourceGoodsDomain.setPntreeCode(rsPntree.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(rsPntree.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(rsClasstree.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(rsClasstree.getClasstreeName());
        rsResourceGoodsDomain.setGoodsNo(infGoods.getGoodsid());
        rsResourceGoodsDomain.setGoodsName(infGoods.getGoodsname());
        rsResourceGoodsDomain.setGoodsShowname(infGoods.getGoodsname());
        if (StringUtils.isNotBlank((String)goodsPrice)) {
            rsResourceGoodsDomain.setPricesetNprice(new BigDecimal(goodsPrice));
        } else {
            rsResourceGoodsDomain.setPricesetNprice(infGoods.getAdviceprice());
        }
        rsResourceGoodsDomain.setGoodsMinnum(new BigDecimal(1));
        rsResourceGoodsDomain.setPartsnameNumunit(infGoods.getUnitname());
        rsResourceGoodsDomain.setPartsnameWeightunit(infGoods.getUnitname());
        if (StringUtils.isNotBlank((String)goodsStockNum)) {
            rsResourceGoodsDomain.setGoodsNum(new BigDecimal(goodsStockNum));
        } else {
            rsResourceGoodsDomain.setGoodsNum(new BigDecimal(0));
        }
        rsResourceGoodsDomain.setGoodsSupplynum(rsResourceGoodsDomain.getGoodsNum());
        Integer goodsweight = infGoods.getGoodsweight();
        if (goodsweight == null) {
            rsResourceGoodsDomain.setGoodsOneweight(new BigDecimal(0));
        } else {
            rsResourceGoodsDomain.setGoodsOneweight(new BigDecimal(infGoods.getGoodsweight()));
        }
        BigDecimal multiplyWeight = rsResourceGoodsDomain.getGoodsOneweight().multiply(rsResourceGoodsDomain.getGoodsNum());
        rsResourceGoodsDomain.setGoodsWeight(multiplyWeight);
        rsResourceGoodsDomain.setGoodsSupplyweight(multiplyWeight);
        if (ListUtil.isNotEmpty(goodsClassList) && goodsClassList.size() == 1) {
            rsResourceGoodsDomain.setClasstreeShopcode(goodsClassList.get(0).getGoodsClassCode());
            rsResourceGoodsDomain.setClasstreeShopname(goodsClassList.get(0).getGoodsClassName());
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)rsBrand.getTenantCode());
        rsResourceGoodsDomain.setMemberCode(memberCode);
        rsResourceGoodsDomain.setMemberName(memberCode);
        rsResourceGoodsDomain.setMemberCode(memberCode);
        rsResourceGoodsDomain.setMemberName(memberCode);
        rsResourceGoodsDomain.setProductareaName(infGoods.getProducingarea());
        if (isChildFlag) {
            rsResourceGoodsDomain.setGoodsOrigin("20");
            rsResourceGoodsDomain.setGoodsPro("3");
        } else {
            rsResourceGoodsDomain.setGoodsOrigin("0");
        }
        rsResourceGoodsDomain.setGoodsType("00");
        rsResourceGoodsDomain.setGoodsCodeOld(infGoods.getGoodsid());
        ArrayList<RsSkuDomain> rsSkuDomainsList = new ArrayList<RsSkuDomain>();
        rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainsList);
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        rsSkuDomainsList.add(rsSkuDomain);
        rsSkuDomain.setSkuCodeOld(infGoods.getGoodsid());
        if (ListUtil.isNotEmpty(goodsClassList) && goodsClassList.size() == 1) {
            rsSkuDomain.setClasstreeShopcode(goodsClassList.get(0).getGoodsClassCode());
        }
        rsSkuDomain.setMemberCode(rsResourceGoodsDomain.getMemberCode());
        rsSkuDomain.setMemberName(rsResourceGoodsDomain.getMemberName());
        rsSkuDomain.setGoodsMinnum(new BigDecimal(1));
        rsSkuDomain.setSkuName(infGoods.getGoodsspec());
        if (StringUtils.isNotBlank((String)goodsPrice)) {
            rsSkuDomain.setPricesetNprice(new BigDecimal(goodsPrice));
        } else {
            rsSkuDomain.setPricesetNprice(infGoods.getAdviceprice());
        }
        rsSkuDomain.setPricesetAsprice(infGoods.getAdvicecost());
        rsSkuDomain.setSkuBarcode(infGoods.getBarcode());
        rsSkuDomain.setGoodsNum(rsResourceGoodsDomain.getGoodsNum());
        rsSkuDomain.setGoodsSupplynum(rsResourceGoodsDomain.getGoodsSupplynum());
        rsSkuDomain.setGoodsOneweight(rsResourceGoodsDomain.getGoodsOneweight());
        rsSkuDomain.setGoodsWeight(rsResourceGoodsDomain.getGoodsWeight());
        rsSkuDomain.setGoodsSupplyweight(rsResourceGoodsDomain.getGoodsSupplyweight());
        rsSkuDomain.setPartsnameNumunit(infGoods.getUnitname());
        rsSkuDomain.setPartsnameWeightunit(infGoods.getUnitname());
        rsSkuDomain.setTenantCode(rsBrand.getTenantCode());
        rsSkuDomain.setSkuNo(infGoods.getGoodsid());
        rsSkuDomain.setGoodsNo(infGoods.getGoodsid());
        rsSkuDomain.setSpecList(rsSpecValueDomainsList);
        if (ListUtil.isNotEmpty(goodsClassList)) {
            rsSkuDomain.setClasstreeShopcode(goodsClassList.get(0).getGoodsClassCode());
        }
        if (rsSkuMomDomain != null) {
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
            RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
            rsGoodsRelDomain.setGoodsRelGcode(rsSkuMomDomain.getGoodsCode());
            rsGoodsRelDomain.setGoodsRelType("4");
            rsGoodsRelDomain.setSkuCode(rsSkuMomDomain.getSkuCode());
            rsGoodsRelDomain.setSkuName(rsSkuMomDomain.getSkuName());
            rsGoodsRelDomain.setPricesetNprice(rsSkuMomDomain.getPricesetNprice());
            rsGoodsRelDomain.setSkuNo(rsSkuMomDomain.getSkuNo());
            rsGoodsRelDomain.setGoodsName(rsSkuMomDomain.getGoodsName());
            rsGoodsRelDomainList.add(rsGoodsRelDomain);
            rsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
            rsSkuDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
        }
        return rsResourceGoodsDomain;
    }

    @Override
    public List<InfGoods> queryGoodsByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo * pageSize);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfGoods> infGoodsQueryResult = this.queryGoodsPage(map);
        return infGoodsQueryResult.getList();
    }

    public static void main(String[] args) {
        ViewChangeunitgoods viewChangeunitgoods = new ViewChangeunitgoods();
        viewChangeunitgoods.setPageNo("5");
        viewChangeunitgoods.setPageSize("10");
        viewChangeunitgoods.setShopid("SH001");
        String requestJson = JsonUtil.buildNormalBinder().toJson((Object)viewChangeunitgoods);
        String requestUrl = "http://wx.52fmart.com:8081";
        String jsonResult = HttpRequestUtiles.httpPost("/qj/queryChildGoodsInfo", requestJson, requestUrl);
        System.out.println(jsonResult);
    }
}

