/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.InfdbShopstockMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.WhStoreGoodsDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.WhStoreSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.WhStoreSkuNumBean;
import com.yqbsoft.laser.service.adapter.fuji.model.DisChannel;
import com.yqbsoft.laser.service.adapter.fuji.model.InfdbShopstock;
import com.yqbsoft.laser.service.adapter.fuji.model.RsResourceGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSku;
import com.yqbsoft.laser.service.adapter.fuji.model.UmUserinfo;
import com.yqbsoft.laser.service.adapter.fuji.model.WhStoreSku;
import com.yqbsoft.laser.service.adapter.fuji.model.WhWarehouse;
import com.yqbsoft.laser.service.adapter.fuji.service.InfdbShopstockService;
import com.yqbsoft.laser.service.adapter.fuji.utils.HttpRequestUtiles;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfdbShopstockServiceImpl
extends BaseServiceImpl
implements InfdbShopstockService {
    private static final String SYS_CODE = "service.adapter.fuji.InfdbShopstockServiceImpl";
    private InfdbShopstockMapper infdbShopstockMapper;
    private String fujiShopstockKey = "";

    public void setInfdbShopstockMapper(InfdbShopstockMapper infdbShopstockMapper) {
        this.infdbShopstockMapper = infdbShopstockMapper;
    }

    private InfdbShopstock getInfdbShopstockModelById(Map<String, Object> map) {
        try {
            return this.infdbShopstockMapper.selectByPrimaryKey(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.getInfdbShopstockModelById", (Throwable)e);
            return null;
        }
    }

    private List<InfdbShopstock> queryInfdbShopstockModelPage(Map<String, Object> parammap) {
        try {
            return this.infdbShopstockMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.queryInfdbShopstockModel", (Throwable)e);
            return null;
        }
    }

    private int countInfdbShopstock(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.infdbShopstockMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.countInfdbShopstock", (Throwable)e);
        }
        return i;
    }

    @Override
    public InfdbShopstock getInfdbShopstock(String shopid, String goodsid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shopid", shopid);
        map.put("goodsid", goodsid);
        return this.getInfdbShopstockModelById(map);
    }

    @Override
    public QueryResult<InfdbShopstock> queryInfdbShopstockPage(Map<String, Object> map) {
        List<InfdbShopstock> infdbShopstockList = this.queryInfdbShopstockModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInfdbShopstock(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infdbShopstockList);
        return queryResult;
    }

    @Override
    public List<InfdbShopstock> queryShopstockByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo * pageSize);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<InfdbShopstock> goodsshopQueryResult = this.queryInfdbShopstockPage(map);
        List goodsshopList = goodsshopQueryResult.getList();
        return goodsshopList;
    }

    @Override
    public void inertShopstockByPage(String pageNo, String pageSize, String tenantCode) {
        List<UmUserinfo> umUserinfoList;
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            DisUtil.del((String)"SH016StockKey");
            pageNo = "0";
            pageSize = "100";
            tenantCode = "2019071800001392";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode));
            return;
        }
        String onLineShop = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            String onLineShopKey = tenantCode.concat("-").concat("SSURL").concat("-").concat("onLineShop");
            onLineShop = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)onLineShopKey);
        }
        if (ListUtil.isEmpty(umUserinfoList = this.getOnlineShop(onLineShop, tenantCode))) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.queryUserinfoPage.umUserinfoList", (Object)"\u6ca1\u6709\u95e8\u5e97umUserinfoList is null");
            return;
        }
        ArrayList listAllError = new ArrayList();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        HashMap<String, Object> queryShopGoodsMap = new HashMap<String, Object>();
        for (int i = 0; i < umUserinfoList.size(); ++i) {
            DisChannel disChannel;
            Integer pn = Integer.valueOf(pageNo);
            Integer ps = Integer.valueOf(pageSize);
            int count = 0;
            UmUserinfo umUserinfo = umUserinfoList.get(i);
            this.fujiShopstockKey = umUserinfo.getUserinfoOcode() + "StockKey";
            String lasttime = DisUtil.getRemot((String)this.fujiShopstockKey);
            lasttime = "";
            DisUtil.set((String)this.fujiShopstockKey, (String)sdf.format(new Date()));
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.start", (Object)("\u540c\u6b65\u8be5" + umUserinfo.getUserinfoOcode() + "-" + umUserinfo.getUserinfoCompname() + "\u95e8\u5e97\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
            if (StringUtils.isNotBlank((String)lasttime)) {
                try {
                    Date dateTime = sdf.parse(lasttime);
                    dateTime.setTime(dateTime.getTime() - 120000L);
                    lasttime = sdf.format(dateTime);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                    DisUtil.set((String)this.fujiShopstockKey, (String)lasttime);
                    return;
                }
            }
            if ((disChannel = this.getChannelCodeByshopId(umUserinfo.getUserinfoOcode(), tenantCode)) == null) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.getChannelCodeByshopId", (Object)"\u83b7\u53d6\u95e8\u5e97\u6e20\u9053\u4e3a\u7a7a\uff01\uff01\uff01disChannel\uff1anull");
                DisUtil.set((String)this.fujiShopstockKey, (String)lasttime);
                continue;
            }
            ArrayList<WhStoreGoodsDomain> whStoreGoodsDomainList = new ArrayList<WhStoreGoodsDomain>();
            ArrayList<WhStoreSkuNumBean> whStoreSkuNumBeanList = new ArrayList<WhStoreSkuNumBean>();
            ArrayList<String> newInsetGoodsNum = new ArrayList<String>();
            ArrayList<String> newUpdateGoodsNum = new ArrayList<String>();
            ArrayList<String> listError = new ArrayList<String>();
            queryShopGoodsMap.put("memberCode", disChannel.getMemberCcode());
            queryShopGoodsMap.put("channelCode", disChannel.getChannelCode());
            queryShopGoodsMap.put("tenantCode", tenantCode);
            while (true) {
                queryShopGoodsMap.put("order", true);
                queryShopGoodsMap.put("rows", ps);
                queryShopGoodsMap.put("startRow", pn * ps);
                queryMap.put("map", JsonUtil.buildNormalBinder().toJson(queryShopGoodsMap));
                String rsSkuDomainJson = null;
                try {
                    rsSkuDomainJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", queryMap);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.querySkuPage.e", (Object)("\u67e5\u8be2\u95e8\u5e97\u5546\u54c1\u5f02\u5e38!\u53c2\u6570map:" + queryShopGoodsMap), (Throwable)e);
                    DisUtil.set((String)this.fujiShopstockKey, (String)lasttime);
                    return;
                }
                SupQueryResult queryRsSkuQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuDomainJson, SupQueryResult.class);
                List rsSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryRsSkuQueryResultStr.getList()), RsSkuDomain.class);
                if (ListUtil.isEmpty((Collection)rsSkuDomainList)) {
                    if (ListUtil.isNotEmpty(listError)) {
                        DisUtil.set((String)this.fujiShopstockKey, (String)lasttime);
                    }
                    break;
                }
                List<Integer> goodsIds = this.covertGoodsId(rsSkuDomainList);
                if (rsSkuDomainList.size() != goodsIds.size()) {
                    DisUtil.set((String)this.fujiShopstockKey, (String)lasttime);
                }
                long requestTime = System.currentTimeMillis();
                InfdbShopstock infdbShopstockRes = new InfdbShopstock();
                infdbShopstockRes.setGoodsids(goodsIds);
                infdbShopstockRes.setShopid(umUserinfo.getUserinfoOcode());
                infdbShopstockRes.setQueryTime(lasttime);
                String requestJson = JsonUtil.buildNonNullBinder().toJson((Object)infdbShopstockRes);
                String jsonResult = null;
                try {
                    jsonResult = HttpRequestUtiles.httpPost("/qj/queryShopstockByPage", requestJson, requestUrl);
                    if (StringUtils.isBlank((String)jsonResult)) {
                        this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockByPage", (Object)("response is null,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryShopstockByPage"));
                        DisUtil.set((String)this.fujiShopstockKey, (String)lasttime);
                        return;
                    }
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockByPage.e", (Object)("\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryShopstockByPage"));
                    DisUtil.set((String)this.fujiShopstockKey, (String)lasttime);
                    return;
                }
                long responseTime = System.currentTimeMillis();
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.time", (Object)("===========\u8bf7\u6c42\u7684\u65f6\u95f4:" + (responseTime - requestTime)));
                Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
                if (!"S".equals(mapResult.get("resCode"))) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockByPage.resCode", (Object)("respose is false,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryShopstockByPage" + ",\u54cd\u5e94\u7ed3\u679c:" + jsonResult));
                    DisUtil.set((String)this.fujiShopstockKey, (String)lasttime);
                    return;
                }
                Object dataStr = mapResult.get("dataStr");
                if (dataStr == null) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryShopstockByPage" + ",\u54cd\u5e94\u7ed3\u679c:" + jsonResult));
                    DisUtil.set((String)this.fujiShopstockKey, (String)lasttime);
                    return;
                }
                List infdbShopstocksList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(dataStr.toString(), InfdbShopstock.class);
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockByPage", (Object)("\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u5f53\u524d\u9875\u7801:" + pn + "-" + ps + ",infdbShopstocksList:" + infdbShopstocksList.size()));
                if (ListUtil.isEmpty((Collection)infdbShopstocksList)) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockByPage.infdbShopstocksList", (Object)("\u67e5\u8be2\u5bcc\u57fa\u5546\u54c1\u53ef\u66f4\u65b0\u5e93\u5b58\u4e3a\u7a7a\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u5f53\u524d\u9875\u7801:" + pn + "-" + ps));
                } else {
                    String res;
                    HashMap<String, String> map;
                    whStoreGoodsDomainList.clear();
                    whStoreSkuNumBeanList.clear();
                    for (InfdbShopstock infdbShopstock : infdbShopstocksList) {
                        ++count;
                        this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.qty", (Object)("========" + JsonUtil.buildNormalBinder().toJson((Object)infdbShopstock)));
                        if (infdbShopstock.getQty() == null) {
                            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.qty.null", (Object)("qty is null," + infdbShopstock.getQty()));
                            continue;
                        }
                        WhStoreSkuNumBean whStoreSkuNumBean = this.queryStoke(infdbShopstock, disChannel, tenantCode);
                        if (whStoreSkuNumBean == null) {
                            WhStoreGoodsDomain whStoreGoodsDomain = this.saveWhStoreSku(infdbShopstock, disChannel, tenantCode);
                            if (whStoreGoodsDomain != null) {
                                newInsetGoodsNum.add(infdbShopstock.getGoodsid());
                                whStoreGoodsDomainList.add(whStoreGoodsDomain);
                                continue;
                            }
                            BigDecimal qty = infdbShopstock.getQty();
                            if (qty == null) {
                                qty = BigDecimal.ZERO;
                            }
                            String res2 = this.errorShopStock("\u5546\u54c1\u4e0d\u5b58\u5728\uff01\uff01\uff01", infdbShopstock.getShopid(), qty.toString(), infdbShopstock.getGoodsid());
                            listError.add(res2);
                            continue;
                        }
                        if (whStoreSkuNumBean.getGoodsNum() == null) {
                            whStoreSkuNumBean.setGoodsNum(BigDecimal.ZERO);
                        }
                        if (whStoreSkuNumBean.getGoodsNum().compareTo(infdbShopstock.getQty()) == 0) continue;
                        whStoreSkuNumBean.setGoodsNum(infdbShopstock.getQty());
                        if (StringUtils.isBlank((String)whStoreSkuNumBean.getMemberCcode())) {
                            BigDecimal qty = infdbShopstock.getQty();
                            if (qty == null) {
                                qty = BigDecimal.ZERO;
                            }
                            String res3 = this.errorShopStock("\u95e8\u5e97\u5bf9\u5e94\u6e20\u9053\u4e0d\u5b58\u5728\uff01\uff01\uff01", infdbShopstock.getShopid(), qty.toString(), infdbShopstock.getGoodsid());
                            listError.add(res3);
                            continue;
                        }
                        newUpdateGoodsNum.add(infdbShopstock.getGoodsid());
                        whStoreSkuNumBeanList.add(whStoreSkuNumBean);
                    }
                    if (ListUtil.isNotEmpty(whStoreGoodsDomainList)) {
                        map = new HashMap<String, String>();
                        map.put("whStoreGoodsDomainList", JsonUtil.buildNonDefaultBinder().toJson(whStoreGoodsDomainList));
                        try {
                            this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveStoreGoodsBatch", map);
                        }
                        catch (Exception e) {
                            res = this.errorShopStock("\u65b0\u589e\u95e8\u5e97\u5546\u54c1\u5e93\u5b58\u5f02\u5e38\uff01\uff01\uff01", umUserinfo.getUserinfoOcode(), null, JsonUtil.buildNonDefaultBinder().toJson(newInsetGoodsNum));
                            newInsetGoodsNum.clear();
                            listError.add(res);
                        }
                    }
                    if (ListUtil.isNotEmpty(whStoreSkuNumBeanList)) {
                        map = new HashMap();
                        map.put("whStoreSkuNumBeanList", JsonUtil.buildNonDefaultBinder().toJson(whStoreSkuNumBeanList));
                        try {
                            this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendUpdateStoreSkuNum", map);
                        }
                        catch (Exception e) {
                            res = this.errorShopStock("\u66f4\u65b0\u95e8\u5e97\u5546\u54c1\u5e93\u5b58\u5f02\u5e38\uff01\uff01\uff01", umUserinfo.getUserinfoOcode(), null, JsonUtil.buildNonDefaultBinder().toJson(newUpdateGoodsNum));
                            newUpdateGoodsNum.clear();
                            listError.add(res);
                        }
                    }
                }
                long endTime = System.currentTimeMillis();
                this.logger.debug("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.time", (Object)("===========\u65b9\u6cd5\u63d2\u5165\u65f6\u95f4:" + (endTime - requestTime)));
                Integer n = pn;
                Integer n2 = pn = Integer.valueOf(pn + 1);
            }
            ListUtil.addAll(listAllError, listError);
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.shopend", (Object)("\u540c\u6b65\u5f00\u59cb\u65f6\u95f4:" + lasttime + ",\u540c\u6b65\u8be5" + umUserinfo.getUserinfoOcode() + "-" + umUserinfo.getUserinfoCompname() + "\u95e8\u5e97\u7ed3\u675f\uff01\uff01\uff01\u603b\u6761\u6570:" + count + ",\u5931\u8d25\u7684\u6761\u6570:" + listError.size() + ",\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.getRemot((String)this.fujiShopstockKey)));
            listError.clear();
        }
        this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.end", (Object)("----------\u6240\u6709\u95e8\u5e97\u5e93\u5b58\u540c\u6b65\u7ed3\u675f\uff01\uff01\uff01\uff01\u5931\u8d25\u7684\u6761\u6570:" + listAllError.size() + ",\u603b\u5931\u8d25\u7684\u6709:" + listAllError));
    }

    public List<Integer> covertGoodsId(List<RsSkuDomain> rsSkuDomainList) {
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            if (StringUtils.isBlank((String)rsSkuDomain.getSkuNo())) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.covertGoodsId.null", (Object)(rsSkuDomain.getSkuCode() + ":" + rsSkuDomain.getSkuNo()));
                continue;
            }
            goodsIds.add(Integer.valueOf(rsSkuDomain.getSkuNo()));
        }
        return goodsIds;
    }

    @Override
    public String insertOneShopstock(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.insertOneViewElabal.map", "map is null");
        }
        String skuNo = (String)map.get("skuNo");
        String goodsCode = (String)map.get("goodsCode");
        String memberCode = (String)map.get("memberCode");
        String channelCode = (String)map.get("channelCode");
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.insertOneShopstock.map", "map:" + map);
        }
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.insertOneShopstock.getRequestUrl", "\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode);
        }
        UmUserinfo umUserinfo = this.queryShopIdByUserinfoCode(memberCode, tenantCode);
        if (umUserinfo == null) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.insertOneShopstock.queryShopIdByUserinfoCode", "\u83b7\u53d6\u95e8\u5e97\u5931\u8d25,umUserinfo is null!" + memberCode + "-" + tenantCode);
        }
        InfdbShopstock infdbShopstock = new InfdbShopstock();
        infdbShopstock.setShopid(umUserinfo.getUserinfoOcode());
        infdbShopstock.setGoodsid(skuNo);
        String requestJson = JsonUtil.buildNonNullBinder().toJson((Object)infdbShopstock);
        String jsonResult = null;
        try {
            jsonResult = HttpRequestUtiles.httpPost("/qj/queryShopstockById", requestJson, requestUrl);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockById.e", "\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockById.resCode", "respose is false,jsonResult:" + jsonResult);
        }
        Object dataStr = mapResult.get("dataStr");
        if (dataStr == null) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockById.dataStr", "dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult);
        }
        infdbShopstock = (InfdbShopstock)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataStr.toString(), InfdbShopstock.class);
        if (infdbShopstock == null) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.httpPost.queryShopstockById.dataStr.e", (Object)("\u5e93\u5b58\u4e3a\u7a7a\uff01\uff01\uff01jsonResult\uff1a" + jsonResult));
            return "success";
        }
        this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.insertOneShopstock.qty", (Object)("========" + JsonUtil.buildNormalBinder().toJson((Object)infdbShopstock)));
        try {
            this.updateGoodsStockNum(infdbShopstock, umUserinfo.getUserinfoOcode(), tenantCode);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.insertOneShopstock.updateGoodsStockNum", "\u66f4\u65b0\u5e93\u5b58\u5931\u8d25\uff01\uff01\uff01" + infdbShopstock.getShopid() + "-" + infdbShopstock.getGoodsid() + "-" + infdbShopstock.getQty());
        }
        return "success";
    }

    private void updateGoodsStockNum(InfdbShopstock infdbShopstock, String userinfoOcode, String tenantCode) {
        if (infdbShopstock.getQty() == null) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.updateGoodsStockNum.qty", (Object)("qty is null," + infdbShopstock.getQty()));
            return;
        }
        ArrayList<WhStoreGoodsDomain> whStoreGoodsDomainList = new ArrayList<WhStoreGoodsDomain>();
        DisChannel disChannel = this.getChannelCodeByshopId(userinfoOcode, tenantCode);
        WhStoreGoodsDomain whStoreGoodsDomain = this.saveWhStoreSku(infdbShopstock, disChannel, tenantCode);
        if (whStoreGoodsDomain == null) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.updateGoodsStockNum", "whStoreGoodsDomain is null");
        }
        whStoreGoodsDomainList.add(whStoreGoodsDomain);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("whStoreGoodsDomainList", JsonUtil.buildNonDefaultBinder().toJson(whStoreGoodsDomainList));
        try {
            this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveStoreGoodsBatch", map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.InfdbShopstockServiceImpl.updateGoodsStockNum.sendSaveStoreGoodsBatch", "\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01", (Throwable)e);
        }
    }

    private UmUserinfo queryShopIdByUserinfoCode(String userinfoCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        String umUserInfoJson = null;
        try {
            umUserInfoJson = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoModelByUserCode", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.queryShopIdByUserinfoCode.getUserinfoModelByUserCode.e", map, (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)umUserInfoJson)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.queryShopIdByUserinfoCode.umUserInfoJson", (Object)"umUserInfoJson is null");
            return null;
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(umUserInfoJson, UmUserinfo.class);
        return umUserinfo;
    }

    private List<UmUserinfo> getOnlineShop(String onLineShop, String tenantCode) {
        ArrayList<UmUserinfo> umUserinfoList = new ArrayList<UmUserinfo>();
        if (StringUtils.isBlank((String)onLineShop)) {
            HashMap<String, String> umInfoMap = new HashMap<String, String>();
            HashMap<String, String> umInfoMapStr = new HashMap<String, String>();
            umInfoMapStr.put("userinfoQuality", "store,supplier");
            umInfoMapStr.put("tenantCode", tenantCode);
            umInfoMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(umInfoMapStr));
            String userListJson = "";
            try {
                userListJson = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", umInfoMap);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.queryUserinfoPage.e", (Object)("\u83b7\u53d6\u6240\u6709\u95e8\u5e97\u5f02\u5e38umInfoMapStr:" + umInfoMapStr), (Throwable)e);
                return null;
            }
            SupQueryResult supQueryUserResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(userListJson, SupQueryResult.class);
            List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryUserResult.getList()), UmUserinfo.class);
            if (ListUtil.isEmpty((Collection)pList)) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.queryUserinfoPage", (Object)("\u67e5\u8be2\u4e0d\u5230\u95e8\u5e97umInfoMapStr:" + umInfoMapStr));
                return null;
            }
            ListUtil.addAll(umUserinfoList, (List)pList);
        } else {
            String[] shopIdArray;
            for (String shopId : shopIdArray = onLineShop.split("-")) {
                HashMap<String, String> umInfoMap = new HashMap<String, String>();
                HashMap<String, String> umInfoMapStr = new HashMap<String, String>();
                umInfoMapStr.put("userinfoOcode", shopId);
                umInfoMapStr.put("userinfoQuality", "store,supplier");
                umInfoMapStr.put("tenantCode", tenantCode);
                umInfoMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(umInfoMapStr));
                String userListJson = "";
                try {
                    userListJson = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", umInfoMap);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.queryUserinfoPage.e", (Object)("\u83b7\u53d6\u6240\u6709\u95e8\u5e97\u5f02\u5e38umInfoMapStr:" + umInfoMapStr), (Throwable)e);
                    return null;
                }
                SupQueryResult supQueryUserResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(userListJson, SupQueryResult.class);
                List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryUserResult.getList()), UmUserinfo.class);
                if (ListUtil.isEmpty((Collection)pList)) {
                    this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.queryUserinfoPage", (Object)("\u67e5\u8be2\u4e0d\u5230\u95e8\u5e97umInfoMapStr:" + umInfoMapStr));
                    continue;
                }
                umUserinfoList.add((UmUserinfo)pList.get(0));
            }
        }
        return umUserinfoList;
    }

    private WhStoreSkuNumBean queryStoke(InfdbShopstock infdbShopstock, DisChannel disChannel, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("skuEocode", infdbShopstock.getGoodsid());
        mapStr.put("memberCcode", disChannel.getMemberCcode());
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(mapStr));
        String whStoreSkuPageJson = null;
        try {
            whStoreSkuPageJson = (String)this.getInternalRouter().inInvoke("wh.whStoreGoods.queryStoreSkuPage", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertShopstockByPage.queryStoreSkuPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01map:" + map), (Throwable)e);
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(whStoreSkuPageJson, SupQueryResult.class);
        List whStoreStrList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), WhStoreSku.class);
        if (ListUtil.isEmpty((Collection)whStoreStrList)) {
            return null;
        }
        WhStoreSku whStoreSku = (WhStoreSku)whStoreStrList.get(0);
        WhStoreSkuNumBean whStoreSkuNumBean = new WhStoreSkuNumBean();
        whStoreSkuNumBean.setTenantCode(whStoreSku.getTenantCode());
        whStoreSkuNumBean.setGoodsEocode(whStoreSku.getGoodsEocode());
        whStoreSkuNumBean.setSkuEocode(whStoreSku.getSkuEocode());
        whStoreSkuNumBean.setGoodsNum(whStoreSku.getGoodsNum());
        whStoreSkuNumBean.setMemberCode(whStoreSku.getMemberCode());
        whStoreSkuNumBean.setMemberCcode(whStoreSku.getMemberCcode());
        return whStoreSkuNumBean;
    }

    protected WhStoreGoodsDomain saveWhStoreSku(InfdbShopstock infdbShopstock, DisChannel disChannel, String tenantCode) {
        HashMap<String, String> goodsBnparamMap = new HashMap<String, String>();
        goodsBnparamMap.put("goodsNo", infdbShopstock.getGoodsid());
        goodsBnparamMap.put("tenantCode", tenantCode);
        List resourceGoodsList = null;
        String resourceGoodsListStr = "";
        try {
            resourceGoodsListStr = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.checkGoodsNo", goodsBnparamMap);
            if (StringUtils.isBlank((String)resourceGoodsListStr)) {
                this.logger.error(".checkGoodsNoApiCode.resourceGoodsListStr", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01goodsBnparamMap:" + goodsBnparamMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".checkGoodsNoApiCode.resourceGoodsListStr.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01goodsBnparamMap:" + goodsBnparamMap));
            return null;
        }
        resourceGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(resourceGoodsListStr, RsResourceGoods.class);
        if (ListUtil.isEmpty((Collection)resourceGoodsList)) {
            this.logger.error(".checkGoodsNoApiCode.resourceGoodsList", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01goodsBnparamMap:" + goodsBnparamMap));
            return null;
        }
        RsResourceGoods rsResourceGoods = (RsResourceGoods)resourceGoodsList.get(0);
        HashMap<String, String> skuMap = new HashMap<String, String>();
        skuMap.put("skuNo", infdbShopstock.getGoodsid());
        skuMap.put("tenantCode", tenantCode);
        List rsSkuList = null;
        String rsSkuListStr = "";
        try {
            rsSkuListStr = (String)this.getInternalRouter().inInvoke("rs.sku.checkSkuNo", skuMap);
            if (StringUtils.isBlank((String)rsSkuListStr)) {
                this.logger.error(".checkGoodsNoApiCode.checkSkuNo.rsSkuListStr", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01skuMap:" + skuMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(".checkGoodsNoApiCode.checkSkuNo.rsSkuListStr.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01skuMap:" + skuMap));
            return null;
        }
        rsSkuList = (List)JsonUtil.buildNormalBinder().getJsonToList(rsSkuListStr, RsSku.class);
        if (ListUtil.isEmpty((Collection)rsSkuList)) {
            this.logger.error(".checkGoodsNoApiCode.checkSkuNo.rsSkuList", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01skuMap:" + skuMap));
            return null;
        }
        RsSku rsSku = (RsSku)rsSkuList.get(0);
        return this.creatParam(rsResourceGoods, rsSku, disChannel, infdbShopstock);
    }

    private WhStoreGoodsDomain creatParam(RsResourceGoods rsResourceGoods, RsSku rsSku, DisChannel disChannel, InfdbShopstock infdbShopstock) {
        HashMap<String, String> queryWhWarehouseMap = new HashMap<String, String>();
        HashMap<String, String> queryWhWarehouseMapStr = new HashMap<String, String>();
        queryWhWarehouseMapStr.put("memberCode", disChannel.getMemberCcode());
        queryWhWarehouseMapStr.put("tenantCode", disChannel.getTenantCode());
        queryWhWarehouseMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryWhWarehouseMapStr));
        String queryWareHouseJson = "";
        try {
            queryWareHouseJson = (String)this.getInternalRouter().inInvoke("wh.warehouse.queryWarehousePage", queryWhWarehouseMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.creatParam.queryWarehousePage", (Object)("\u83b7\u53d6\u95e8\u5e97\u5bf9\u5e94\u4ed3\u5e93\u5f02\u5e38\uff01\uff01\uff01map:" + queryWhWarehouseMapStr));
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryWareHouseJson, SupQueryResult.class);
        List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), WhWarehouse.class);
        if (ListUtil.isEmpty((Collection)pList)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.creatParam.queryWarehousePage", (Object)("\u83b7\u53d6\u95e8\u5e97\u5bf9\u5e94\u4ed3\u5e93\u4e3a\u7a7a\uff01\uff01\uff01map:" + queryWhWarehouseMapStr));
            return null;
        }
        WhWarehouse whWarehouse = (WhWarehouse)pList.get(0);
        WhStoreGoodsDomain whStoreGoodsDomain = new WhStoreGoodsDomain();
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)rsSku.getTenantCode());
        try {
            BeanUtils.copyAllPropertys((Object)whStoreGoodsDomain, (Object)rsResourceGoods);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.whStoreGoodsDomain.rsResourceGoods.e", (Throwable)e);
            return null;
        }
        whStoreGoodsDomain.setGoodsNum(infdbShopstock.getQty());
        whStoreGoodsDomain.setGoodsSupplynum(whStoreGoodsDomain.getGoodsNum());
        if (rsSku.getGoodsOneweight() == null) {
            rsSku.setGoodsOneweight(BigDecimal.ONE);
        }
        whStoreGoodsDomain.setGoodsOneweight(rsSku.getGoodsOneweight());
        BigDecimal multiply = whStoreGoodsDomain.getGoodsNum().multiply(rsSku.getGoodsOneweight());
        whStoreGoodsDomain.setGoodsWeight(multiply);
        whStoreGoodsDomain.setGoodsSupplyweight(multiply);
        whStoreGoodsDomain.setPricesetPurrice(infdbShopstock.getCost());
        whStoreGoodsDomain.setPartsnameWeightunit(rsResourceGoods.getPartsnameWeightunit());
        whStoreGoodsDomain.setGoodsEocode(infdbShopstock.getGoodsid());
        whStoreGoodsDomain.setMemberCode(memberCode);
        whStoreGoodsDomain.setMemberName(memberCode);
        whStoreGoodsDomain.setGoodsMinnum(new BigDecimal(1));
        ArrayList<WhStoreSkuDomain> whStoreSkuDomainList = new ArrayList<WhStoreSkuDomain>();
        WhStoreSkuDomain whStoreSkuDomain = new WhStoreSkuDomain();
        whStoreSkuDomainList.add(whStoreSkuDomain);
        whStoreGoodsDomain.setWhStoreSkuDomainList(whStoreSkuDomainList);
        try {
            BeanUtils.copyAllPropertys((Object)whStoreSkuDomain, (Object)rsSku);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.whStoreSkuDomain.rsSku.e", (Throwable)e);
            return null;
        }
        whStoreSkuDomain.setGoodsNum(whStoreGoodsDomain.getGoodsNum());
        whStoreSkuDomain.setGoodsSupplynum(whStoreGoodsDomain.getGoodsNum());
        whStoreSkuDomain.setGoodsOneweight(whStoreGoodsDomain.getGoodsOneweight());
        whStoreSkuDomain.setGoodsWeight(whStoreGoodsDomain.getGoodsWeight());
        whStoreSkuDomain.setGoodsSupplyweight(whStoreGoodsDomain.getGoodsSupplyweight());
        whStoreSkuDomain.setGoodsMinnum(new BigDecimal(1));
        whStoreSkuDomain.setPricesetPurrice(infdbShopstock.getCost());
        whStoreSkuDomain.setPartsnameWeightunit(rsSku.getPartsnameWeightunit());
        whStoreSkuDomain.setSkuEocode(infdbShopstock.getGoodsid());
        whStoreSkuDomain.setGoodsEocode(infdbShopstock.getGoodsid());
        whStoreSkuDomain.setMemberCode(memberCode);
        whStoreSkuDomain.setMemberName(memberCode);
        whStoreSkuDomain.setChannelCode(disChannel.getChannelCode());
        whStoreSkuDomain.setChannelName(disChannel.getChannelName());
        whStoreSkuDomain.setMemberCcode(disChannel.getMemberCcode());
        whStoreSkuDomain.setMemberCname(disChannel.getMemberCname());
        whStoreSkuDomain.setWarehouseCode(whWarehouse.getWarehouseCode());
        whStoreSkuDomain.setWarehouseName(whWarehouse.getWarehouseName());
        return whStoreGoodsDomain;
    }

    private DisChannel getChannelCodeByshopId(String shopId, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("userinfoOcode", shopId);
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String umJosnStr = null;
        try {
            umJosnStr = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", map);
            if (StringUtils.isBlank((String)umJosnStr)) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryUserinfoPage", (Object)("\u67e5\u8be2\u4e3a\u7a7a!!!mapStr:" + mapStr));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryUserinfoPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38!!!mapStr:" + mapStr));
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(umJosnStr, SupQueryResult.class);
        List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), UmUserinfo.class);
        if (ListUtil.isEmpty((Collection)pList)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryUserinfoPage", (Object)("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        UmUserinfo umUserinfo = (UmUserinfo)pList.get(0);
        map.clear();
        mapStr.clear();
        mapStr.put("memberCcode", umUserinfo.getUserinfoCode());
        mapStr.put("tenantCode", tenantCode);
        mapStr.put("channelType", "1");
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String disChannelJson = null;
        try {
            disChannelJson = (String)this.getInternalRouter().inInvoke("dis.channel.queryChannelPage", map);
            if (StringUtils.isBlank((String)disChannelJson)) {
                this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryChannelPage", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryChannelPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map));
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disChannelJson, SupQueryResult.class);
        List disChannelList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisChannel.class);
        if (ListUtil.isEmpty((Collection)disChannelList)) {
            this.logger.error("service.adapter.fuji.InfdbShopstockServiceImpl.inertGoodsshopByPage.queryDictionaryPage", (Object)("\u95e8\u5e97\u672a\u7ed1\u5b9a\u6e20\u9053,\u8bf7\u524d\u5f80\u7ed1\u5b9a\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        return (DisChannel)disChannelList.get(0);
    }

    public String errorShopStock(String msg, String shopId, String stock, String goodid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("msg", msg);
        map.put("shopid", shopId);
        map.put("stock", stock);
        map.put("goodid", goodid);
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }

    public static void main(String[] args) {
    }
}

