/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.fuji.service.impl;

import com.yqbsoft.laser.service.adapter.fuji.dao.ViewElabalSendMapper;
import com.yqbsoft.laser.service.adapter.fuji.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.EditSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.domain.RsSkuDomain;
import com.yqbsoft.laser.service.adapter.fuji.model.DisChannel;
import com.yqbsoft.laser.service.adapter.fuji.model.DisDgmcnumlist;
import com.yqbsoft.laser.service.adapter.fuji.model.DisDgoods;
import com.yqbsoft.laser.service.adapter.fuji.model.DisDpriceConf;
import com.yqbsoft.laser.service.adapter.fuji.model.RsResourceGoods;
import com.yqbsoft.laser.service.adapter.fuji.model.RsSku;
import com.yqbsoft.laser.service.adapter.fuji.model.UmUserinfo;
import com.yqbsoft.laser.service.adapter.fuji.model.ViewElabalSend;
import com.yqbsoft.laser.service.adapter.fuji.service.ViewElabalSendService;
import com.yqbsoft.laser.service.adapter.fuji.utils.HttpRequestUtiles;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewElabalSendServiceImpl
extends BaseServiceImpl
implements ViewElabalSendService {
    private static final String SYS_CODE = "service.adapter.fuji.ViewElabalSendServiceImpl";
    private ViewElabalSendMapper viewElabalSendMapper;
    private String fujiShopGoodsPriceKey = "";

    public void setViewElabalSendMapper(ViewElabalSendMapper viewElabalSendMapper) {
        this.viewElabalSendMapper = viewElabalSendMapper;
    }

    private List<ViewElabalSend> queryViewElabalSendModelPage(Map<String, Object> parammap) {
        try {
            return this.viewElabalSendMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.queryViewElabalSendModel", (Throwable)e);
            return null;
        }
    }

    private int countViewElabalSend(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.viewElabalSendMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.countViewElabalSend", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<ViewElabalSend> queryViewElabalSendPage(Map<String, Object> map) {
        List<ViewElabalSend> viewElabalSendList = this.queryViewElabalSendModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countViewElabalSend(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(viewElabalSendList);
        return queryResult;
    }

    @Override
    public List<ViewElabalSend> queryViewElabalSendByPage(Integer pageNo, Integer pageSize, String lasttime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo * pageSize);
        map.put("pageSize", pageSize);
        map.put("lasttime", lasttime);
        QueryResult<ViewElabalSend> viewElabalSendQueryResult = this.queryViewElabalSendPage(map);
        List viewElabalSendList = viewElabalSendQueryResult.getList();
        return viewElabalSendList;
    }

    @Override
    public void inertViewElabalSendByPage(String pageNo, String pageSize, String tenantCode) {
        boolean flag = false;
        if (StringUtils.isBlank((String)pageNo) || StringUtils.isBlank((String)pageSize) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.intoParam", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01\uff01\uff01pageNo:" + pageNo + ",pageSize:" + pageSize + ",tenantCode:" + tenantCode));
            pageNo = "0";
            pageSize = "50";
            tenantCode = "2019071800001392";
            flag = true;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode));
            return;
        }
        String onLineShop = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            String onLineShopKey = tenantCode.concat("-").concat("SSURL").concat("-").concat("onLineShop");
            onLineShop = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)onLineShopKey);
        }
        this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.onLineShop", (Object)onLineShop);
        List<UmUserinfo> umUserinfoList = this.getOnlineShop(onLineShop, tenantCode);
        if (ListUtil.isEmpty(umUserinfoList)) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.queryUserinfoPage.umUserinfoList", (Object)"\u6ca1\u6709\u95e8\u5e97umUserinfoList is null");
            return;
        }
        ArrayList errorAllList = new ArrayList();
        ArrayList oldGoodsPriceList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, Object> queryShopGoodsMap = new HashMap<String, Object>();
        for (int i = 0; i < umUserinfoList.size(); ++i) {
            DisChannel disChannel;
            Integer pn = Integer.valueOf(pageNo);
            Integer ps = Integer.valueOf(pageSize);
            UmUserinfo umUserinfo = umUserinfoList.get(i);
            int allcount = 0;
            ArrayList<String> errorShopList = new ArrayList<String>();
            this.fujiShopGoodsPriceKey = umUserinfo.getUserinfoOcode() + "GoodsPriceKey";
            if (flag) {
                DisUtil.del((String)this.fujiShopGoodsPriceKey);
            }
            String lasttime = DisUtil.getRemot((String)this.fujiShopGoodsPriceKey);
            DisUtil.set((String)this.fujiShopGoodsPriceKey, (String)sdf.format(new Date()));
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.start", (Object)("\u540c\u6b65\u8be5" + umUserinfo.getUserinfoOcode() + "-" + umUserinfo.getUserinfoCompname() + "\u95e8\u5e97\u5f00\u59cb\uff0c\u540c\u6b65\u4ece\u4e0a\u6b21\u65f6\u95f4\u4e3a:" + lasttime));
            if (StringUtils.isNotBlank((String)lasttime)) {
                try {
                    Date dateTime = sdf.parse(lasttime);
                    dateTime.setTime(dateTime.getTime() - 120000L);
                    lasttime = sdf.format(dateTime);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.time.e", (Object)("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38\uff01\uff01\uff01lasttime:" + lasttime));
                    DisUtil.set((String)this.fujiShopGoodsPriceKey, (String)lasttime);
                    return;
                }
            }
            if ((disChannel = this.getChannelCodeByshopId(umUserinfo.getUserinfoOcode(), tenantCode)) == null) {
                this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getChannelCodeByshopId", (Object)"\u83b7\u53d6\u95e8\u5e97\u6e20\u9053\u4e3a\u7a7a\uff01\uff01\uff01disChannel\uff1anull");
                DisUtil.set((String)this.fujiShopGoodsPriceKey, (String)lasttime);
                continue;
            }
            queryShopGoodsMap.put("memberCode", disChannel.getMemberCcode());
            queryShopGoodsMap.put("channelCode", disChannel.getChannelCode());
            queryShopGoodsMap.put("tenantCode", tenantCode);
            while (true) {
                queryShopGoodsMap.put("order", true);
                queryShopGoodsMap.put("rows", ps);
                queryShopGoodsMap.put("startRow", pn * ps);
                map.put("map", JsonUtil.buildNormalBinder().toJson(queryShopGoodsMap));
                String rsSkuDomainJson = null;
                try {
                    rsSkuDomainJson = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuPage", map);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.querySkuPage.e", (Object)("\u67e5\u8be2\u95e8\u5e97\u5546\u54c1\u5f02\u5e38!\u53c2\u6570map:" + queryShopGoodsMap), (Throwable)e);
                    DisUtil.set((String)this.fujiShopGoodsPriceKey, (String)lasttime);
                    return;
                }
                SupQueryResult queryRsSkuQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuDomainJson, SupQueryResult.class);
                List rsSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryRsSkuQueryResultStr.getList()), RsSkuDomain.class);
                if (ListUtil.isEmpty((Collection)rsSkuDomainList)) {
                    if (ListUtil.isNotEmpty(errorShopList)) {
                        DisUtil.set((String)this.fujiShopGoodsPriceKey, (String)lasttime);
                    }
                    break;
                }
                List<Integer> goodsIds = this.covertGoodsId(rsSkuDomainList);
                ListUtil.addAll(oldGoodsPriceList, goodsIds);
                if (rsSkuDomainList.size() != goodsIds.size()) {
                    DisUtil.set((String)this.fujiShopGoodsPriceKey, (String)lasttime);
                }
                long requestTime = System.currentTimeMillis();
                ViewElabalSend viewElabalSendRes = new ViewElabalSend();
                viewElabalSendRes.setGoodsids(goodsIds);
                viewElabalSendRes.setShopid(umUserinfo.getUserinfoOcode());
                viewElabalSendRes.setQueryTime(lasttime);
                String requestJson = JsonUtil.buildNonNullBinder().toJson((Object)viewElabalSendRes);
                String jsonResult = null;
                try {
                    jsonResult = HttpRequestUtiles.httpPost("/qj/queryViewElabalSendByPage", requestJson, requestUrl);
                    if (StringUtils.isBlank((String)jsonResult)) {
                        this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.queryViewElabalSendByPage", (Object)("response is null,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryBrandByPage"));
                        DisUtil.set((String)this.fujiShopGoodsPriceKey, (String)lasttime);
                        return;
                    }
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.queryViewElabalSendByPage.e", (Object)("\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01,\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryBrandByPage"));
                    DisUtil.set((String)this.fujiShopGoodsPriceKey, (String)lasttime);
                    return;
                }
                long responseTime = System.currentTimeMillis();
                this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.time", (Object)("===========\u8bf7\u6c42\u7684\u65f6\u95f4:" + (responseTime - requestTime)));
                Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
                if (!"S".equals(mapResult.get("resCode"))) {
                    this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.queryViewElabalSendByPage.resCode", (Object)("respose is false,jsonResult:" + jsonResult + ",\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryBrandByPage"));
                    DisUtil.set((String)this.fujiShopGoodsPriceKey, (String)lasttime);
                    return;
                }
                Object dataStr = mapResult.get("dataStr");
                if (dataStr == null) {
                    this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.queryViewElabalSendByPage.dataStr", (Object)("dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult + ",\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u8bf7\u6c42\u5730\u5740:" + requestUrl + "/qj/queryBrandByPage"));
                    DisUtil.set((String)this.fujiShopGoodsPriceKey, (String)lasttime);
                    return;
                }
                List viewElabalSends = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(dataStr.toString(), ViewElabalSend.class);
                this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.queryViewElabalSendByPage", (Object)("\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u5f53\u524d\u9875\u7801:" + pn + "-" + ps));
                if (ListUtil.isEmpty((Collection)viewElabalSends)) {
                    this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.queryViewElabalSendByPage.viewElabalSends", (Object)("\u67e5\u8be2\u5bcc\u57fa\u5546\u54c1\u53ef\u66f4\u65b0\u4ef7\u683c\u4e3a\u7a7a\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570:" + requestJson + ",\u5f53\u524d\u9875\u7801:" + pn + "-" + ps));
                } else {
                    HashMap<String, String> querySkuMap = new HashMap<String, String>();
                    for (ViewElabalSend viewElabalSend : viewElabalSends) {
                        String rsSkuJson;
                        block35: {
                            ++allcount;
                            oldGoodsPriceList.remove(viewElabalSend.getGoodsid());
                            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.queryViewElabalSendByPage.price", (Object)("\u5546\u54c1:" + viewElabalSend.getGoodsid() + "-" + viewElabalSend.getNewprice() + "(" + viewElabalSend.getOldprice() + ")" + ",\u95e8\u5e97:" + viewElabalSend.getShopid() + ",\u8be5\u8bb0\u5f55\u65f6\u95f4:" + viewElabalSend.getGendate()));
                            Integer goodsid = viewElabalSend.getGoodsid();
                            if (goodsid == null || goodsid == 0) {
                                this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.goodsid", (Object)("goodsid:" + goodsid));
                                errorShopList.add("\u95e8\u5e97:" + viewElabalSend.getShopid() + ",\u5546\u54c1:" + viewElabalSend.getGoodsid() + "(" + viewElabalSend.getGoodsname() + "),\u4ef7\u683c\u4e2d\u8d27\u54c1id\u4e3a\u7a7a\u62160\u3002");
                                continue;
                            }
                            querySkuMap.put("skuNo", goodsid.toString());
                            querySkuMap.put("memberCode", disChannel.getMemberCcode());
                            querySkuMap.put("channelCode", disChannel.getChannelCode());
                            querySkuMap.put("tenantCode", tenantCode);
                            rsSkuJson = "";
                            try {
                                rsSkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.getSkuBySkuNo", querySkuMap);
                                if (StringUtils.isBlank((String)rsSkuJson)) {
                                    this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getSkuBySkuNo", (Object)("\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570:" + querySkuMap));
                                    errorShopList.add("\u95e8\u5e97:" + viewElabalSend.getShopid() + ",\u5546\u54c1:" + viewElabalSend.getGoodsid() + "(" + viewElabalSend.getGoodsname() + "),\u4e2d\u53f0\u83b7\u53d6\u5546\u54c1\u4e3a\u7a7a\u3002");
                                }
                                break block35;
                            }
                            catch (Exception e) {
                                this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getSkuBySkuNo.e", (Object)("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570:" + querySkuMap), (Throwable)e);
                                errorShopList.add("\u95e8\u5e97:" + viewElabalSend.getShopid() + ",\u5546\u54c1:" + viewElabalSend.getGoodsid() + "(" + viewElabalSend.getGoodsname() + "),\u4e2d\u53f0\u83b7\u53d6\u5546\u54c1\u5f02\u5e38\u3002");
                            }
                            continue;
                        }
                        RsSku rsSku = (RsSku)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuJson, RsSku.class);
                        EditSkuDomain editSkuDomain = new EditSkuDomain();
                        editSkuDomain.setSkuId(rsSku.getSkuId());
                        editSkuDomain.setSkuCode(rsSku.getSkuCode());
                        editSkuDomain.setGoodsCode(rsSku.getGoodsCode());
                        editSkuDomain.setTenantCode(tenantCode);
                        if (viewElabalSend.getNewprice() == null) {
                            if (viewElabalSend.getOldprice() == null) {
                                errorShopList.add("\u95e8\u5e97:" + viewElabalSend.getShopid() + ",\u5546\u54c1:" + viewElabalSend.getGoodsid() + "(" + viewElabalSend.getGoodsname() + "),\u4ef7\u683c\u4e3a\u7a7a:" + viewElabalSend.getOldprice() + "-" + viewElabalSend.getNewprice());
                                this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.Oldprice.null", (Object)(viewElabalSend.getOldprice() + "-" + viewElabalSend.getNewprice()));
                                continue;
                            }
                            editSkuDomain.setPricesetNprice(viewElabalSend.getOldprice().setScale(2, 4));
                        } else {
                            editSkuDomain.setPricesetNprice(viewElabalSend.getNewprice().setScale(2, 4));
                        }
                        this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.updatePrice", (Object)("\u95e8\u5e97:" + viewElabalSend.getShopid() + ",\u5546\u54c1:" + viewElabalSend.getGoodsid() + "(" + viewElabalSend.getGoodsname() + ")" + "\u65e7\u4ef7\u683c:" + rsSku.getPricesetNprice() + ",\u65b0\u4ef7\u683c:" + editSkuDomain.getPricesetNprice()));
                        if (rsSku.getPricesetNprice() == null) {
                            rsSku.setPricesetNprice(BigDecimal.ZERO);
                        }
                        if (rsSku.getPricesetNprice().compareTo(editSkuDomain.getPricesetNprice()) == 0) continue;
                        HashMap<String, String> updateMap = new HashMap<String, String>();
                        updateMap.put("editSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain));
                        try {
                            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSkuEditErp", updateMap);
                            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.sendUpdateSkuEditErp.end", (Object)("json:" + JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain)));
                        }
                        catch (Exception e) {
                            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.sendUpdateSkuEdit.e", (Object)("\u66f4\u65b0\u5f02\u5e38!!!\u5165\u53c2updateMap:" + updateMap), (Throwable)e);
                            errorShopList.add("\u95e8\u5e97:" + viewElabalSend.getShopid() + ",\u5546\u54c1:" + viewElabalSend.getGoodsid() + "(" + viewElabalSend.getGoodsname() + "),\u4e2d\u53f0\u95e8\u5e97\u5546\u54c1\u4ef7\u683c\u66f4\u65b0\u5931\u8d25\u3002");
                        }
                    }
                }
                long endTime = System.currentTimeMillis();
                this.logger.debug("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.time", (Object)("===========\u65b9\u6cd5\u63d2\u5165\u65f6\u95f4:" + (endTime - requestTime)));
                Integer n = pn;
                Integer n2 = pn = Integer.valueOf(pn + 1);
            }
            ListUtil.addAll(errorAllList, errorShopList);
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.shopend", (Object)("\u540c\u6b65\u5f00\u59cb\u65f6\u95f4:" + lasttime + ",\u540c\u6b65\u8be5" + umUserinfo.getUserinfoOcode() + "-" + umUserinfo.getUserinfoCompname() + "\u95e8\u5e97\u7ed3\u675f\uff01\uff01\uff01\u603b\u6761\u6570:" + allcount + ",\u5931\u8d25\u6761\u6570:" + errorShopList.size() + ",\u672a\u66f4\u65b0\u5230\u6761\u6570\uff1aoldGoodsPriceList\uff1a" + oldGoodsPriceList.size() + ",\u540c\u6b65\u7ed3\u675f\u65f6\u95f4:" + DisUtil.getRemot((String)this.fujiShopGoodsPriceKey)));
            oldGoodsPriceList.clear();
            errorShopList.clear();
        }
        this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.end", (Object)("----------\u6240\u6709\u95e8\u5e97\u5e93\u5b58\u540c\u6b65\u7ed3\u675f\uff01\uff01\uff01\uff01\u603b\u5931\u8d25\u6761\u6570:" + errorAllList.size() + "\u603b\u5931\u8d25\u7684\u6709:" + errorAllList));
    }

    public List<Integer> covertGoodsId(List<RsSkuDomain> rsSkuDomainList) {
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            if (StringUtils.isBlank((String)rsSkuDomain.getSkuNo())) {
                this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.covertGoodsId.null", (Object)(rsSkuDomain.getSkuCode() + ":" + rsSkuDomain.getSkuNo()));
                continue;
            }
            goodsIds.add(Integer.valueOf(rsSkuDomain.getSkuNo()));
        }
        return goodsIds;
    }

    private List<UmUserinfo> getOnlineShop(String onLineShop, String tenantCode) {
        ArrayList<UmUserinfo> umUserinfoList = new ArrayList<UmUserinfo>();
        if (StringUtils.isBlank((String)onLineShop)) {
            HashMap<String, Object> umInfoMapStr = new HashMap<String, Object>();
            umInfoMapStr.put("userinfoQuality", "store");
            umInfoMapStr.put("fuzzy", true);
            umInfoMapStr.put("tenantCode", tenantCode);
            List<UmUserinfo> pList = this.queryStore(umInfoMapStr);
            ListUtil.addAll(umUserinfoList, pList);
        } else {
            String[] shopIdArray;
            for (String shopId : shopIdArray = onLineShop.split("-")) {
                UmUserinfo umUserinfo = this.getStore(shopId, tenantCode);
                if (null == umUserinfo) continue;
                umUserinfoList.add(umUserinfo);
            }
        }
        return umUserinfoList;
    }

    private UmUserinfo getStore(String shopId, String tenantCode) {
        if (StringUtils.isBlank((String)shopId) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> umInfoMap = new HashMap<String, String>();
        HashMap<String, String> umInfoMapStr = new HashMap<String, String>();
        umInfoMapStr.put("userinfoOcode", shopId);
        umInfoMapStr.put("tenantCode", tenantCode);
        umInfoMap.put("map", JsonUtil.buildNormalBinder().toJson(umInfoMapStr));
        String userListJson = "";
        try {
            userListJson = (String)this.getInternalRouter().inInvoke("um.userbase.getUserInfoByQualityAndStore", umInfoMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getStore.e", (Object)("\u83b7\u53d6\u6240\u6709\u95e8\u5e97\u5f02\u5e38umInfoMapStr:" + umInfoMap), (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)userListJson)) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getStore.userListJson", (Object)("\u83b7\u53d6\u6240\u6709\u95e8\u5e97\u5f02\u5e38umInfoMapStr:" + umInfoMap));
            return null;
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userListJson, UmUserinfo.class);
        if (null == umUserinfo) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getStore.userListJson1", (Object)userListJson);
        }
        return umUserinfo;
    }

    private List<UmUserinfo> queryStore(Map<String, Object> umInfoMap) {
        if (MapUtil.isEmpty(umInfoMap)) {
            return null;
        }
        HashMap<String, String> umInfoMapStr = new HashMap<String, String>();
        umInfoMapStr.put("map", JsonUtil.buildNormalBinder().toJson(umInfoMap));
        String userListJson = "";
        try {
            userListJson = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", umInfoMapStr);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.queryStore.e", (Object)("\u83b7\u53d6\u6240\u6709\u95e8\u5e97\u5f02\u5e38umInfoMapStr:" + umInfoMapStr), (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)userListJson)) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.queryStore.userListJson", (Object)("\u83b7\u53d6\u6240\u6709\u95e8\u5e97\u5f02\u5e38umInfoMapStr:" + umInfoMapStr));
            return null;
        }
        SupQueryResult supQueryUserResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(userListJson, SupQueryResult.class);
        List pList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryUserResult.getList()), UmUserinfo.class);
        if (ListUtil.isEmpty((Collection)pList)) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getUserInfoByQualityAndStore", (Object)("\u67e5\u8be2\u4e0d\u5230\u95e8\u5e97umInfoMapStr:" + umInfoMapStr));
            return null;
        }
        return pList;
    }

    @Override
    public String insertOneViewElabal(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.insertOneViewElabal.map", "map is null");
        }
        String skuNo = (String)map.get("skuNo");
        String goodsCode = (String)map.get("goodsCode");
        String memberCode = (String)map.get("memberCode");
        String channelCode = (String)map.get("channelCode");
        String tenantCode = (String)map.get("tenantCode");
        HashMap<String, String> queryDgmcnumListMap = new HashMap<String, String>();
        HashMap<String, String> queryDgmcnumListMapStr = new HashMap<String, String>();
        queryDgmcnumListMapStr.put("dgmcnumSkuNo", skuNo);
        queryDgmcnumListMapStr.put("memberCode", memberCode);
        queryDgmcnumListMapStr.put("tenantCode", tenantCode);
        queryDgmcnumListMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryDgmcnumListMapStr));
        String queryDgnumListJson = null;
        try {
            queryDgnumListJson = (String)this.getInternalRouter().inInvoke("dis.dgmcnum.queryDgmcnumlistPage", queryDgmcnumListMap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.insertOneViewElabal.queryDgmcnumlistPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + queryDgmcnumListMapStr), (Throwable)e);
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.insertOneViewElabal.queryDgmcnumlistPage", "map:" + queryDgmcnumListMapStr);
        }
        SupQueryResult querynulListQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryDgnumListJson, SupQueryResult.class);
        List queryDgnumList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)querynulListQueryResultStr.getList()), DisDgmcnumlist.class);
        if (ListUtil.isNotEmpty((Collection)queryDgnumList)) {
            skuNo = ((DisDgmcnumlist)queryDgnumList.get(0)).getSkuNo();
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.insertOneViewElabal.MomtherGoodsNo", (Object)skuNo);
        }
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.insertOneViewElabal.map", "map:" + map);
        }
        String requestUrl = "";
        String key = "";
        if (StringUtils.isNotBlank((String)tenantCode)) {
            key = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.insertOneViewElabal.getRequestUrl", "\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + key + ",tenantCode:" + tenantCode);
        }
        UmUserinfo umUserinfo = this.queryShopIdByUserinfoCode(memberCode, tenantCode);
        if (umUserinfo == null) {
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.insertOneViewElabal.queryShopIdByUserinfoCode", "\u83b7\u53d6\u95e8\u5e97\u5931\u8d25,umUserinfo is null!" + memberCode + "-" + tenantCode);
        }
        ViewElabalSend viewElabalSend = new ViewElabalSend();
        viewElabalSend.setShopid(umUserinfo.getUserinfoOcode());
        viewElabalSend.setGoodsid(Integer.valueOf(skuNo));
        String requestJson = JsonUtil.buildNonNullBinder().toJson((Object)viewElabalSend);
        String jsonResult = null;
        try {
            jsonResult = HttpRequestUtiles.httpPost("/qj/queryViewElabalSendById", requestJson, requestUrl);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.queryViewElabalSendById.e", "\u8bf7\u6c42\u5f02\u5e38\uff01\uff01\uff01");
        }
        Map mapResult = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jsonResult, String.class, Object.class);
        if (!"S".equals(mapResult.get("resCode"))) {
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.queryViewElabalSendById.resCode", "respose is false,jsonResult:" + jsonResult);
        }
        Object dataStr = mapResult.get("dataStr");
        if (dataStr == null) {
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.queryViewElabalSendById.dataStr", "dataStr is null\uff01\uff01\uff01jsonResult:" + jsonResult);
        }
        viewElabalSend = (ViewElabalSend)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataStr.toString(), ViewElabalSend.class);
        if (viewElabalSend == null) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.httpPost.queryViewElabalSendById.dataStr.e", (Object)("\u83b7\u53d6\u4ef7\u683c\u4e3a\u7a7a\uff01\uff01\uff01jsonResult\uff1a" + jsonResult));
            return "success";
        }
        this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.insertOneViewElabal.price", (Object)("\u5546\u54c1:" + viewElabalSend.getGoodsid() + "-" + viewElabalSend.getNewprice() + "(" + viewElabalSend.getOldprice() + ")" + ",\u95e8\u5e97:" + viewElabalSend.getShopid()));
        try {
            this.updateGoodsPrice(viewElabalSend, memberCode, channelCode, tenantCode);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.insertOneViewElabal.updateGoodsPrice", "\u66f4\u65b0\u4ef7\u683c\u5931\u8d25\uff01\uff01\uff01" + viewElabalSend.getShopid() + "-" + viewElabalSend.getGoodsid() + "-" + viewElabalSend.getOldprice() + "(" + viewElabalSend.getNewprice() + ")");
        }
        return "success";
    }

    private void updateGoodsPrice(ViewElabalSend viewElabalSend, String memberCode, String channelCode, String tenantCode) {
        HashMap<String, Object> querySkuMap = new HashMap<String, Object>();
        querySkuMap.put("skuNo", viewElabalSend.getGoodsid());
        querySkuMap.put("memberCode", memberCode);
        querySkuMap.put("channelCode", channelCode);
        querySkuMap.put("tenantCode", tenantCode);
        String rsSkuJson = "";
        try {
            rsSkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.getSkuBySkuNo", querySkuMap);
            if (StringUtils.isBlank((String)rsSkuJson)) {
                this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.updateGoodsPrice.getSkuBySkuNo", (Object)("\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570:" + querySkuMap));
                return;
            }
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.updateGoodsPrice.getSkuBySkuNo.e", "\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570:" + querySkuMap, (Throwable)e);
        }
        RsSku rsSku = (RsSku)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuJson, RsSku.class);
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        editSkuDomain.setSkuId(rsSku.getSkuId());
        editSkuDomain.setSkuCode(rsSku.getSkuCode());
        editSkuDomain.setGoodsCode(rsSku.getGoodsCode());
        editSkuDomain.setTenantCode(tenantCode);
        if (viewElabalSend.getNewprice() == null) {
            if (viewElabalSend.getOldprice() == null) {
                throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.updateGoodsPrice.Oldprice.null", viewElabalSend.getOldprice() + "-" + viewElabalSend.getNewprice());
            }
            editSkuDomain.setPricesetNprice(viewElabalSend.getOldprice().setScale(2, 4));
        } else {
            editSkuDomain.setPricesetNprice(viewElabalSend.getNewprice().setScale(2, 4));
        }
        HashMap<String, String> updateMap = new HashMap<String, String>();
        String json = JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain);
        updateMap.put("editSkuDomain", json);
        try {
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSkuEditErp", updateMap);
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.updateGoodsPrice.end", (Object)("json:" + json));
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.fuji.ViewElabalSendServiceImpl.updateGoodsPrice.sendUpdateSkuEdit.e", "\u66f4\u65b0\u5f02\u5e38!!!\u5165\u53c2updateMap:" + updateMap, (Throwable)e);
        }
    }

    private UmUserinfo queryShopIdByUserinfoCode(String userinfoCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        String umUserInfoJson = null;
        try {
            umUserInfoJson = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoModelByUserCode", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.queryShopIdByUserinfoCode.getUserinfoModelByUserCode.e", map, (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)umUserInfoJson)) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.queryShopIdByUserinfoCode.umUserInfoJson", (Object)"umUserInfoJson is null");
            return null;
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(umUserInfoJson, UmUserinfo.class);
        return umUserinfo;
    }

    private DisDpriceDomain createParam(DisDgoods disDgoods, ViewElabalSend viewElabalSend, RsResourceGoods rsResourceGoods, DisChannel disChannel) {
        DisDpriceDomain disDpriceDomain = new DisDpriceDomain();
        disDpriceDomain.setChannelCode(disDgoods.getChannelCode());
        disDpriceDomain.setDgoodsCode(disDgoods.getDgoodsCode());
        disDpriceDomain.setDpricePro("2");
        disDpriceDomain.setMemberMname(disChannel.getMemberMname());
        disDpriceDomain.setMemberMcode(disChannel.getMemberCcode());
        disDpriceDomain.setTenantCode(disDgoods.getTenantCode());
        disDpriceDomain.setMemberCode(disChannel.getMemberCode());
        disDpriceDomain.setMemberName(disChannel.getMemberName());
        DisDpriceConf disDpriceConf = new DisDpriceConf();
        disDpriceConf.setDpriceConfType("goodsNo");
        disDpriceConf.setDpriceConfValue(rsResourceGoods.getGoodsNo());
        disDpriceConf.setDpriceConfValuen(rsResourceGoods.getGoodsName());
        if (viewElabalSend.getNewprice() == null) {
            disDpriceConf.setDpriceConfPrice(viewElabalSend.getOldprice());
        } else {
            disDpriceConf.setDpriceConfPrice(viewElabalSend.getOldprice());
        }
        disDpriceConf.setDpriceConfPro("2");
        disDpriceConf.setTenantCode(disDgoods.getTenantCode());
        disDpriceConf.setDpriceConfValueno(rsResourceGoods.getGoodsId().toString());
        ArrayList<DisDpriceConf> disDpriceConfList = new ArrayList<DisDpriceConf>();
        disDpriceConfList.add(disDpriceConf);
        disDpriceDomain.setDisDpriceConfList(disDpriceConfList);
        return disDpriceDomain;
    }

    private DisChannel getChannelCodeByshopId(String shopId, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("userinfoOcode", shopId);
        mapStr.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String userListJson = "";
        try {
            userListJson = (String)this.getInternalRouter().inInvoke("um.userbase.getUserInfoByQualityAndStore", map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getStore.e", (Object)("\u83b7\u53d6\u6240\u6709\u95e8\u5e97\u5f02\u5e38mapStr:" + mapStr), (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)userListJson)) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getStore.userListJson", (Object)("\u83b7\u53d6\u6240\u6709\u95e8\u5e97\u5f02\u5e38mapStr:" + mapStr));
            return null;
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userListJson, UmUserinfo.class);
        if (null == umUserinfo) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertViewElabalSendByPage.getStore.userListJson1", (Object)userListJson);
            return null;
        }
        map.clear();
        mapStr.clear();
        mapStr.put("memberCcode", umUserinfo.getUserinfoCode());
        mapStr.put("tenantCode", tenantCode);
        mapStr.put("channelType", "1");
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        String disChannelJson = null;
        try {
            disChannelJson = (String)this.getInternalRouter().inInvoke("dis.channel.queryChannelPage", map);
            if (StringUtils.isBlank((String)disChannelJson)) {
                this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertGoodsshopByPage.queryChannelPage", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertGoodsshopByPage.queryChannelPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map));
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(disChannelJson, SupQueryResult.class);
        List disChannelList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisChannel.class);
        if (ListUtil.isEmpty((Collection)disChannelList)) {
            this.logger.error("service.adapter.fuji.ViewElabalSendServiceImpl.inertGoodsshopByPage.queryDictionaryPage", (Object)("\u95e8\u5e97\u672a\u7ed1\u5b9a\u6e20\u9053,\u8bf7\u524d\u5f80\u7ed1\u5b9a\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        return (DisChannel)disChannelList.get(0);
    }

    public String errorShopPrice(String msg, String shopId, String price, String goodid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("msg", msg);
        map.put("shopid", shopId);
        map.put("price", price);
        map.put("goodid", goodid);
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }

    public static void main(String[] args) {
        String[] shopIdArray;
        String onLineShop = "SH015-SH016";
        for (String shopId : shopIdArray = onLineShop.split("-")) {
            HashMap<String, Object> umInfoMapStr = new HashMap<String, Object>();
            umInfoMapStr.put("userinfoOcode", shopId);
            umInfoMapStr.put("userinfoQuality", "store");
            umInfoMapStr.put("fuzzy", true);
            umInfoMapStr.put("tenantCode", "1212");
            String s = JsonUtil.buildNonDefaultBinder().toJson(umInfoMapStr);
            System.out.println(s);
        }
    }
}

