/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.jd.service.impl;

import com.yqbsoft.laser.service.adapter.jd.JdConstants;
import com.yqbsoft.laser.service.adapter.jd.domain.BsAreaDomain;
import com.yqbsoft.laser.service.adapter.jd.domain.BsProvinceDomain;
import com.yqbsoft.laser.service.adapter.jd.domain.BsRoadDomain;
import com.yqbsoft.laser.service.adapter.jd.service.JdDistrictService;
import com.yqbsoft.laser.service.adapter.jd.utils.WebUtils;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JdDistrictServiceImpl
extends BaseServiceImpl
implements JdDistrictService {
    public static final String SYS_CODE = "jd.JdDistrictServiceImpl";
    static final String PROVINCE_ADD_API_CODE = "bs.province.saveProvince";
    static final String AREA_ADD_API_CODE = "bs.area.saveAreaList";
    static final String ROAD_ADD_API_CODE = "bs.road.saveRoadBatch";

    @Override
    public String proAreaRoad() {
        String url = "https://bizapi.jd.com/api/area/getProvince";
        Map<String, Object> mm = this.getJdDistrict(url, null);
        if (null == mm) {
            return null;
        }
        ArrayList<String> strList = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : mm.entrySet()) {
            BsProvinceDomain bsProvinceDomain = new BsProvinceDomain();
            bsProvinceDomain.setProvincName(entry.getKey());
            bsProvinceDomain.setProvinceCode(String.valueOf(entry.getValue()));
            bsProvinceDomain.setTenantCode(JdConstants.getTenantCode());
            bsProvinceDomain.setDataState("1");
            HashMap<String, String> proMap = new HashMap<String, String>();
            proMap.put("bsProvinceDomain", JsonUtil.buildNormalBinder().toJson((Object)bsProvinceDomain));
            this.getInternalRouter().inInvoke(PROVINCE_ADD_API_CODE, proMap);
            strList.add(String.valueOf(entry.getValue()));
        }
        this.saveCity(strList);
        return null;
    }

    public void saveCity(List<String> ids) {
        if (ListUtil.isEmpty(ids)) {
            this.logger.error("jd.JdDistrictServiceImpl.saveCity");
            return;
        }
        ArrayList<String> strList = new ArrayList<String>();
        Iterator<String> i$ = ids.iterator();
        while (i$.hasNext()) {
            String url = "https://bizapi.jd.com/api/area/getCity";
            String id = i$.next();
            Map<String, Object> mm = this.getJdDistrict(url, id);
            if (null == mm) continue;
            ArrayList<BsAreaDomain> bsAreaDomainList = new ArrayList<BsAreaDomain>();
            for (Map.Entry<String, Object> entry : mm.entrySet()) {
                BsAreaDomain bsAreaDomain = new BsAreaDomain();
                bsAreaDomain.setAreaCode(String.valueOf(entry.getValue()));
                bsAreaDomain.setAreaName(entry.getKey());
                bsAreaDomain.setProvinceCode(id);
                bsAreaDomain.setTenantCode(JdConstants.getTenantCode());
                bsAreaDomain.setDataState("1");
                bsAreaDomainList.add(bsAreaDomain);
                strList.add(String.valueOf(entry.getValue()));
            }
            HashMap<String, String> proMap = new HashMap<String, String>();
            proMap.put("bsAreaDomains", JsonUtil.buildNormalBinder().toJson(bsAreaDomainList));
            this.getInternalRouter().inInvoke(AREA_ADD_API_CODE, proMap);
        }
        if (ListUtil.isNotEmpty(strList)) {
            this.saveArea(strList);
        }
    }

    public void saveArea(List<String> ids) {
        if (ListUtil.isEmpty(ids)) {
            this.logger.error("jd.JdDistrictServiceImpl.saveArea");
            return;
        }
        ArrayList<String> strList = new ArrayList<String>();
        Iterator<String> i$ = ids.iterator();
        while (i$.hasNext()) {
            String url = "https://bizapi.jd.com/api/area/getCounty";
            String id = i$.next();
            Map<String, Object> mm = this.getJdDistrict(url, id);
            if (null == mm) continue;
            ArrayList<BsAreaDomain> bsAreaDomainList = new ArrayList<BsAreaDomain>();
            for (Map.Entry<String, Object> entry : mm.entrySet()) {
                BsAreaDomain bsAreaDomain = new BsAreaDomain();
                bsAreaDomain.setAreaCode(String.valueOf(entry.getValue()));
                bsAreaDomain.setAreaName(entry.getKey());
                bsAreaDomain.setAreaParentCode(id);
                bsAreaDomain.setTenantCode(JdConstants.getTenantCode());
                bsAreaDomain.setDataState("1");
                bsAreaDomainList.add(bsAreaDomain);
                strList.add(String.valueOf(entry.getValue()));
            }
            HashMap<String, String> proMap = new HashMap<String, String>();
            proMap.put("bsAreaDomains", JsonUtil.buildNormalBinder().toJson(bsAreaDomainList));
            this.getInternalRouter().inInvoke(AREA_ADD_API_CODE, proMap);
        }
        if (ListUtil.isNotEmpty(strList)) {
            this.saveRoad(strList);
        }
    }

    public void saveRoad(List<String> ids) {
        if (ListUtil.isEmpty(ids)) {
            this.logger.error("jd.JdDistrictServiceImpl.saveRoad");
            return;
        }
        Iterator<String> i$ = ids.iterator();
        while (i$.hasNext()) {
            String url = "https://bizapi.jd.com/api/area/getTown";
            String id = i$.next();
            Map<String, Object> mm = this.getJdDistrict(url, id);
            if (null == mm) continue;
            ArrayList<BsRoadDomain> bsRoadDomains = new ArrayList<BsRoadDomain>();
            for (Map.Entry<String, Object> entry : mm.entrySet()) {
                BsRoadDomain bsRoadDomain = new BsRoadDomain();
                bsRoadDomain.setAreaCode(id);
                bsRoadDomain.setRoadCode(String.valueOf(entry.getValue()));
                bsRoadDomain.setRoadName(entry.getKey());
                bsRoadDomain.setTenantCode(JdConstants.getTenantCode());
                bsRoadDomain.setDataState("1");
                bsRoadDomains.add(bsRoadDomain);
            }
            HashMap<String, String> proMap = new HashMap<String, String>();
            proMap.put("bsRoadDomainList", JsonUtil.buildNormalBinder().toJson(bsRoadDomains));
            this.getInternalRouter().inInvoke(ROAD_ADD_API_CODE, proMap);
        }
    }

    public Map<String, Object> getJdDistrict(String url, String id) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("token", JdConstants.getToken());
        if (StringUtils.isNotBlank((String)id)) {
            paramMap.put("id", id);
        }
        String json = null;
        try {
            json = WebUtils.doPost(url, paramMap, 10000, 10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        String s = JsonUtil.buildNormalBinder().toJson(map.get("result"));
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(s, String.class, Object.class);
    }
}

