/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.jd.service.impl;

import com.google.common.base.Joiner;
import com.yqbsoft.laser.service.adapter.jd.JdConstants;
import com.yqbsoft.laser.service.adapter.jd.domain.JdCategorys;
import com.yqbsoft.laser.service.adapter.jd.domain.JdGoodsCheckDomain;
import com.yqbsoft.laser.service.adapter.jd.domain.JdGoodsDomain;
import com.yqbsoft.laser.service.adapter.jd.domain.JdGoodsPoolDomain;
import com.yqbsoft.laser.service.adapter.jd.domain.RsBrandDomain;
import com.yqbsoft.laser.service.adapter.jd.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.adapter.jd.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.adapter.jd.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.adapter.jd.domain.RsSkuDomain;
import com.yqbsoft.laser.service.adapter.jd.model.DdFalgSetting;
import com.yqbsoft.laser.service.adapter.jd.model.RsBrand;
import com.yqbsoft.laser.service.adapter.jd.model.RsClasstree;
import com.yqbsoft.laser.service.adapter.jd.model.RsPntree;
import com.yqbsoft.laser.service.adapter.jd.model.RsResourceGoods;
import com.yqbsoft.laser.service.adapter.jd.model.RsSku;
import com.yqbsoft.laser.service.adapter.jd.model.UmUserinfo;
import com.yqbsoft.laser.service.adapter.jd.service.JdResourceGoodsService;
import com.yqbsoft.laser.service.adapter.jd.utils.WebUtils;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JdResourceGoodsServiceImpl
extends BaseServiceImpl
implements JdResourceGoodsService {
    public static final String SYS_CODE = "jd.JdResourceGoodsServiceImpl";
    private static final String CLASSTREE_QUERY_API_CODE = "rs.rsClasstree.getClasstreeByCode";
    private static final String DDSETTING_QUERY_API_CODE = "dd.falgSetting.queryFalgSettingPage";
    private static final String BRAND_QUERY_API_CODE = "rs.brand.queryBrandPage";
    private static final String USER_QUERY_API_CODE = "um.user.getUserinfoModelByUserCode";
    private static final String BRAND_ADD_API_CODE = "rs.brand.saveBrand";
    private static final String BRAND_GET_API_CODE = "rs.brand.getBrandByName";
    private static final String RESOURCEGOODS_ADD_CODE = "rs.resourceGoods.saveResourceGoods";
    private static final String CLASSTREE_ADD_API_CODE = "rs.rsClasstree.saveClasstreeList";
    private static final String PNTREE_QUERY_API_CODE = "rs.pntree.queryPntreePage";
    private static final String RESOURCEGOODS_CHECK_API_CODE = "rs.resourceGoods.checkGoodsNo";
    private static final String SKU_CHECK_API_CODE = "rs.sku.checkSkuNo";
    private static final String SKU_UPDATE_API_CODE = "rs.sku.updateSku";
    private static final String SKU_QUERY_API_CODE = "rs.sku.querySkuPage";
    String poolUrl = "https://bizapi.jd.com/api/product/getPageNum";
    String poolSkuUrl = "https://bizapi.jd.com/api/product/getSkuByPage";
    String checkUrl = "https://bizapi.jd.com/api/product/check";
    String skuDetailUrl = "https://bizapi.jd.com/api/product/getDetail";
    String goodsFileUrl = "https://bizapi.jd.com/api/product/skuImage";
    String priceUrl = "https://bizapi.jd.com/api/price/getSellPrice";
    private static final String PNTREE_NAME = "\u4eac\u4e1c\u9ed8\u8ba4";
    private String pntreeCode = "";
    private String tokenCode = "";
    private String tenantCode = "";
    private static final String IMG_ADDRESS_N1 = "http://img13.360buyimg.com/n1/";

    public void getToken() {
        this.tokenCode = JdConstants.getToken();
        this.tenantCode = JdConstants.getTenantCode();
    }

    @Override
    public void importJdGoods() throws Exception {
        this.getToken();
        HashMap<String, String> poolMap = new HashMap<String, String>();
        poolMap.put("token", this.tokenCode);
        String poolStr = this.getJdRemote(this.poolUrl, poolMap);
        List poolList = (List)JsonUtil.buildNormalBinder().getJsonToList(poolStr, JdGoodsPoolDomain.class);
        if (ListUtil.isEmpty((Collection)poolList)) {
            return;
        }
        HashMap<String, String> poolSkuMap = new HashMap<String, String>();
        poolSkuMap.put("token", this.tokenCode);
        poolSkuMap.put("pageNo", "1");
        for (JdGoodsPoolDomain rsGoodsPoolDomain : poolList) {
            Map poolSkuR;
            poolSkuMap.put("pageNum", rsGoodsPoolDomain.getPage_num());
            String poolSkuStr = this.getJdRemote(this.poolSkuUrl, poolSkuMap);
            if (null == poolSkuStr || null == (poolSkuR = (Map)JsonUtil.buildNormalBinder().getJsonToMap(poolSkuStr, String.class, Object.class))) continue;
            Integer pageCount = (Integer)poolSkuR.get("pageCount");
            this.getSkuDetail(poolSkuR);
            if (pageCount <= 1) continue;
            for (int i = 2; i <= pageCount; ++i) {
                poolSkuMap.put("pageNo", String.valueOf(i));
                poolSkuStr = this.getJdRemote(this.poolSkuUrl, poolSkuMap);
                if (null == poolSkuStr || null == (poolSkuR = (Map)JsonUtil.buildNormalBinder().getJsonToMap(poolSkuStr, String.class, Object.class))) continue;
                this.getSkuDetail(poolSkuR);
            }
            poolSkuMap.put("pageNo", "1");
        }
    }

    @Override
    public void jdGoodsNprice() throws Exception {
        this.getToken();
        int total = 0;
        int rows = 500;
        int page = 1;
        HashMap<String, Object> mapR = new HashMap<String, Object>();
        mapR.put("page", String.valueOf(page));
        mapR.put("rows", String.valueOf(rows));
        mapR.put("tenantCode", "00000001");
        mapR.put("endRow", Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
        mapR.put("order", true);
        mapR.put("fuzzy", false);
        int startRow = Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue();
        mapR.put("startRow", startRow);
        total = this.getPrice(mapR, total, rows);
        if (total > 1) {
            int i = 2;
            while (i <= total) {
                page = i++;
                mapR.put("page", String.valueOf(page));
                startRow = Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue();
                mapR.put("startRow", startRow);
                total = this.getPrice(mapR, total, rows);
            }
        }
    }

    public void getSkuDetail(Map<String, Object> poolSkuR) {
        Map<String, Object> brandMap = this.getBrandAll();
        List skuIdList = (List)poolSkuR.get("skuIds");
        if (ListUtil.isEmpty((Collection)skuIdList)) {
            return;
        }
        if (ListUtil.isNotEmpty((Collection)skuIdList)) {
            List<String> skuIdsList = this.groupListToStr(skuIdList);
            if (ListUtil.isEmpty(skuIdsList)) {
                return;
            }
            ArrayList skuCheckDomainsR = new ArrayList();
            HashMap<String, String> checkMap = new HashMap<String, String>();
            checkMap.put("token", this.tokenCode);
            for (String str : skuIdsList) {
                checkMap.put("skuIds", str);
                String checkStr = this.getJdRemote(this.checkUrl, checkMap);
                if (null == checkStr) continue;
                List skuCheckDomains = (List)JsonUtil.buildNormalBinder().getJsonToList(checkStr, JdGoodsCheckDomain.class);
                skuCheckDomainsR.addAll(skuCheckDomains);
            }
            HashMap<String, String> inClasstreeCode = new HashMap<String, String>();
            HashMap<String, String> skuDetailMap = new HashMap<String, String>();
            skuDetailMap.put("token", this.tokenCode);
            for (JdGoodsCheckDomain rsSkuCheckDomain : skuCheckDomainsR) {
                String brandName;
                JdGoodsDomain rsGoodsDomain;
                if (!rsSkuCheckDomain.getSaleState().equals("1")) continue;
                String skuId = rsSkuCheckDomain.getSkuId();
                skuDetailMap.put("sku", skuId);
                String skuDetail = this.getJdRemote(this.skuDetailUrl, skuDetailMap);
                if (null == skuDetail || null == (rsGoodsDomain = (JdGoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(skuDetail, JdGoodsDomain.class))) continue;
                String string = brandName = rsGoodsDomain.getBrand() == null ? rsGoodsDomain.getBrandName() : rsGoodsDomain.getBrand();
                if (null != rsGoodsDomain.getSkuType() && rsGoodsDomain.getSkuType().equals("vedio") || this.checkGoodsNo(rsGoodsDomain.getSku())) continue;
                RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
                rsResourceGoodsDomain.setGoodsOrigin("15");
                if (null != rsGoodsDomain.getSkuType()) {
                    rsResourceGoodsDomain.setGoodsOrigin("16");
                }
                String brandCode = null;
                if (null != brandMap) {
                    brandCode = (String)brandMap.get(brandName);
                }
                if (null == brandCode && null != brandName) {
                    brandCode = this.saveBrand(brandName);
                    brandMap.put(brandName, brandCode);
                }
                int last = rsGoodsDomain.getCategory().lastIndexOf(";");
                String lastClasstree = rsGoodsDomain.getCategory().substring(last + 1);
                rsResourceGoodsDomain.setClasstreeCode(lastClasstree);
                rsResourceGoodsDomain.setPntreeCode(this.pntreeCode);
                if (StringUtils.isBlank((String)this.pntreeCode)) {
                    rsResourceGoodsDomain.setPntreeCode(this.getPntreeCode());
                }
                rsResourceGoodsDomain.setPntreeName(PNTREE_NAME);
                if (!inClasstreeCode.containsKey(lastClasstree)) {
                    RsClasstree rsClasstree = this.checkClasstree(lastClasstree);
                    inClasstreeCode.put(lastClasstree, rsClasstree.getClasstreeName());
                    if (null != rsClasstree) {
                        rsResourceGoodsDomain.setClasstreeName(rsClasstree.getClasstreeName());
                        rsResourceGoodsDomain.setPntreeCode(rsClasstree.getPntreeCode());
                    } else {
                        Map<String, Object> rMap = this.saveClasstree(rsGoodsDomain.getCategory());
                        rsResourceGoodsDomain.setClasstreeName((String)rMap.get(lastClasstree));
                    }
                } else {
                    rsResourceGoodsDomain.setClasstreeName((String)inClasstreeCode.get(lastClasstree));
                }
                rsResourceGoodsDomain.setBrandCode(brandCode);
                rsResourceGoodsDomain.setBrandName(brandName);
                rsResourceGoodsDomain.setMemberCode(this.getJdMemeberCode());
                rsResourceGoodsDomain.setMemberName(this.getJdMemberName());
                rsResourceGoodsDomain.setTenantCode(this.tenantCode);
                rsResourceGoodsDomain.setGoodsName(rsGoodsDomain.getName());
                rsResourceGoodsDomain.setDataPic(rsGoodsDomain.getImagePath());
                rsResourceGoodsDomain.setDataState(2);
                rsResourceGoodsDomain.setDataOpbillstate(1);
                rsResourceGoodsDomain.setGoodsNum(BigDecimal.ZERO);
                rsResourceGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                rsResourceGoodsDomain.setGoodsNo(rsGoodsDomain.getSku());
                rsResourceGoodsDomain.setGoodsType("00");
                rsResourceGoodsDomain.setRsGoodsFileDomainList(this.getGoodsFile(rsGoodsDomain.getSku()));
                ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
                RsSkuDomain rsSkuDomain = new RsSkuDomain();
                rsSkuDomain.setSkuName(rsResourceGoodsDomain.getGoodsName());
                rsSkuDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
                rsSkuDomain.setGoodsNum(rsResourceGoodsDomain.getGoodsNum());
                rsSkuDomain.setGoodsNo(rsGoodsDomain.getSku());
                rsSkuDomain.setSkuBarcode(rsGoodsDomain.getISBN() == null ? rsGoodsDomain.getUpc() : rsGoodsDomain.getISBN());
                rsSkuDomain.setPricesetNprice(rsResourceGoodsDomain.getPricesetNprice());
                rsSkuDomain.setSkuNo(rsGoodsDomain.getSku());
                rsSkuDomain.setRsGoodsFileDomainList(this.getGoodsFile(rsGoodsDomain.getSku()));
                rsSkuDomainList.add(rsSkuDomain);
                rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainList);
                HashMap<String, String> goodsparamMap = new HashMap<String, String>();
                goodsparamMap.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain));
                String resultGoods = null;
                try {
                    resultGoods = (String)this.getInternalRouter().inInvoke(RESOURCEGOODS_ADD_CODE, goodsparamMap);
                }
                catch (Exception e) {
                    this.logger.error("importJdGoods", (Object)resultGoods);
                }
            }
        }
    }

    public List<RsGoodsFileDomain> getGoodsFile(String skuId) {
        HashMap<String, String> poolMap = new HashMap<String, String>();
        poolMap.put("token", this.tokenCode);
        poolMap.put("sku", skuId);
        String goodsFileStr = this.getJdRemote(this.goodsFileUrl, poolMap);
        Map fileMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(goodsFileStr, String.class, Object.class);
        if (null == fileMap) {
            return null;
        }
        List listMap = (List)fileMap.get(skuId);
        ArrayList<RsGoodsFileDomain> goodsFilesortDomains = new ArrayList<RsGoodsFileDomain>();
        for (Map map : listMap) {
            RsGoodsFileDomain rsGoodsFilesortDomain = new RsGoodsFileDomain();
            rsGoodsFilesortDomain.setGoodsFileUrl(IMG_ADDRESS_N1 + map.get("path").toString());
            rsGoodsFilesortDomain.setTenantCode(this.tenantCode);
            goodsFilesortDomains.add(rsGoodsFilesortDomain);
        }
        return goodsFilesortDomains;
    }

    public int getPrice(Map<String, Object> mapR, int total, int rows) {
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.buildNormalBinder().toJson(mapR));
        String skuStr = (String)this.getInternalRouter().inInvoke(SKU_QUERY_API_CODE, mapP);
        List rsSkuDomains = null;
        try {
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuStr, SupQueryResult.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                return 0;
            }
            total = (int)supQueryResult.getTotal();
            rsSkuDomains = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsSkuDomain.class);
        }
        catch (Exception e) {
            this.logger.error("jd.JdResourceGoodsServiceImplimportJdGoodsFile", (Throwable)e);
        }
        if (ListUtil.isEmpty(rsSkuDomains)) {
            return 0;
        }
        if (total == 0) {
            total = (total + rows - 1) / rows;
        }
        for (RsSkuDomain rsSkuDomain : rsSkuDomains) {
            HashMap<String, String> priceMap = new HashMap<String, String>();
            priceMap.put("token", this.tokenCode);
            priceMap.put("sku", rsSkuDomain.getSkuNo());
            String priceStr = this.getJdRemote(this.priceUrl, priceMap);
            List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(priceStr, Map.class);
            if (ListUtil.isEmpty((Collection)mapList)) continue;
            Map map = (Map)mapList.get(0);
            Double price = (Double)map.get("price");
            Double jdPrice = (Double)map.get("jdPrice");
            rsSkuDomain.setPricesetNprice(BigDecimal.valueOf(jdPrice));
            rsSkuDomain.setPricesetAsprice(BigDecimal.valueOf(price));
            mapP.put("rsSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSkuDomain));
            this.getInternalRouter().inInvoke(SKU_UPDATE_API_CODE, mapP);
        }
        return total;
    }

    public String getPntreeCode() {
        HashMap<String, String> mapR = new HashMap<String, String>();
        mapR.put("pntreeName", PNTREE_NAME);
        mapR.put("tenantCode", this.tenantCode);
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.buildNormalBinder().toJson(mapR));
        String pntreeStr = (String)this.getInternalRouter().inInvoke(PNTREE_QUERY_API_CODE, mapP);
        List pntreeList = null;
        try {
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(pntreeStr, SupQueryResult.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                return null;
            }
            pntreeList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsPntree.class);
        }
        catch (Exception e) {
            this.logger.error("jd.JdResourceGoodsServiceImplgetPntreeCode", (Throwable)e);
        }
        if (ListUtil.isEmpty(pntreeList)) {
            return null;
        }
        this.pntreeCode = ((RsPntree)pntreeList.get(0)).getPntreeCode();
        return ((RsPntree)pntreeList.get(0)).getPntreeCode();
    }

    public Map<String, Object> saveClasstree(String cid) {
        String[] cidSp = cid.split(";");
        ArrayList<JdCategorys> categorysList = new ArrayList<JdCategorys>();
        HashMap<String, String> poolMap = new HashMap<String, String>();
        poolMap.put("token", this.tokenCode);
        for (int i = 0; i <= cidSp.length; ++i) {
            poolMap.put("cid", cidSp[i]);
            String classtreeStr = this.getJdRemote("https://bizapi.jd.com/api/product/getCategory", poolMap);
            if (null == classtreeStr) continue;
            HashMap mapR = new HashMap();
            JdCategorys categorys = (JdCategorys)JsonUtil.buildNormalBinder().getJsonToObject(classtreeStr, JdCategorys.class);
            if (null == categorys) break;
            categorysList.add(categorys);
        }
        if (ListUtil.isEmpty(categorysList)) {
            return null;
        }
        return this.saveClasstreeList(categorysList);
    }

    public Map<String, Object> saveClasstreeList(List<JdCategorys> categorysList) {
        HashMap<String, Object> mapM = new HashMap<String, Object>();
        ArrayList<RsClasstreeDomain> rsClasstreeDomainList = new ArrayList<RsClasstreeDomain>();
        for (JdCategorys categorys : categorysList) {
            RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
            rsClasstreeDomain.setClasstreeCode(categorys.getCatId());
            rsClasstreeDomain.setClasstreeName(categorys.getName());
            rsClasstreeDomain.setClasstreeParentcode("-1");
            if (!categorys.getParentId().equals("0")) {
                rsClasstreeDomain.setClasstreeParentcode(categorys.getParentId());
            }
            rsClasstreeDomain.setClasstreeLast("1");
            if (categorys.getCatClass().equals("2")) {
                rsClasstreeDomain.setClasstreeLast("0");
                rsClasstreeDomain.setPntreeCode(this.pntreeCode);
                if (StringUtils.isBlank((String)this.pntreeCode)) {
                    rsClasstreeDomain.setPntreeCode(this.getPntreeCode());
                }
            }
            rsClasstreeDomain.setClasstreeType("5");
            rsClasstreeDomain.setTenantCode(this.tenantCode);
            rsClasstreeDomainList.add(rsClasstreeDomain);
            mapM.put(categorys.getCatId(), categorys.getName());
        }
        HashMap<String, String> mapR = new HashMap<String, String>();
        mapR.put("rsClasstreeDomains", JsonUtil.buildNormalBinder().toJson(rsClasstreeDomainList));
        this.getInternalRouter().inInvoke(CLASSTREE_ADD_API_CODE, mapR);
        return mapM;
    }

    public RsSku checkSkuNo(String no) {
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("skuNo", no);
        mapP.put("tenantCode", this.tenantCode);
        List skus = null;
        try {
            String skuStr = (String)this.getInternalRouter().inInvoke(SKU_CHECK_API_CODE, mapP);
            skus = (List)JsonUtil.buildNormalBinder().getJsonToList(skuStr, RsSku.class);
        }
        catch (Exception e) {
            this.logger.error("getJdMemberName", (Throwable)e);
        }
        if (null == skus || ListUtil.isEmpty(skus)) {
            return null;
        }
        return (RsSku)skus.get(0);
    }

    public boolean checkGoodsNo(String GoodsNo) {
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("goodsNo", GoodsNo);
        mapP.put("tenantCode", this.tenantCode);
        List resourceGoods = null;
        try {
            String resourceStr = (String)this.getInternalRouter().inInvoke(RESOURCEGOODS_CHECK_API_CODE, mapP);
            resourceGoods = (List)JsonUtil.buildNormalBinder().getJsonToList(resourceStr, RsResourceGoods.class);
        }
        catch (Exception e) {
            this.logger.error("getJdMemberName", (Throwable)e);
        }
        return null != resourceGoods && !ListUtil.isEmpty(resourceGoods);
    }

    public List<String> groupListToStr(List<Integer> list) {
        ArrayList<String> re = new ArrayList<String>();
        int listSize = list.size();
        int toIndex = 100;
        for (int i = 0; i < list.size(); i += 100) {
            if (i + 100 > listSize) {
                toIndex = listSize - i;
            }
            List<Integer> newList = list.subList(i, i + toIndex);
            String skuIds = Joiner.on((String)",").join(newList);
            re.add(skuIds);
        }
        return re;
    }

    public String getJdRemote(String url, Map<String, String> paramMap) {
        String json = null;
        try {
            json = WebUtils.doPost(url, paramMap, 10000, 10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (null == map) {
            return null;
        }
        return JsonUtil.buildNormalBinder().toJson(map.get("result"));
    }

    public String getJdMemeberCode() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flagSettingScope", "WFData");
        map.put("flagSettingType", "JdMemberCode");
        map.put("tenantCode", this.tenantCode);
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String ddSettings = (String)this.getInternalRouter().inInvoke(DDSETTING_QUERY_API_CODE, mapP);
        List ddFalgSettings = null;
        try {
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(ddSettings, SupQueryResult.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getRows())) {
                return null;
            }
            ddFalgSettings = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getRows()), DdFalgSetting.class);
        }
        catch (Exception e) {
            this.logger.error("jd.JdResourceGoodsServiceImplgetJdMemeberCode", (Throwable)e);
        }
        if (ListUtil.isEmpty(ddFalgSettings)) {
            return null;
        }
        return ((DdFalgSetting)ddFalgSettings.get(0)).getFlagSettingInfo();
    }

    public String getJdMemberName() {
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("userinfoCode", this.getJdMemeberCode());
        mapP.put("tenantCode", this.tenantCode);
        UmUserinfo umUserinfo = null;
        try {
            String userinfoStr = (String)this.getInternalRouter().inInvoke(USER_QUERY_API_CODE, mapP);
            umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userinfoStr, UmUserinfo.class);
        }
        catch (Exception e) {
            this.logger.error("getJdMemberName", (Throwable)e);
        }
        if (null == umUserinfo) {
            return null;
        }
        return umUserinfo.getUserinfoCompname();
    }

    public String saveBrand(String brandName) {
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("tenantCode", this.tenantCode);
        mapP.put("brandName", brandName);
        String brandStr = (String)this.getInternalRouter().inInvoke(BRAND_GET_API_CODE, mapP);
        RsBrand rsBrand = (RsBrand)JsonUtil.buildNormalBinder().getJsonToObject(brandStr, RsBrand.class);
        if (null != rsBrand && StringUtils.isNotBlank((String)rsBrand.getBrandCode())) {
            return rsBrand.getBrandCode();
        }
        RsBrandDomain rsBrandDomain = new RsBrandDomain();
        rsBrandDomain.setBrandName(brandName);
        rsBrandDomain.setTenantCode(this.tenantCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain));
        return (String)this.getInternalRouter().inInvoke(BRAND_ADD_API_CODE, map);
    }

    public Map<String, Object> getBrandAll() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.tenantCode);
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String brands = (String)this.getInternalRouter().inInvoke(BRAND_QUERY_API_CODE, mapP);
        List brandList = null;
        try {
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(brands, SupQueryResult.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getRows())) {
                return null;
            }
            brandList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getRows()), RsBrand.class);
        }
        catch (Exception e) {
            this.logger.error("jd.JdResourceGoodsServiceImplgetJdMemeberCode", (Throwable)e);
        }
        if (ListUtil.isEmpty(brandList)) {
            return null;
        }
        HashMap<String, Object> mapRes = new HashMap<String, Object>();
        for (RsBrand rsBrand : brandList) {
            mapRes.put(rsBrand.getBrandName(), rsBrand.getBrandCode());
        }
        return mapRes;
    }

    public RsClasstree checkClasstree(String classtreeCode) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("tenantCode", this.tenantCode);
        map1.put("classtreeCode", classtreeCode);
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.buildNormalBinder().toJson(map1));
        RsClasstree rsClasstree = null;
        String classtreeStr = (String)this.getInternalRouter().inInvoke(CLASSTREE_QUERY_API_CODE, mapP);
        rsClasstree = (RsClasstree)JsonUtil.buildNormalBinder().getJsonToObject(classtreeStr, RsClasstree.class);
        return rsClasstree;
    }
}

