/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mid.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mid.dao.MidAddressMapper;
import com.yqbsoft.laser.service.mid.domain.MidAddressDomain;
import com.yqbsoft.laser.service.mid.domain.MidAddressReDomain;
import com.yqbsoft.laser.service.mid.model.MidAddress;
import com.yqbsoft.laser.service.mid.service.MidAddressService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MidAddressServiceImpl
extends BaseServiceImpl
implements MidAddressService {
    private static final String SYS_CODE = "mid.MidAddressServiceImpl";
    private MidAddressMapper midAddressMapper;

    public void setMidAddressMapper(MidAddressMapper midAddressMapper) {
        this.midAddressMapper = midAddressMapper;
    }

    private Date getSysDate() {
        try {
            return this.midAddressMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mid.MidAddressServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkaddress(MidAddressDomain midAddressDomain) {
        if (null == midAddressDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midAddressDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setaddressDefault(MidAddress midAddress) {
        if (null == midAddress) {
            return;
        }
        if (null == midAddress.getDataState()) {
            midAddress.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midAddress.getGmtCreate()) {
            midAddress.setGmtCreate(date);
        }
        midAddress.setGmtModified(date);
        if (StringUtils.isBlank((String)midAddress.getAddressCode())) {
            midAddress.setAddressCode(this.getNo(null, "MidAddress", "midAddress", midAddress.getTenantCode()));
        }
    }

    private int getaddressMaxCode() {
        int code = 0;
        try {
            return this.midAddressMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidAddressServiceImpl.getaddressMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setaddressUpdataDefault(MidAddress midAddress) {
        if (null == midAddress) {
            return;
        }
        midAddress.setGmtModified(this.getSysDate());
    }

    private void saveaddressModel(MidAddress midAddress) throws ApiException {
        if (null == midAddress) {
            return;
        }
        try {
            this.midAddressMapper.insert(midAddress);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidAddressServiceImpl.saveaddressModel.ex", (Throwable)e);
        }
    }

    private void saveaddressBatchModel(List<MidAddress> midAddressList) throws ApiException {
        if (null == midAddressList || midAddressList.isEmpty()) {
            return;
        }
        try {
            this.midAddressMapper.insertBatch(midAddressList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidAddressServiceImpl.saveaddressBatchModel.ex", (Throwable)e);
        }
    }

    private MidAddress getaddressModelById(Integer addressId) {
        if (null == addressId) {
            return null;
        }
        try {
            return this.midAddressMapper.selectByPrimaryKey(addressId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidAddressServiceImpl.getaddressModelById", (Throwable)e);
            return null;
        }
    }

    private MidAddress getaddressModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midAddressMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidAddressServiceImpl.getaddressModelByCode", (Throwable)e);
            return null;
        }
    }

    private void deladdressModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midAddressMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidAddressServiceImpl.deladdressModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidAddressServiceImpl.deladdressModelByCode.num");
        }
    }

    private void deleteaddressModel(Integer addressId) throws ApiException {
        if (null == addressId) {
            return;
        }
        int i = 0;
        try {
            i = this.midAddressMapper.deleteByPrimaryKey(addressId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidAddressServiceImpl.deleteaddressModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidAddressServiceImpl.deleteaddressModel.num");
        }
    }

    private void updateaddressModel(MidAddress midAddress) throws ApiException {
        if (null == midAddress) {
            return;
        }
        int i = 0;
        try {
            i = this.midAddressMapper.updateByPrimaryKey(midAddress);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidAddressServiceImpl.updateaddressModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidAddressServiceImpl.updateaddressModel.num");
        }
    }

    private void updateStateaddressModel(Integer addressId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == addressId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addressId", addressId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midAddressMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidAddressServiceImpl.updateStateaddressModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidAddressServiceImpl.updateStateaddressModel.null");
        }
    }

    private void updateStateaddressModelByCode(String tenantCode, String addressCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)addressCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("addressCode", addressCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midAddressMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidAddressServiceImpl.updateStateaddressModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidAddressServiceImpl.updateStateaddressModelByCode.null");
        }
    }

    private MidAddress makeaddress(MidAddressDomain midAddressDomain, MidAddress midAddress) {
        if (null == midAddressDomain) {
            return null;
        }
        if (null == midAddress) {
            midAddress = new MidAddress();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midAddress, (Object)midAddressDomain);
            return midAddress;
        }
        catch (Exception e) {
            this.logger.error("mid.MidAddressServiceImpl.makeaddress", (Throwable)e);
            return null;
        }
    }

    private MidAddressReDomain makeMidAddressReDomain(MidAddress midAddress) {
        if (null == midAddress) {
            return null;
        }
        MidAddressReDomain midAddressReDomain = new MidAddressReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midAddressReDomain, (Object)midAddress);
            return midAddressReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidAddressServiceImpl.makeMidAddressReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidAddress> queryaddressModelPage(Map<String, Object> parammap) {
        try {
            return this.midAddressMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidAddressServiceImpl.queryaddressModel", (Throwable)e);
            return null;
        }
    }

    private int countaddress(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midAddressMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidAddressServiceImpl.countaddress", (Throwable)e);
        }
        return i;
    }

    private MidAddress createMidAddress(MidAddressDomain midAddressDomain) {
        String msg = this.checkaddress(midAddressDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidAddressServiceImpl.saveaddress.checkaddress", msg);
        }
        MidAddress midAddress = this.makeaddress(midAddressDomain, null);
        this.setaddressDefault(midAddress);
        return midAddress;
    }

    @Override
    public String saveaddress(MidAddressDomain midAddressDomain) throws ApiException {
        MidAddress midAddress = this.createMidAddress(midAddressDomain);
        this.saveaddressModel(midAddress);
        return midAddress.getAddressCode();
    }

    @Override
    public String saveaddressBatch(List<MidAddressDomain> midAddressDomainList) throws ApiException {
        if (null == midAddressDomainList || midAddressDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidAddress> midAddressList = new ArrayList<MidAddress>();
        String code = "";
        for (MidAddressDomain midAddressDomain : midAddressDomainList) {
            MidAddress midAddress = this.createMidAddress(midAddressDomain);
            code = midAddress.getAddressCode();
            midAddressList.add(midAddress);
        }
        this.saveaddressBatchModel(midAddressList);
        return code;
    }

    @Override
    public void updateaddressState(Integer addressId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == addressId) {
            return;
        }
        this.updateStateaddressModel(addressId, dataState, oldDataState, map);
    }

    @Override
    public void updateaddressStateByCode(String tenantCode, String addressCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)addressCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateaddressModelByCode(tenantCode, addressCode, dataState, oldDataState, map);
    }

    @Override
    public void updateaddress(MidAddressDomain midAddressDomain) throws ApiException {
        String msg = this.checkaddress(midAddressDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidAddressServiceImpl.updateaddress.checkaddress", msg);
        }
        MidAddress oldMidAddress = this.getaddressModelById(midAddressDomain.getAddressId());
        if (null == oldMidAddress) {
            throw new ApiException("mid.MidAddressServiceImpl.updateaddress.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidAddress midAddress = this.makeaddress(midAddressDomain, oldMidAddress);
        this.setaddressUpdataDefault(midAddress);
        this.updateaddressModel(midAddress);
    }

    @Override
    public MidAddress getaddress(Integer addressId) {
        if (null == addressId) {
            return null;
        }
        return this.getaddressModelById(addressId);
    }

    @Override
    public void deleteaddress(Integer addressId) throws ApiException {
        if (null == addressId) {
            return;
        }
        this.deleteaddressModel(addressId);
    }

    @Override
    public QueryResult<MidAddress> queryaddressPage(Map<String, Object> map) {
        List<MidAddress> midAddressList = this.queryaddressModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countaddress(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midAddressList);
        return queryResult;
    }

    @Override
    public MidAddress getaddressByCode(String tenantCode, String addressCode) throws ApiException {
        if (StringUtils.isBlank((String)addressCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("addressCode", addressCode);
        return this.getaddressModelByCode(map);
    }

    @Override
    public void deleteaddressByCode(String tenantCode, String addressCode) throws ApiException {
        if (StringUtils.isBlank((String)addressCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("addressCode", addressCode);
        this.deladdressModelByCode(map);
    }
}

