/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mid.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mid.dao.MidUserMapper;
import com.yqbsoft.laser.service.mid.domain.MidUserDomain;
import com.yqbsoft.laser.service.mid.domain.MidUserReDomain;
import com.yqbsoft.laser.service.mid.model.MidUser;
import com.yqbsoft.laser.service.mid.service.MidUserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MidUserServiceImpl
extends BaseServiceImpl
implements MidUserService {
    private static final String SYS_CODE = "mid.MidUserServiceImpl";
    private MidUserMapper midUserMapper;

    public void setMidUserMapper(MidUserMapper midUserMapper) {
        this.midUserMapper = midUserMapper;
    }

    private Date getSysDate() {
        try {
            return this.midUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mid.MidUserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkuser(MidUserDomain midUserDomain) {
        if (null == midUserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midUserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setuserDefault(MidUser midUser) {
        if (null == midUser) {
            return;
        }
        if (null == midUser.getDataState()) {
            midUser.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midUser.getGmtCreate()) {
            midUser.setGmtCreate(date);
        }
        midUser.setGmtModified(date);
        if (StringUtils.isBlank((String)midUser.getUserCode())) {
            midUser.setUserCode(this.getNo(null, "MidUser", "midUser", midUser.getTenantCode()));
        }
    }

    private int getuserMaxCode() {
        int code = 0;
        try {
            return this.midUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidUserServiceImpl.getuserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setuserUpdataDefault(MidUser midUser) {
        if (null == midUser) {
            return;
        }
        midUser.setGmtModified(this.getSysDate());
    }

    private void saveuserModel(MidUser midUser) throws ApiException {
        if (null == midUser) {
            return;
        }
        try {
            this.midUserMapper.insert(midUser);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUserServiceImpl.saveuserModel.ex", (Throwable)e);
        }
    }

    private void saveuserBatchModel(List<MidUser> midUserList) throws ApiException {
        if (null == midUserList || midUserList.isEmpty()) {
            return;
        }
        try {
            this.midUserMapper.insertBatch(midUserList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUserServiceImpl.saveuserBatchModel.ex", (Throwable)e);
        }
    }

    private MidUser getuserModelById(Integer userId) {
        if (null == userId) {
            return null;
        }
        try {
            return this.midUserMapper.selectByPrimaryKey(userId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUserServiceImpl.getuserModelById", (Throwable)e);
            return null;
        }
    }

    private MidUser getuserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUserServiceImpl.getuserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void deluserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midUserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUserServiceImpl.deluserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidUserServiceImpl.deluserModelByCode.num");
        }
    }

    private void deleteuserModel(Integer userId) throws ApiException {
        if (null == userId) {
            return;
        }
        int i = 0;
        try {
            i = this.midUserMapper.deleteByPrimaryKey(userId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUserServiceImpl.deleteuserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidUserServiceImpl.deleteuserModel.num");
        }
    }

    private void updateuserModel(MidUser midUser) throws ApiException {
        if (null == midUser) {
            return;
        }
        int i = 0;
        try {
            i = this.midUserMapper.updateByPrimaryKey(midUser);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUserServiceImpl.updateuserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidUserServiceImpl.updateuserModel.num");
        }
    }

    private void updateStateuserModel(Integer userId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == userId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUserServiceImpl.updateStateuserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidUserServiceImpl.updateStateuserModel.null");
        }
    }

    private void updateStateuserModelByCode(String tenantCode, String userCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)userCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userCode", userCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midUserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidUserServiceImpl.updateStateuserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidUserServiceImpl.updateStateuserModelByCode.null");
        }
    }

    private MidUser makeuser(MidUserDomain midUserDomain, MidUser midUser) {
        if (null == midUserDomain) {
            return null;
        }
        if (null == midUser) {
            midUser = new MidUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midUser, (Object)midUserDomain);
            return midUser;
        }
        catch (Exception e) {
            this.logger.error("mid.MidUserServiceImpl.makeuser", (Throwable)e);
            return null;
        }
    }

    private MidUserReDomain makeMidUserReDomain(MidUser midUser) {
        if (null == midUser) {
            return null;
        }
        MidUserReDomain midUserReDomain = new MidUserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midUserReDomain, (Object)midUser);
            return midUserReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidUserServiceImpl.makeMidUserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidUser> queryuserModelPage(Map<String, Object> parammap) {
        try {
            return this.midUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUserServiceImpl.queryuserModel", (Throwable)e);
            return null;
        }
    }

    private int countuser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidUserServiceImpl.countuser", (Throwable)e);
        }
        return i;
    }

    private MidUser createMidUser(MidUserDomain midUserDomain) {
        String msg = this.checkuser(midUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidUserServiceImpl.saveuser.checkuser", msg);
        }
        MidUser midUser = this.makeuser(midUserDomain, null);
        this.setuserDefault(midUser);
        return midUser;
    }

    @Override
    public String saveuser(MidUserDomain midUserDomain) throws ApiException {
        MidUser midUser = this.createMidUser(midUserDomain);
        this.saveuserModel(midUser);
        return midUser.getUserCode();
    }

    @Override
    public String saveuserBatch(List<MidUserDomain> midUserDomainList) throws ApiException {
        if (null == midUserDomainList || midUserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidUser> midUserList = new ArrayList<MidUser>();
        String code = "";
        for (MidUserDomain midUserDomain : midUserDomainList) {
            MidUser midUser = this.createMidUser(midUserDomain);
            code = midUser.getUserCode();
            midUserList.add(midUser);
        }
        this.saveuserBatchModel(midUserList);
        return code;
    }

    @Override
    public void updateuserState(Integer userId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == userId) {
            return;
        }
        this.updateStateuserModel(userId, dataState, oldDataState, map);
    }

    @Override
    public void updateuserStateByCode(String tenantCode, String userCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateuserModelByCode(tenantCode, userCode, dataState, oldDataState, map);
    }

    @Override
    public void updateuser(MidUserDomain midUserDomain) throws ApiException {
        String msg = this.checkuser(midUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidUserServiceImpl.updateuser.checkuser", msg);
        }
        MidUser oldMidUser = this.getuserModelById(midUserDomain.getUserId());
        if (null == oldMidUser) {
            throw new ApiException("mid.MidUserServiceImpl.updateuser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidUser midUser = this.makeuser(midUserDomain, oldMidUser);
        this.setuserUpdataDefault(midUser);
        this.updateuserModel(midUser);
    }

    @Override
    public MidUser getuser(Integer userId) {
        if (null == userId) {
            return null;
        }
        return this.getuserModelById(userId);
    }

    @Override
    public void deleteuser(Integer userId) throws ApiException {
        if (null == userId) {
            return;
        }
        this.deleteuserModel(userId);
    }

    @Override
    public QueryResult<MidUser> queryuserPage(Map<String, Object> map) {
        List<MidUser> midUserList = this.queryuserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countuser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midUserList);
        return queryResult;
    }

    @Override
    public MidUser getuserByCode(String tenantCode, String userCode) throws ApiException {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userCode", userCode);
        return this.getuserModelByCode(map);
    }

    @Override
    public void deleteuserByCode(String tenantCode, String userCode) throws ApiException {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userCode", userCode);
        this.deluserModelByCode(map);
    }
}

