/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mid.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mid.dao.MidPromotionDiscountlistMapper;
import com.yqbsoft.laser.service.mid.dao.MidPromotionMapper;
import com.yqbsoft.laser.service.mid.dao.MidPromotionRangelistMapper;
import com.yqbsoft.laser.service.mid.dao.MidPromotionTargetlistMapper;
import com.yqbsoft.laser.service.mid.dao.MidUserCoupontMapper;
import com.yqbsoft.laser.service.mid.domain.MidPromotionDiscountlistDomain;
import com.yqbsoft.laser.service.mid.domain.MidPromotionDiscountlistReDomain;
import com.yqbsoft.laser.service.mid.domain.MidPromotionDomain;
import com.yqbsoft.laser.service.mid.domain.MidPromotionRangelistDomain;
import com.yqbsoft.laser.service.mid.domain.MidPromotionRangelistReDomain;
import com.yqbsoft.laser.service.mid.domain.MidPromotionReDomain;
import com.yqbsoft.laser.service.mid.domain.MidPromotionTargetlistDomain;
import com.yqbsoft.laser.service.mid.domain.MidPromotionTargetlistReDomain;
import com.yqbsoft.laser.service.mid.domain.MidUserCoupontDomain;
import com.yqbsoft.laser.service.mid.domain.MidUserCoupontReDomain;
import com.yqbsoft.laser.service.mid.model.MidPromotion;
import com.yqbsoft.laser.service.mid.model.MidPromotionDiscountlist;
import com.yqbsoft.laser.service.mid.model.MidPromotionRangelist;
import com.yqbsoft.laser.service.mid.model.MidPromotionTargetlist;
import com.yqbsoft.laser.service.mid.model.MidUserCoupont;
import com.yqbsoft.laser.service.mid.service.MidPromotionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MidPromotionServiceImpl
extends BaseServiceImpl
implements MidPromotionService {
    private static final String SYS_CODE = "mid.MidPromotionServiceImpl";
    private MidPromotionMapper midPromotionMapper;
    private MidPromotionRangelistMapper midPromotionRangelistMapper;
    private MidPromotionDiscountlistMapper midPromotionDiscountlistMapper;
    private MidPromotionTargetlistMapper midPromotionTargetlistMapper;
    private MidUserCoupontMapper midUserCoupontMapper;

    public void setMidPromotionMapper(MidPromotionMapper midPromotionMapper) {
        this.midPromotionMapper = midPromotionMapper;
    }

    public void setMidPromotionRangelistMapper(MidPromotionRangelistMapper midPromotionRangelistMapper) {
        this.midPromotionRangelistMapper = midPromotionRangelistMapper;
    }

    public void setMidPromotionDiscountlistMapper(MidPromotionDiscountlistMapper midPromotionDiscountlistMapper) {
        this.midPromotionDiscountlistMapper = midPromotionDiscountlistMapper;
    }

    public void setMidPromotionTargetlistMapper(MidPromotionTargetlistMapper midPromotionTargetlistMapper) {
        this.midPromotionTargetlistMapper = midPromotionTargetlistMapper;
    }

    public void setMidUserCoupontMapper(MidUserCoupontMapper midUserCoupontMapper) {
        this.midUserCoupontMapper = midUserCoupontMapper;
    }

    private Date getSysDate() {
        try {
            return this.midPromotionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotion(MidPromotionDomain midPromotionDomain) {
        if (null == midPromotionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midPromotionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionDefault(MidPromotion midPromotion) {
        if (null == midPromotion) {
            return;
        }
        if (null == midPromotion.getDataState()) {
            midPromotion.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midPromotion.getGmtCreate()) {
            midPromotion.setGmtCreate(date);
        }
        midPromotion.setGmtModified(date);
        if (StringUtils.isBlank((String)midPromotion.getPromotionCode())) {
            midPromotion.setPromotionCode(this.getNo(null, "MidPromotion", "midPromotion", midPromotion.getTenantCode()));
        }
    }

    private int getPromotionMaxCode() {
        int code = 0;
        try {
            return this.midPromotionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionUpdataDefault(MidPromotion midPromotion) {
        if (null == midPromotion) {
            return;
        }
        midPromotion.setGmtModified(this.getSysDate());
    }

    private void savePromotionModel(MidPromotion midPromotion) throws ApiException {
        if (null == midPromotion) {
            return;
        }
        try {
            this.midPromotionMapper.insert(midPromotion);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionModel.ex", (Throwable)e);
        }
    }

    private void savePromotionBatchModel(List<MidPromotion> midPromotionList) throws ApiException {
        if (null == midPromotionList || midPromotionList.isEmpty()) {
            return;
        }
        try {
            this.midPromotionMapper.insertBatch(midPromotionList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionBatchModel.ex", (Throwable)e);
        }
    }

    private MidPromotion getPromotionModelById(Integer promotionId) {
        if (null == promotionId) {
            return null;
        }
        try {
            return this.midPromotionMapper.selectByPrimaryKey(promotionId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionModelById", (Throwable)e);
            return null;
        }
    }

    private MidPromotion getPromotionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midPromotionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.delPromotionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.delPromotionModelByCode.num");
        }
    }

    private void deletePromotionModel(Integer promotionId) throws ApiException {
        if (null == promotionId) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionMapper.deleteByPrimaryKey(promotionId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.deletePromotionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.deletePromotionModel.num");
        }
    }

    private void updatePromotionModel(MidPromotion midPromotion) throws ApiException {
        if (null == midPromotion) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionMapper.updateByPrimaryKey(midPromotion);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionModel.num");
        }
    }

    private void updateStatePromotionModel(Integer promotionId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == promotionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promotionId", promotionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midPromotionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionModel.null");
        }
    }

    private void updateStatePromotionModelByCode(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)promotionCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midPromotionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionModelByCode.null");
        }
    }

    private MidPromotion makePromotion(MidPromotionDomain midPromotionDomain, MidPromotion midPromotion) {
        if (null == midPromotionDomain) {
            return null;
        }
        if (null == midPromotion) {
            midPromotion = new MidPromotion();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midPromotion, (Object)midPromotionDomain);
            return midPromotion;
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.makePromotion", (Throwable)e);
            return null;
        }
    }

    private MidPromotionReDomain makeMidPromotionReDomain(MidPromotion midPromotion) {
        if (null == midPromotion) {
            return null;
        }
        MidPromotionReDomain midPromotionReDomain = new MidPromotionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midPromotionReDomain, (Object)midPromotion);
            return midPromotionReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.makeMidPromotionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidPromotion> queryPromotionModelPage(Map<String, Object> parammap) {
        try {
            return this.midPromotionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.queryPromotionModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotion(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midPromotionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.countPromotion", (Throwable)e);
        }
        return i;
    }

    private MidPromotion createMidPromotion(MidPromotionDomain midPromotionDomain) {
        String msg = this.checkPromotion(midPromotionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotion.checkPromotion", msg);
        }
        MidPromotion midPromotion = this.makePromotion(midPromotionDomain, null);
        this.setPromotionDefault(midPromotion);
        return midPromotion;
    }

    private String checkPromotionRangelist(MidPromotionRangelistDomain midPromotionRangelistDomain) {
        if (null == midPromotionRangelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midPromotionRangelistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionRangelistDefault(MidPromotionRangelist midPromotionRangelist) {
        if (null == midPromotionRangelist) {
            return;
        }
        if (null == midPromotionRangelist.getDataState()) {
            midPromotionRangelist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midPromotionRangelist.getGmtCreate()) {
            midPromotionRangelist.setGmtCreate(date);
        }
        midPromotionRangelist.setGmtModified(date);
        if (StringUtils.isBlank((String)midPromotionRangelist.getPprlCode())) {
            midPromotionRangelist.setPprlCode(this.getNo(null, "MidPromotionRangelist", "midPromotionRangelist", midPromotionRangelist.getTenantCode()));
        }
    }

    private int getPromotionRangelistMaxCode() {
        int code = 0;
        try {
            return this.midPromotionRangelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionRangelistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionRangelistUpdataDefault(MidPromotionRangelist midPromotionRangelist) {
        if (null == midPromotionRangelist) {
            return;
        }
        midPromotionRangelist.setGmtModified(this.getSysDate());
    }

    private void savePromotionRangelistModel(MidPromotionRangelist midPromotionRangelist) throws ApiException {
        if (null == midPromotionRangelist) {
            return;
        }
        try {
            this.midPromotionRangelistMapper.insert(midPromotionRangelist);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionRangelistModel.ex", (Throwable)e);
        }
    }

    private void savePromotionRangelistBatchModel(List<MidPromotionRangelist> midPromotionRangelistList) throws ApiException {
        if (null == midPromotionRangelistList || midPromotionRangelistList.isEmpty()) {
            return;
        }
        try {
            this.midPromotionRangelistMapper.insertBatch(midPromotionRangelistList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionRangelistBatchModel.ex", (Throwable)e);
        }
    }

    private MidPromotionRangelist getPromotionRangelistModelById(Integer pprlId) {
        if (null == pprlId) {
            return null;
        }
        try {
            return this.midPromotionRangelistMapper.selectByPrimaryKey(pprlId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionRangelistModelById", (Throwable)e);
            return null;
        }
    }

    private MidPromotionRangelist getPromotionRangelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midPromotionRangelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionRangelistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionRangelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionRangelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.delPromotionRangelistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.delPromotionRangelistModelByCode.num");
        }
    }

    private void deletePromotionRangelistModel(Integer pprlId) throws ApiException {
        if (null == pprlId) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionRangelistMapper.deleteByPrimaryKey(pprlId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.deletePromotionRangelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.deletePromotionRangelistModel.num");
        }
    }

    private void updatePromotionRangelistModel(MidPromotionRangelist midPromotionRangelist) throws ApiException {
        if (null == midPromotionRangelist) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionRangelistMapper.updateByPrimaryKey(midPromotionRangelist);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionRangelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionRangelistModel.num");
        }
    }

    private void updateStatePromotionRangelistModel(Integer pprlId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pprlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pprlId", pprlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midPromotionRangelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionRangelistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionRangelistModel.null");
        }
    }

    private void updateStatePromotionRangelistModelByCode(String tenantCode, String pprlCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pprlCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pprlCode", pprlCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midPromotionRangelistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionRangelistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionRangelistModelByCode.null");
        }
    }

    private MidPromotionRangelist makePromotionRangelist(MidPromotionRangelistDomain midPromotionRangelistDomain, MidPromotionRangelist midPromotionRangelist) {
        if (null == midPromotionRangelistDomain) {
            return null;
        }
        if (null == midPromotionRangelist) {
            midPromotionRangelist = new MidPromotionRangelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midPromotionRangelist, (Object)midPromotionRangelistDomain);
            return midPromotionRangelist;
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.makePromotionRangelist", (Throwable)e);
            return null;
        }
    }

    private MidPromotionRangelistReDomain makeMidPromotionRangelistReDomain(MidPromotionRangelist midPromotionRangelist) {
        if (null == midPromotionRangelist) {
            return null;
        }
        MidPromotionRangelistReDomain midPromotionRangelistReDomain = new MidPromotionRangelistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midPromotionRangelistReDomain, (Object)midPromotionRangelist);
            return midPromotionRangelistReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.makeMidPromotionRangelistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidPromotionRangelist> queryPromotionRangelistModelPage(Map<String, Object> parammap) {
        try {
            return this.midPromotionRangelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.queryPromotionRangelistModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionRangelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midPromotionRangelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.countPromotionRangelist", (Throwable)e);
        }
        return i;
    }

    private MidPromotionRangelist createMidPromotionRangelist(MidPromotionRangelistDomain midPromotionRangelistDomain) {
        String msg = this.checkPromotionRangelist(midPromotionRangelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionRangelist.checkPromotionRangelist", msg);
        }
        MidPromotionRangelist midPromotionRangelist = this.makePromotionRangelist(midPromotionRangelistDomain, null);
        this.setPromotionRangelistDefault(midPromotionRangelist);
        return midPromotionRangelist;
    }

    private String checkPromotionDiscountlist(MidPromotionDiscountlistDomain midPromotionDiscountlistDomain) {
        if (null == midPromotionDiscountlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midPromotionDiscountlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionDiscountlistDefault(MidPromotionDiscountlist midPromotionDiscountlist) {
        if (null == midPromotionDiscountlist) {
            return;
        }
        if (null == midPromotionDiscountlist.getDataState()) {
            midPromotionDiscountlist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midPromotionDiscountlist.getGmtCreate()) {
            midPromotionDiscountlist.setGmtCreate(date);
        }
        midPromotionDiscountlist.setGmtModified(date);
        if (StringUtils.isBlank((String)midPromotionDiscountlist.getPpdlCode())) {
            midPromotionDiscountlist.setPpdlCode(this.getNo(null, "MidPromotionDiscountlist", "midPromotionDiscountlist", midPromotionDiscountlist.getTenantCode()));
        }
    }

    private int getPromotionDiscountlistMaxCode() {
        int code = 0;
        try {
            return this.midPromotionDiscountlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionDiscountlistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionDiscountlistUpdataDefault(MidPromotionDiscountlist midPromotionDiscountlist) {
        if (null == midPromotionDiscountlist) {
            return;
        }
        midPromotionDiscountlist.setGmtModified(this.getSysDate());
    }

    private void savePromotionDiscountlistModel(MidPromotionDiscountlist midPromotionDiscountlist) throws ApiException {
        if (null == midPromotionDiscountlist) {
            return;
        }
        try {
            this.midPromotionDiscountlistMapper.insert(midPromotionDiscountlist);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionDiscountlistModel.ex", (Throwable)e);
        }
    }

    private void savePromotionDiscountlistBatchModel(List<MidPromotionDiscountlist> midPromotionDiscountlistList) throws ApiException {
        if (null == midPromotionDiscountlistList || midPromotionDiscountlistList.isEmpty()) {
            return;
        }
        try {
            this.midPromotionDiscountlistMapper.insertBatch(midPromotionDiscountlistList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionDiscountlistBatchModel.ex", (Throwable)e);
        }
    }

    private MidPromotionDiscountlist getPromotionDiscountlistModelById(Integer ppdlId) {
        if (null == ppdlId) {
            return null;
        }
        try {
            return this.midPromotionDiscountlistMapper.selectByPrimaryKey(ppdlId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionDiscountlistModelById", (Throwable)e);
            return null;
        }
    }

    private MidPromotionDiscountlist getPromotionDiscountlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midPromotionDiscountlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionDiscountlistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionDiscountlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionDiscountlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.delPromotionDiscountlistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.delPromotionDiscountlistModelByCode.num");
        }
    }

    private void deletePromotionDiscountlistModel(Integer ppdlId) throws ApiException {
        if (null == ppdlId) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionDiscountlistMapper.deleteByPrimaryKey(ppdlId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.deletePromotionDiscountlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.deletePromotionDiscountlistModel.num");
        }
    }

    private void updatePromotionDiscountlistModel(MidPromotionDiscountlist midPromotionDiscountlist) throws ApiException {
        if (null == midPromotionDiscountlist) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionDiscountlistMapper.updateByPrimaryKey(midPromotionDiscountlist);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionDiscountlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionDiscountlistModel.num");
        }
    }

    private void updateStatePromotionDiscountlistModel(Integer ppdlId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ppdlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ppdlId", ppdlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midPromotionDiscountlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionDiscountlistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionDiscountlistModel.null");
        }
    }

    private void updateStatePromotionDiscountlistModelByCode(String tenantCode, String ppdlCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ppdlCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppdlCode", ppdlCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midPromotionDiscountlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionDiscountlistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionDiscountlistModelByCode.null");
        }
    }

    private MidPromotionDiscountlist makePromotionDiscountlist(MidPromotionDiscountlistDomain midPromotionDiscountlistDomain, MidPromotionDiscountlist midPromotionDiscountlist) {
        if (null == midPromotionDiscountlistDomain) {
            return null;
        }
        if (null == midPromotionDiscountlist) {
            midPromotionDiscountlist = new MidPromotionDiscountlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midPromotionDiscountlist, (Object)midPromotionDiscountlistDomain);
            return midPromotionDiscountlist;
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.makePromotionDiscountlist", (Throwable)e);
            return null;
        }
    }

    private MidPromotionDiscountlistReDomain makeMidPromotionDiscountlistReDomain(MidPromotionDiscountlist midPromotionDiscountlist) {
        if (null == midPromotionDiscountlist) {
            return null;
        }
        MidPromotionDiscountlistReDomain midPromotionDiscountlistReDomain = new MidPromotionDiscountlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midPromotionDiscountlistReDomain, (Object)midPromotionDiscountlist);
            return midPromotionDiscountlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.makeMidPromotionDiscountlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidPromotionDiscountlist> queryPromotionDiscountlistModelPage(Map<String, Object> parammap) {
        try {
            return this.midPromotionDiscountlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.queryPromotionDiscountlistModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionDiscountlist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midPromotionDiscountlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.countPromotionDiscountlist", (Throwable)e);
        }
        return i;
    }

    private MidPromotionDiscountlist createMidPromotionDiscountlist(MidPromotionDiscountlistDomain midPromotionDiscountlistDomain) {
        String msg = this.checkPromotionDiscountlist(midPromotionDiscountlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionDiscountlist.checkPromotionDiscountlist", msg);
        }
        MidPromotionDiscountlist midPromotionDiscountlist = this.makePromotionDiscountlist(midPromotionDiscountlistDomain, null);
        this.setPromotionDiscountlistDefault(midPromotionDiscountlist);
        return midPromotionDiscountlist;
    }

    private String checkPromotionTargetlist(MidPromotionTargetlistDomain midPromotionTargetlistDomain) {
        if (null == midPromotionTargetlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midPromotionTargetlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionTargetlistDefault(MidPromotionTargetlist midPromotionTargetlist) {
        if (null == midPromotionTargetlist) {
            return;
        }
        if (null == midPromotionTargetlist.getDataState()) {
            midPromotionTargetlist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midPromotionTargetlist.getGmtCreate()) {
            midPromotionTargetlist.setGmtCreate(date);
        }
        midPromotionTargetlist.setGmtModified(date);
        if (StringUtils.isBlank((String)midPromotionTargetlist.getPptlCode())) {
            midPromotionTargetlist.setPptlCode(this.getNo(null, "MidPromotionTargetlist", "midPromotionTargetlist", midPromotionTargetlist.getTenantCode()));
        }
    }

    private int getPromotionTargetlistMaxCode() {
        int code = 0;
        try {
            return this.midPromotionTargetlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionTargetlistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionTargetlistUpdataDefault(MidPromotionTargetlist midPromotionTargetlist) {
        if (null == midPromotionTargetlist) {
            return;
        }
        midPromotionTargetlist.setGmtModified(this.getSysDate());
    }

    private void savePromotionTargetlistModel(MidPromotionTargetlist midPromotionTargetlist) throws ApiException {
        if (null == midPromotionTargetlist) {
            return;
        }
        try {
            this.midPromotionTargetlistMapper.insert(midPromotionTargetlist);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionTargetlistModel.ex", (Throwable)e);
        }
    }

    private void savePromotionTargetlistBatchModel(List<MidPromotionTargetlist> midPromotionTargetlistList) throws ApiException {
        if (null == midPromotionTargetlistList || midPromotionTargetlistList.isEmpty()) {
            return;
        }
        try {
            this.midPromotionTargetlistMapper.insertBatch(midPromotionTargetlistList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionTargetlistBatchModel.ex", (Throwable)e);
        }
    }

    private MidPromotionTargetlist getPromotionTargetlistModelById(Integer pptlId) {
        if (null == pptlId) {
            return null;
        }
        try {
            return this.midPromotionTargetlistMapper.selectByPrimaryKey(pptlId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionTargetlistModelById", (Throwable)e);
            return null;
        }
    }

    private MidPromotionTargetlist getPromotionTargetlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midPromotionTargetlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getPromotionTargetlistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionTargetlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionTargetlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.delPromotionTargetlistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.delPromotionTargetlistModelByCode.num");
        }
    }

    private void deletePromotionTargetlistModel(Integer pptlId) throws ApiException {
        if (null == pptlId) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionTargetlistMapper.deleteByPrimaryKey(pptlId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.deletePromotionTargetlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.deletePromotionTargetlistModel.num");
        }
    }

    private void updatePromotionTargetlistModel(MidPromotionTargetlist midPromotionTargetlist) throws ApiException {
        if (null == midPromotionTargetlist) {
            return;
        }
        int i = 0;
        try {
            i = this.midPromotionTargetlistMapper.updateByPrimaryKey(midPromotionTargetlist);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionTargetlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionTargetlistModel.num");
        }
    }

    private void updateStatePromotionTargetlistModel(Integer pptlId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pptlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pptlId", pptlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midPromotionTargetlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionTargetlistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionTargetlistModel.null");
        }
    }

    private void updateStatePromotionTargetlistModelByCode(String tenantCode, String pptlCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pptlCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pptlCode", pptlCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midPromotionTargetlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionTargetlistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStatePromotionTargetlistModelByCode.null");
        }
    }

    private MidPromotionTargetlist makePromotionTargetlist(MidPromotionTargetlistDomain midPromotionTargetlistDomain, MidPromotionTargetlist midPromotionTargetlist) {
        if (null == midPromotionTargetlistDomain) {
            return null;
        }
        if (null == midPromotionTargetlist) {
            midPromotionTargetlist = new MidPromotionTargetlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midPromotionTargetlist, (Object)midPromotionTargetlistDomain);
            return midPromotionTargetlist;
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.makePromotionTargetlist", (Throwable)e);
            return null;
        }
    }

    private MidPromotionTargetlistReDomain makeMidPromotionTargetlistReDomain(MidPromotionTargetlist midPromotionTargetlist) {
        if (null == midPromotionTargetlist) {
            return null;
        }
        MidPromotionTargetlistReDomain midPromotionTargetlistReDomain = new MidPromotionTargetlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midPromotionTargetlistReDomain, (Object)midPromotionTargetlist);
            return midPromotionTargetlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.makeMidPromotionTargetlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidPromotionTargetlist> queryPromotionTargetlistModelPage(Map<String, Object> parammap) {
        try {
            return this.midPromotionTargetlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.queryPromotionTargetlistModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionTargetlist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midPromotionTargetlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.countPromotionTargetlist", (Throwable)e);
        }
        return i;
    }

    private MidPromotionTargetlist createMidPromotionTargetlist(MidPromotionTargetlistDomain midPromotionTargetlistDomain) {
        String msg = this.checkPromotionTargetlist(midPromotionTargetlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidPromotionServiceImpl.savePromotionTargetlist.checkPromotionTargetlist", msg);
        }
        MidPromotionTargetlist midPromotionTargetlist = this.makePromotionTargetlist(midPromotionTargetlistDomain, null);
        this.setPromotionTargetlistDefault(midPromotionTargetlist);
        return midPromotionTargetlist;
    }

    private String checkUserCoupont(MidUserCoupontDomain midUserCoupontDomain) {
        if (null == midUserCoupontDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)midUserCoupontDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserCoupontDefault(MidUserCoupont midUserCoupont) {
        if (null == midUserCoupont) {
            return;
        }
        if (null == midUserCoupont.getDataState()) {
            midUserCoupont.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == midUserCoupont.getGmtCreate()) {
            midUserCoupont.setGmtCreate(date);
        }
        midUserCoupont.setGmtModified(date);
        if (StringUtils.isBlank((String)midUserCoupont.getUsercouponCode())) {
            midUserCoupont.setUsercouponCode(this.getNo(null, "MidUserCoupont", "midUserCoupont", midUserCoupont.getTenantCode()));
        }
    }

    private int getUserCoupontMaxCode() {
        int code = 0;
        try {
            return this.midUserCoupontMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getUserCoupontMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserCoupontUpdataDefault(MidUserCoupont midUserCoupont) {
        if (null == midUserCoupont) {
            return;
        }
        midUserCoupont.setGmtModified(this.getSysDate());
    }

    private void saveUserCoupontModel(MidUserCoupont midUserCoupont) throws ApiException {
        if (null == midUserCoupont) {
            return;
        }
        try {
            this.midUserCoupontMapper.insert(midUserCoupont);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.saveUserCoupontModel.ex", (Throwable)e);
        }
    }

    private void saveUserCoupontBatchModel(List<MidUserCoupont> midUserCoupontList) throws ApiException {
        if (null == midUserCoupontList || midUserCoupontList.isEmpty()) {
            return;
        }
        try {
            this.midUserCoupontMapper.insertBatch(midUserCoupontList);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.saveUserCoupontBatchModel.ex", (Throwable)e);
        }
    }

    private MidUserCoupont getUserCoupontModelById(Integer usercouponId) {
        if (null == usercouponId) {
            return null;
        }
        try {
            return this.midUserCoupontMapper.selectByPrimaryKey(usercouponId);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getUserCoupontModelById", (Throwable)e);
            return null;
        }
    }

    private MidUserCoupont getUserCoupontModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.midUserCoupontMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.getUserCoupontModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserCoupontModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.midUserCoupontMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.delUserCoupontModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.delUserCoupontModelByCode.num");
        }
    }

    private void deleteUserCoupontModel(Integer usercouponId) throws ApiException {
        if (null == usercouponId) {
            return;
        }
        int i = 0;
        try {
            i = this.midUserCoupontMapper.deleteByPrimaryKey(usercouponId);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.deleteUserCoupontModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.deleteUserCoupontModel.num");
        }
    }

    private void updateUserCoupontModel(MidUserCoupont midUserCoupont) throws ApiException {
        if (null == midUserCoupont) {
            return;
        }
        int i = 0;
        try {
            i = this.midUserCoupontMapper.updateByPrimaryKey(midUserCoupont);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateUserCoupontModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateUserCoupontModel.num");
        }
    }

    private void updateStateUserCoupontModel(Integer usercouponId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == usercouponId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usercouponId", usercouponId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midUserCoupontMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStateUserCoupontModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStateUserCoupontModel.null");
        }
    }

    private void updateStateUserCoupontModelByCode(String tenantCode, String usercouponCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)usercouponCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.midUserCoupontMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStateUserCoupontModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateStateUserCoupontModelByCode.null");
        }
    }

    private MidUserCoupont makeUserCoupont(MidUserCoupontDomain midUserCoupontDomain, MidUserCoupont midUserCoupont) {
        if (null == midUserCoupontDomain) {
            return null;
        }
        if (null == midUserCoupont) {
            midUserCoupont = new MidUserCoupont();
        }
        try {
            BeanUtils.copyAllPropertys((Object)midUserCoupont, (Object)midUserCoupontDomain);
            return midUserCoupont;
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.makeUserCoupont", (Throwable)e);
            return null;
        }
    }

    private MidUserCoupontReDomain makeMidUserCoupontReDomain(MidUserCoupont midUserCoupont) {
        if (null == midUserCoupont) {
            return null;
        }
        MidUserCoupontReDomain midUserCoupontReDomain = new MidUserCoupontReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)midUserCoupontReDomain, (Object)midUserCoupont);
            return midUserCoupontReDomain;
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.makeMidUserCoupontReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MidUserCoupont> queryUserCoupontModelPage(Map<String, Object> parammap) {
        try {
            return this.midUserCoupontMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.queryUserCoupontModel", (Throwable)e);
            return null;
        }
    }

    private int countUserCoupont(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.midUserCoupontMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mid.MidPromotionServiceImpl.countUserCoupont", (Throwable)e);
        }
        return i;
    }

    private MidUserCoupont createMidUserCoupont(MidUserCoupontDomain midUserCoupontDomain) {
        String msg = this.checkUserCoupont(midUserCoupontDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidPromotionServiceImpl.saveUserCoupont.checkUserCoupont", msg);
        }
        MidUserCoupont midUserCoupont = this.makeUserCoupont(midUserCoupontDomain, null);
        this.setUserCoupontDefault(midUserCoupont);
        return midUserCoupont;
    }

    @Override
    public String savePromotion(MidPromotionDomain midPromotionDomain) throws ApiException {
        MidPromotion midPromotion = this.createMidPromotion(midPromotionDomain);
        this.savePromotionModel(midPromotion);
        this.savePromotionReRelatedData(midPromotionDomain, midPromotion.getPromotionCode());
        return midPromotion.getPromotionCode();
    }

    private void savePromotionReRelatedData(MidPromotionDomain pmPromotionDomain, String promotionCode) {
        List<MidPromotionRangelistDomain> rangelistDomainList;
        List<MidPromotionTargetlistDomain> targetlistDomainList = pmPromotionDomain.getMidPromotionTargetlistList();
        if (null != targetlistDomainList && targetlistDomainList.size() > 0) {
            for (MidPromotionTargetlistDomain targetlistDomain : targetlistDomainList) {
                targetlistDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                targetlistDomain.setMemberName(pmPromotionDomain.getMemberName());
                targetlistDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                targetlistDomain.setPromotionCode(promotionCode);
            }
            this.savePromotionTargetlistBatch(targetlistDomainList);
        }
        if (null != (rangelistDomainList = pmPromotionDomain.getMidPromotionRangelistList()) && rangelistDomainList.size() > 0) {
            for (MidPromotionRangelistDomain rangelistDomain : rangelistDomainList) {
                rangelistDomain.setTenantCode(pmPromotionDomain.getTenantCode());
                rangelistDomain.setMemberName(pmPromotionDomain.getMemberName());
                rangelistDomain.setMemberCode(pmPromotionDomain.getMemberCode());
                rangelistDomain.setPromotionCode(promotionCode);
            }
            this.savePromotionRangelistBatch(rangelistDomainList);
        }
    }

    @Override
    public String savePromotionBatch(List<MidPromotionDomain> midPromotionDomainList) throws ApiException {
        if (null == midPromotionDomainList || midPromotionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidPromotion> midPromotionList = new ArrayList<MidPromotion>();
        String code = "";
        for (MidPromotionDomain midPromotionDomain : midPromotionDomainList) {
            MidPromotion midPromotion = this.createMidPromotion(midPromotionDomain);
            code = midPromotion.getPromotionCode();
            midPromotionList.add(midPromotion);
        }
        this.savePromotionBatchModel(midPromotionList);
        return code;
    }

    @Override
    public void updatePromotionState(Integer promotionId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == promotionId) {
            return;
        }
        this.updateStatePromotionModel(promotionId, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionStateByCode(String tenantCode, String promotionCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePromotionModelByCode(tenantCode, promotionCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotion(MidPromotionDomain midPromotionDomain) throws ApiException {
        String msg = this.checkPromotion(midPromotionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotion.checkPromotion", msg);
        }
        MidPromotion oldMidPromotion = this.getPromotionModelById(midPromotionDomain.getPromotionId());
        if (null == oldMidPromotion) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotion.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidPromotion midPromotion = this.makePromotion(midPromotionDomain, oldMidPromotion);
        this.setPromotionUpdataDefault(midPromotion);
        this.updatePromotionModel(midPromotion);
    }

    @Override
    public MidPromotion getPromotion(Integer promotionId) {
        if (null == promotionId) {
            return null;
        }
        return this.getPromotionModelById(promotionId);
    }

    @Override
    public void deletePromotion(Integer promotionId) throws ApiException {
        if (null == promotionId) {
            return;
        }
        this.deletePromotionModel(promotionId);
    }

    @Override
    public QueryResult<MidPromotion> queryPromotionPage(Map<String, Object> map) {
        List<MidPromotion> midPromotionList = this.queryPromotionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotion(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midPromotionList);
        return queryResult;
    }

    @Override
    public MidPromotion getPromotionByCode(String tenantCode, String promotionCode) throws ApiException {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        return this.getPromotionModelByCode(map);
    }

    @Override
    public void deletePromotionByCode(String tenantCode, String promotionCode) throws ApiException {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.delPromotionModelByCode(map);
    }

    @Override
    public String savePromotionRangelist(MidPromotionRangelistDomain midPromotionRangelistDomain) throws ApiException {
        MidPromotionRangelist midPromotionRangelist = this.createMidPromotionRangelist(midPromotionRangelistDomain);
        this.savePromotionRangelistModel(midPromotionRangelist);
        return midPromotionRangelist.getPprlCode();
    }

    @Override
    public String savePromotionRangelistBatch(List<MidPromotionRangelistDomain> midPromotionRangelistDomainList) throws ApiException {
        if (null == midPromotionRangelistDomainList || midPromotionRangelistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidPromotionRangelist> midPromotionRangelistList = new ArrayList<MidPromotionRangelist>();
        String code = "";
        for (MidPromotionRangelistDomain midPromotionRangelistDomain : midPromotionRangelistDomainList) {
            MidPromotionRangelist midPromotionRangelist = this.createMidPromotionRangelist(midPromotionRangelistDomain);
            code = midPromotionRangelist.getPprlCode();
            midPromotionRangelistList.add(midPromotionRangelist);
        }
        this.savePromotionRangelistBatchModel(midPromotionRangelistList);
        return code;
    }

    @Override
    public void updatePromotionRangelistState(Integer pprlId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pprlId) {
            return;
        }
        this.updateStatePromotionRangelistModel(pprlId, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionRangelistStateByCode(String tenantCode, String pprlCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pprlCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePromotionRangelistModelByCode(tenantCode, pprlCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionRangelist(MidPromotionRangelistDomain midPromotionRangelistDomain) throws ApiException {
        String msg = this.checkPromotionRangelist(midPromotionRangelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionRangelist.checkPromotionRangelist", msg);
        }
        MidPromotionRangelist oldMidPromotionRangelist = this.getPromotionRangelistModelById(midPromotionRangelistDomain.getPprlId());
        if (null == oldMidPromotionRangelist) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionRangelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidPromotionRangelist midPromotionRangelist = this.makePromotionRangelist(midPromotionRangelistDomain, oldMidPromotionRangelist);
        this.setPromotionRangelistUpdataDefault(midPromotionRangelist);
        this.updatePromotionRangelistModel(midPromotionRangelist);
    }

    @Override
    public MidPromotionRangelist getPromotionRangelist(Integer pprlId) {
        if (null == pprlId) {
            return null;
        }
        return this.getPromotionRangelistModelById(pprlId);
    }

    @Override
    public void deletePromotionRangelist(Integer pprlId) throws ApiException {
        if (null == pprlId) {
            return;
        }
        this.deletePromotionRangelistModel(pprlId);
    }

    @Override
    public QueryResult<MidPromotionRangelist> queryPromotionRangelistPage(Map<String, Object> map) {
        List<MidPromotionRangelist> midPromotionRangelistList = this.queryPromotionRangelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionRangelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midPromotionRangelistList);
        return queryResult;
    }

    @Override
    public MidPromotionRangelist getPromotionRangelistByCode(String tenantCode, String pprlCode) throws ApiException {
        if (StringUtils.isBlank((String)pprlCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pprlCode", pprlCode);
        return this.getPromotionRangelistModelByCode(map);
    }

    @Override
    public void deletePromotionRangelistByCode(String tenantCode, String pprlCode) throws ApiException {
        if (StringUtils.isBlank((String)pprlCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pprlCode", pprlCode);
        this.delPromotionRangelistModelByCode(map);
    }

    @Override
    public String savePromotionDiscountlist(MidPromotionDiscountlistDomain midPromotionDiscountlistDomain) throws ApiException {
        MidPromotionDiscountlist midPromotionDiscountlist = this.createMidPromotionDiscountlist(midPromotionDiscountlistDomain);
        this.savePromotionDiscountlistModel(midPromotionDiscountlist);
        return midPromotionDiscountlist.getPpdlCode();
    }

    @Override
    public String savePromotionDiscountlistBatch(List<MidPromotionDiscountlistDomain> midPromotionDiscountlistDomainList) throws ApiException {
        if (null == midPromotionDiscountlistDomainList || midPromotionDiscountlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidPromotionDiscountlist> midPromotionDiscountlistList = new ArrayList<MidPromotionDiscountlist>();
        String code = "";
        for (MidPromotionDiscountlistDomain midPromotionDiscountlistDomain : midPromotionDiscountlistDomainList) {
            MidPromotionDiscountlist midPromotionDiscountlist = this.createMidPromotionDiscountlist(midPromotionDiscountlistDomain);
            code = midPromotionDiscountlist.getPpdlCode();
            midPromotionDiscountlistList.add(midPromotionDiscountlist);
        }
        this.savePromotionDiscountlistBatchModel(midPromotionDiscountlistList);
        return code;
    }

    @Override
    public void updatePromotionDiscountlistState(Integer ppdlId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ppdlId) {
            return;
        }
        this.updateStatePromotionDiscountlistModel(ppdlId, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionDiscountlistStateByCode(String tenantCode, String ppdlCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ppdlCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePromotionDiscountlistModelByCode(tenantCode, ppdlCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionDiscountlist(MidPromotionDiscountlistDomain midPromotionDiscountlistDomain) throws ApiException {
        String msg = this.checkPromotionDiscountlist(midPromotionDiscountlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionDiscountlist.checkPromotionDiscountlist", msg);
        }
        MidPromotionDiscountlist oldMidPromotionDiscountlist = this.getPromotionDiscountlistModelById(midPromotionDiscountlistDomain.getPpdlId());
        if (null == oldMidPromotionDiscountlist) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionDiscountlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidPromotionDiscountlist midPromotionDiscountlist = this.makePromotionDiscountlist(midPromotionDiscountlistDomain, oldMidPromotionDiscountlist);
        this.setPromotionDiscountlistUpdataDefault(midPromotionDiscountlist);
        this.updatePromotionDiscountlistModel(midPromotionDiscountlist);
    }

    @Override
    public MidPromotionDiscountlist getPromotionDiscountlist(Integer ppdlId) {
        if (null == ppdlId) {
            return null;
        }
        return this.getPromotionDiscountlistModelById(ppdlId);
    }

    @Override
    public void deletePromotionDiscountlist(Integer ppdlId) throws ApiException {
        if (null == ppdlId) {
            return;
        }
        this.deletePromotionDiscountlistModel(ppdlId);
    }

    @Override
    public QueryResult<MidPromotionDiscountlist> queryPromotionDiscountlistPage(Map<String, Object> map) {
        List<MidPromotionDiscountlist> midPromotionDiscountlistList = this.queryPromotionDiscountlistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionDiscountlist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midPromotionDiscountlistList);
        return queryResult;
    }

    @Override
    public MidPromotionDiscountlist getPromotionDiscountlistByCode(String tenantCode, String ppdlCode) throws ApiException {
        if (StringUtils.isBlank((String)ppdlCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppdlCode", ppdlCode);
        return this.getPromotionDiscountlistModelByCode(map);
    }

    @Override
    public void deletePromotionDiscountlistByCode(String tenantCode, String ppdlCode) throws ApiException {
        if (StringUtils.isBlank((String)ppdlCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppdlCode", ppdlCode);
        this.delPromotionDiscountlistModelByCode(map);
    }

    @Override
    public String savePromotionTargetlist(MidPromotionTargetlistDomain midPromotionTargetlistDomain) throws ApiException {
        MidPromotionTargetlist midPromotionTargetlist = this.createMidPromotionTargetlist(midPromotionTargetlistDomain);
        this.savePromotionTargetlistModel(midPromotionTargetlist);
        return midPromotionTargetlist.getPptlCode();
    }

    @Override
    public String savePromotionTargetlistBatch(List<MidPromotionTargetlistDomain> midPromotionTargetlistDomainList) throws ApiException {
        if (null == midPromotionTargetlistDomainList || midPromotionTargetlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidPromotionTargetlist> midPromotionTargetlistList = new ArrayList<MidPromotionTargetlist>();
        String code = "";
        for (MidPromotionTargetlistDomain midPromotionTargetlistDomain : midPromotionTargetlistDomainList) {
            MidPromotionTargetlist midPromotionTargetlist = this.createMidPromotionTargetlist(midPromotionTargetlistDomain);
            code = midPromotionTargetlist.getPptlCode();
            midPromotionTargetlistList.add(midPromotionTargetlist);
        }
        this.savePromotionTargetlistBatchModel(midPromotionTargetlistList);
        return code;
    }

    @Override
    public void updatePromotionTargetlistState(Integer pptlId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pptlId) {
            return;
        }
        this.updateStatePromotionTargetlistModel(pptlId, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionTargetlistStateByCode(String tenantCode, String pptlCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pptlCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePromotionTargetlistModelByCode(tenantCode, pptlCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionTargetlist(MidPromotionTargetlistDomain midPromotionTargetlistDomain) throws ApiException {
        String msg = this.checkPromotionTargetlist(midPromotionTargetlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionTargetlist.checkPromotionTargetlist", msg);
        }
        MidPromotionTargetlist oldMidPromotionTargetlist = this.getPromotionTargetlistModelById(midPromotionTargetlistDomain.getPptlId());
        if (null == oldMidPromotionTargetlist) {
            throw new ApiException("mid.MidPromotionServiceImpl.updatePromotionTargetlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidPromotionTargetlist midPromotionTargetlist = this.makePromotionTargetlist(midPromotionTargetlistDomain, oldMidPromotionTargetlist);
        this.setPromotionTargetlistUpdataDefault(midPromotionTargetlist);
        this.updatePromotionTargetlistModel(midPromotionTargetlist);
    }

    @Override
    public MidPromotionTargetlist getPromotionTargetlist(Integer pptlId) {
        if (null == pptlId) {
            return null;
        }
        return this.getPromotionTargetlistModelById(pptlId);
    }

    @Override
    public void deletePromotionTargetlist(Integer pptlId) throws ApiException {
        if (null == pptlId) {
            return;
        }
        this.deletePromotionTargetlistModel(pptlId);
    }

    @Override
    public QueryResult<MidPromotionTargetlist> queryPromotionTargetlistPage(Map<String, Object> map) {
        List<MidPromotionTargetlist> midPromotionTargetlistList = this.queryPromotionTargetlistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionTargetlist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midPromotionTargetlistList);
        return queryResult;
    }

    @Override
    public MidPromotionTargetlist getPromotionTargetlistByCode(String tenantCode, String pptlCode) throws ApiException {
        if (StringUtils.isBlank((String)pptlCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pptlCode", pptlCode);
        return this.getPromotionTargetlistModelByCode(map);
    }

    @Override
    public void deletePromotionTargetlistByCode(String tenantCode, String pptlCode) throws ApiException {
        if (StringUtils.isBlank((String)pptlCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pptlCode", pptlCode);
        this.delPromotionTargetlistModelByCode(map);
    }

    @Override
    public String saveUserCoupont(MidUserCoupontDomain midUserCoupontDomain) throws ApiException {
        MidUserCoupont midUserCoupont = this.createMidUserCoupont(midUserCoupontDomain);
        this.saveUserCoupontModel(midUserCoupont);
        return midUserCoupont.getUsercouponCode();
    }

    @Override
    public String saveUserCoupontBatch(List<MidUserCoupontDomain> midUserCoupontDomainList) throws ApiException {
        if (null == midUserCoupontDomainList || midUserCoupontDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MidUserCoupont> midUserCoupontList = new ArrayList<MidUserCoupont>();
        String code = "";
        for (MidUserCoupontDomain midUserCoupontDomain : midUserCoupontDomainList) {
            MidUserCoupont midUserCoupont = this.createMidUserCoupont(midUserCoupontDomain);
            code = midUserCoupont.getUsercouponCode();
            midUserCoupontList.add(midUserCoupont);
        }
        this.saveUserCoupontBatchModel(midUserCoupontList);
        return code;
    }

    @Override
    public void updateUserCoupontState(Integer usercouponId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == usercouponId) {
            return;
        }
        this.updateStateUserCoupontModel(usercouponId, dataState, oldDataState, map);
    }

    @Override
    public void updateUserCoupontStateByCode(String tenantCode, String usercouponCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)usercouponCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUserCoupontModelByCode(tenantCode, usercouponCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUserCoupont(MidUserCoupontDomain midUserCoupontDomain) throws ApiException {
        String msg = this.checkUserCoupont(midUserCoupontDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateUserCoupont.checkUserCoupont", msg);
        }
        MidUserCoupont oldMidUserCoupont = this.getUserCoupontModelById(midUserCoupontDomain.getUsercouponId());
        if (null == oldMidUserCoupont) {
            throw new ApiException("mid.MidPromotionServiceImpl.updateUserCoupont.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MidUserCoupont midUserCoupont = this.makeUserCoupont(midUserCoupontDomain, oldMidUserCoupont);
        this.setUserCoupontUpdataDefault(midUserCoupont);
        this.updateUserCoupontModel(midUserCoupont);
    }

    @Override
    public MidUserCoupont getUserCoupont(Integer usercouponId) {
        if (null == usercouponId) {
            return null;
        }
        return this.getUserCoupontModelById(usercouponId);
    }

    @Override
    public void deleteUserCoupont(Integer usercouponId) throws ApiException {
        if (null == usercouponId) {
            return;
        }
        this.deleteUserCoupontModel(usercouponId);
    }

    @Override
    public QueryResult<MidUserCoupont> queryUserCoupontPage(Map<String, Object> map) {
        List<MidUserCoupont> midUserCoupontList = this.queryUserCoupontModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserCoupont(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(midUserCoupontList);
        return queryResult;
    }

    @Override
    public MidUserCoupont getUserCoupontByCode(String tenantCode, String usercouponCode) throws ApiException {
        if (StringUtils.isBlank((String)usercouponCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        return this.getUserCoupontModelByCode(map);
    }

    @Override
    public void deleteUserCoupontByCode(String tenantCode, String usercouponCode) throws ApiException {
        if (StringUtils.isBlank((String)usercouponCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usercouponCode", usercouponCode);
        this.delUserCoupontModelByCode(map);
    }

    public static void main(String[] args) {
        System.out.println();
    }
}

