/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.mnsali;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.yqbsoft.laser.service.esb.core.auth.AuthUtil;
import com.yqbsoft.laser.service.esb.core.core.EsbReBean;
import com.yqbsoft.laser.service.esb.core.router.ProxyInvokeSupport;
import com.yqbsoft.laser.service.esb.core.transformer.InvokeIdParser;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class MnsAliInvokeService
extends ProxyInvokeSupport {
    private static final String sys_code = "http.adapter.mnsali.MnsAliInvoke";
    static final String product = "Dysmsapi";
    static final String domain = "dysmsapi.aliyuncs.com";

    public OutMessage channelSendMsg(InMessage inMessage) {
        if (null == inMessage) {
            return new OutMessage("http.adapter.mnsali.MnsAliInvoke.empty", "\u4fe1\u606f\u4e3a\u7a7a");
        }
        OutMessage outMessage = new OutMessage();
        try {
            String rsp = null;
            Invoke invoke = inMessage.getInvoke();
            Map params = invoke.getParams();
            InvokeIdParser.addInInvokeIdParamByHttp((Map)params, (InMessage)inMessage);
            String accessKeyId = (String)params.get("accessKeyId");
            String accessKeySecret = (String)params.get("accessKeySecret");
            String content = (String)params.get("content");
            String phone = (String)params.get("phone");
            String code = (String)params.get("randomCode");
            String signName = (String)params.get("signName");
            String paramMapjson = (String)params.get("paramMap");
            SendSmsResponse sendSmsResponse = this.sendSms(accessKeyId, accessKeySecret, content, phone, code, signName, paramMapjson);
            if (null != sendSmsResponse) {
                rsp = sendSmsResponse.getMessage();
            }
            if (!"OK".equals(rsp)) {
                this.logger.error(sys_code, (Object)("\u53d1\u9001\u5931\u8d25,url:" + inMessage.getInvoke().getRouterServiceName() + ",param" + inMessage.getInvoke().getParams()));
                outMessage.setErrorCode("http.adapter.mnsali.MnsAliInvoke.ex");
                outMessage.setMsg("\u53d1\u9001\u5931\u8d25");
            }
            this.logger.error(sys_code, (Object)("http rsp:" + content + "==" + rsp));
            outMessage.setReObj((Object)sendSmsResponse.getBizId());
        }
        catch (Exception e) {
            this.logger.error(sys_code, (Object)("\u8c03\u7528\u5f02\u5e38,url:" + inMessage.getInvoke().getRouterServiceName() + ",param" + inMessage.getInvoke().getParams()), (Throwable)e);
            outMessage.setErrorCode("http.adapter.mnsali.MnsAliInvoke.ex");
            outMessage.setMsg("\u8c03\u7528\u5f02\u5e38");
        }
        return outMessage;
    }

    private SendSmsResponse sendSms(String accessKeyId, String accessKeySecret, String content, String phone, String code, String signName, String paramMapjson) throws ClientException {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)product, (String)domain);
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(phone);
        request.setSignName(signName);
        request.setTemplateCode(content);
        if (StringUtils.isNotBlank((String)paramMapjson)) {
            HashMap map = (HashMap)JsonUtil.buildNormalBinder().getJsonToMap(paramMapjson, String.class, String.class);
            if (null == map) {
                map = new HashMap();
            }
            request.setTemplateParam(JsonUtil.buildNormalBinder().toJson(map));
        }
        request.setOutId("yourOutId");
        SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        return sendSmsResponse;
    }

    public void securityEncoder(InMessage inMessage) {
        Map params = inMessage.getInvoke().getParams();
        if (MapUtil.isEmpty((Map)params)) {
            return;
        }
        String plainText = AuthUtil.getSignCheckContentV1((Map)params);
        String sign = AuthUtil.sendAuth((InMessage)inMessage, (String)plainText);
        inMessage.getInvoke().setSign(sign);
    }

    public void securityDecoder(OutMessage outMessage, InMessage inMessage) {
        if (outMessage == null || inMessage == null) {
            return;
        }
        Map resultMap = null;
        if (outMessage.getReObj() == null) {
            return;
        }
        String resultJson = outMessage.getReObj().toString();
        if (!StringUtils.isMapJson((String)resultJson)) {
            return;
        }
        resultMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, String.class);
        if (MapUtil.isEmpty((Map)resultMap)) {
            return;
        }
        String sign = (String)resultMap.get("sign");
        if (StringUtils.isEmpty((String)sign)) {
            this.logger.error(sys_code, (Object)"securityDecoder sign is null");
            return;
        }
        String plainText = AuthUtil.getSignCheckContentV1((Map)resultMap);
        boolean checkFlag = AuthUtil.returnAuthCheck((InMessage)inMessage, (String)plainText, (String)sign);
        if (!checkFlag) {
            this.logger.error(sys_code, (Object)("validate sign fail plainTest " + plainText));
        }
    }

    protected void handleInvokeId(InMessage inMessage, OutMessage outMessage) {
        EsbReBean jrb;
        String objectJson;
        Object reObject = outMessage.getReObj();
        if (reObject != null && StringUtils.isMapJson((String)(objectJson = reObject.toString())) && null != (jrb = (EsbReBean)JsonUtil.buildNormalBinder().getJsonToObject(objectJson, EsbReBean.class, new Class[]{String.class})) && null != jrb.getInvokeId()) {
            int level = jrb.getInvokeId().getMsgLevel();
            inMessage.getInvokeId().setMsgLevel(level);
        }
        super.handleInvokeId(inMessage, outMessage);
    }
}

