/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.mnsjd;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.adapter.mnsjd.SmsResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class Sender {
    private String username;
    private String password;
    private String signName;
    private static final String requestUrl = "http://smspaas-gateway.jdcloud.com:9000/HttpSmsMt";
    private static final SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyyMMddhhmmss");

    public Sender(String username, String password, String signName) {
        this.username = username;
        this.password = password;
        this.signName = signName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SmsResponse send(String phone, String content, Map<String, String> params) {
        HttpPost httpPost = new HttpPost(requestUrl);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        String requestParameters = this.parametersToString(this.generateParameters(phone, content, params));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            StringEntity stringEntity = new StringEntity(requestParameters, "utf-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            String stringResponse = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
            JSONObject jsonObject = JSONObject.parseObject((String)stringResponse);
            SmsResponse smsResponse = new SmsResponse();
            smsResponse.setCode(jsonObject.getString("ReqCode"));
            smsResponse.setMsg(jsonObject.getString("ReqMsg"));
            smsResponse.setRequestId(jsonObject.getString("ReqId"));
            SmsResponse smsResponse2 = smsResponse;
            return smsResponse2;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private Map<String, String> generateParameters(String phone, String content, Map<String, String> params) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", this.username);
        String mttime = this.fetchMttime();
        parameters.put("mttime", mttime);
        parameters.put("pwd", this.generatePwd(mttime));
        parameters.put("phone", phone);
        parameters.put("content", this.generateContent(content, params));
        parameters.put("rpttype", "1");
        return parameters;
    }

    private String generateContent(String content, Map<String, String> params) {
        return this.appendSignName(this.convertTemplate(content, params));
    }

    private String convertTemplate(String content, Map<String, String> params) {
        if (params == null) {
            return content;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            content = content.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return content;
    }

    private String appendSignName(String content) {
        if (this.signName != null && !"".equals(this.signName)) {
            StringBuilder builder = new StringBuilder();
            builder.append("\u3010");
            builder.append(this.signName);
            builder.append("\u3011");
            builder.append(content);
            return builder.toString();
        }
        return content;
    }

    private String parametersToString(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
            builder.append("&");
        }
        builder.delete(builder.length() - 1, builder.length());
        return builder.toString();
    }

    private String fetchMttime() {
        return timeFormatter.format(new Date());
    }

    private String generatePwd(String time) {
        return DigestUtils.md5Hex((String)(this.password + time));
    }
}

