/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.mq;

import com.yqbsoft.laser.service.adapter.mq.MessageObj;
import com.yqbsoft.laser.service.adapter.mq.ProducerCall;
import com.yqbsoft.laser.service.adapter.mq.SupperConsumerSession;
import com.yqbsoft.laser.service.adapter.mq.SupperProducerSession;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.MessageChannel;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

public class ConsumerSession
extends SupperConsumerSession {
    private static final String sys_code = "amq.ADAPTER.MQ.ConsumerSession";
    protected final OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private SupperProducerSession repProducerSession;

    public SupperProducerSession getRepProducerSession() {
        return this.repProducerSession;
    }

    public void setRepProducerSession(SupperProducerSession repProducerSession) {
        this.repProducerSession = repProducerSession;
    }

    public ConsumerSession() {
    }

    public ConsumerSession(int corePoolSize, int maximumPoolSize, long keepAliveTime, String replyType) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, replyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMessageDo(Message message) {
        long a = System.currentTimeMillis();
        boolean flag = true;
        ObjectMessage response = null;
        String remsg = "";
        OutMessage outMessage = new OutMessage();
        InMessage inMessage = null;
        Destination dst = null;
        String jmsId = "";
        try {
            MessageObj messageObj = this.invoke(message);
            outMessage = messageObj.getOutMessage();
            inMessage = messageObj.getInMessage();
            dst = message.getJMSReplyTo();
            jmsId = message.getJMSCorrelationID();
            this.logger.debug("mq.ConsumerSession", (Object)("apiCode:" + this.getApiCode(inMessage) + ",id:" + message.getJMSCorrelationID() + "==start=="));
        }
        catch (Exception e) {
            remsg = "\u5f02\u5e38:" + e.getMessage();
            outMessage.setSubCode("error");
            outMessage.setSubMsg(remsg);
            this.logger.error("amq.ADAPTER.MQ.ConsumerSession.onMessage", (Throwable)e);
        }
        if (null != dst && null != this.getRepProducerSession()) {
            try {
                response = this.getRepProducerSession().getSession().createObjectMessage();
                response.setStringProperty("mq_filter_appKey", message.getStringProperty("mq_filter_appKey"));
                response.setJMSCorrelationID(jmsId);
                if (null == outMessage) {
                    outMessage = new OutMessage();
                }
                response.setObject((Serializable)outMessage);
                int priority = inMessage.getInvoke().getApiRouterProperty().getRouterPriorty();
                if (0 == priority) {
                    priority = this.getRepProducerSession().getProducer().getPriority();
                }
                this.getRepProducerSession().getProducer().send(message.getJMSReplyTo(), (Message)response, this.getRepProducerSession().getProducer().getDeliveryMode(), priority, (long)inMessage.getInvoke().getApiRouterProperty().getRouterReadtimeout().intValue());
                this.logger.debug("mq.ConsumerSession", (Object)("apiCode:" + this.getApiCode(inMessage) + ",id:" + jmsId + "==end=="));
            }
            catch (Exception e) {
                this.logger.error("amq.ADAPTER.MQ.ConsumerSession.onMessage catch", (Throwable)e);
            }
        } else {
            String sendType = inMessage.getInvoke().getApiRouterProperty().getRouterSendtype();
            if (StringUtils.isNotBlank((String)sendType) && "2".equals(sendType)) {
                ProducerCall.syncApiCall(jmsId, outMessage);
            }
            if (StringUtils.isNotBlank((String)sendType) && "0".equals(sendType) && (outMessage.isError() || outMessage.isFail())) {
                throw new ApiException("amq.ADAPTER.MQ.ConsumerSession.onMessage.error", "apiCode:" + this.getApiCode(inMessage) + "==" + outMessage.getMsg());
            }
        }
        OpenPerfLogUtil.info((String)("[ConsumerSession]spend times:{},apiCode:" + this.getApiCode(inMessage)), (long)(System.currentTimeMillis() - a));
        return flag;
    }

    public MessageObj invoke(Message message) {
        try {
            MessageObj messageObj = new MessageObj();
            if (!(message instanceof TextMessage) && message instanceof ObjectMessage) {
                ObjectMessage oabjectMsg = (ObjectMessage)message;
                InMessage inMessage = (InMessage)oabjectMsg.getObject();
                Invoke invoke = inMessage.getInvoke();
                MessageChannel messageChannel = (MessageChannel)SpringApplicationContextUtil.getBean((String)invoke.getApiRouterProperty().getRouterServicemessid());
                OutMessage outMessage = messageChannel.send(inMessage);
                messageObj.setOutMessage(outMessage);
                messageObj.setInMessage(inMessage);
                return messageObj;
            }
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.ConsumerSession.invoke", (Object)"", (Throwable)e);
        }
        return null;
    }

    private String getApiCode(InMessage inMessage) {
        try {
            Invoke invoke = inMessage.getInvoke();
            return invoke.getApiProperty().getAppapiCode();
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.ConsumerSession.getApiCode", (Throwable)e);
            return null;
        }
    }
}

