/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.mq;

import com.yqbsoft.laser.service.esb.core.jms.invo.SessionBean;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.pool.PooledConnection;

public abstract class SupperConsumerSession
implements MessageListener {
    private static final String sys_code = "amq.ADAPTER.MQ.SupperConsumerSession";
    int corePoolSize;
    int maximumPoolSize;
    long keepAliveTime;
    protected final OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private ExecutorService pool = null;
    public PooledConnection connection;
    private Session session;
    private MessageConsumer consumer;
    private SessionBean sessionBean;
    private String name;

    public MessageConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public PooledConnection getConnection() {
        return this.connection;
    }

    public void setConnection(PooledConnection connection) {
        this.connection = connection;
    }

    public SessionBean getSessionBean() {
        return this.sessionBean;
    }

    public void setSessionBean(SessionBean sessionBean) {
        this.sessionBean = sessionBean;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SupperConsumerSession() {
    }

    public SupperConsumerSession(int corePoolSize, int maximumPoolSize, long keepAliveTime, String replyType) {
        if ("0".equals(replyType)) {
            this.corePoolSize = corePoolSize < 1 ? 1 : corePoolSize;
            this.maximumPoolSize = maximumPoolSize < 1 ? 5 : maximumPoolSize;
            this.keepAliveTime = keepAliveTime < 1L ? 30L : keepAliveTime;
            this.createThread(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime);
        }
        this.logger.info("amq.ADAPTER.MQ.SupperConsumerSessioncerate ConsumerSession with replyType = " + replyType);
    }

    private void createThread(int corePoolSize, int maximumPoolSize, long keepAliveTime) {
        if (null != this.pool) {
            try {
                this.pool.shutdown();
            }
            catch (Exception e) {
                this.logger.error("amq.ADAPTER.MQ.SupperConsumerSession.createThread", (Object)"\u521b\u5efa\u7ebf\u7a0b\u6c60\u65f6\uff0c\u975e\u7a7a\u7ebf\u7a0b\u6c60\u5173\u95ed\u5f02\u5e38\u3002");
            }
        }
        this.pool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.logger.info("amq.ADAPTER.MQ.SupperConsumerSession\u7ebf\u7a0b\u6c60\u521b\u5efa\u6210\u529f\uff0ccorePoolSize=" + corePoolSize + "maximumPoolSize=" + maximumPoolSize + "keepAliveTime=" + keepAliveTime);
    }

    public void onMessage(Message message) {
        if (null != this.pool) {
            final Message syncMessage = message;
            this.pool.execute(new Runnable(){

                @Override
                public void run() {
                    SupperConsumerSession.this.onMessageDo(syncMessage);
                }
            });
        } else {
            this.onMessageDo(message);
        }
    }

    public abstract boolean onMessageDo(Message var1);

    public void stopExecutorService() {
        if (null == this.pool) {
            return;
        }
        try {
            this.pool.shutdownNow();
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.SupperConsumerSession.stopExecutorService", (Throwable)e);
        }
        this.logger.info("[stopExecutorService]ExecutorService is close.");
    }
}

