/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.mq;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.sync.SyncApiFuture;
import com.yqbsoft.laser.service.esb.core.sync.SyncInvokeFuture;
import com.yqbsoft.laser.service.suppercore.cache.repository.BeanRepository;
import com.yqbsoft.laser.service.suppercore.cache.repository.CacheBean;
import com.yqbsoft.laser.service.suppercore.cache.repository.DisCacheBean;
import com.yqbsoft.laser.service.suppercore.cache.repository.InvokeFuture;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.supper.SupperCallDomain;
import com.yqbsoft.laser.service.tool.util.StringUtils;

public class ProducerCall {
    private static final String sys_code = "amq.ADAPTER.MQ.call";
    protected static final OpenLogUtil logger = new OpenLogUtil(ProducerCall.class);
    public static final String PRODUCER_CALL = "PRODUCERCALL";
    public static final String PRODUCER_SYNCCALL = "PRODUCERSYNCCALL";
    public static final long DEFAULT_TIME = 5000L;
    private boolean synFlag = false;
    private String correlationId;
    private long timeout = 0L;

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public static void putSync(String correlationId, SyncInvokeFuture syncInvokeFuture, long timeout) {
        if (StringUtils.isBlank((String)correlationId) || null == syncInvokeFuture) {
            return;
        }
        CacheBean bean = new CacheBean();
        bean.setValue((Object)correlationId);
        if (timeout == -1L) {
            bean.setExpire(-1L);
        } else {
            bean.setExpire(timeout + 5000L);
        }
        bean.setFuture((InvokeFuture)syncInvokeFuture);
        BeanRepository.newInstance((String)PRODUCER_CALL).put(correlationId, (Object)bean);
    }

    public static void putSyncCall(String correlationId, SupperCallDomain callDomain, long timeout) {
        if (StringUtils.isBlank((String)correlationId) || null == callDomain) {
            return;
        }
        DisCacheBean bean = new DisCacheBean();
        bean.setValue((Object)correlationId);
        if (timeout == -1L) {
            bean.setExpire(-1L);
        } else {
            bean.setExpire(timeout + 5000L);
        }
        bean.setTimeout(timeout);
        bean.setCallDomain(callDomain);
        bean.setCorrelationId(correlationId);
        bean.setMapkey(PRODUCER_SYNCCALL);
        BeanRepository.newInstance((String)PRODUCER_SYNCCALL, (String)"DIS", (Object)PRODUCER_SYNCCALL).put(correlationId, (Object)bean);
    }

    public static InvokeFuture getSyncCall(String correlationId) {
        if (StringUtils.isBlank((String)correlationId)) {
            return null;
        }
        DisCacheBean bean = (DisCacheBean)BeanRepository.newInstance((String)PRODUCER_SYNCCALL, (String)"DIS", (Object)PRODUCER_SYNCCALL).get(correlationId);
        return ProducerCall.getFuture(bean, correlationId);
    }

    private static InvokeFuture getFuture(DisCacheBean bean, String correlationId) {
        if (null == bean) {
            return null;
        }
        SyncApiFuture syncApiFuture = new SyncApiFuture(bean.getCallDomain(), bean.getTimeout(), correlationId, bean.getMapkey());
        return syncApiFuture;
    }

    public static InvokeFuture getSync(String correlationId) {
        if (StringUtils.isBlank((String)correlationId)) {
            return null;
        }
        CacheBean bean = (CacheBean)BeanRepository.newInstance((String)PRODUCER_CALL).remove(correlationId);
        return bean != null ? bean.getFuture() : null;
    }

    public boolean isSynFlag() {
        return this.synFlag;
    }

    public void setSynFlag(boolean synFlag) {
        this.synFlag = synFlag;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public static void syncApiCall(String correlationId, OutMessage outMessage) {
        if (StringUtils.isBlank((String)correlationId)) {
            logger.error("amq.ADAPTER.MQ.call.syncApiCall", (Object)"correlationId is null");
            return;
        }
        InvokeFuture syncInvokeFuture = ProducerCall.getSyncCall(correlationId);
        if (null == syncInvokeFuture) {
            logger.warn("amq.ADAPTER.MQ.call.syncApiCall", (Object)("correlationId:" + correlationId + " null"));
            return;
        }
        if (null == outMessage) {
            outMessage = new OutMessage("amq.ADAPTER.MQ.call.syncApiCall.null", "\u56de\u8c03\u5f02\u5e38");
        }
        syncInvokeFuture.setDone((Object)outMessage);
    }

    public static void call(String correlationId, OutMessage outMessage) {
        if (StringUtils.isBlank((String)correlationId)) {
            logger.error("amq.ADAPTER.MQ.call.call", (Object)"correlationId is null");
            return;
        }
        InvokeFuture syncInvokeFuture = ProducerCall.getSync(correlationId);
        if (null == syncInvokeFuture) {
            logger.warn("amq.ADAPTER.MQ.call.call", (Object)("correlationId:" + correlationId + " null"));
            return;
        }
        if (null == outMessage) {
            outMessage = new OutMessage("amq.ADAPTER.MQ.call.null", "\u56de\u8c03\u5f02\u5e38");
        }
        syncInvokeFuture.setDone((Object)outMessage);
    }
}

