/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.mq;

import com.yqbsoft.laser.service.adapter.mq.MessageObj;
import com.yqbsoft.laser.service.adapter.mq.ProducerCall;
import com.yqbsoft.laser.service.adapter.mq.SupperConsumerSession;
import com.yqbsoft.laser.service.adapter.mq.SupperProducerSession;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.MessageChannel;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

public class ConsumerSession
extends SupperConsumerSession {
    private static final String sys_code = "amq.ADAPTER.MQ.ConsumerSession";
    protected final OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private SupperProducerSession repProducerSession;

    public ConsumerSession() {
    }

    public ConsumerSession(int corePoolSize, int maximumPoolSize, long keepAliveTime, String replyType) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, replyType);
    }

    public SupperProducerSession getRepProducerSession() {
        return this.repProducerSession;
    }

    public void setRepProducerSession(SupperProducerSession repProducerSession) {
        this.repProducerSession = repProducerSession;
    }

    @Override
    public boolean onMessageDo(Message message) throws JMSException {
        long a = System.currentTimeMillis();
        boolean flag = true;
        ObjectMessage response = null;
        String remsg = "";
        OutMessage outMessage = new OutMessage();
        InMessage inMessage = null;
        Destination dst = null;
        String jmsId = "";
        MessageObj messageObj = null;
        try {
            messageObj = this.invoke(message);
            outMessage = messageObj.getOutMessage();
            inMessage = messageObj.getInMessage();
            dst = message.getJMSReplyTo();
            jmsId = message.getJMSCorrelationID();
            this.logger.debug("mq.ConsumerSession", (Object)("apiCode:" + this.getApiCode(inMessage) + ",id:" + message.getJMSCorrelationID() + "==start=="));
        }
        catch (Exception e) {
            remsg = "\u5f02\u5e38:" + e.getMessage();
            outMessage.setSubCode("error");
            outMessage.setSubMsg(remsg);
            this.logger.error("amq.ADAPTER.MQ.ConsumerSession.onMessage", (Throwable)e);
        }
        OpenPerfLogUtil.debug((String)("[ConsumerSession.send]spend times(" + this.getId(inMessage) + "):==={}===" + ",apiCode:" + this.getApiCode(inMessage)), (long)(System.currentTimeMillis() - a));
        if (null != dst && null != this.getRepProducerSession()) {
            response = this.getRepProducerSession().getSession().createObjectMessage();
            response.setStringProperty("mq_filter_appKey", message.getStringProperty("mq_filter_appKey"));
            response.setJMSCorrelationID(jmsId);
            if (null == outMessage) {
                outMessage = new OutMessage();
            }
            response.setObject((Serializable)outMessage);
            if (messageObj.isHeartbeat()) {
                this.getRepProducerSession().getProducer().send(message.getJMSReplyTo(), (Message)response, this.getRepProducerSession().getProducer().getDeliveryMode(), this.getRepProducerSession().getProducer().getPriority(), 0L);
                OpenPerfLogUtil.debug((String)("[ConsumerSession]spend times:{},apiCode:Heartbeat " + response.getStringProperty("mq_filter_appKey")), (long)(System.currentTimeMillis() - a));
                return flag;
            }
            int priority = inMessage.getInvoke().getApiRouterProperty().getRouterPriorty();
            if (0 == priority) {
                priority = this.getRepProducerSession().getProducer().getPriority();
            }
            this.getRepProducerSession().getProducer().send(message.getJMSReplyTo(), (Message)response, this.getRepProducerSession().getProducer().getDeliveryMode(), priority, (long)inMessage.getInvoke().getApiRouterProperty().getRouterReadtimeout().intValue());
            this.logger.debug("mq.ConsumerSession", (Object)("apiCode:" + this.getApiCode(inMessage) + ",id:" + jmsId + "==end=="));
        } else if (null != inMessage.getInvoke() && null != inMessage.getInvoke().getApiRouterProperty()) {
            String sendType = inMessage.getInvoke().getApiRouterProperty().getRouterSendtype();
            if (StringUtils.isNotBlank((String)sendType) && "2".equals(sendType)) {
                ProducerCall.syncApiCall(jmsId, outMessage);
            }
            if (!StringUtils.isNotBlank((String)sendType) || !"0".equals(sendType) || outMessage.isError() || outMessage.isFail()) {
                // empty if block
            }
        }
        OpenPerfLogUtil.info((String)("[ConsumerSession.all]spend times(" + this.getId(inMessage) + "):==={}===" + ",apiCode:" + this.getApiCode(inMessage)), (long)(System.currentTimeMillis() - a));
        return flag;
    }

    public MessageObj invoke(Message message) {
        try {
            MessageObj messageObj = new MessageObj();
            if (!(message instanceof TextMessage) && message instanceof ObjectMessage) {
                MessageChannel messageChannel;
                ObjectMessage objectMsg = (ObjectMessage)message;
                if (this.checkHeartbeat(messageObj, objectMsg)) {
                    return messageObj;
                }
                InMessage inMessage = (InMessage)objectMsg.getObject();
                Invoke invoke = inMessage.getInvoke();
                if (null == invoke) {
                    this.logger.error("amq.ADAPTER.MQ.ConsumerSession.invoke");
                }
                if (null == invoke.getApiRouterProperty()) {
                    this.logger.error("amq.ADAPTER.MQ.ConsumerSession.apiRouterProperty", (Object)invoke.getRouterServiceName());
                }
                if (null == (messageChannel = (MessageChannel)SpringApplicationContextUtil.getBean((String)invoke.getApiRouterProperty().getRouterServicemessid()))) {
                    this.logger.error("amq.ADAPTER.MQ.ConsumerSession.messageChannel", (Object)invoke.getApiRouterProperty().getRouterServicemessid());
                }
                OutMessage outMessage = messageChannel.send(inMessage);
                messageObj.setOutMessage(outMessage);
                messageObj.setInMessage(inMessage);
                return messageObj;
            }
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.ConsumerSession.invoke", (Object)"", (Throwable)e);
        }
        return null;
    }

    private boolean checkHeartbeat(MessageObj messageObj, ObjectMessage objectMsg) {
        boolean heartbeat = false;
        try {
            heartbeat = objectMsg.getBooleanProperty("heartbeat");
        }
        catch (JMSException e) {
            // empty catch block
        }
        if (!heartbeat) {
            return false;
        }
        messageObj.setInMessage(new InMessage());
        messageObj.setOutMessage(new OutMessage());
        messageObj.setHeartbeat(true);
        return true;
    }

    private String getId(InMessage inMessage) {
        try {
            if (null == inMessage) {
                return null;
            }
            Invoke invoke = inMessage.getInvoke();
            if (invoke == null || null == inMessage.getInvokeId()) {
                return null;
            }
            return inMessage.getInvokeId().getCurrentMsgId();
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.ConsumerSession.getId", (Throwable)e);
            return null;
        }
    }

    private String getApiCode(InMessage inMessage) {
        try {
            if (null == inMessage) {
                return null;
            }
            Invoke invoke = inMessage.getInvoke();
            if (invoke == null || null == invoke.getApiProperty()) {
                return null;
            }
            return invoke.getApiProperty().getAppapiCode();
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.ConsumerSession.getApiCode", (Throwable)e);
            return null;
        }
    }
}

