/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.oms.utils;

import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class JsonHttpClient {
    private HttpClient httpClient = null;
    private HttpPost method = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private int status = 0;

    public JsonHttpClient(String url) {
        if (url != null) {
            // empty if block
        }
        if (url != null) {
            this.httpClient = new DefaultHttpClient();
            this.method = new HttpPost(url);
        }
    }

    public String post(String parameters, String access_token) {
        String body = null;
        if (this.method != null & parameters != null && !"".equals(parameters.trim())) {
            try {
                this.method.addHeader("Content-type", "application/json; charset=utf-8");
                this.method.setHeader("Accept", "application/json");
                if (StringUtils.isNotBlank((String)access_token)) {
                    this.method.setHeader("access_token", access_token);
                }
                this.method.setEntity((HttpEntity)new StringEntity(parameters, Charset.forName("UTF-8")));
                this.startTime = System.currentTimeMillis();
                HttpResponse response = this.httpClient.execute((HttpUriRequest)this.method);
                this.endTime = System.currentTimeMillis();
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    this.status = 1;
                }
                body = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                this.status = 3;
            }
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, String token, String numbers) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String entityStr = null;
        CloseableHttpResponse response = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            uriBuilder.setParameter("numbers", numbers);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.addHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.7.6)");
            httpGet.addHeader("Content-Type", "application/x-www-form-urlencoded");
            if (StringUtils.isNotBlank((String)token)) {
                httpGet.setHeader("access_token", token);
            }
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            entityStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ClientProtocolException e) {
            System.err.println("Http\u534f\u8bae\u51fa\u73b0\u95ee\u9898");
            e.printStackTrace();
        }
        catch (ParseException e) {
            System.err.println("\u89e3\u6790\u9519\u8bef");
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            System.err.println("URI\u89e3\u6790\u5f02\u5e38");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IO\u5f02\u5e38");
            e.printStackTrace();
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                    httpClient.close();
                }
                catch (IOException e) {
                    System.err.println("\u91ca\u653e\u8fde\u63a5\u51fa\u9519");
                    e.printStackTrace();
                }
            }
        }
        return entityStr;
    }

    public static void main(String[] args) {
        JsonHttpClient ac = new JsonHttpClient("http://116.196.116.0:8080/ierp/api/getAppToken.do");
        HashMap<String, String> bodyParam = new HashMap<String, String>();
        bodyParam.put("tenantid", "dmerp");
        bodyParam.put("accountId", "1155696913958306816");
        bodyParam.put("appSecuret", "123456");
        bodyParam.put("appId", "123456");
        bodyParam.put("language", "zh_CN");
        System.out.println(ac.post(JsonUtil.buildNonDefaultBinder().toJson(bodyParam), null));
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }
}

