/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.sso.impl;

import com.yqbsoft.laser.service.adapter.sso.ScomService;
import com.yqbsoft.laser.service.adapter.sso.domain.UmUserBean;
import com.yqbsoft.laser.service.adapter.sso.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.adapter.sso.integration.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.adapter.sso.integration.enums.UrlEnums;
import com.yqbsoft.laser.service.adapter.sso.integration.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.adapter.sso.integration.request.OauthSmmLoginRequest;
import com.yqbsoft.laser.service.adapter.sso.integration.request.OauthSmmUserRequest;
import com.yqbsoft.laser.service.adapter.sso.integration.respone.OauthSmmLoginResponse;
import com.yqbsoft.laser.service.adapter.sso.integration.respone.OauthSmmUserResponse;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;

public class ScomServiceImpl
extends BaseServiceImpl
implements ScomService {
    private String SYS_CODE = "sso.ScomServiceImpl";

    @Override
    public UmUserBean oauthSmmLogin(String userName, String password, String appmanageIcode, String tenantCode, String isValid) throws ApiException {
        if (StringUtils.isBlank((String)userName)) {
            UmUserBean userBean = new UmUserBean();
            userBean.setFlag(false);
            userBean.setMsg("\u4f20\u5165\u53c2\u6570\u9519\u8bef");
            return userBean;
        }
        String url = this.getUrl(tenantCode, "smmsso", "url", appmanageIcode);
        String key = this.getUrl(tenantCode, "smmsso", "key", appmanageIcode);
        String appid = this.getUrl(tenantCode, "smmsso", "appid", appmanageIcode);
        HttpFormfacade ssOfacade = new HttpFormfacade(url, appid, key, null);
        OauthSmmLoginRequest oauthSmmLoginRequest = new OauthSmmLoginRequest();
        oauthSmmLoginRequest.setCode(userName);
        oauthSmmLoginRequest.setTopHttpMethod(UrlEnums.getOauthToken.geturlMethod());
        OauthSmmLoginResponse execute = ssOfacade.execute(oauthSmmLoginRequest);
        if (!execute.isSuccess()) {
            this.logger.error(this.SYS_CODE + ".oauthSmmLogin.errorCode", (Object)execute.getMsg());
            UmUserBean userBean = new UmUserBean();
            userBean.setFlag(false);
            userBean.setMsg(execute.getMsg());
            return userBean;
        }
        if (StringUtils.isBlank((String)execute.getUid())) {
            this.logger.error(this.SYS_CODE + ".oauthSmmLogin.getUid", (Object)execute.getMsg());
            UmUserBean userBean = new UmUserBean();
            userBean.setFlag(false);
            userBean.setMsg("uid is null");
            return userBean;
        }
        if (!this.checkUserAndSave(execute, url, appid, key, appmanageIcode, tenantCode)) {
            this.logger.error(this.SYS_CODE + ".oauthSmmLogin.checkUserAndSave", (Object)userName);
            UmUserBean userBean = new UmUserBean();
            userBean.setFlag(false);
            userBean.setMsg("save is error");
            return userBean;
        }
        return this.loginUser(password, appmanageIcode, tenantCode, execute);
    }

    private boolean checkUserAndSave(OauthSmmLoginResponse execute, String url, String appid, String key, String appmanageIcode, String tenantCode) {
        if (null == execute || StringUtils.isBlank((String)url) || StringUtils.isBlank((String)tenantCode)) {
            return false;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userName", execute.getUid());
        paramMap.put("tenantCode", tenantCode);
        QueryResult quser = this.sendReSupObject(ApiCodeEnums.queryUser.getApiCode(), paramMap, UmUserBean.class);
        if (null != quser && ListUtil.isNotEmpty((Collection)quser.getList())) {
            return true;
        }
        HttpFormfacade ssOfacade = new HttpFormfacade(url, appid, key, null);
        OauthSmmUserRequest oauthSmmLoginRequest = new OauthSmmUserRequest();
        oauthSmmLoginRequest.setAccess_token(execute.getToken());
        oauthSmmLoginRequest.setUid(execute.getUid());
        oauthSmmLoginRequest.setTopHttpMethod(UrlEnums.getUser.geturlMethod());
        OauthSmmUserResponse responeexecute = ssOfacade.execute(oauthSmmLoginRequest);
        if (!responeexecute.isSuccess()) {
            this.logger.error(this.SYS_CODE + ".checkUserAndSave.errorCode", (Object)execute.getMsg());
            return false;
        }
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserName(responeexecute.getNick_name());
        umUserDomainBean.setUserPhone(responeexecute.getCellphone());
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setAppmanageIcode(appmanageIcode);
        String compname = umUserDomainBean.getUserName();
        if (StringUtils.isBlank((String)compname)) {
            compname = umUserDomainBean.getUserPhone();
        }
        umUserDomainBean.setUserinfoCompname(compname);
        umUserDomainBean.setUserinfoQuality("buy");
        try {
            HashMap<String, String> inventoryMap = new HashMap<String, String>();
            inventoryMap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
            String api = ApiCodeEnums.openUserinfo.getApiCode();
            this.getInternalRouter().inInvoke(api, inventoryMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".checkUserAndSave.exception", (Object)"\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570inventoryMap", (Throwable)e);
            return false;
        }
        return true;
    }

    private UmUserBean loginUser(String password, String appmanageIcode, String tenantCode, OauthSmmLoginResponse execute) {
        if (null == execute || StringUtils.isBlank((String)appmanageIcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> inventoryMap = new HashMap<String, Object>();
        inventoryMap.put("userName", execute.getUid());
        inventoryMap.put("password", password);
        inventoryMap.put("appmanageIcode", appmanageIcode);
        inventoryMap.put("tenantCode", tenantCode);
        inventoryMap.put("isValid", 3);
        String userBeanStr = "";
        UmUserBean userBean = new UmUserBean();
        try {
            String api = ApiCodeEnums.checkUmApi.getApiCode();
            if ("000".equals(appmanageIcode)) {
                api = ApiCodeEnums.checkMuApi.getApiCode();
            }
            if (StringUtils.isBlank((String)(userBeanStr = (String)this.getInternalRouter().inInvoke(api, inventoryMap)))) {
                this.logger.error(this.SYS_CODE + ".loginUser.userBeanStr", (Object)("\u8fd4\u56de\u7ed3\u679cuserBeanStr\uff1a" + userBeanStr + ",\u8bf7\u6c42\u53c2\u6570inventoryMap\uff1a" + inventoryMap));
                userBean.setFlag(false);
                userBean.setMsg("queryUmuserCheck\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return userBean;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".loginUser.userBeanStr.exception", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u8bf7\u6c42\u53c2\u6570inventoryMap\uff1a" + inventoryMap), (Throwable)e);
            userBean.setFlag(false);
            userBean.setMsg("\u8acb\u6c42um.user.queryUmuserCheck\u5f02\u5e38\uff01\uff01\uff01");
            return userBean;
        }
        userBean = (UmUserBean)JsonUtil.buildNormalBinder().getJsonToObject(userBeanStr, UmUserBean.class);
        if (null == userBean || !userBean.isFlag()) {
            this.logger.error(this.SYS_CODE + ".loginUser.userBean", (Object)("\u8fd4\u56de\u7ed3\u679cuserBeanStr\uff1a" + userBeanStr + ",\u8bf7\u6c42\u53c2\u6570inventoryMap\uff1a" + inventoryMap));
        }
        return userBean;
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        this.logger.error(this.SYS_CODE + ".getUrl", (Object)(tenantCode + "=" + flagSettingType + appmanageIcode + "=" + flagSettingCode + "=" + value));
        return value;
    }

    public static void main(String[] args) {
    }
}

