/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.taobao.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileUtil {
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    private FileUtil() {
    }

    public static String readText(String path) {
        try {
            return FileUtil.readString(new FileInputStream(path));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static String readClasspathText(String classpath) {
        if (!classpath.startsWith("/")) {
            classpath = "/" + classpath;
        }
        return FileUtil.readString(FileUtil.class.getResourceAsStream(classpath));
    }

    public static String readTextFromPath(String filePath, String charset) {
        InputStream bin = null;
        ByteArrayOutputStream bos = null;
        boolean isClasspath = false;
        if (filePath.startsWith("classpath")) {
            isClasspath = true;
            if (!(filePath = filePath.replace("classpath:", "")).startsWith("/")) {
                filePath = "/" + filePath;
            }
        } else {
            filePath = FileUtil.makeFilePath(System.getProperty("user.dir"), filePath);
        }
        try {
            bin = isClasspath ? FileUtil.class.getResourceAsStream(filePath) : new FileInputStream(filePath);
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = bin.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            String string = bos.toString(charset);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25: [" + filePath + "]");
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\ufffd?: [" + filePath + "]");
            }
        }
    }

    public static byte[] readByteArray(InputStream in) {
        return FileUtil.readByteArray(in, 2048);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByteArray(InputStream in, int bufferSize) {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[bufferSize];
        int i = 0;
        try {
            while ((i = bis.read(buf)) != -1) {
                bos.write(buf, 0, i);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream in, int bufferSize) {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[bufferSize];
        int i = 0;
        try {
            while ((i = bis.read(buf)) != -1) {
                bos.write(buf, 0, i);
            }
            String string = bos.toString("UTF-8");
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String readString(InputStream in) {
        return FileUtil.readString(in, 2048);
    }

    public static InputStream getClasspathFileInputStream(String classpath) {
        if (!classpath.startsWith("/")) {
            classpath = "/" + classpath;
        }
        return FileUtil.class.getResourceAsStream(classpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(OutputStream out, String data) {
        BufferedOutputStream bout = new BufferedOutputStream(out);
        try {
            bout.write(data.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                    bout.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String makeFilePath(String folderPath, String fileName) {
        return folderPath.endsWith("\\") || folderPath.endsWith("/") ? folderPath + fileName : folderPath + File.separatorChar + fileName;
    }
}

